<?php

/**
 * The Template for displaying product archives, including the main shop page which is a post type archive
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/archive-product.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see https://docs.woocommerce.com/document/template-structure/
 * @package WooCommerce\Templates
 * @version 3.4.0
 */

defined('ABSPATH') || exit;

get_header();
$page_breadcrumb_image = Egns_Helpers::egns_page_option_value('breadcrumb_page_bg_image');
?>

<?php if (isset($page_breadcrumb_image['url'])) : ?>
	<header class="woocommerce-products-header" style="background-image: url(<?php echo esc_url($page_breadcrumb_image['url']) ?>)">
	<?php else : ?>
		<header class="woocommerce-products-header">
		<?php endif ?>
	<?php if (apply_filters('woocommerce_show_page_title', true)) : ?>
		<h1 class="woocommerce-products-header__title page-title"><?php woocommerce_page_title(); ?></h1>
	<?php endif; ?>

	<?php
	/**
	 * Hook: woocommerce_archive_description.
	 *
	 * @hooked woocommerce_taxonomy_archive_description - 10
	 * @hooked woocommerce_product_archive_description - 10
	 */
	do_action('woocommerce_archive_description');
	?>
	<?php
	/**
	 * Hook: woocommerce_before_main_content.
	 *
	 * @hooked woocommerce_output_content_wrapper - 10 (outputs opening divs for the content)
	 * @hooked woocommerce_breadcrumb - 20
	 * @hooked WC_Structured_Data::generate_website_data() - 30
	 */
	do_action('woocommerce_before_main_content');

	?>
</header>
<div class="page-wrapper sec-mar">
	<div class="container">
		<div class="row">
			<div class="<?php echo is_active_sidebar('shop_sidebar') && !empty(Egns_Helpers::egns_get_theme_option('woo_sidebar')) ? 'col-lg-9' : 'col-12' ?>">
				<?php
				if (woocommerce_product_loop()) { ?>

					<div class="shop-sort-group">
						<?php /**
						 * Hook: woocommerce_before_shop_loop.
						 *
						 * @hooked woocommerce_output_all_notices - 10
						 * @hooked woocommerce_result_count - 20
						 * @hooked woocommerce_catalog_ordering - 30
						 */
						do_action('woocommerce_before_shop_loop'); ?>
					</div>
					<div class="clearfix"></div>
				<?php
					woocommerce_product_loop_start();

					if (wc_get_loop_prop('total')) {
						while (have_posts()) {
							the_post();

							/**
							 * Hook: woocommerce_shop_loop.
							 */
							do_action('woocommerce_shop_loop');

							wc_get_template_part('content', 'product');
						}
					}

					woocommerce_product_loop_end();

					/**
					 * Hook: woocommerce_after_shop_loop.
					 *
					 * @hooked woocommerce_pagination - 10
					 */
					do_action('woocommerce_after_shop_loop');
				} else {
					/**
					 * Hook: woocommerce_no_products_found.
					 *
					 * @hooked wc_no_products_found - 10
					 */
					do_action('woocommerce_no_products_found');
				}
				?>
			</div>

			<?php if (!empty(Egns_Helpers::egns_get_theme_option('woo_sidebar'))) : ?>
				<!-- Start right Sidebar -->
				<div class="col-lg-3">
					<div id="shop-left-sidebar">
						<aside>
							<?php
							if (is_active_sidebar('shop_sidebar')) {
								dynamic_sidebar('shop_sidebar');
							}
							?>
						</aside>
					</div>
				</div>
			<?php endif; ?>

		</div>
		<!-- End right sidebar -->
		<?php

		/**
		 * Hook: woocommerce_after_main_content.
		 *
		 * @hooked woocommerce_output_content_wrapper_end - 10 (outputs closing divs for the content)
		 */
		do_action('woocommerce_after_main_content');
		?>

	</div>
</div>
<?php
get_footer();
