<div class="tour-review-area">
    <!-- review-progress-box -->
    <div class="review-progress-box">
        <div class="row g-4 align-items-center">
            <div class="col-md-7">
                <?php 
                $reivew_based_on_criteria = [];
                if( count((array) $review_rating_criteria ) > 0 ) : ?>
                    <?php 
                        $total_rating = 0;
                        $flag = false;
                    ?>
                    <?php foreach( (array) $review_rating_criteria as $criteria ) : ?>
                        <?php
                            if( isset( $criteria['criteria_item'] ) ) {
                                $args = array(
                                    'post_type'         => 'review-rating',
                                    'posts_per_page'    => -1,
                                    'meta_query' => array(
                                        'relation'      => 'AND',
                                        array(
                                            'key'       => 'tour_astrip_review_rating',
                                            'value'     => $criteria['criteria_item'],
                                            'compare'   => 'LIKE' 
                                        ),
                                        array(
                                            'key'       => 'tour_astrip_review_rating',
                                            'value'     => $tour_title,
                                            'compare'   => 'LIKE' 
                                        ),
                                        array(
                                            'key'       => 'tour_astrip_review_rating',
                                            'value'     => esc_html('approve'),
                                            'compare'   => 'LIKE' 
                                        ),
    
                                    )
                                );
                                $total_rating_based_on_criteria = 0;
                                $reivew_based_on_criteria = get_posts( $args );
                                $all_rating_in_single_criteria = count( $reivew_based_on_criteria );
                                if( count( $reivew_based_on_criteria ) > 0 ) {
                                    foreach( $reivew_based_on_criteria as $rating ) {
                                        $rating_meta_value = Egns_Helpers::egns_post_meta_box_value_by_id( $rating->ID,'tour_astrip_review_rating','review_rating' );
        
                                        $filtered = array_filter($rating_meta_value, function($item) use ( $criteria ) {
                                            return $item["reivew_criteria"] == $criteria['criteria_item'];
                                        });
                                        $total = array_reduce(
                                            $filtered,
                                            function ($prev, $item) {
                                                return $prev +  $item['reivew_criteria_rating'];
                                            }
                                        );
                                        $total_rating_based_on_criteria += $total;
        
                                    }
                                    $max_rating = count( $reivew_based_on_criteria ) * 5;
                                    $calculate_percent = round( ( $total_rating_based_on_criteria / $max_rating ) * 100 );
                                    $total_rating += $total_rating_based_on_criteria;
                                }else{
                                    $flag = true;
                                }
                            }
                        ?>
                        <?php if( isset( $criteria['criteria_item'] ) && isset( $calculate_percent ) ) : ?>
                            <div class="progress-singl">
                                <span><?php echo esc_html( $criteria['criteria_item'] ) ?></span>
                                <i class="progress-bar" style="--progress: <?php echo esc_html( $calculate_percent ). '%' ?>"><?php echo esc_html( $calculate_percent ) .'%' ?></i>
                            </div>
                        <?php endif ?>
                        
                    <?php endforeach ?>
                    <?php
                        if( $flag == true ) {
                            echo wp_kses_post('<h3>Rating not Found</h3>');
                        }
                    ?>
                <?php endif ?>
            </div>
            <?php if( count( $reivew_based_on_criteria ) > 0 ) : ?>
            <div class="col-md-5">
                <div class="tour-review-number">
                    <?php 
                        $avg_rating_point = round( ( $total_rating / ( count( $reivew_based_on_criteria ) * count( $review_rating_criteria ) * 5 ) ) * 100 );
                        $rating_status = Egns_Helpers::egns_get_avg_rating_status_by_tour_id( $avg_rating_point );
                    ?>
                    <span>
                        <?php echo number_format($avg_rating_point/10, 2); ?>
                    </span>
                    <h2><?php echo sprintf( esc_html__('%s','astrip'),$rating_status  ); ?></h2>
                </div>
            </div>
            <?php endif ?>
        </div>
    </div>

    <!-- review-comment-area -->
    <div class="review-commetn-area">
        <ul class="review-comment-list">
            <?php
                
                $all_rating = Egns_Helpers::egns_get_all_rating_by_tour_id( $tour_title );
            ?>
            <?php foreach( (array)$all_rating as $rating )  :  ?>
                <li>
                    <div class="comment-item">
                        <div class="image">
                            <?php
                                $image = '';
                                if( !empty( get_current_user_id() ) ) {
                                    $get_avatar_url = get_user_meta(get_current_user_id(), 'image', $attachment_id);
                                    if( isset( $get_avatar_url[0] ) ) {
                                        $image = wp_get_attachment_image($get_avatar_url[0], 'thumbnail');
                                    }
                                }
                            ?>
                            <?php echo wp_kses_post( $image ) ?>
                        </div>
                        <div class="content">
                            <div class="comment-meta">
                                <h5> <?php echo Egns_Helpers::egns_post_meta_box_value_by_id( $rating->ID,'tour_astrip_review_rating','customer_name') ?>-</h5><span><?php echo esc_html( $rating->post_date ) ?? '' ?></span>
                            </div>
                            <h3 class="comment-title"><?php echo Egns_Helpers::egns_post_meta_box_value_by_id( $rating->ID,'tour_astrip_review_rating','review_title') ?></h3>
                            <p><?php echo Egns_Helpers::egns_post_meta_box_value_by_id( $rating->ID,'tour_astrip_review_rating','review_message') ?></p>
                            <?php 
                                $rating_meta = Egns_Helpers::egns_post_meta_box_value_by_id( $rating->ID,'tour_astrip_review_rating','review_rating' );
                            ?>
                            
                            <ul class="review-item-list">
                                <?php foreach( $rating_meta as $rating_nested ) : ?>
                                <li>
                                    <span><?php echo esc_html( $rating_nested['reivew_criteria'] ) ?></span>
                                    <ul class="star-list">
                                        <?php 
                                            for ($x = 1; $x <= 5; $x++) {
                                                if( $rating_nested['reivew_criteria_rating'] >= $x ) {
                                                    echo wp_kses_post( '<li><i class="bi bi-star-fill"></i></li>' );
                                                }else{
                                                    echo wp_kses_post( '<li><i class="bi bi-star"></i></li>' );
                                                }
                                            }
                                        
                                        ?>
                                    </ul>
                                </li>
                                <?php endforeach ?>
                            </ul>
                        </div>
                    </div>
                </li>
            <?php endforeach ?>
            <?php wp_reset_postdata() ?>
        </ul>
    </div>

    <!-- review-comment-form -->
    <?php
        $current_user = wp_get_current_user();
        $url  = get_permalink();
    ?>
    <div class="review-form-area">
        <h3 class="tour-details-subtitle"><?php echo esc_html__('Write a review:','astrip') ?></h3>
        <div class="contact-from-wrapper">
            <form action="<?php echo esc_url( $url ) ?>" method="post" id="review_rating" name="review_rating">
                <input type="hidden" value="1" name="customer_id">
                <div class="row">
                    <div class="col-lg-6">
                        <div class="form-inner">
                            <input type="text" name="customer_name" value="<?php echo esc_html( $current_user->display_name ) ?>" placeholder="<?php echo esc_attr__( 'Your Name:','astrip' ) ?>">
                        </div>
                    </div>
                    <div class="col-lg-6">
                        <div class="form-inner">
                            <input type="text" name="customer_email" value="<?php echo esc_html( $current_user->user_email ) ?>" placeholder="<?php echo esc_attr__('Your Email Address:','astrip') ?>">
                        </div>
                    </div>
                    <div class="col-lg-12">
                        <div class="form-inner">
                            <input type="text" name="review_title" placeholder="<?php echo esc_attr__('Reivew Title:','astrip') ?>">
                        </div>
                    </div>
                    <div class="col-lg-12">
                        <div class="form-inner">
                            <textarea name="review_message" rows="5" placeholder="<?php echo esc_attr__('Review Message','astrip') ?>"></textarea>
                        </div>
                    </div>
                    <div class="col-lg-12">
                        <div class="star-rating-wrapper">
                            <!-- <ul class="star-rating-list">
                            </ul> -->
                            <ul class="review-item-list">
                                <?php foreach( (array) $review_rating_criteria as $key => $criteria ) : ?>
                                    <?php if( isset( $criteria['criteria_item'] ) ) : ?>
                                        <li>
                                            <span><?php echo esc_html( $criteria['criteria_item'] ) ?></span>
                                            <ul class="star-list">
                                                <fieldset class="rating">
                                                    <input type="radio" class="rating_last" id="<?php echo esc_attr( strtolower( trim( preg_replace('/[^A-Za-z0-9-]+/', '_',  $criteria['criteria_item']) ).'rating' ) ) ?>star5" name="<?php echo esc_attr( strtolower( trim( preg_replace('/[^A-Za-z0-9-]+/', '_',  $criteria['criteria_item']) ).'rating' ) ) ?>" value="5" />
                                                    <label for="<?php echo esc_attr( strtolower( trim( preg_replace('/[^A-Za-z0-9-]+/', '_',  $criteria['criteria_item']) ).'rating' ) ) ?>star5" title="5 stars"></label>
                                                    <input type="radio" id="<?php echo esc_attr( strtolower( trim( preg_replace('/[^A-Za-z0-9-]+/', '_',  $criteria['criteria_item']) ).'rating' ) ) ?>star4" name="<?php echo esc_attr( strtolower( trim( preg_replace('/[^A-Za-z0-9-]+/', '_',  $criteria['criteria_item']) ).'rating' ) ) ?>" value="4" />
                                                    <label for="<?php echo esc_attr( strtolower( trim( preg_replace('/[^A-Za-z0-9-]+/', '_',  $criteria['criteria_item']) ).'rating' ) ) ?>star4" title="4 stars"></label>
                                                    <input type="radio" id="<?php echo esc_attr( strtolower( trim( preg_replace('/[^A-Za-z0-9-]+/', '_',  $criteria['criteria_item']) ).'rating' ) ) ?>star3" name="<?php echo esc_attr( strtolower( trim( preg_replace('/[^A-Za-z0-9-]+/', '_',  $criteria['criteria_item']) ).'rating' ) ) ?>" value="3"/>
                                                    <label for="<?php echo esc_attr( strtolower( trim( preg_replace('/[^A-Za-z0-9-]+/', '_',  $criteria['criteria_item']) ).'rating' ) ) ?>star3" title="3 stars"></label>
                                                    <input type="radio" id="<?php echo esc_attr( strtolower( trim( preg_replace('/[^A-Za-z0-9-]+/', '_',  $criteria['criteria_item']) ).'rating' ) ) ?>star2" name="<?php echo esc_attr( strtolower( trim( preg_replace('/[^A-Za-z0-9-]+/', '_',  $criteria['criteria_item']) ).'rating' ) ) ?>" value="2" />
                                                    <label for="<?php echo esc_attr( strtolower( trim( preg_replace('/[^A-Za-z0-9-]+/', '_',  $criteria['criteria_item']) ).'rating' ) ) ?>star2" title="2 stars"></label>
                                                    <input type="radio" id="<?php echo esc_attr( strtolower( trim( preg_replace('/[^A-Za-z0-9-]+/', '_',  $criteria['criteria_item']) ).'rating' ) ) ?>star1" name="<?php echo esc_attr( strtolower( trim( preg_replace('/[^A-Za-z0-9-]+/', '_',  $criteria['criteria_item']) ).'rating' ) ) ?>rating" value="1" />
                                                    <label for="<?php echo esc_attr( strtolower( trim( preg_replace('/[^A-Za-z0-9-]+/', '_',  $criteria['criteria_item']) ).'rating' ) ) ?>star1" title="1 star"></label>
                                                </fieldset>
                                            </ul>
                                        </li>
                                    <?php endif ?>
                                <?php endforeach ?>
                            </ul>
                        </div>
                    </div>
                    <div class="col-lg-12">
                        <span class="rating_all_fields_error d-none text-start text-danger"><?php echo esc_html('Please fill up all the Fields') ?></span>
                    </div>
                    <div class="col-lg-12">
                        <?php wp_nonce_field( 'rating_nonce', 'custom_rating_nonce' ); ?>
                        <button type="submit" id="ratingFormSubmit" value="ratingFormSubmit" class="eg-btn btn--primary btn--lg submit-btn"><?php echo esc_html__('Submit Now','astrip') ?></button>
                    </div>
                </div>
            </form>
        </div>
    </div>

</div>