<?php
// Theme Options value 
$theme_options = get_option('egns_theme_options'); // prefix of theme


// query the user media
$fields = "id,caption,media_type,media_url,permalink,thumbnail_url,timestamp,username";
$token = !empty($theme_options['astrip_insta_feed_token']) ? $theme_options['astrip_insta_feed_token'] : '';
$limit = 10;

$json_feed_url = wp_kses_bad_protocol("https://graph.instagram.com/me/media?fields={$fields}&access_token={$token}&limit={$limit}", array('http', 'https'));
// First, initialize WP_Filesystem
if (!function_exists('WP_Filesystem')) {
    require_once ABSPATH . 'wp-admin/includes/file.php';
}
WP_Filesystem();
global $wp_filesystem;
$json_feed = $wp_filesystem->get_contents($json_feed_url);

$contents = json_decode($json_feed, true, 512, JSON_BIGINT_AS_STRING);

?>

<?php if ( !empty($token) && !empty($contents['data']) ) : ?>
    <div class="instagram-feed-section">
        <div class="container">
            <div class="row justify-content-lg-start justify-content-center">
                <div class="col-lg-6">
                    <?php if (!empty($theme_options['astrip_insta_feed_title'])) : ?>
                        <div class="section-title-small text-lg-start text-center">
                            <i class="bi bi-instagram"></i><span><?php echo esc_html($theme_options['astrip_insta_feed_title']) ?></span>
                        </div>
                    <?php endif ?>
                </div>
            </div>
        </div>
        <div class="container-fluid px-0">
            <div class="swiper insta-feed-slider">
                <div class="swiper-wrapper">
                    <?php if (!empty($contents['data'])) : ?>
                        <?php foreach ((array) $contents["data"] as $post) : ?>
                            <div class="swiper-slide">
                                <?php if (!empty($post['media_url'])) : ?>
                                    <div class="insta-feed-single">
                                        <img src="<?php echo esc_url($post['media_url']) ?>" alt="<?php echo esc_attr('insta-feed') ?>">
                                    </div>
                                <?php endif ?>
                            </div>
                        <?php endforeach ?>
                    <?php endif ?>
                </div>
            </div>
        </div>
    </div>
<?php endif ?>