<?php

$enable_breadcrumb_by_theme = Egns_Helpers::egns_get_theme_option('breadcrumb_enable');
$breadcrumb_enable_by_page = Egns_Helpers::egns_page_option_value('enable_breadcrumb');

$page_breadcrumb_image = Egns_Helpers::egns_page_option_value('breadcrumb_page_bg_image');




if (Egns_Helpers::is_enabled($enable_breadcrumb_by_theme, $breadcrumb_enable_by_page)) { ?>


    <?php if (isset($page_breadcrumb_image['url'])) : ?>
        <div class="inner-banner-section" style="background-image: url(<?php echo esc_url($page_breadcrumb_image['url']) ?>)">
        <?php else : ?>
            <div class="inner-banner-section">
            <?php endif ?>
            <div class="container">
                <div class="row justify-content-center">
                    <div class="col-xl-8 col-md-10 col-sm-12">
                        <?php if (!class_exists('CSF') && is_home()) { ?>
                            <div class="breadcrumb-area">
                                <span><?php echo esc_html(get_bloginfo('name')) ?></span>
                                <?php if (!empty(Egns_Helpers::egns_page_option_value('breadcrumb_subtitle'))) : ?>
                                    <span><?php echo esc_html(Egns_Helpers::egns_page_option_value('breadcrumb_subtitle')) ?></span>
                                <?php endif; ?>
                            </div>
                        <?php } else { ?>
                            <div class="breadcrumb-area">
                                <h2>
                                    <?php
                                    if (is_category()) {
                                        echo esc_html__('Category : ', 'astrip');
                                        single_cat_title();
                                    } elseif (is_tag()) {
                                        echo esc_html__('Tag : ', 'astrip');
                                        single_tag_title();
                                    } elseif (is_author()) {
                                        echo esc_html__('Author : ', 'astrip');
                                        the_author();
                                    } elseif (is_date()) {
                                        echo esc_html__('Date : ', 'astrip');
                                        if (is_day()) {
                                            echo get_the_time('F j, Y');
                                        } else if (is_month()) {
                                            echo get_the_time('F, Y');
                                        } else if (is_year()) {
                                            echo get_the_time('Y');
                                        }
                                    } elseif (is_home()) {
                                        Egns_Helpers::egns_translate_with_escape_('Blog');
                                    } else {
                                        the_title();
                                    }
                                    ?>
                                </h2>
                            </div>
                        <?php } ?>
                    </div>
                </div>
            </div>
            </div>
        <?php
    }

        ?>