<?php
$product_id = Egns_Helpers::egns_post_meta_box_value(EGNS_TOUR_META_ID, 'tour_product');

$get_booking_form_type = Egns_Helpers::egns_post_meta_box_value(EGNS_TOUR_META_ID, 'tour_booking_options');
$price_html = '';
if ($get_booking_form_type != 'enquiry_form') {
    if (class_exists('Woocommerce') && !empty($product_id)) {
        $product_id_single = wc_get_product($product_id);
        if (Egns_Helpers::egns_check_sale_price_schedule($product_id_single->get_id())) {
            $price_html = get_woocommerce_currency_symbol() . Egns_Helpers::egns_calculate_product_price($product_id_single->get_id()) . ' <del>' . get_woocommerce_currency_symbol() . $product_id_single->get_regular_price() .  '</del>';
        } else {
            $price_html =  get_woocommerce_currency_symbol() . Egns_Helpers::egns_calculate_product_price($product_id_single->get_id());
        }
    }
} else {
    if (!empty(Egns_Helpers::egns_post_meta_box_value(EGNS_TOUR_META_ID, 'sale_price'))) {
        $price_html = Egns_Helpers::egns_calculate_product_price() . ' <del>' . Egns_Helpers::egns_post_meta_box_value(EGNS_TOUR_META_ID, 'regular_price') .  '</del>';
    } else {
        $price_html =  Egns_Helpers::egns_calculate_product_price();
    }
}

?>
<div class="col-lg-4 col-md-6 col-sm-12">
    <div class="best-plan-single1">
        <div class="image">
            <?php the_post_thumbnail('egns-img-one') ?>
        </div>
        <div class="content">
            <?php if (!empty($price_html)) : ?>
                <p><?php echo esc_html__('From', 'astrip') ?> <?php echo wp_kses($price_html, wp_kses_allowed_html('post')) ?></p>
            <?php endif ?>
            <h4><a href="<?php the_permalink() ?>"><?php the_title() ?></a></h4>
            <div class="best-plan-meta">
                <?php if (!empty(Egns_Helpers::egns_post_meta_box_value(EGNS_TOUR_META_ID, 'tour_duration'))) : ?>
                    <span class="duration"><i class="bi bi-clock"></i><?php echo esc_html(Egns_Helpers::egns_post_meta_box_value(EGNS_TOUR_META_ID, 'tour_duration')) ?></span>
                <?php endif ?>
                <span class="rating">
                    <?php if (Egns_Helpers::egns_get_avg_rating_by_tour_id(get_the_ID()) > 0) : ?>
                        <ul class="star-list">
                            <?php
                            for ($x = 1; $x <= 5; $x++) {
                                if (Egns_Helpers::egns_get_avg_rating_by_tour_id(get_the_ID()) >= $x) {
                                    echo wp_kses_post('<li><i class="bi bi-star-fill"></i></li>');
                                } else {
                                    echo wp_kses_post('<li><i class="bi bi-star"></i></li>');
                                }
                            }
                            ?>
                        </ul>
                    <?php endif ?>
                    <?php if (Egns_Helpers::egns_get_all_rating_count_by_tour_id(get_the_ID()) > 0) : ?>
                        <?php echo esc_html(Egns_Helpers::egns_get_avg_rating_by_tour_id(get_the_ID())) ?> (<?php echo esc_html(Egns_Helpers::egns_get_all_rating_count_by_tour_id(get_the_ID())) ?>)
                    <?php endif ?>
                </span>
            </div>
            <div class="list-area">
                <?php if (!empty(Egns_Helpers::egns_post_meta_box_value(EGNS_TOUR_META_ID, 'included_content'))) : ?>
                    <h5><?php echo Egns_Helpers::egns_post_meta_box_value(EGNS_TOUR_META_ID, 'facility_title') ?></h5>
                <?php endif ?>
                <ul class="plan-list1">
                    <?php if (!empty(Egns_Helpers::egns_post_meta_box_value(EGNS_TOUR_META_ID, 'included_content'))) : ?>
                        <?php foreach (Egns_Helpers::egns_post_meta_box_value(EGNS_TOUR_META_ID, 'included_content') as $includes) : ?>
                            <li><?php echo esc_html($includes['included_content_name']) ?></li>
                        <?php endforeach ?>
                    <?php endif ?>
                </ul>
            </div>
            <a href="<?php the_permalink() ?>" class="eg-btn btn--primary-outline btn--md"><?php echo esc_html__('Explorer Now', 'astrip') ?></a>
        </div>
    </div>
</div>