<?php
$product_id = Egns_Helpers::egns_post_meta_box_value(EGNS_TOUR_META_ID, 'tour_product');
$get_booking_form_type = Egns_Helpers::egns_post_meta_box_value(EGNS_TOUR_META_ID, 'tour_booking_options');
$price_html = '';
if ($get_booking_form_type != 'enquiry_form') {
    if (class_exists('Woocommerce') && !empty($product_id)) {
        $product_id_single = wc_get_product($product_id);
        if (Egns_Helpers::egns_check_sale_price_schedule($product_id_single->get_id())) {
            $price_html = '<span>' . 'From ' . get_woocommerce_currency_symbol() . Egns_Helpers::egns_calculate_product_price($product_id_single->get_id()) . '</span>/' . ' <del>' . get_woocommerce_currency_symbol() . $product_id_single->get_regular_price() .  '</del>';
        } else {
            $price_html = '<span>' . 'From ' . get_woocommerce_currency_symbol() . Egns_Helpers::egns_calculate_product_price($product_id_single->get_id()) . '</span>';
        }
    }
} else {
    if (!empty(Egns_Helpers::egns_post_meta_box_value(EGNS_TOUR_META_ID, 'sale_price'))) {
        $price_html = '<span>' . 'From ' . Egns_Helpers::egns_calculate_product_price() . '</span>/' . ' <del>' . Egns_Helpers::egns_post_meta_box_value(EGNS_TOUR_META_ID, 'regular_price') .  '</del>';
    } else {
        $price_html =  Egns_Helpers::egns_calculate_product_price();
    }
}


?>

<div class="col-lg-4 col-md-6 col-sm-12">
    <div class="deal-single1">
        <div class="deal-image">
            <?php if (!empty($product_id) && Egns_Helpers::egns_check_sale_price_schedule($product_id)) : ?>
                <span class="discount-bagde"><?php echo Egns_Helpers::egns_calculate_offer_percent($product_id) ?><?php echo esc_html('%') ?></span>
            <?php endif ?>
            <?php the_post_thumbnail('egns-img-one', ['class' => 'img-fluid']); ?>
        </div>
        <div class="deal-content">
            <div class="review-area">
                <?php if (Egns_Helpers::egns_get_avg_rating_by_tour_id(get_the_ID()) > 0) : ?>
                    <ul class="star-list">
                        <?php
                        for ($x = 1; $x <= 5; $x++) {
                            if (Egns_Helpers::egns_get_avg_rating_by_tour_id(get_the_ID()) >= $x) {
                                echo wp_kses_post('<li><i class="bi bi-star-fill"></i></li>');
                            } else {
                                echo wp_kses_post('<li><i class="bi bi-star"></i></li>');
                            }
                        }
                        ?>
                    </ul>
                    <?php if (Egns_Helpers::egns_get_all_rating_count_by_tour_id(get_the_ID()) > 0) : ?>
                        <span>(<?php echo Egns_Helpers::egns_get_avg_rating_by_tour_id(get_the_ID()); ?> <?php echo Egns_Helpers::egns_get_all_rating_count_by_tour_id(get_the_ID()) == 1 ? esc_html__('Review', 'astrip') : esc_html__('Reviews', 'astrip') ?>)</span>
                    <?php endif ?>
                <?php endif ?>
            </div>
            <h4><a href="<?php echo the_permalink() ?>"><?php the_title() ?></a></h4>
            <div class="price">
                <?php echo wp_kses($price_html, wp_kses_allowed_html('post'));   ?>
            </div>
            <a href="<?php echo the_permalink() ?>" class="eg-btn btn--primary-outline btn--md"><?php echo esc_html__('Explorer Now', 'astrip') ?></a>
        </div>
    </div>
</div>