<?php 
/*-----------------------------------
Trip Info SECTION
------------------------------------*/
CSF::createSection( EGNS_TOUR_META_ID,
    array(
        'title'  => esc_html__( 'Trip Info', 'astrip' ),
        'parent' => 'astrip_tour_meta_option',
        'fields' => array(
            array(
                'type'    => 'subheading',
                'content' => esc_html__( 'Trip Info Content', 'astrip' ),
            ),
            array(
                'id'      => 'trip_info_enable_disable_option',
                'title'   => esc_html__( 'Enable/Disable', 'astrip' ),
                'type'    => 'switcher',
                'desc'    => wp_kses( __( 'you can set <mark>Yes / No</mark> to enable/disable button area', 'astrip' ), wp_kses_allowed_html('post') ),
                'default' => true,
            ),
            array(
                'id'        => 'trip_info_content',
                'type'      => 'repeater',
                'title'     => esc_html__( 'Trip Info Content', 'astrip' ),
                'button_title' => esc_html__( 'Add New', 'astrip' ),
                'dependency' => array( 'trip_info_enable_disable_option', '==', 'true' ),
                'fields'    => array(
                  array(
                    'id'    => 'trip_info_content_name',
                    'type'  => 'text',
                    'title' => esc_html__( 'Name', 'astrip' ),
                  ),
              
                  array(
                    'id'    => 'trip_info_content_content',
                    'type'  => 'textarea',
                    'title' => esc_html__( 'Content', 'astrip' ),
                  ),
              
                ),
                'default'   => array(
                  array(
                    'trip_info_content_name' => 'Title',
                    'trip_info_content_content' => 'Content',
                  )
                )
            ),
        ),
    )
);