<?php 
/*-----------------------------------
TOUR PLAN SECTION
------------------------------------*/
CSF::createSection( EGNS_TOUR_META_ID,
    array(
        'title'  => esc_html__( 'Tour Plan', 'astrip' ),
        'parent' => 'astrip_tour_meta_option',
        'fields' => array(
            array(
                'type'    => 'subheading',
                'content' => esc_html__( 'Tour Plan Content', 'astrip' ),
            ),
            array(
                'id'      => 'tour_plan_enable_disable_option',
                'title'   => esc_html__( 'Enable/Disable', 'astrip' ),
                'type'    => 'switcher',
                'desc'    => wp_kses( __( 'you can set <mark>Yes / No</mark> to enable/disable button area', 'astrip' ), wp_kses_allowed_html('post') ),
                'default' => true,
			      ),
            array(
                'id'      => 'tour_plan_section_title',
                'type'    => 'text',
                'title'   => esc_html__( 'Section Title', 'astrip' ),
                'default' => esc_html__( 'Tour Plan', 'astrip' ),
                'dependency' => array( 'tour_plan_enable_disable_option', '==', 'true' ),
            ),
            array(
                'id'        => 'tour_plan_content',
                'type'      => 'repeater',
                'title'     => esc_html__( 'Tour Plan Content', 'astrip' ),
                'button_title' => esc_html__( 'Add New', 'astrip' ),
                'dependency' => array( 'tour_plan_enable_disable_option', '==', 'true' ),
                'fields'    => array(
                  array(
                    'id'    => 'tour_plan_content_title',
                    'type'  => 'text',
                    'title' => esc_html__( 'Title', 'astrip' ),
                  ),
              
                  array(
                    'id'    => 'tour_plan_content_description',
                    'type'  => 'wp_editor',
                    'title' => esc_html__( 'Description', 'astrip' ),
                  ),
              
                ),
                'default'   => array(
                  array(
                    'tour_plan_content_title' => 'Title',
                    'tour_plan_content_description' => 'Description',
                  )
                )
              ),
        ),
    )
);