<?php 
/*-----------------------------------
FAQ SECTION
------------------------------------*/
CSF::createSection( EGNS_TOUR_META_ID,
    array(
        'title'  => esc_html__( 'FAQ Questions/Answer', 'astrip' ),
        'parent' => 'astrip_tour_meta_option',
        'fields' => array(
            array(
                'type'    => 'subheading',
                'content' => esc_html__( 'FAQ Content Area', 'astrip' ),
            ),
            array(
                'id'      => 'faq_enable_disable_option',
                'title'   => esc_html__( 'Enable/Disable', 'astrip' ),
                'type'    => 'switcher',
                'desc'    => wp_kses( __( 'you can set <mark>Yes / No</mark> to enable/disable button area', 'astrip' ), wp_kses_allowed_html('post') ),
                'default' => true,
            ),
            array(
                'id'      => 'faq_section_title',
                'type'    => 'text',
                'title'   => esc_html__( 'Section Title', 'astrip' ),
                'default' => 'Frequently Asked Questions',
                'dependency' => array( 'faq_enable_disable_option', '==', 'true' ),
            ),
            array(
                'id'        => 'faq_content',
                'type'      => 'repeater',
                'title'     => esc_html__( 'FAQ Question/Answer', 'astrip' ),
                'button_title' => esc_html__( 'Add New FAQ', 'astrip' ),
                'dependency' => array( 'faq_enable_disable_option', '==', 'true' ),
                'fields'    => array(
                  array(
                    'id'    => 'faq_content_question',
                    'type'  => 'text',
                    'title' => esc_html__( 'Question', 'astrip' ),
                  ),
              
                  array(
                    'id'    => 'faq_content_answer',
                    'type'  => 'wp_editor',
                    'title' => esc_html__( 'Answer', 'astrip' ),
                  ),
              
                ),
                'default'   => array(
                  array(
                    'faq_content_question' => 'FAQ Question',
                    'faq_content_answer' => esc_html__( 'FAQ Answer', 'astrip' ),
                  )
                )
            ),
        ),
    )
);