<?php 
/*-----------------------------------
Package Included/Excludes SECTION
------------------------------------*/
CSF::createSection( EGNS_TOUR_META_ID,
    array(
        'title'  => esc_html__( 'Included/Excludes', 'astrip' ),
        'parent' => 'astrip_tour_meta_option',
        'fields' => array(
            array(
                'type'    => 'subheading',
                'content' => esc_html__( 'Package Included/Excludes Content', 'astrip' ),
            ),
            array(
              'id'      => 'pie_enable_disable_option',
              'title'   => esc_html__( 'Enable/Disable', 'astrip' ),
              'type'    => 'switcher',
              'desc'    => wp_kses( __( 'you can set <mark>Yes / No</mark> to enable/disable button area', 'astrip' ), wp_kses_allowed_html('post') ),
              'default' => true,
            ),
            array(
                'id'      => 'facility_title',
                'type'    => 'text',
                'title'   => esc_html__( 'Main Title', 'astrip' ),
                'default' => esc_html__( 'Free Package Facility', 'astrip' ),
                'dependency' => array( 'pie_enable_disable_option', '==', 'true' ),
            ),
            array(
                'id'      => 'included_title',
                'type'    => 'text',
                'title'   => esc_html__( 'Title', 'astrip' ),
                'default' => esc_html__( 'Package Included', 'astrip' ),
                'dependency' => array( 'pie_enable_disable_option', '==', 'true' ),
            ),
            array(
                'id'        => 'included_content',
                'type'      => 'repeater',
                'title'     => esc_html__( 'Included Content', 'astrip' ),
                'button_title' => esc_html__( 'Add New', 'astrip' ),
                'dependency' => array( 'pie_enable_disable_option', '==', 'true' ),
                'fields'    => array(
                  array(
                    'id'    => 'included_content_name',
                    'type'  => 'text',
                    'title' => esc_html__( 'Name', 'astrip' ),
                  ),
                ),
                'default'   => array(
                  array(
                    'included_content_name' => 'Name',
                  )
                )
            ),
            
            /** Excludes Content **/
            array(
                'id'      => 'excludes_title',
                'type'    => 'text',
                'title'   => esc_html__( 'Title', 'astrip' ),
                'default' => esc_html__( 'Package Excludes', 'astrip' ),
                'dependency' => array( 'pie_enable_disable_option', '==', 'true' ),
            ),
            array(
                'id'        => 'excludes_content',
                'type'      => 'repeater',
                'title'     => esc_html__( 'Excludes Content', 'astrip' ),
                'button_title' => esc_html__( 'Add New', 'astrip' ),
                'dependency' => array( 'pie_enable_disable_option', '==', 'true' ),
                'fields'    => array(
                  array(
                    'id'    => 'excludes_content_name',
                    'type'  => 'text',
                    'title' => esc_html__( 'Name', 'astrip' ),
                  ),
                ),
                'default'   => array(
                  array(
                    'excludes_content_name' => 'Name',
                  )
                )
            ),
            // A Notice
            array(
              'type'    => 'notice',
              'style'   => 'info',
              'content' => "<strong>NOTE:</strong> You can use this shortcode <strong>[astrip_package_included_excludes]</strong> to display Tour Info of this tour in posts/pages/tabs or use this snippet <strong><?php echo do_shortcode('[astrip_package_included_excludes id=1916]'); ?></strong> to display Tour Info in templates.",
            ),
        ),
    )
);