<?php 
/*-----------------------------------
LOCATION MAP SECTION
------------------------------------*/
CSF::createSection( EGNS_TOUR_META_ID,
    array(
        'title'  => esc_html__( 'Location Map', 'astrip' ),
        'parent' => 'astrip_tour_meta_option',
        'fields' => array(
            array(
                'type'    => 'subheading',
                'content' => esc_html__( 'Location', 'astrip' ),
            ),
            array(
				'id'      => 'location_enable_disable_option',
				'title'   => esc_html__( 'Enable/Disable', 'astrip' ),
				'type'    => 'switcher',
				'desc'    => wp_kses( __( 'you can set <mark>Yes / No</mark> to enable/disable button area', 'astrip' ), wp_kses_allowed_html('post') ),
				'default' => true,
			),
            array(
                'id'      => 'location_title',
                'type'    => 'text',
                'title'   => esc_html__( 'Section Title', 'astrip' ),
                'default' => 'Location Map',
                'dependency' => array( 'location_enable_disable_option', '==', 'true' ),
            ),
            array(
                'id'    => 'location_map_iframe_code',
                'type'  => 'code_editor',
                'title' => esc_html__( 'Map iFrame Code', 'astrip' ),
                'sanitize' => false,
                'dependency' => array( 'location_enable_disable_option', '==', 'true' ),
            ),
            array(
                'id'    => 'location_description',
                'type'  => 'wp_editor',
                'title' => esc_html__( 'Description', 'astrip' ),
                'dependency' => array( 'location_enable_disable_option', '==', 'true' ),
            ),
        ),
    )
);