<?php
/*-----------------------------------
GENERAL INFORMATION SECTION
------------------------------------*/

// Pricing Type 
$pricing_type = '';
if (function_exists('get_woocommerce_currency_symbol')) {
  $pricing_type =  'Pricing Type' . '(' . get_woocommerce_currency_symbol() . ')';
} else {
  $pricing_type =  'Pricing Type';
}

CSF::createSection(
  EGNS_TOUR_META_ID,
  array(
    'title'  => esc_html__('General Information', 'astrip'),
    'parent' => 'astrip_tour_meta_option',
    'fields' => array(
      array(
        'type'    => 'subheading',
        'content' => esc_html__('General Information', 'astrip'),
      ),
      array(
        'id'      => 'tour_video_and_gallery',
        'title'   => esc_html__('Breadcrumb Gallery & Video', 'astrip'),
        'type'    => 'switcher',
        'desc'    => wp_kses(__('you can set <mark>Yes / No</mark> to enable/disable tour video', 'astrip'), wp_kses_allowed_html('post')),
        'default' => true,
      ),
      array(
        'id'         => 'tour_video_and_gallery_options',
        'type'       => 'radio',
        'inline'     => true,
        'title'   => esc_html__('Select Options (Video/Gallery)', 'astrip'),
        'options'         => array(
          'breadcrumb_img'    => esc_html__('Image', 'astrip'),
          'breadcrumb_video'    => esc_html__('Video', 'astrip'),
          'breadcrumb_gallery' => esc_html__('Gallery', 'astrip'),
        ),
        'desc'    => wp_kses(__('you can select <mark>Header Style </mark> for header section', 'astrip'), wp_kses_allowed_html('post')),
        'default' => 'breadcrumb_img',
        'dependency' => array('tour_video_and_gallery', '==', 'true'),
      ),
      array(
        'id'    => 'tour_breadcrumb_image',
        'type'  => 'media',
        'title' => esc_html('Breadcrumb Thumb Image:'),
        'dependency' => array('tour_video_and_gallery|tour_video_and_gallery_options', '==|==', 'true|breadcrumb_img'),
        'default'  => array(
          'url'         => esc_url(EGNS_THEME_SETTINGS_IMAGES . '/breadcrumb/breadcrumb-bg.jpg'),
          'id'          => 'logo',
          'thumbnail'   => esc_url(EGNS_THEME_SETTINGS_IMAGES . '/breadcrumb/breadcrumb-bg.jpg'),
          'alt'         => esc_attr('logo'),
          'title'       => esc_html('Logo'),
        ),
      ),
      array(
        'id'    => 'tour_breadcrumb_video',
        'type'  => 'media',
        'title' => esc_html('Breadcrumb Thumb Video:'),
        'dependency' => array('tour_video_and_gallery|tour_video_and_gallery_options', '==|==', 'true|breadcrumb_video'),
      ),
      array(
        'id'    => 'tour_breadcrumb_gallery',
        'type'  => 'gallery',
        'title' => esc_html('Breadcrumb Thumb Gallery'),
        'dependency' => array('tour_video_and_gallery|tour_video_and_gallery_options', '==|==', 'true|breadcrumb_gallery'),
      ),
      array(
        'id'          => 'tour_booking_options',
        'type'        => 'select',
        'title'       => esc_html('Booking Options', 'astrip'),
        'placeholder' => esc_html__('Select an Option', 'astrip'),
        'options'     => array(
          'enquiry_form'    => esc_html__('Enquiry Form', 'astrip'),
          'booking_form'    => esc_html__('Booking Form ', 'astrip'),
          'both'            => esc_html__('Both', 'astrip'),
        ),
        'default'     => 'both'
      ),
      array(
        'id'    => 'regular_price',
        'type'  => 'text',
        'title' => esc_html__('Regular Price','astrip'),
        'dependency' => array('tour_booking_options', '==', 'enquiry_form'),
        'desc'        => esc_html__('Please fill-up this field!','astrip'),
        'class'       => 'text-danger',
        'attributes'  => array(
          'required'  => true,
        ),
        'validate'   => 'csf_validate_required',
      ), 
      array(
        'id'    => 'sale_price',
        'type'  => 'text',
        'title' => esc_html__('Sale Price','astrip'),
        'dependency' => array('tour_booking_options', '==', 'enquiry_form'),
      ),      
      array(
        'id'          => 'tour_product',
        'type'        => 'select',
        'title'       => esc_html__('Select Product', 'astrip'),
        'placeholder' => esc_html__('Select a Product', 'astrip'),
        'desc'        => wp_kses_post( 'Must be select <mark>Product</mark> for package You can create product form here ( <a href="' . home_url() . '/wp-admin/edit.php?post_type=product">Product</a> )' ),
        'chosen'      => true,
        'ajax'        => true,
        'options'     => 'posts',
        'query_args'  => array(
          'post_type' => 'product'
        ),
        'dependency' => array('tour_booking_options', '!=', 'enquiry_form'),
      ),
      array(
        'id'          => 'tour_destination',
        'type'        => 'select',
        'title'       => esc_html__('Select Destination', 'astrip'),
        'placeholder' => esc_html__('Select a Destination', 'astrip'),
        'chosen'      => true,
        'ajax'        => true,
        'options'     => 'posts',
        'query_args'  => array(
          'post_type' => 'astrip-destination'
        ),
        'width'       => '100%',
      ),
      array(
        'id'          => 'pricing_type',
        'type'        => 'select',
        'title'       => esc_html($pricing_type, 'astrip'),
        'placeholder' => esc_html__('Select an Type', 'astrip'),
        'options'     => array(
          'per_person '  => esc_html__('Per Person ', 'astrip'),
          'per_group'  => esc_html__('Per Group', 'astrip'),
        ),
        'default'     => 'per_person'
      ),
      array(
        'id'      => 'tour_duration',
        'type'    => 'text',
        'title'   => esc_html__('Duration', 'astrip'),
      ),

      array(
        'id'      => 'tour_max_people',
        'type'    => 'number',
        'title'   => esc_html__('Max People', 'astrip'),
      ),
      array(
        'id'        => 'tour_date',
        'type'      => 'repeater',
        'title'     => esc_html__('Tour Booking Date', 'astrip'),
        'fields'    => array(
          array(
            'id'    => 'tour_start_date',
            'type'  => 'date',
            'title' => esc_html('Check In', 'astrip'),
          ),

          array(
            'id'    => 'tour_end_date',
            'type'  => 'date',
            'title' => esc_html('Check Out', 'astrip'),
          ),

        )
      ),
      array(
        'id'      => 'tour_children_age',
        'type'    => 'text',
        'title'   => esc_html__('Children Age(Range)', 'astrip'),
      ),
    ),
  )
);
