<?php

/*-----------------------------------------
	CONTROL CORE CLASSES FOR AVOID ERRORS
------------------------------------------*/
if (class_exists('CSF')) {
  $prefix       = 'egns';
  /*-------------------------------------------------------
	   ** Tour Review  Options
   --------------------------------------------------------*/
  CSF::createSection($prefix . '_theme_options', array(
    'id'    => 'tour_review',
    'title' => esc_html__('Astrip Tour', 'astrip'),
    'icon'  => 'fa fa-grav'
  ));

  CSF::createSection($prefix . '_theme_options', array(
    'parent' => 'tour_review', // The slug id of the parent section
    'title'  => esc_html__('Add Review criteria', 'astrip'),
    'fields' => array(

      array(
        'id'      => 'tour_book_form_title',
        'type'    => 'text',
        'title'   => esc_html__('Tour Booking Form Title', 'astrip'),
        'default'   => esc_html__('Book this Tour', 'astrip'),
      ),

      array(
        'id'     => 'tour_criteria',
        'type'   => 'repeater',
        'max'    => 5,
        'title'  => esc_html__('Tour Criteria', 'astrip'),
        'fields' => array(

          array(
            'id'    => 'criteria_item',
            'type'  => 'text',
            'title' => esc_html__('Creiteria', 'astrip'),
            'default' => esc_html__('Transport', 'astrip'),
          ),

        ),
        'default'   => array(
          array(
            'criteria_item' => esc_html('Overall'),
          ),
          array(
            'criteria_item' => esc_html('Accommodation'),
          ),
          array(
            'criteria_item' => esc_html('Transport'),
          ),
          array(
            'criteria_item' => esc_html('Food'),
          ),
          array(
            'criteria_item' => esc_html('Destination'),
          ),
        )
      ),

    )
  ));
}
