<?php
/*-----------------------------------
		Logo Options
	------------------------------------*/

CSF::createSection($prefix . '_theme_options', array(
	'parent' => 'header_options',
	'title'  => esc_html__('Logo', 'astrip'),
	'id'     => 'theme_header_logo_options',
	'icon'   => 'fa fa-id-card-o',
	'fields' => array(
		array(
			'type'    => 'subheading',
			'content' => '<h3>' . esc_html__('Upload Logo', 'astrip') . '</h3>'
		),
		array(
			'id'      => 'header_logo',
			'title'   => esc_html__('Upload Header Logo', 'astrip'),
			'type'    => 'media',
			'desc'    => wp_kses(__('you can upload logo for header', 'astrip'), $allowed_html),
			'default' => array(
				'url'       => esc_url(EGNS_THEME_SETTINGS_IMAGES . '/logo/logo.svg'),
				'id'        => 'logo',
				'thumbnail' => esc_url(EGNS_THEME_SETTINGS_IMAGES . '/logo/logo.svg'),
				'alt'       => esc_attr('logo'),
				'title'     => esc_html('Logo'),
			),
		),
		array(
			'id'      => 'header_logo_mobile',
			'title'   => esc_html__('Upload Mobile Logo', 'astrip'),
			'type'    => 'media',
			'desc'    => wp_kses(__('you can upload Mobile Logo for header', 'astrip'), $allowed_html),
			'default' => array(
				'url'       => esc_url(EGNS_THEME_SETTINGS_IMAGES . '/logo/logo.svg'),
				'id'        => 'logo',
				'thumbnail' => esc_url(EGNS_THEME_SETTINGS_IMAGES . '/logo/logo.svg'),
				'alt'       => esc_attr('logo'),
				'title'     => esc_html('Logo'),
			),
		),
		array(
			'id'      => 'sticky_header_logo',
			'title'   => esc_html__('Sticky Header Logo', 'astrip'),
			'type'    => 'media',
			'desc'    => wp_kses(__('you can upload Sticky Header Logo for header', 'astrip'), $allowed_html),
			'default' => array(
				'url'       => esc_url(EGNS_THEME_SETTINGS_IMAGES . '/logo/logo.svg'),
				'id'        => 'logo',
				'thumbnail' => esc_url(EGNS_THEME_SETTINGS_IMAGES . '/logo/logo.svg'),
				'alt'       => esc_attr('logo'),
				'title'     => esc_html('Logo'),
			),
		),
		array(
			'id'       => 'astrip_logo_dimensions',
			'type'     => 'dimensions',
			'title'    => 'Set Logo width & height',
			'output_important'   => true,
			'default'  => array(
				'width'  => '150',
				'height' => '',
				'unit'   => 'px',
			),
			'output' => array(
				'header.style-2 .header-logo img',
				'header.style-2.sticky .header-sticky-logo img',

				'header.style-4 .header-logo img',
				'header.style-4.sticky .header-sticky-logo img',

				'.main-nav-wrapper .mobile-logo-area .header-logo img',
				'header.style-3 .header-logo img'
			),
		),
	),

));
