<?php
/*-----------------------------------
		Logo Options
	------------------------------------*/

CSF::createSection($prefix . '_theme_options', array(
	'parent' => 'header_options',
	'title'  => esc_html__('Topbar', 'astrip'),
	'id'     => 'theme_header_topbar_options',
	'icon'   => 'fa fa-id-card-o',
	'fields' => array(
		array(
			'type'    => 'subheading',
			'content' => '<h3>' . esc_html__('Topbar', 'astrip') . '</h3>'
		),
		array(
			'id'      => 'header_topbar_enable',
			'title'   => esc_html__('Enable Topbar', 'astrip'),
			'type'    => 'switcher',
			'desc'    => wp_kses(__('you can set <mark>Yes / No</mark> to enable/disable header topbar', 'astrip'), $allowed_html),
			'default' => true,
		),
		array(
			'id'      => 'header_topbar_icon_source',
			'title'   => esc_html__('Icon Source', 'astrip'),
			'type'    => 'select',
			'options'     		=> array(
				'custom_svg'  	=> 'Custom SVG',
				'icon_library' 	=> 'Icon Library (Fontawesome Icons / Bootstrap Icons)',
			),
			'desc'    => wp_kses(__('you can select <mark>Header Style </mark> for header section', 'astrip'), $allowed_html),
			'default' => 'icon_library',
			'dependency' => array('header_topbar_enable', '==', 'true')
		),
		array(
			'type'    => 'subheading',
			'content' => '<h3>' . esc_html__('Topbar Content', 'astrip') . '</h3>'
		),
		array(
			'id'    	=> 'header_topbar_content_left_icon_one',
			'type'  	=> 'media',
			'title' 	=> esc_html__('Content Left Icon (1)', 'astrip'),
			'dependency' => array('header_topbar_enable|header_topbar_icon_source', '==|==', 'true|custom_svg'),
			'default'	=> array(
				'url'         => esc_url(EGNS_THEME_SETTINGS_IMAGES . '/topbar/cell-icon.svg'),
				'id'          => 'content_icon',
				'thumbnail'   => esc_url(EGNS_THEME_SETTINGS_IMAGES . '/topbar/cell-icon.svg'),
				'alt'         => esc_attr('content-icons'),
				'title'       => esc_html('Icon'),
			),
		),
		array(
			'id'      	=> 'header_topbar_content_left_icon_one_class',
			'type'    	=> 'text',
			'title' 	=> esc_html__('Content Left Icon Class (1)', 'astrip'),
			'dependency' => array('header_topbar_enable|header_topbar_icon_source', '==|==', 'true|icon_library'),
			'default'	=> 'bi bi-clock',
			'desc'    => wp_kses(__('you can use <mark> Fontawesome or Bootstrap Icon </mark> for header topbar', 'astrip'), $allowed_html),
		),
		array(
			'id'    	=> 'header_topbar_content_left_icon_two',
			'type'  	=> 'media',
			'title' 	=> esc_html__('Contact Left Icon (2)', 'astrip'),
			'dependency' => array('header_topbar_enable|header_topbar_icon_source', '==|==', 'true|custom_svg'),
			'default'	=> array(
				'url'         => esc_url(EGNS_THEME_SETTINGS_IMAGES . '/topbar/cell-icon.svg'),
				'id'          => 'content_icon',
				'thumbnail'   => esc_url(EGNS_THEME_SETTINGS_IMAGES . '/topbar/cell-icon.svg'),
				'alt'         => esc_attr('content-icons'),
				'title'       => esc_html('Icon'),
			),
		),
		array(
			'id'      	=> 'header_topbar_content_left_icon_two_class',
			'type'    	=> 'text',
			'title' 	=> esc_html__('Content Left Icon Class (2)', 'astrip'),
			'dependency' => array('header_topbar_enable|header_topbar_icon_source', '==|==', 'true|icon_library'),
			'default'	=> 'bi bi-geo-alt',
			'desc'    => wp_kses(__('you can use <mark> Fontawesome or Bootstrap Icon </mark> for header topbar', 'astrip'), $allowed_html),
		),
		array(
			'id'    	=> 'header_topbar_content_left_text_one',
			'type'  	=> 'text',
			'title' 	=> esc_html__('Content Left Text (1)', 'astrip'),
			'default' 	=> esc_html__('Opening Hours: 8am - 6pm', 'astrip'),
			'dependency' => array('header_topbar_enable', '==', 'true'),
		),

		array(
			'id'    	=> 'header_topbar_content_left_text_two',
			'type'  	=> 'text',
			'title' 	=> esc_html__('Contact Left Text (2)', 'astrip'),
			'default' 	=> esc_html__('2464 Royal Ln. Mesa New', 'astrip'),
			'dependency' => array('header_topbar_enable', '==', 'true'),
		),
		array(
			'id'    	=> 'header_topbar_right_side_shortcode',
			'type'  	=> 'textarea',
			'title' 	=> esc_html__('Shortcode or Text (Right Side Top)', 'astrip'),
			'dependency' => array('header_topbar_enable', '==', 'true'),
		),

		array(
			'type'    => 'notice',
			'content' => '<h4>' . wp_kses(__('Select Topbar Rightside Menu from Apperence->Menus (create menu & check mark Top Bar Menu then save)', 'astrip'), $allowed_html) . '</h4>',
			'dependency' => array('header_topbar_enable', '==', 'true'),
		),

		array(
			'type'    => 'subheading',
			'content' => '<h3>' . esc_html__('Topbar Social', 'astrip') . '</h3>'
		),
		array(
			'id'      => 'header_topbar_social_enable',
			'title'   => esc_html__('Enable Social', 'astrip'),
			'type'    => 'switcher',
			'desc'    => wp_kses(__('you can set <mark>Yes / No</mark> to enable/disable Social', 'astrip'), $allowed_html),
			'default' => true,
		),
		array(
			'id'     => 'header_topbar_social_list',
			'type'   => 'repeater',
			'title'  => 'Repeater',
			'dependency' => array('header_topbar_enable|header_topbar_social_enable', '==|==', 'true|true'),
			'fields' => array(

				array(
					'id'      => 'header_topbar_social_class',
					'type'    => 'icon',
					'title'   => esc_html__('Social icon', 'astrip'),
					'default' => 'fa fa-heart'
				),
				array(
					'id'    => 'header_topbar_social_link',
					'type'  => 'link',
					'title' => esc_html__('Social link', 'astrip'),
					'default' => array(
						'url'    => 'https://www.example.com/',
						'target' => '_blank'
					),
				),

			),
			'default'   => array(
				array(
					'header_topbar_social_class' => 'fab fa-facebook-f',
					'header_topbar_social_link' => array(
						'url'    => 'https://www.facebook.com/',
						'target' => '_blank'
					),
				),
				array(
					'header_topbar_social_class' => 'fab fa-twitter',
					'header_topbar_social_link' => array(
						'url'    => 'https://www.twitter.com/',
						'target' => '_blank'
					),
				),
				array(
					'header_topbar_social_class' => 'fab fa-linkedin-in',
					'header_topbar_social_link' => array(
						'url'    => 'https://www.linkedin.com/',
						'target' => '_blank'
					),
				),
				array(
					'header_topbar_social_class' => 'fab fa-instagram',
					'header_topbar_social_link' => array(
						'url'    => 'https://www.instagram.com/',
						'target' => '_blank'
					),
				),
			)
		),


		array(
			'type'    => 'subheading',
			'content' => '<h3>' . esc_html__('Topbar Color', 'astrip') . '</h3>'
		),
		array(
			'id'    		=> 'header_topbar_bg_color',
			'type'  		=> 'color',
			'title'   		=> esc_html__('Background Color', 'astrip'),
			'desc'    		=> wp_kses(__('you can select <mark>Header Topbar Text Color </mark> for header topbar section', 'astrip'), $allowed_html),
			'dependency'	=> array('header_topbar_enable', '==', 'true'),
		),
		array(
			'id'    		=> 'header_topbar_text_color',
			'type'  		=> 'color',
			'title'   		=> esc_html__('Text Color', 'astrip'),
			'desc'    		=> wp_kses(__('you can select <mark>Header Topbar Text Color </mark> for header topbar section', 'astrip'), $allowed_html),
			'dependency'	=> array('header_topbar_enable', '==', 'true'),
		),
		array(
			'id'    		=> 'header_topbar_icon_color',
			'type'  		=> 'color',
			'title'   		=> esc_html__('Icon Color', 'astrip'),
			'desc'    		=> wp_kses(__('you can select <mark>Header Topbar Icon Color </mark> for header topbar section', 'astrip'), $allowed_html),
			'dependency'	=> array('header_topbar_enable', '==', 'true'),
		),
		array(
			'id'    		=> 'header_topbar_select_menu_hover_color',
			'type'  		=> 'color',
			'title'   		=> esc_html__('Select Menu Hover Color', 'astrip'),
			'desc'    		=> wp_kses(__('you can select <mark>Header Topbar Link Hover Color </mark> for header topbar section', 'astrip'), $allowed_html),
			'dependency'	=> array('header_topbar_enable', '==', 'true'),
		),
	),

));
