<?php
/*-------------------------------------------------------
		   ** Footer  Options
	--------------------------------------------------------*/
CSF::createSection($prefix . '_theme_options', array(
	'title'  => esc_html__('Footer', 'astrip'),
	'id'     => 'footer_options',
	'icon'   => 'fa fa-copyright',
	'fields' => array(
		array(
			'type'    => 'subheading',
			'content' => '<h3>' . esc_html__('Footer Options', 'astrip') . '</h3>'
		),

		array(
			'id'      => 'footer_widget_area_background',
			'title'   => esc_html__('Footer Background Image', 'astrip'),
			'type'    => 'media',
			'desc'    => wp_kses(__('Set footer bottom background Image.', 'astrip'), $allowed_html),
			'default' => array(
				'url'         => esc_url(EGNS_THEME_SETTINGS_IMAGES . '/footer/footer-bg.png'),
				'thumbnail'   => esc_url(EGNS_THEME_SETTINGS_IMAGES . '/footer/footer-bg.png'),
				'alt'         => esc_attr('Footer Image'),
				'title'       => esc_html('Footer Image'),
			),
		),

		array(
			'id'          => 'footer_widget_area_padding',
			'type'        => 'spacing',
			'title'       => esc_html__('Footer Widget Area Space', 'astrip'),
			'desc'        => esc_html__('Set the space ( top / bottom ) in footer bottom.', 'astrip'),
			'left'        => false,
			'right'       => false,
			'units'       => array('px', 'px', 'em', '%', 'cm', 'pt'),
			'output_mode' => 'padding',
			'output'      => '.footer-bottom',
			'default'     => array(
				'top'       => '',
				'bottom'    => '',
				'unit'      => 'px',
			),
		),
		array(
			'type'    => 'subheading',
			'content' => '<h3>' . esc_html__('Footer Copyright Area', 'astrip') . '</h3>'
		),

		array(
			'id'    => 'copyright_text',
			'title' => esc_html__('Copyright Area Text', 'astrip'),
			'type'  => 'textarea',
			'default' => wp_kses(('Copyright 2023 <a href="#">Astrip</a> | Design By <a rel="nofollow" href="https://www.egenslab.com/">Egens Lab</a>'), $allowed_html),
			'desc'  => wp_kses(__('use  <mark>{copy}</mark> for copyright symbol, use <mark>{year}</mark> for current year, ', 'astrip'), $allowed_html),
		),
		array(
			'id'          => 'copyright_area_spacing',
			'type'        => 'spacing',
			'title'       => esc_html__('Footer Copyright Area Space', 'astrip'),
			'desc'        => esc_html__('Set the space ( top / bottom ) in footer bottom.', 'astrip'),
			'left'        => false,
			'right'       => false,
			'units'       => array('px', 'px', 'em', '%', 'cm', 'pt'),
			'default'     => array(
				'top'       => '',
				'bottom'    => '',
				'unit'      => 'px',
			),
		),

		array(
			'type'    => 'subheading',
			'content' => '<h3>' . esc_html__('Footer Important Link', 'astrip') . '</h3>'
		),

		array(
			'id'        => 'footer_menu_list',
			'type'      => 'repeater',
			'fields'    => array(
				array(
					'id'    => 'footer_menu_name',
					'type'  => 'text',
					'title' => esc_html('Text'),
				),
				array(
					'id'       => 'footer_menu_link',
					'type'     => 'link',
					'title'    => esc_html('Link'),
					'default'  => array(
						'url'    => '#',
						'text'   => esc_html('Menu Link'),
						'target' => '_blank'
					),
				),
			),
			'default'   => array(
				array(
					'footer_menu_name' => esc_html('Privacy Policy'),
					'footer_menu_link' => array(
						'url'   => '#',
						'text'  => esc_html('Privacy Policy'),
						'target' => '_blank'
					),
				),
				array(
					'footer_menu_name' => esc_html('Terms of Use'),
					'footer_menu_link' => array(
						'url'   => '#',
						'text'  => esc_html('Terms of Use'),
						'target' => '_blank'
					)
				),
			)
		),
		// Footer Meta Link 
		array(
			'type'    => 'subheading',
			'content' => '<h3>' . esc_html__('Footer Meta', 'astrip') . '</h3>'
		),
		array(
			'type'    => 'subheading',
			'content' => '<h5>' . esc_html__('Social Meta', 'astrip') . '</h5>'
		),
		array(
			'id'    => 'footer_meta_social_text',
			'type'  => 'text',
			'title' => esc_html__('Social Text', 'astrip'),
			'default' => esc_html__('Stay Connected:','astrip')
		),
		array(
			'id'        => 'footer_meta_social',
			'type'      => 'repeater',
			'fields'    => array(
				array(
					'id'      => 'footer_meta_social_icon',
					'type'    => 'icon',
					'title'   => 'Icon',
					'default' => esc_html('fa fa-facebook'),
				),
				array(
					'id'      => 'footer_meta_social_link',
					'type'    => 'text',
					'title'   => esc_html__('Link','astrip'),
					'default' => esc_url('https://facebook.com'),
				),

			),
			'default'   => array(
				array(
					'footer_meta_social_icon' => esc_html('fa fa-facebook'),
					'footer_meta_social_link' => esc_url('https://facebook.com'),
				),
				array(
					'footer_meta_social_icon' => esc_html('fa fa-twitter'),
					'footer_meta_social_link' => esc_url('https://twitter.com'),
				),
				array(
					'footer_meta_social_icon' => esc_html('fa fa-instagram'),
					'footer_meta_social_link' => esc_url('https://instagram.com'),
				),
				array(
					'footer_meta_social_icon' => esc_html('fa fa-pinterest'),
					'footer_meta_social_link' => esc_url('https://pinterest.com'),
				),
			)
		),
		array(
			'type'    	=> 'subheading',
			'content' 	=> '<h5>' . esc_html__('Brand Meta', 'astrip') . '</h5>'
		),
		array(
			'id'    	=> 'footer_meta_brand_text',
			'type'  	=> 'text',
			'title' 	=> esc_html__('Brand Text', 'astrip'),
			'default'	=> esc_html__('Pay Safely With Us!', 'astrip'),
		),
		array(
			'id'        => 'footer_meta_brand',
			'type'      => 'repeater',
			'fields'    => array(
				array(
					'id'    	=> 'footer_meta_brand_image',
					'type'  	=> 'upload',
					'title' 	=> esc_html__('Upload Brand Image', 'astrip'),
				),
			),
			'default'   => array(
				array(
					'footer_meta_brand_image' => EGNS_THEME_SETTINGS_IMAGES . '/footer/pay1.svg'
				),
				array(
					'footer_meta_brand_image' => EGNS_THEME_SETTINGS_IMAGES . '/footer/pay2.svg'
				),
				array(
					'footer_meta_brand_image' => EGNS_THEME_SETTINGS_IMAGES . '/footer/pay3.svg'
				),
				array(
					'footer_meta_brand_image' => EGNS_THEME_SETTINGS_IMAGES . '/footer/pay4.svg'
				),
			)
		),
		// End Footer Meta Link
		array(
			'type'    	=> 'subheading',
			'content' 	=> '<h3>' . esc_html__('Color Options', 'astrip') . '</h3>'
		),

		array(
			'id'    	=> 'footer_copyright_area_text_color',
			'type'  	=> 'color',
			'title'   	=> esc_html__('Copyright Text Color', 'astrip'),
			'desc'    	=> wp_kses(__('you can select <mark>Footer Copyright Text Color </mark> for footer section', 'astrip'), $allowed_html),
		),
		array(
			'id'    	=> 'footer_copyright_area_link_color',
			'type'  	=> 'color',
			'title'   	=> esc_html__('Copyright Link Color', 'astrip'),
			'desc'    	=> wp_kses(__('you can select <mark>Footer Copyright Link Color </mark> for footer section', 'astrip'), $allowed_html),
		),
		array(
			'id'    	=> 'footer_bottom_nav_color',
			'type'  	=> 'color',
			'title'   	=> esc_html__('Footer Bottom Nav Color', 'astrip'),
			'desc'    	=> wp_kses(__('you can select <mark>Footer Bottom Nav Color </mark> for footer section', 'astrip'), $allowed_html),
		),
		array(
			'id'    	=> 'footer_bottom_nav_hover_color',
			'type'  	=> 'color',
			'title'   	=> esc_html__('Footer Bottom Nav Hover Color', 'astrip'),
			'desc'    	=> wp_kses(__('you can select <mark>Footer Bottom Nav Hover Color </mark> for footer section', 'astrip'), $allowed_html),
		),
	)
));
