<?php

/*-------------------------------------------------------
		  ** Breadcrumbs Options
--------------------------------------------------------*/

CSF::createSection($prefix . '_theme_options', array(
	'title'  => esc_html__('Breadcrumb', 'astrip'),
	'id'     => 'breadcrumb_options',
	'icon'   => 'fa fa-ellipsis-h',
	'fields' => array(
		array(
			'type'    => 'subheading',
			'content' => '<h3>' . esc_html__('Breadcrumb Options', 'astrip') . '</h3>'
		),
		array(
			'id'      => 'breadcrumb_enable',
			'title'   => esc_html__('Breadcrumb', 'astrip'),
			'type'    => 'switcher',
			'desc'    => wp_kses(__('you can set <mark>Yes / No</mark> to show/hide breadcrumb', 'astrip'), $allowed_html),
			'default' => true,
		),
		array(
			'id'      => 'breadcrumb_title_typography',
			'type'    => 'typography',
			'title'   => esc_html__('Title Typography', 'astrip'),
			'default' => array(
				'color'       => '#fff',
				'font-family' => 'Merriweather',
				'font-size'   => '50',
				'line-height' => '',
				'unit'        => 'px',
				'type'        => 'google',
			),
			'line_height' => false,
			'dependency'  => array('breadcrumb_enable', '==', 'true')
		),
		array(
			'id'         => 'breadcrumb_subtitle_color',
			'type'       => 'color',
			'title'      => esc_html__('Breadcrumb Sub title Color', 'astrip'),
			'default'    => '#fff',
			'dependency' => array('breadcrumb_enable', '==', 'true'),
		),
		array(
			'id'         => 'breadcrumb_bg_color',
			'type'       => 'color',
			'title'      => esc_html__('Breadcrumb Background Color', 'astrip'),
			'default'    => '#000',
			'dependency' => array('breadcrumb_enable', '==', 'true'),
		),
		array(
			'id'         => 'breadcrumb_bg_image',
			'type'       => 'media',
			'title'      => esc_html__('Breadcrumb Background Image', 'astrip'),
			'desc'       => esc_html__('Set the banner background image', 'astrip'),
			'dependency' => array('breadcrumb_enable', '==', 'true'),
			'default'    => array(
				'url'       => esc_url(EGNS_THEME_SETTINGS_IMAGES . '/breadcrumb/breadcrumb-bg.jpg'),
				'id'        => 'mail_icon',
				'thumbnail' => esc_url(EGNS_THEME_SETTINGS_IMAGES . '/breadcrumb/breadcrumb-bg.jpg'),
				'alt'       => esc_attr('logo-icons'),
				'title'     => esc_html('logo Title'),
			),
		),
	)
));
