<?php

// Control core classes for avoid errors
if (class_exists('CSF')) {

    // Set a unique slug-like ID
    $prefix = 'astrip_tour_taxonomy';

    // Create taxonomy options
    CSF::createTaxonomyOptions($prefix, array(
        'taxonomy'  => 'astrip-tour-type',
        'data_type' => 'serialize', // The type of the database save options. `serialize` or `unserialize`
    ));

    // Create a section
    CSF::createSection($prefix, array(
        'fields' => array(
            array(
                'id'    => 'astrip_tour_type_image',
                'type'  => 'media',
                'title' => esc_html__('Image', 'astrip'),
            ),
        )
    ));

    $review_rating_preview = 'astrip_review_rating';
    // Create taxonomy options
    CSF::createTaxonomyOptions($review_rating_preview, array(
        'taxonomy'  => 'astrip-review-rating',
        'data_type' => 'serialize', // The type of the database save options. `serialize` or `unserialize`
    ));

    // Create a section
    CSF::createSection($review_rating_preview, array(
        'fields' => array(
            array(
                'id'    => 'astrip_review_rating_name',
                'type'  => 'media',
                'title' => esc_html__('Name', 'astrip'),
            ),
        )
    ));
}
