<?php

// Control core classes for avoid errors
if (class_exists('CSF')) {

    //Set a unique slug-like ID
    $prefix = 'tour_astrip_review_rating';

    //Create a metabox
    CSF::createMetabox($prefix, array(
        'title'     => esc_html__('Review & Rating Meta', 'astrip'),
        'post_type' => 'review-rating',
    ));

    //Create a section
    CSF::createSection($prefix, array(
        'title'  => esc_html__('Review & Rating Data', 'astrip'),
        'fields' => array(
            array(
                'id'         => 'review_status',
                'type'       => 'select',
                'title'      => esc_html('Review Status'),
                'options'    => array(
                    'approve'  => esc_html__('Approve', 'astrip'),
                    'unapprove' => esc_html__('Unapprove', 'astrip'),
                ),
                'default'    => 'unapprove'
            ),
            array(
                'id'            => 'customer_id',
                'type'          => 'text',
                'title'         =>  esc_html__('User ID', 'astrip'),
                'attributes'    => array('readonly' => true)
            ),
            array(
                'id'            => 'tour_package_id',
                'type'          => 'text',
                'title'         =>  esc_html__('Tour Package URL', 'astrip'),
                'attributes'    =>  array('readonly' => true)
            ),
            array(
                'id'            => 'tour_package_title',
                'type'          => 'text',
                'title'         =>  esc_html__('Tour Package Title', 'astrip'),
                'attributes'    => array('readonly' => true)
            ),
            array(
                'id'            => 'customer_name',
                'type'          => 'text',
                'title'         =>  esc_html__('User Name', 'astrip'),
                'attributes'    => array('readonly' => true)
            ),
            array(
                'id'            => 'customer_email',
                'type'          => 'text',
                'title'         =>  esc_html__('User Phone', 'astrip'),
                'attributes'    => array('readonly' => true)
            ),
            array(
                'id'            => 'review_title',
                'type'          => 'text',
                'title'         =>  esc_html__('Review Title', 'astrip'),
                'attributes'    => array('readonly' => true)
            ),
            array(
                'id'            => 'review_message',
                'type'          => 'textarea',
                'title'         =>  esc_html__('Review Message', 'astrip'),
                'attributes'    => array('readonly' => true)

            ),
            array(
                'id'     => 'review_rating',
                'type'   => 'repeater',
                'title'  => esc_html__('Review Rating', 'astrip'),
                'attributes' => array('readonly' => true),
                'fields' => array(
                    array(
                        'id'    => 'reivew_criteria',
                        'type'  => 'text',
                        'title' => esc_html__('Criteria', 'astrip'),
                        'attributes' => array('readonly' => true)
                    ),
                    array(
                        'id'    => 'reivew_criteria_rating',
                        'type'  => 'number',
                        'title' => esc_html__('Rating', 'astrip'),
                        'attributes' => array('readonly' => true)
                    ),
                ),
            ),
        )
    ));
}
