<?php

/*-----------------------------------
PAGE MENU SECTION
------------------------------------*/
CSF::createSection(
    EGNS_META_ID . '-page',
    array(
        'title'  => esc_html__('Header Options', 'astrip'),
        'parent' => 'page_meta_option',
        'fields' => array(
            array(
                'type'       => 'subheading',
                'content'    => esc_html__('Menu Style', 'astrip'),
                'dependency' => array('custom_header_style', '==', 'false'),
            ),
            array(
                'id'      => 'page_header_topbar_enable',
                'type'    => 'switcher',
                'title'   => esc_html__('Header Topbar', 'astrip'),
                'desc'    => wp_kses(__('you can enable/disable <mark>Header Topbar </mark> for header section', 'astrip'), wp_kses_allowed_html('post')),
                'default' => 1
            ),
            array(
                'id'      => 'page_main_header_enable',
                'type'    => 'select',
                'title'   => esc_html__('Main Header', 'astrip'),
                'desc'    => wp_kses(__('you can enable/disable <mark>Main Header </mark> for header section', 'astrip'), wp_kses_allowed_html('post')),
                'options' => array(
                    'enable'  => esc_html('Enable'),
                    'disable' => esc_html('Disable'),
                ),
            ),
            array(
                'id'      => 'page_header_menu_style',
                'title'   => esc_html__('Select Style', 'astrip'),
                'type'    => 'select',
                'options' => array(
                    'default'      => esc_html__('Default', 'astrip'),
                    'header_one'   => esc_html__('Header One', 'astrip'),
                    'header_two'   => esc_html__('Header Two', 'astrip'),
                    'header_three' => esc_html__('Header Three', 'astrip'),
                ),
                'desc'       => wp_kses(__('you can select <mark>Header Style </mark> for header section', 'astrip'), wp_kses_allowed_html('post')),
                'default'    => 'default',
                'dependency' => array('page_main_header_enable', '==', 'enable'),
            ),

            array(
                'type'       => 'subheading',
                'content'    => '<h3>' . esc_html__('Upload Logo(Header One)', 'astrip') . '</h3>',
                'dependency' => array('page_header_menu_style', '==', 'header_one'),
            ),
            array(
                'id'         => 'header_one_logo',
                'title'      => esc_html__('Upload  Logo', 'astrip'),
                'type'       => 'media',
                'desc'       => wp_kses(__('you can upload <mark> Logo</mark> for header', 'astrip'), wp_kses_allowed_html('post')),
                'dependency' => array('page_header_menu_style', '==', 'header_one'),
            ),
            array(
                'id'         => 'header_one_sticky_logo',
                'title'      => esc_html__('Upload Sticky Logo', 'astrip'),
                'type'       => 'media',
                'desc'       => wp_kses(__('you can upload <mark>Sticky Logo</mark> for header', 'astrip'), wp_kses_allowed_html('post')),
                'dependency' => array('page_header_menu_style', '==', 'header_one'),
            ),
            array(
                'id'         => 'header_one_logo_mobile',
                'title'      => esc_html__('Upload Mobile Logo', 'astrip'),
                'type'       => 'media',
                'desc'       => wp_kses(__('you can upload <mark>Mobile Logo</mark> for header', 'astrip'), wp_kses_allowed_html('post')),
                'dependency' => array('page_header_menu_style', '==', 'header_one'),
            ),

            // Two

            array(
                'type'       => 'subheading',
                'content'    => '<h3>' . esc_html__('Upload Logo(Header Two)', 'astrip') . '</h3>',
                'dependency' => array('page_header_menu_style', '==', 'header_two'),
            ),
            array(
                'id'         => 'header_two_logo',
                'title'      => esc_html__('Upload  Logo', 'astrip'),
                'type'       => 'media',
                'desc'       => wp_kses(__('you can upload <mark> Logo</mark> for header', 'astrip'), wp_kses_allowed_html('post')),
                'dependency' => array('page_header_menu_style', '==', 'header_two'),
            ),
            array(
                'id'         => 'header_two_sticky_logo',
                'title'      => esc_html__('Upload Sticky Logo', 'astrip'),
                'type'       => 'media',
                'desc'       => wp_kses(__('you can upload <mark>Sticky Logo</mark> for header', 'astrip'), wp_kses_allowed_html('post')),
                'dependency' => array('page_header_menu_style', '==', 'header_two'),
            ),
            array(
                'id'         => 'header_two_logo_mobile',
                'title'      => esc_html__('Upload Mobile Logo', 'astrip'),
                'type'       => 'media',
                'desc'       => wp_kses(__('you can upload <mark>Mobile Logo</mark> for header', 'astrip'), wp_kses_allowed_html('post')),
                'dependency' => array('page_header_menu_style', '==', 'header_two'),
            ),

            // Three
            array(
                'type'       => 'subheading',
                'content'    => '<h3>' . esc_html__('Upload Logo(Header Three)', 'astrip') . '</h3>',
                'dependency' => array('page_header_menu_style', '==', 'header_three'),
            ),
            array(
                'id'         => 'header_three_logo',
                'title'      => esc_html__('Upload  Logo', 'astrip'),
                'type'       => 'media',
                'desc'       => wp_kses(__('you can upload <mark> Logo</mark> for header', 'astrip'), wp_kses_allowed_html('post')),
                'dependency' => array('page_header_menu_style', '==', 'header_three'),
            ),
            array(
                'id'         => 'header_three_page_login_button_icon',
                'type'       => 'icon',
                'title'      => esc_html__('Login ICON', 'astrip'),
                'default'    => 'fa fa-user-circle-o',
                'dependency' => array('page_header_menu_style', '==', 'header_three'),
            ),

            array(
                'id'         => 'header_three_page_login_button_url',
                'type'       => 'text',
                'title'      => esc_html__('Button URL', 'astrip'),
                'desc'       => wp_kses(__('you can set <mark>Header Three Login Button URL </mark> for header section', 'astrip'), wp_kses_allowed_html('post')),
                'default'    => '#',
                'dependency' => array('page_header_menu_style', '==', 'header_three'),
            ),

            // Four
            array(
                'type'       => 'subheading',
                'content'    => '<h3>' . esc_html__('Upload Logo(Header Four)', 'astrip') . '</h3>',
                'dependency' => array('page_header_menu_style', '==', 'header_four'),
            ),
            array(
                'id'         => 'header_four_logo',
                'title'      => esc_html__('Upload  Logo', 'astrip'),
                'type'       => 'media',
                'desc'       => wp_kses(__('you can upload <mark> Logo</mark> for header', 'astrip'), wp_kses_allowed_html('post')),
                'dependency' => array('page_header_menu_style', '==', 'header_four'),
            ),
            array(
                'id'         => 'header_four_sticky_logo',
                'title'      => esc_html__('Upload Sticky Logo', 'astrip'),
                'type'       => 'media',
                'desc'       => wp_kses(__('you can upload <mark>Sticky Logo</mark> for header', 'astrip'), wp_kses_allowed_html('post')),
                'dependency' => array('page_header_menu_style', '==', 'header_four'),
            ),
            array(
                'id'         => 'header_four_logo_mobile',
                'title'      => esc_html__('Upload Mobile Logo', 'astrip'),
                'type'       => 'media',
                'desc'       => wp_kses(__('you can upload <mark>Mobile Logo</mark> for header', 'astrip'), wp_kses_allowed_html('post')),
                'dependency' => array('page_header_menu_style', '==', 'header_four'),
            ),


        ),
    )
);
