<?php 
function add_query_vars_filter( $vars ) {
    // add custom query vars that will be public
    // https://codex.wordpress.org/WordPress_Query_Vars
    $vars[] .= 'tour_destination';
	$vars[] .= 'tour_type';
	$vars[] .= 'tour_month';

  return $vars;
}
add_filter( 'query_vars', 'add_query_vars_filter' );
/**
 * Override Tour Package Archive Query
 * https://codex.wordpress.org/Plugin_API/Action_Reference/pre_get_posts
 */
function astrip_package_archive_with_search( $query ) {

    if ( $query->is_archive('astrip-tour') && $query->is_main_query() ) {
        // Get Form Value
        $destination = get_query_var( 'tour_destination', FALSE );
        $tour_type  = get_query_var( 'tour_type' );
        $tour_month = get_query_var( 'tour_month' );
        // Query Array
        $tax_query_array = array( 'relation' => 'AND' );
        $meta_query_array = array( 'relation' => 'AND' );

        if( !empty( $tour_type ) ) {
            array_push($tax_query_array, array( 'taxonomy' => 'astrip-tour-type', 'field' => 'term_id', 'terms' => $tour_type ) );
        }

        if( !empty( $destination ) ) {
            array_push($meta_query_array, array( 'key' => 'egns-tour-meta', 'compare' => 'LIKE', 'value' => $destination ) );
        }

        if( !empty( $tour_month ) ) {
            $tour_month = '"'.str_pad($tour_month, 2, '0', STR_PAD_LEFT).'/';
            array_push( $meta_query_array, array( 'key' => 'egns-tour-meta', 'compare' => 'LIKE', 'value' => $tour_month ) );
        }
        $query->set( 'tax_query', $tax_query_array);
        $query->set( 'meta_query', $meta_query_array);
    }
}
add_action( 'pre_get_posts', 'astrip_package_archive_with_search' );