<?php

/**
 * egns enqueue scripts
 *
 * @package egns
 */

if (!function_exists('egns_scripts')) {

	function egns_enqueue_scripts()
	{
		// Get the theme data.
		$the_theme = wp_get_theme();

		//Fonts
		wp_enqueue_style('google-fonts', 'https://fonts.googleapis.com/css2?family=Merriweather:wght@300;400;700;900&family=Satisfy&family=Work+Sans:wght@300;400;500;600;700;800;900&display=swap', [], null);

		//style

		wp_enqueue_style('animate', get_template_directory_uri() . '/assets/css/animate.css', array(), $the_theme->get('Version'), 'all');

		wp_enqueue_style('bootstrap', get_template_directory_uri() . '/assets/css/bootstrap.min.css', array(), $the_theme->get('Version'), 'all');

		wp_enqueue_style('boxicons', get_template_directory_uri() . '/assets/css/boxicons.min.css', array(), $the_theme->get('Version'), 'all');

		wp_enqueue_style('bootstrap-icons', get_template_directory_uri() . '/assets/css/bootstrap-icons.css', array(), $the_theme->get('Version'), 'all');

		wp_enqueue_style('swiper-bundle', get_template_directory_uri() . '/assets/css/swiper-bundle.css', array(), $the_theme->get('Version'), 'all');

		wp_enqueue_style('slick-theme', get_template_directory_uri() . '/assets/css/slick-theme.css', array(), $the_theme->get('Version'), 'all');

		wp_enqueue_style('slick', get_template_directory_uri() . '/assets/css/slick.css', array(), $the_theme->get('Version'), 'all');

		wp_enqueue_style('nice-select', get_template_directory_uri() . '/assets/css/nice-select.css', array(), $the_theme->get('Version'), 'all');

		wp_enqueue_style('magnific-popup', get_template_directory_uri() . '/assets/css/magnific-popup.css', array(), $the_theme->get('Version'), 'all');

		wp_enqueue_style('odometer', get_template_directory_uri() . '/assets/css/odometer.css', array(), $the_theme->get('Version'), 'all');

		wp_enqueue_style('date-ui', get_template_directory_uri() . '/assets/css/jquery.ui.css', array(), $the_theme->get('Version'), 'all');

		wp_enqueue_style('egns-blog-page', get_template_directory_uri() . '/assets/css/blog-and-page.css', array(), time(), 'all');

		wp_enqueue_style('egns-woocommerce', get_template_directory_uri() . '/assets/css/woocommerce-custom.css', array(), $the_theme->get('Version'), 'all');

		wp_enqueue_style('egns-typography', get_template_directory_uri() . '/assets/css/typography.css', array(), $the_theme->get('Version'), 'all');

		wp_enqueue_style('egns-default', get_template_directory_uri() . '/assets/css/default.css', array(), $the_theme->get('Version'), 'all');

		wp_enqueue_style('egns-style', get_template_directory_uri() . '/assets/css/style.css', array(), time(), 'all');

		wp_enqueue_style('egns-theme', get_stylesheet_uri());

		// Scripts
		wp_enqueue_script('jquery-masonry');
		
		wp_enqueue_script('jquery-ui', get_template_directory_uri() . '/assets/js/jquery-ui.js', array('jquery'), $the_theme->get('Version'), true);

		wp_enqueue_script('bootstrap', get_template_directory_uri() . '/assets/js/bootstrap.bundle.min.js', array('jquery'), $the_theme->get('Version'), true);

		wp_enqueue_script('swiper', get_template_directory_uri() . '/assets/js/swiper-bundle.min.js', array('jquery'), $the_theme->get('Version'), true);

		wp_enqueue_script('isotope', get_template_directory_uri() . '/assets/js/isotope.pkgd.min.js', array('jquery'), $the_theme->get('Version'), true);

		wp_enqueue_script('slick', get_template_directory_uri() . '/assets/js/slick.js', array('jquery'), $the_theme->get('Version'), true);

		wp_enqueue_script('nice-select', get_template_directory_uri() . '/assets/js/jquery.nice-select.js', array('jquery'), $the_theme->get('Version'), true);

		wp_enqueue_script('odometer', get_template_directory_uri() . '/assets/js/odometer.min.js', array('jquery'), $the_theme->get('Version'), true);

		wp_enqueue_script('viewport', get_template_directory_uri() . '/assets/js/viewport.jquery.js', array('jquery'), $the_theme->get('Version'), true);

		wp_enqueue_script('magnific-popup', get_template_directory_uri() . '/assets/js/jquery.magnific-popup.min.js', array('jquery'), $the_theme->get('Version'), true);

		wp_enqueue_script('egns-main', get_template_directory_uri() . '/assets/js/main.js', array('jquery'), $the_theme->get('Version'), true);

		if (is_singular() && comments_open() && get_option('thread_comments')) {
			wp_enqueue_script('comment-reply');
		}
	}
}

add_action('wp_enqueue_scripts', 'egns_enqueue_scripts');


if (!function_exists('your_prefix_enqueue_fa5')) {
	function your_prefix_enqueue_fa5()
	{
		wp_enqueue_style('fa5', 'https://use.fontawesome.com/releases/v5.13.0/css/all.css', array(), '5.13.0', 'all');
		wp_enqueue_style('fa5-v4-shims', 'https://use.fontawesome.com/releases/v5.13.0/css/v4-shims.css', array(), '5.13.0', 'all');
	}
	add_action('wp_enqueue_scripts', 'your_prefix_enqueue_fa5');
}

// Admin css or js enqueue
function engs_admin_scripts()
{
	// Get the theme data.
	$the_theme = wp_get_theme();

	wp_register_style('admin_css', get_template_directory_uri() .  '/assets/css/admin.css', array(), $the_theme->get('Version'), 'all');
	//OR
	wp_enqueue_style('admin_css');

	// loading css
	wp_enqueue_style('select2', get_template_directory_uri() . '/assets/css/select2.min.css', false, '1.3.0');

	// admin js
	wp_enqueue_script('select2', get_template_directory_uri() . '/assets/js/select2.min.js', array('jquery'), false, true);

	wp_enqueue_script('admin-js', get_template_directory_uri() . '/assets/js/admin.js', array('jquery'), false, true);
}

add_action('admin_enqueue_scripts', 'engs_admin_scripts');
