<?php

/**
 * Add localize scripts 
 *
 * @return void
 */
function egens_ajax_handler_scripts()
{

	global $wp_query;

	// now the most interesting part
	// we have to pass parameters to myloadmore.js script but we can get the parameters values only in PHP
	// you can define variables directly in your HTML but I decided that the most proper way is wp_localize_script()
	wp_localize_script('admin-js', 'egens_ajax_handler_params', array(
		'ajaxurl' => home_url() . '/wp-admin/admin-ajax.php', // WordPress AJAX
		'posts' => json_encode($wp_query->query_vars), // everything about your loop is here
		'current_page' => get_query_var('paged') ? get_query_var('paged') : 1,
		'max_page' => $wp_query->max_num_pages,
		'wp_date_format' => get_option( 'date_format' ),
		'is_woocommerce_active'	=> class_exists('WooCommerce') ? true : false,
	));
}

add_action('admin_enqueue_scripts', 'egens_ajax_handler_scripts');


/**
 * Add localize scripts 
 *
 * @return void
 */
function egens_frontend_ajax_handler_scripts()
{

	global $wp_query;

	// now the most interesting part
	// we have to pass parameters to myloadmore.js script but we can get the parameters values only in PHP
	// you can define variables directly in your HTML but I decided that the most proper way is wp_localize_script()
	wp_localize_script('egns-main', 'egens_frontend_ajax_handler_params', array(
		'ajaxurl' 				=> home_url() . '/wp-admin/admin-ajax.php', // WordPress AJAX
		'posts' 				=> json_encode($wp_query->query_vars), // everything about your loop is here
		'current_page' 			=> get_query_var('paged') ? get_query_var('paged') : 1,
		'max_page' 				=> $wp_query->max_num_pages,
		'wp_date_format' 		=> get_option( 'date_format' ),
		'get_all_criteria' 		=> Egns_Helpers::egns_get_theme_option('tour_criteria'),
		'is_egns_core_enable'  	=> class_exists('CSF') ? true : false,
	));
}

add_action('wp_enqueue_scripts', 'egens_frontend_ajax_handler_scripts');

// Get Product Data by ID

function egns_get_product_data_by_id_ajax_handler()
{

	$product = wc_get_product($_POST['product_id']);
	$services_list = get_post_meta($product->get_id(), EGNS_META_ID . '-woocommerce', true);
	$children_person = get_post_meta($product->get_id(), 'astrip_children_price', true);
	$total_price = 0;

	if (isset($_POST['product_info']['adultsPerson'])) {
		$total_price += (float) Egns_Helpers::egns_calculate_product_price($product->get_id()) * (int) $_POST['product_info']['adultsPerson'];
	}

	if (isset($_POST['product_info']['childrenPerson'])) {
		$total_price += (float) $children_person * (int) $_POST['product_info']['childrenPerson'];
	}

	foreach ($_POST['product_info']['servicesList'] as $value) {
		$total_price += $services_list['astrip_woocommerce_services'][$value]['astrip_woocommerce_services_price'];
	}

	$product_data = [
		'total_price' => get_woocommerce_currency_symbol() . $total_price,
	];

	print_r(json_encode($product_data));
	die();
}


add_action('wp_ajax_egns_get_product_data_by_id', 'egns_get_product_data_by_id_ajax_handler'); // wp_ajax_{action}
add_action('wp_ajax_nopriv_egns_get_product_data_by_id', 'egns_get_product_data_by_id_ajax_handler'); // wp_ajax_nopriv_{action}

// Update add to cart data

function update_cart_price_ajax_handler()
{

	add_action('woocommerce_before_calculate_totals', 'wk_update_price');
	function wk_update_price($cart_object)
	{
		$cart_items = $cart_object->cart_contents;
		if (!empty($cart_items)) {
			$price = 100;
			foreach ($cart_items as $key => $value) {
				$value['data']->set_price($price);
			}
		}
	}

	$product_data = [
		'message'	=> 'Updated',
	];

	print_r(json_encode($product_data));

	die();
}

add_action('wp_ajax_update_cart_price', 'update_cart_price_ajax_handler'); // wp_ajax_{action}
add_action('wp_ajax_nopriv_update_cart_price', 'update_cart_price_ajax_handler'); // wp_ajax_nopriv_{action}


// tour Search Filter


add_action('wp_ajax_tour_search_filter', 'egens_tour_search_filter_ajax_handler'); // wp_ajax_{action}
add_action('wp_ajax_nopriv_tour_search_filter', 'egens_tour_search_filter_ajax_handler'); // wp_ajax_nopriv_{action}

function egens_tour_search_filter_ajax_handler(){
	// Product Query

	global $wp_query;

	$args['post_status'] = 'publish';
    $args['post_type'] = 'astrip-tour';

	// Min and Max price query

	if( !empty( $_POST['tourFilterData']['tourPriceRangeMin'] && !empty( $_POST['tourFilterData']['tourPriceRangeMax'] ) ) ) {

		$post_in = Egns_Helpers::egns_get_tour_package_by_product_price( sanitize_text_field($_POST['tourFilterData']['tourPriceRangeMin']), sanitize_text_field( $_POST['tourFilterData']['tourPriceRangeMax'] ) );
		if( !empty( $post_in ) ) {
			$args['post__in'] = $post_in;
		}else{
			$args['post__in'] = [0];
		}
	}
	
	if( !empty( $_POST['tourFilterData']['page_number'] ) ) {
		$args['paged'] = number_format( $_POST['tourFilterData']['page_number'] ); // we need next page to be loaded
	}
	
	if( !empty( $_POST['tourFilterData']['tourSearchKeyword'] ) ) {
		$searchKeyword = sanitize_text_field( $_POST['tourFilterData']['tourSearchKeyword'] );
		$args['s'] = $searchKeyword;
	}

	if( !empty( $_POST['tourFilterData']['tourDestinationDropdown'] ) ) {
		$destinationId 			= sanitize_text_field( $_POST['tourFilterData']['tourDestinationDropdown'] );
		$args['meta_query'] 	= array(
			array(
				'key' 		=> 'egns-tour-meta',
				'compare' 	=> 'LIKE',
				'value' 	=> $destinationId
			)
		);
	}

	if( !empty( $_POST['tourFilterData']['tourTypeTermId'] ) ) {
		$tourTypeTermArray 	= Egns_Helpers::egns_sanitize_array_recursive( $_POST['tourFilterData']['tourTypeTermId'] );
		$args['tax_query']  = array(
			array(
				'taxonomy'  => 'astrip-tour-type',
				'field' 	=> 'term_id',
				'terms' 	=> $tourTypeTermArray
			)
		);
	}

	$wp_query = new WP_Query($args);

	?>
		<?php if( $wp_query->have_posts() ) :  ?>
			<?php 
			while ($wp_query->have_posts()) {
				$wp_query->the_post();
				get_template_part( 'loop-templates/content-archive-tour-3' );

			}
		?>
		<?php else : ?>
			<div class="package-not-found">
				<img src="<?php echo esc_url( EGNS_ASSETS. '/images/icons/package-not-found.svg' )  ?>" alt="<?php echo esc_attr__('Package not found','astrip') ?>">
				<h3 class="text-center "><?php echo esc_html__('Tour Package not Found','astrip') ?></h3>
				<p><?php echo esc_html__('It seems we can’t find what you’re looking for.','astrip') ?></p>
				<a href="<?php echo esc_url( get_post_type_archive_link('astrip-tour') ) ?>" class="eg-btn btn--primary btn--lg mt-5"><?php echo esc_html__('Back to Tour','astrip') ?></a>
			</div>
		<?php endif ?>
		<div class="row justify-content-center">
			<div class="col-md-12" id="tourPackagePagination">
				<?php get_template_part( 'template-parts/tour/pagination' ); ?>
			</div>
		</div>
		<?php 
	die();
}



add_action('wp_ajax_tour_package_rating_action', 'egens_tour_package_rating_action_ajax_handler'); // wp_ajax_{action}
add_action('wp_ajax_nopriv_tour_package_rating_action', 'egens_tour_package_rating_action_ajax_handler'); // wp_ajax_nopriv_{action}



function egens_tour_package_rating_action_ajax_handler() {
	
	// Get Updated Data 
	$post_id 		= sanitize_text_field( $_POST['post_id'] );
	$post_status	= sanitize_text_field( $_POST['post_status'] );

	// Get Old Data 
	$post_meta 		= get_post_meta($post_id,'tour_astrip_review_rating',true);
	$post_meta_array = array(
		'customer_id'           => sanitize_text_field( $post_meta['custom_id'] ),
		'tour_package_id'       => sanitize_text_field( $post_meta['tour_package_id'] ),
		'tour_package_title'    => sanitize_text_field( $post_meta['tour_package_title'] ), 
		'customer_email'        => sanitize_text_field( $post_meta['customer_email'] ),
		'customer_name'         => sanitize_text_field( $post_meta['customer_name'], ),
		'review_title'          => sanitize_text_field( $post_meta['review_title'] ),
		'review_message'        => sanitize_text_field( $post_meta['review_message'] ),
		'review_rating'         => Egns_Helpers::egns_sanitize_array_recursive($post_meta['review_rating']),
		'review_status'         => sanitize_text_field( $post_status ) 
	);
	update_post_meta($post_id, 'tour_astrip_review_rating', $post_meta_array);
	die();
}


// Enquiry Form Handler 
add_action('wp_ajax_enquiry_form_handler', 'egens_enquiry_form_handler_ajax_handler'); // wp_ajax_{action}
add_action('wp_ajax_nopriv_enquiry_form_handler', 'egens_enquiry_form_handler_ajax_handler'); // wp_ajax_nopriv_{action}

function egens_enquiry_form_handler_ajax_handler() {
	$enquiries_fullname 			= isset( $_POST['getEnquiryFormData']['enquiries_fullname'] ) ? sanitize_text_field( $_POST['getEnquiryFormData']['enquiries_fullname'] ) : '';
	$enquiries_email_address 		= isset( $_POST['getEnquiryFormData']['enquiries_email_address'] ) ? sanitize_text_field( $_POST['getEnquiryFormData']['enquiries_email_address'] ) : '';
	$enquiries_phone 				= isset( $_POST['getEnquiryFormData']['enquiries_phone'] ) ? sanitize_text_field( $_POST['getEnquiryFormData']['enquiries_phone'] ) : '';
	$enquiries_people 				= isset( $_POST['getEnquiryFormData']['enquiries_people'] ) ? sanitize_text_field( $_POST['getEnquiryFormData']['enquiries_people'] ) : '';
	$enquiries_number_of_tickets 	= isset( $_POST['getEnquiryFormData']['enquiries_number_of_tickets'] ) ? sanitize_text_field( $_POST['getEnquiryFormData']['enquiries_number_of_tickets'] ) : '';
	$enquiries_message 				= isset( $_POST['getEnquiryFormData']['enquiries_message'] ) ? wp_kses_post( $_POST['getEnquiryFormData']['enquiries_message'] ) : '';
	$enquiries_package_id 			= isset( $_POST['getEnquiryFormData']['enquiries_package_id'] ) ? sanitize_text_field( $_POST['getEnquiryFormData']['enquiries_package_id'] ) : '';
	
	$enquiries = array(
		'post_type'     => 'enquiries',
		'post_title'    => $enquiries_fullname,
		'post_status'   => 'publish',
	);
	$enquiries_id = wp_insert_post( $enquiries );

	// Get Tour by Id
	$tour = get_post($enquiries_package_id);

	$tour_enquiries_array = array(
		'enquiries_fullname'            => $enquiries_fullname,
		'enquiries_email_address'       => $enquiries_email_address,
		'enquiries_phone'               => $enquiries_phone,
		'enquiries_people'              => $enquiries_people,
		'enquiries_number_of_tickets'   => $enquiries_number_of_tickets,
		'enquiries_message'             => $enquiries_message,
		'enquiries_package_id'          => $tour->post_title ?? '',
	);

	add_post_meta($enquiries_id, 'tour_astrip_enquiries', $tour_enquiries_array);
	
}