<?php
get_header();

if (!is_front_page()) {
    get_template_part('template-parts/breadcrumbs/breadcrumb-tour-archive');
}

?>
<div class="pt-120 pb-120">
    <div class="container">
        <div class="row g-4">
            <?php
            global $wp_query;

            $args = array_merge($wp_query->query_vars);
            $wp_query = new WP_Query($args);

            ?>
            <?php if ($wp_query->have_posts()) :  ?>
                <?php
                while ($wp_query->have_posts()) {
                    $wp_query->the_post();

                    get_template_part('loop-templates/content', 'archive-tour');
                }
                ?>
            <?php else : ?>
                <div class="package-not-found">
                    <img src="<?php echo esc_url(EGNS_ASSETS . '/images/icons/package-not-found.svg')  ?>" alt="<?php echo esc_attr__('Package not found', 'astrip') ?>">
                    <h3 class="text-center "><?php echo esc_html__('Tour Package not Found', 'astrip') ?></h3>
                    <p><?php echo esc_html__('It seems we can’t find what you’re looking for.', 'astrip') ?></p>
                    <a href="<?php echo esc_url(get_post_type_archive_link('astrip-tour')) ?>" class="eg-btn btn--primary btn--lg mt-5"><?php echo esc_html__('Back to Tour', 'astrip') ?></a>
                </div>
            <?php endif ?>
        </div>
        <div class="row justify-content-center">
            <div class="col-md-8">
                <?php get_template_part('template-parts/blog/pagination'); ?>
            </div>
        </div>
    </div>
</div>

<?php
// Theme Options value 
$theme_options = get_option('egns_theme_options'); // prefix of theme

if ($theme_options['astrip_insta_feed_switcher'] == true) :
    // Instagram Feed 
    get_template_part('template-parts/common/instagram');
endif;
get_footer();
