<?php

/**
 * The template for displaying 404 page
 * Template Name: 404
 * 
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package astrip
 */

get_header();
if (!is_front_page()) :

    $enable_breadcrumb_by_theme = Egns_Helpers::egns_get_theme_option('breadcrumb_enable');
    $breadcrumb_enable_by_page = Egns_Helpers::egns_page_option_value('enable_breadcrumb');
    if (Egns_Helpers::is_enabled($enable_breadcrumb_by_theme, $breadcrumb_enable_by_page)) { ?>
        <div class="inner-banner-section">
            <div class="container">
                <div class="row justify-content-center">
                    <div class="col-xl-8 col-md-10 col-sm-12">
                        <div class="breadcrumb-area">
                            <span>
                                <?php
                                if ( is_404() ) { ?>
                                    <h2><?php echo Egns_Helpers::egns_translate_with_escape_('Error'); ?></h2>
                                <?php
                                }
                                the_title();
                                ?>
                            </span>
                            <?php if (!empty(Egns_Helpers::egns_page_option_value('breadcrumb_subtitle'))) : ?>
                                <h2><?php echo Egns_Helpers::egns_page_option_value('breadcrumb_subtitle') ?></h2>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
<?php
    }


endif;

?>


<div class="error-section pt-120 pb-120">
    <div class="container">
        <div class="row justify-content-center">
            <div class="col-lg-7 col-md-10 col-sm-12 text-center">
                <div class="error-wrapper">
                    <div class="error-image">
                        <?php if (!empty(Egns_Helpers::egns_get_theme_option('404_image')['url'])) :  ?>
                            <img src="<?php echo esc_url(Egns_Helpers::egns_get_theme_option('404_image')['url'])  ?>" alt="<?php echo esc_attr('error-image') ?>">
                        <?php endif; ?>
                    </div>
                    <div class="error-text">
                        <p class="para"><?php echo Egns_Helpers::egns_get_theme_option('404_description') ? esc_html(Egns_Helpers::egns_get_theme_option('404_description')) : esc_html__("It looks like you've reached a URL that doesn’t exist. Please use the navigation above or search below to find your way back to our amazing website.", 'astrip') ?></p>
                        <a href="<?php echo esc_url(home_url('/')); ?>" class="eg-btn btn--outline sibling3 btn--lg capsule btn--primary"><i class="bi bi-house-door"></i> <?php echo Egns_Helpers::egns_get_theme_option('404_button_text') ? esc_html(Egns_Helpers::egns_get_theme_option('404_button_text')) : esc_html__('Go To Home', 'astrip') ?></a>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<?php
get_footer();
