<?php

//tour_banner post custom widget

class Egns_Single_Tour_Widget extends WP_Widget
{

    function __construct()
    {
        parent::__construct(

            // Base ID of our widget
            'egns_single_tour_widget',

            // Widget name
            __('Egns Single Tour Widget', 'egens-core'),

            // Widget description
            array('description' => __('Egens Tour Post', 'egens-core'),)
        );
    }

    public function widget($args, $instance)
    {
        $title =   isset($instance['title']) ?  apply_filters('widget_title', $instance['title']) : '';
        $tour_id = isset($instance['tour_id']) ? apply_filters('tour_id', $instance['tour_id']) : '';

        $tour_data = get_post($tour_id);

        $product_id = egens_core()->egns_post_meta_box_value($tour_id, EGNS_TOUR_META_ID, 'tour_product');
        $tour_meta = get_post_meta($tour_id, EGNS_TOUR_META_ID, true);
        $show_offer = false;
        $price_html = '';
        if (class_exists('Woocommerce') && !empty($product_id)) {
            $product = wc_get_product($product_id);
            $schedule_price = egens_core()->egns_check_sale_price_schedule($product_id);
            if ($schedule_price) {
                $show_offer = true;
                $price_html = '<span>From ' . get_woocommerce_currency_symbol() . '' . egens_core()->egns_calculate_product_price($product_id) . '</span> <del>/' . get_woocommerce_currency_symbol() . $product->get_regular_price() . '</del>';
            } else {
                $price_html = '<span>' . get_woocommerce_currency_symbol() . egens_core()->egns_calculate_product_price($product_id) . '</span>';
            }
        } else {
            if (!empty(Egns_Helpers::egns_post_meta_box_value(EGNS_TOUR_META_ID, 'sale_price'))) {
                $price_html = '<h3>' . get_woocommerce_currency_symbol() . Egns_Helpers::egns_calculate_product_price() . '/</h3>' . ' <del>' . Egns_Helpers::egns_post_meta_box_value(EGNS_TOUR_META_ID, 'regular_price') .  '</del>';
            } else {
                $price_html = '<h3>' . get_woocommerce_currency_symbol() . Egns_Helpers::egns_calculate_product_price() . '</h3>';
            }
        }


        echo $args['before_widget'];
?>
        <?php if (!empty($title)) : ?>
            <?php echo $args['before_title'] . esc_attr(__($title, 'astrip-core')) . $args['after_title']; ?>
        <?php endif; ?>
        <div class="sidebar-offer">
            <?php if ($show_offer && isset($product_id)) : ?>
                <div class="offer-badge">
                    <img src="<?php echo get_template_directory_uri() ?>/assets/images/icons/Frame.svg" alt="<?php echo esc_attr('offer-img') ?>">
                    <div class="offer-text">
                        <h5><span><?php echo egens_core()->egns_calculate_offer_percent($product_id) ?><?php echo esc_html('%') ?></span> <br> <?php echo esc_html__('Off', 'astrip-core') ?></h5>
                    </div>
                </div>
            <?php endif ?>
            <div class="offer-content">
                <div class="review-area">
                    <?php if (egens_core()->egns_core_get_avg_rating_by_tour_id(get_the_ID()) > 0) : ?>
                        <ul class="star-list">
                            <?php
                            for ($x = 1; $x <= 5; $x++) {
                                if (egens_core()->egns_core_get_avg_rating_by_tour_id(get_the_ID()) >= $x) {
                                    echo wp_kses_post('<li><i class="bi bi-star-fill"></i></li>');
                                } else {
                                    echo wp_kses_post('<li><i class="bi bi-star"></i></li>');
                                }
                            }
                            ?>
                        </ul>
                        <?php if (egens_core()->egns_core_get_all_rating_count_by_tour_id(get_the_ID()) > 0) : ?>
                            <span>(<?php echo egens_core()->egns_core_get_avg_rating_by_tour_id(get_the_ID()); ?> <?php echo egens_core()->egns_core_get_all_rating_count_by_tour_id(get_the_ID()) == 1 ? esc_html__('Review', 'astrip') : esc_html__('Reviews', 'astrip') ?>)</span>
                        <?php endif ?>
                    <?php endif ?>
                </div>
                <?php if (isset($tour_data->post_title)) : ?>
                    <h4><a href="<?php echo get_the_permalink($tour_id) ?>"><?php echo esc_html($tour_data->post_title) ?></a></h4>
                <?php endif ?>
                <div class="price">
                    <?php if (!empty($product_id)) : ?>
                        <span class="tt"><?php echo esc_html($tour_meta['tour_duration'] ?? '' . ' / ') ?> <?php echo wp_kses($price_html, wp_kses_allowed_html('post'))  ?></span>
                    <?php endif ?>
                </div>
            </div>
            <?php echo get_the_post_thumbnail($tour_id) ?>
        </div>
    <?php
        echo $args['after_widget'];
    }

    // Widget Backend
    public function form($instance)
    {
        $title = '';
        if (isset($instance['title'])) {
            $title = $instance['title'];
        }

        $tour_id = '';
        if (isset($instance['tour_id'])) {
            $tour_id = $instance['tour_id'];
        }

        $args = array(
            'post_type'          => 'astrip-tour',
            'posts_per_page'    => -1
        );
        $tourList = get_posts($args);

    ?>
        <!--Title-->

        <p>
            <label for="<?php echo $this->get_field_id('title'); ?>"><?php _e('Title:', 'egens-core'); ?></label>
            <input class="widefat" id="<?php echo $this->get_field_id('title'); ?>" name="<?php echo $this->get_field_name('title'); ?>" type="text" value="<?php echo esc_attr($title); ?>" />
        </p>
        <p>
            <label for="<?php echo $this->get_field_id('tour_id'); ?>">
                <select class='widefat' id="<?php echo $this->get_field_id('tour_id'); ?>" name="<?php echo $this->get_field_name('tour_id'); ?>" type="text">
                    <?php foreach ((array) $tourList as $tour) : ?>
                        <option value="<?php echo esc_html($tour->ID) ?>" <?php echo $tour_id == $tour->ID ? 'selected' : '' ?>><?php echo esc_html($tour->post_title)  ?></option>
                    <?php endforeach ?>
                </select>
            </label>
        </p>
<?php
    }

    // Updating widget replacing old instances with
    public function update($new_instance, $old_instance)
    {
        $instance = array();
        $instance['tour_id'] = (!empty($new_instance['tour_id'])) ? strip_tags($new_instance['tour_id']) : '';
        $instance['title'] = (!empty($new_instance['title'])) ? strip_tags($new_instance['title']) : '';
        return $instance;
    }
}

if (!function_exists('Egns_Single_Tour_Widget')) {
    function Egns_Single_Tour_Widget()
    {
        register_widget('Egns_Single_Tour_Widget');
    }
    add_action('widgets_init', 'Egns_Single_Tour_Widget');
}
