<?php

//recent post custom widget

class Egns_Recent_Post_Widget extends WP_Widget
{

    function __construct()
    {
        parent::__construct(

            // Base ID of our widget
            'egns_recent_post',

            // Widget name
            __('Egns Tour Post', 'egens-core'),

            // Widget description
            array('description' => __('Egens Tour Post', 'egens-core'),)
        );
    }

    public function widget($args, $instance)
    {
        $title = apply_filters('widget_title', $instance['title']);
        echo $args['before_widget'];
?>

        <?php
        $query = new WP_Query(array(
            'post_type'           => 'astrip-tour',
            'posts_per_page'      => 4,
            'orderby'             => "asc"
        ));


        ?>
        <?php if (!empty($title)) : ?>
            <?php echo $args['before_title'] . esc_attr(__($title, 'astrip-core')) . $args['after_title']; ?>
        <?php endif; ?>
        <ul class="tour-package-list">
            <?php
            if ($query->have_posts()) {
                while ($query->have_posts()) {
                    $query->the_post();

                    $product_id = egens_core()->egns_post_meta_box_value(get_the_ID(),EGNS_TOUR_META_ID, 'tour_product');
            ?>
                    <li>
                        <div class="sidebar-package-single">
                            <div class="package-image">
                                <?php the_post_thumbnail(); ?>
                            </div>
                            <div class="package-content">
                                <h5><a href="<?php esc_url(the_permalink()); ?>"><?php esc_html__(the_title()); ?></a></h5>
                                <?php if (!empty(egens_core()->egns_post_meta_box_value(get_the_ID(),EGNS_TOUR_META_ID, 'tour_duration'))) : ?>
                                    <span class="duration"><i class="bi bi-clock"></i> <?php echo esc_html(Egns_Helpers::egns_post_meta_box_value(EGNS_TOUR_META_ID, 'tour_duration')) ?></span>
                                <?php endif ?>
                                <?php if( isset( $product_id ) ) : ?>
                                    <p class="package-price"><?php echo esc_html__('From ', 'astrip-core') . get_woocommerce_currency_symbol() . Egens_Core_Helper_Functions::egns_calculate_product_price($product_id);  ?></p>
                                <?php endif ?>
                            </div>
                        </div>
                    </li>
            <?php
                }
            }
            wp_reset_query();
            ?>
        </ul>
    <?php
        echo $args['after_widget'];
    }

    // Widget Backend
    public function form($instance)
    {
        $title = '';
        if (isset($instance['title'])) {
            $title = $instance['title'];
        }
    ?>
        <!--Title-->
        <p>
            <label for="<?php echo $this->get_field_id('title'); ?>"><?php _e('Title:', 'egens-core'); ?></label>
            <input class="widefat" id="<?php echo $this->get_field_id('title'); ?>" name="<?php echo $this->get_field_name('title'); ?>" type="text" value="<?php echo esc_attr($title); ?>" />
        </p>
<?php
    }

    // Updating widget replacing old instances with
    public function update($new_instance, $old_instance)
    {
        $instance = array();
        $instance['title'] = (!empty($new_instance['title'])) ? strip_tags($new_instance['title']) : '';
        return $instance;
    }
}

if (!function_exists('Egns_Recent_Post_Widget')) {
    function Egns_Recent_Post_Widget()
    {
        register_widget('Egns_Recent_Post_Widget');
    }
    add_action('widgets_init', 'Egns_Recent_Post_Widget');
}
