<?php

//Post tags custom widget
class Egens_Contacts extends WP_Widget
{

    function __construct()
    {
        parent::__construct(

            //Base ID of our widget
            'egens_contacts',

            //Widget name
            __('Egns Contacts', 'egens-core'),

            //Widget description
            array('description' => __('Egns Contacts', 'egens-core'),)
        );
    }

    public function widget($args, $instance)
    {
        $title = apply_filters('widget_title', $instance['title']);

        echo $args['before_widget'];
?>

        <?php if (!empty($title)) : ?>
            <?php echo $args['before_title'] . esc_attr(__($title, 'egens-core')) . $args['after_title']; ?>
        <?php endif; ?>
        <ul class="contact-list">
            <?php if (!empty($instance['contact_number_one'] || !empty($instance['contact_number_two']))) : ?>
                <li>
                    <div class="icon">
                        <i class="bi bi-telephone"></i>
                    </div>
                    <div class="text">
                        <?php if (!empty($instance['contact_number_one'])) : ?>
                            <a href="tel:<?php echo  esc_html($instance['contact_number_one'], 'egens-core') ?>"><?php echo  esc_html(__($instance['contact_number_one'], 'egens-core')); ?></a>
                        <?php endif; ?>
                        <?php if (!empty($instance['contact_number_two'])) : ?>
                            <a href="tel:<?php echo  esc_html($instance['contact_number_two'], 'egens-core') ?>"><?php echo  esc_html(__($instance['contact_number_two'], 'egens-core')); ?></a>
                        <?php endif; ?>
                    </div>
                </li>
            <?php endif; ?>
            <?php if (!empty($instance['email_one'] || !empty($instance['email_two']))) : ?>
                <li>
                    <div class="icon">
                        <i class="bi bi-envelope"></i>
                    </div>
                    <div class="text">
                        <?php if (!empty($instance['email_one'])) : ?>
                            <a href="<?php echo  esc_url('mailto:' . $instance['email_one']) ?>"><?php echo  esc_html(__($instance['email_one'], 'egens-core')); ?></a>
                        <?php endif; ?>
                        <?php if (!empty($instance['email_two'])) : ?>
                            <a href="<?php echo  esc_url('mailto:' . $instance['email_two']) ?>"><?php echo  esc_html(__($instance['email_two'], 'egens-core')); ?></a>
                        <?php endif; ?>
                    </div>
                </li>
            <?php endif; ?>
            <?php if (!empty($instance['address'])) : ?>
                <li>
                    <div class="icon">
                        <i class="bi bi-geo-alt"></i>
                    </div>
                    <div class="text">
                        <?php if (!empty($instance['address'])) : ?>
                            <?php echo  esc_html(__($instance['address'], 'egens-core')); ?>
                        <?php endif; ?>
                    </div>
                </li>
            <?php endif; ?>
        </ul>
    <?php
        echo $args['after_widget'];
    }

    //Widget Backend
    public function form($instance)
    {
        $title = '';
        if (isset($instance['title'])) {
            $title = $instance['title'];
        }
        $contact_number_one = '';
        if (isset($instance['contact_number_one'])) {
            $contact_number_one = $instance['contact_number_one'];
        }
        $contact_number_two = '';
        if (isset($instance['contact_number_two'])) {
            $contact_number_two = $instance['contact_number_two'];
        }
        $email_one = '';
        if (isset($instance['email_one'])) {
            $email_one = $instance['email_one'];
        }

        $email_two = '';
        if (isset($instance['email_two'])) {
            $email_two = $instance['email_two'];
        }

        $address = '';
        if (isset($instance['address'])) {
            $address = $instance['address'];
        }

    ?>

        <p>
            <label for="<?php echo $this->get_field_id('title'); ?>"><?php _e('Title:', 'egens-core'); ?></label>
            <input class="widefat" id="<?php echo $this->get_field_id('title'); ?>" name="<?php echo $this->get_field_name('title'); ?>" type="text" value="<?php echo esc_attr($title); ?>" />
        </p>
        <p>
            <label for="<?php echo $this->get_field_id('contact_number_one'); ?>"><?php _e('Contact Number One:', 'egens-core'); ?></label>
            <input class="widefat" id="<?php echo $this->get_field_id('contact_number_one'); ?>" name="<?php echo $this->get_field_name('contact_number_one'); ?>" type="text" value="<?php echo esc_attr($contact_number_one); ?>" />
        </p>
        <p>
            <label for="<?php echo $this->get_field_id('contact_number_two'); ?>"><?php _e('Contact Number Two:', 'egens-core'); ?></label>
            <input class="widefat" id="<?php echo $this->get_field_id('contact_number_two'); ?>" name="<?php echo $this->get_field_name('contact_number_two'); ?>" type="text" value="<?php echo esc_attr($contact_number_two); ?>" />
        </p>

        <p>
            <label for="<?php echo $this->get_field_id('email_one'); ?>"><?php _e('Email One:', 'egens-core'); ?></label>
            <input class="widefat" id="<?php echo $this->get_field_id('email_one'); ?>" name="<?php echo $this->get_field_name('email_one'); ?>" type="text" value="<?php echo esc_attr($email_one); ?>" />
        </p>

        <p>
            <label for="<?php echo $this->get_field_id('email_two'); ?>"><?php _e('Email Two:', 'egens-core'); ?></label>
            <input class="widefat" id="<?php echo $this->get_field_id('email_two'); ?>" name="<?php echo $this->get_field_name('email_two'); ?>" type="text" value="<?php echo esc_attr($email_two); ?>" />
        </p>

        <p>
            <label for="<?php echo $this->get_field_id('address'); ?>"><?php _e('Address:', 'egens-core'); ?></label>
            <input class="widefat" id="<?php echo $this->get_field_id('address'); ?>" name="<?php echo $this->get_field_name('address'); ?>" type="text" value="<?php echo esc_attr($address); ?>" />
        </p>


<?php
    }

    //Updating widget replacing old instances with new
    public function update($new_instance, $old_instance)
    {
        $instance = array();
        $instance['title'] = (!empty($new_instance['title'])) ? strip_tags($new_instance['title']) : '';
        $instance['contact_number_one'] = (!empty($new_instance['contact_number_one'])) ? strip_tags($new_instance['contact_number_one']) : '';
        $instance['contact_number_two'] = (!empty($new_instance['contact_number_two'])) ? strip_tags($new_instance['contact_number_two']) : '';
        $instance['email_one'] = (!empty($new_instance['email_one'])) ? strip_tags($new_instance['email_one']) : '';
        $instance['email_two'] = (!empty($new_instance['email_two'])) ? strip_tags($new_instance['email_two']) : '';
        $instance['address'] = (!empty($new_instance['address'])) ? strip_tags($new_instance['address']) : '';
        return $instance;
    }
}
if (!function_exists('Egens_Contacts')) {
    function Egens_Contacts()
    {
        register_widget('Egens_Contacts');
    }
    add_action('widgets_init', 'Egens_Contacts');
}
