<?php

/**
 * @package Egens
 * @author Egens Lab
 */
if (!defined("ABSPATH")) {
	exit(); //exit if access directly
}

if (!class_exists('Egens_Core_Helper_Functions')) {

	class Egens_Core_Helper_Functions
	{
		/*
		* $instance
		* @since 1.3.0
		* */
		protected static $instance;

		public function __construct()
		{
		}

		/**
		 * getInstance()
		 * */
		public static function getInstance()
		{
			if (null == self::$instance) {
				self::$instance = new self();
			}

			return self::$instance;
		}
		/**
		 * Check product schedule 
		 * 
		 */

		public static function egns_check_sale_price_schedule($product_id)
		{
			$product = wc_get_product($product_id);
			if (!empty($product->get_sale_price())) {
				if (!empty($product->get_date_on_sale_from()) && !empty($product->get_date_on_sale_to())) {
					$product_sale_start_time = date('Y-m-d h:i:s', strtotime($product->get_date_on_sale_from()));
					$current_time = date('Y-m-d h:i:s', time());
					$product_sale_end_time  = date('Y-m-d h:i:s', strtotime($product->get_date_on_sale_to()));

					if ($current_time > $product_sale_start_time && $current_time < $product_sale_end_time) {
						return true;
					} else {
						return false;
					}
				} else {
					return true;
				}
			} else {
				return false;
			}
		}
		/**
		 * Post Meta Box Key Information
		 *
		 * @param  String $meta_key
		 */

		public static function egns_post_meta_box_value($post_id, $meta_key, $meta_key_value)
		{	
			if (isset(get_post_meta($post_id, $meta_key, true)[$meta_key_value])) {
				return get_post_meta($post_id, $meta_key, true)[$meta_key_value];
			}
		}

		/**
		 * Calculate Offer percent
		 */

		public static function egns_calculate_offer_percent($product_id)
		{
			$product = wc_get_product($product_id);
			if (self::egns_check_sale_price_schedule($product_id)) {
				$regular_price = $product->get_regular_price();
				$sale_price = $product->get_sale_price();
				return round((($regular_price - $sale_price) / ($regular_price)) * 100);
			} else {
				return esc_html__('Sale price not found');
			}
		}

		/**
		 * Calculate woocommerce product price
		 */

		public static function egns_calculate_product_price($product_id = '')
		{
			if( !empty( $product_id ) && Egns_Helpers::egns_post_meta_box_value(EGNS_TOUR_META_ID, 'tour_booking_options') != 'enquiry_form' ) {
				$product = wc_get_product($product_id);
				$sale_from = $product->get_date_on_sale_from();
				$date_sale_to = $product->get_date_on_sale_to();
				// Show product price with calculate sale schedule date 
				if (!empty($product->get_sale_price())) {
					if (isset($sale_from) && isset($date_sale_to)) {
						if (self::egns_check_sale_price_schedule($product)) {
							return $product->get_sale_price();
						} else {
							return $product->get_regular_price();
						}
					} else {
						return $product->get_sale_price();
					}
				} else {
					return $product->get_regular_price();
				}
			}else{
				if( !empty( Egns_Helpers::egns_post_meta_box_value( EGNS_TOUR_META_ID, 'sale_price' ) ) ) {
					return Egns_Helpers::egns_post_meta_box_value( EGNS_TOUR_META_ID, 'sale_price' );
				}else{
					return Egns_Helpers::egns_post_meta_box_value( EGNS_TOUR_META_ID, 'regular_price' );
				}
			}

		}

		/**
		 * get post list by post type
		 * @sicne 2.0.0
		 * */
		public function get_all_post_list_by_post_type($post_type)
		{
			$return_val = [];
			$args       = array(
				'post_type'      => $post_type,
				'posts_per_page' => 6,
				'post_status' 	 => 'publish',
			);
			$all_post   = new \WP_Query($args);

			while ($all_post->have_posts()) {
				$all_post->the_post();
				$return_val[get_the_ID()] = get_the_title();
			}

			return $return_val;
		}

		/**
		 * This function will return tour count by desctiont ID
		 * @return integer
		 */

		public function get_tour_count_by_destination_id( $destinationID = '' ) {

			$args_two = array(
				'post_type'  => 'astrip-tour',
				'meta_query' => array(
					array(
						'key' 		=> 'egns-tour-meta',
						'compare' 	=> 'LIKE',
						'value' 	=> get_the_ID()
					)
				)
			);
			$tourCount = get_posts( $args_two );
			return count( $tourCount );
		}
		
		// =================================Tour   Package============================================//

		public function get_terms_names($taxonomy_name = '', $output = '', $hide_empty = false)
		{
			$return_val = [];
			$terms      = get_terms(
				array(
					'taxonomy'   => $taxonomy_name,
					'hide_empty' => $hide_empty
				)
			);
			foreach ($terms as $term) {
				if ('id' == $output) {
					$return_val[$term->term_id] = $term->name;
				} else {
					$return_val[$term->slug] = $term->name;
				}
			}

			return $return_val;
		}
		public function get_all_terms_names($taxonomy_name = '', $output = '', $hide_empty = false)
		{
			$return_val = [];
			$terms    = get_terms(
				array(
					'taxonomy'   => $taxonomy_name,
					'hide_empty' => $hide_empty,
					'number' 	 =>  9,
				)
			);
			foreach ($terms as $term) {
				if ('id' == $output) {
					$return_val[$term->term_id] = $term->term_id;
				} else {
					$return_val[$term->slug] = $term->term_id;
				}
			}
			return $return_val;
		}






		public function get_post_list_by_post_type($post_type)
		{
			$return_val = [];
			$args       = array(
				'post_type'      => $post_type,
				'posts_per_page' => -1,
				'post_status' 	 => 'publish',
			);
			$all_post   = new \WP_Query($args);

			while ($all_post->have_posts()) {
				$all_post->the_post();
				$return_val[get_the_ID()] = get_the_title();
			}
			wp_reset_query();
			return $return_val;
		}

		public function get_all_post_key($post_type)
		{
			$return_val = [];
			$args       = array(
				'post_type'      => $post_type,
				'posts_per_page' => 6,
				'post_status' 	 => 'publish',

			);
			$all_post   = new \WP_Query($args);

			while ($all_post->have_posts()) {
				$all_post->the_post();
				$return_val[] = get_the_ID();
			}
			wp_reset_query();
			return $return_val;
		}

		//================================= Tour Package End==================================//



		/**
		 * get post list by post type
		 * @sicne 2.0.0
		 * */
		public function get_post_all_list()
		{
			$return_val = [];
			$args       = array(
				'post_type'      => 'post',
				'posts_per_page' => -1,
				'post_status' 	 => 'publish',
			);
			$all_post   = new \WP_Query($args);

			while ($all_post->have_posts()) {
				$all_post->the_post();
				$return_val[get_the_ID()] = get_the_title();
			}
			wp_reset_query();
			return $return_val;
		}

		/**
		 * Egns Blog Pagination for Plugin
		 *
		 * @param integer $post_per_page
		 * @return void
		 */
		function egns_blog_pagination($post_per_page = 3)
		{
			add_filter('number_format_i18n', array($this, 'give_numbers_leading_zero'));
			$links = paginate_links(array(
				'current'  => max(1, get_query_var('paged')),
				'total'    => $post_per_page,
				'type'     => 'list',
				'mid_size' => apply_filters("egns_pagination_mid_size", 3),
				'prev_text'    => '<i class="bi bi-arrow-left"></i> PREV',
				'next_text'    => 'NEXT <i class="bi bi-arrow-right"></i>',
			));
			$links = str_replace("<ul class='page-numbers'>", "<ul class='pagination d-flex justify-content-center gap-md-3 gap-2'>", $links);
			$links = str_replace("<li>", "<li class='page-item'>", $links);
			$links = str_replace("page-numbers", "", $links);
			$links = str_replace("&laquo; Previous</a>", '&laquo;</a>', $links);
			$links = str_replace("Next &raquo;</a>", "&raquo;</a>", $links);
			$links = str_replace("next aria-label='Next'", "page-link", $links);
			$links = str_replace("prev aria-hidden='true'", "sr-only page-link", $links);
			$links = str_replace("<li><span", " <li class='active'><a", $links);
			$links = str_replace('span', 'a', $links);

			echo wp_kses_post($links);
		}

		/**
		 * Add Zero before number
		 *
		 * @param float $number
		 * @return float
		 */

		function give_numbers_leading_zero($number)
		{
			return sprintf("%02s", $number);
		}

		/**
		 * Get avarage rating by tour ID
		 *
		 * @param [type] $tour_id
		 * @return array
		 */
		public function egns_core_get_all_rating_by_tour_id( $tour_id ) {
			$args = array(
				'post_type'         => 'review-rating',
				'posts_per_page'    => -1,
				'meta_query' => array(
					'relation'      => 'AND',
					array(
						'key'       => 'tour_astrip_review_rating',
						'value'     => esc_html( $tour_id ),
						'compare'   => 'LIKE' 
					),
					array(
						'key'       => 'tour_astrip_review_rating',
						'value'     => esc_html('approve'),
						'compare'   => 'LIKE'
					)
					
				)
			);
			$all_rating = get_posts( $args );
			return $all_rating;

		}

		/***
		 * Egns Sanitize Array
		 * @param array
		 * @return array
		 */
		public function egns_core_sanitize_array_recursive(&$array) {
			array_walk_recursive($array, function(&$value) {
				$value = is_string($value) ? sanitize_text_field($value) : $value;
			});
			return $array;
		}

		/**
		 * Egns get avarage rating by tour ID
		 *
		 * @param integer $tour_id
		 * @return integer
		 */

		public function egns_core_get_avg_rating_by_tour_id( $tour_id ) {
			$all_rating = self::egns_core_get_all_rating_by_tour_id( $tour_id );
			$initial_rating = 0;
			$rating_meta_count = '';
			if( count( $all_rating ) > 0 ) {
				foreach( (array)$all_rating as $rating ) {
					$rating_meta = self::egns_post_meta_box_value( $rating->ID,'tour_astrip_review_rating','review_rating' );
					$rating_meta_count = count( $rating_meta );
					if( count( $rating_meta ) > 0 ) {
						foreach( (array)$rating_meta as $rating_nested ) {
							if( isset( $rating_nested['reivew_criteria_rating'] ) ) {
								$initial_rating += $rating_nested['reivew_criteria_rating'];
							}
						}
					}else{
						return false;
					}
					
				}
			}else{
				return false;
			}
			
			return round( ($initial_rating/$rating_meta_count) );
		}

		/**
		 * Egns get all rating count
		 *
		 * @param integer $tour_id
		 * @return integer
		 */

		public function egns_core_get_all_rating_count_by_tour_id( $tour_id ) {
			return count( self::egns_core_get_all_rating_by_tour_id( $tour_id ) );
		}

	} //end class
	if (class_exists('Egens_Core_Helper_Functions')) {
		Egens_Core_Helper_Functions::getInstance();
	}
}
