<?php

namespace Elementor;

if (!defined('ABSPATH')) {
    exit;
} //Exit if accessed directly

use Elementor\Core\Schemes;

class astrip_video_Widget extends Widget_Base
{

    public function get_name()
    {
        return 'egens_video';
    }

    public function get_title()
    {
        return esc_html__('EG Video', 'astrip-core');
    }

    public function get_icon()
    {
        return 'eicon-youtube';
    }

    public function get_categories()
    {
        return ['astrip_widgets'];
    }

    protected function register_controls()
    {

        //-------------Content-------------------//
        //stats Section

        $this->start_controls_section(
            'astrip_section_content_general',
            [
                'label' => esc_html__('General', 'astrip-core')
                
            ]
        );

        $this->add_control(
			'astrip_video_popup_style',
			[
				'label' => esc_html__( 'Video PopUp Design', 'astrip-core' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'default' => 'style_one',
				'options' => [
					'style_one'  => esc_html__( 'Style 1', 'astrip-core' ),
					'style_two' => esc_html__( 'Style 2', 'astrip-core' ),					
					
				],
			]
		);

        $this->end_controls_section();


       
        $this->start_controls_section(
            'astrip_content_video_popup_section',
            [
                'label' => esc_html__( 'Video PopUp', 'astrip-core' ),
                
            ]
        );

        $this->add_control(
            'astrip_video_popup_title',
            [
                'label' => esc_html__( 'Title', 'astrip-core' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => esc_html__( 'Play Video', 'astrip-core' ),
                'placeholder' => esc_html__( 'Type your title here', 'astrip-core' ),
            ]
        );

        $this->add_control(
            'astrip_video_popup_link',
            [
                'label' => esc_html__( 'Link', 'astrip-core' ),
                'type' => \Elementor\Controls_Manager::URL,
                'placeholder' => esc_html__( 'https://your-link.com', 'astrip-core' ),
                'options' => [ 'url', 'is_external', 'nofollow' ],
                'default' => [
                    'url' => '',
                    'is_external' => true,
                    'nofollow' => true,
                    // 'custom_attributes' => '',
                ],
                'label_block' => true,
            ]
        );

        
        
        $this->end_controls_section();
     
        //---------------Style----------------------//


        //Video popup Title Style
        $this->start_controls_section(
            'astrip_video_popup_title_style_section',
            [
                'label' => esc_html__('Video PopUp Title', 'astrip-core'),
                'tab'   => Controls_Manager::TAB_STYLE,
                
                
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label'    => esc_html__('Typography', 'astrip-core'),
                'name'     => 'astrip_video_popup_title_style_typography',
                'selector' => 
                    '{{WRAPPER}} .video-wrapper.sibling-3 span.watch-video,.video-wrapper span.watch-video',
                    
            ]
        );

        $this->add_control(
            'astrip_video_popup_title_style_color',
            [
                'label'     => esc_html__('Title Color', 'astrip-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .video-wrapper.sibling-3 span.watch-video' => 'color: {{VALUE}};',
                    '{{WRAPPER}} .video-wrapper span.watch-video' => 'color: {{VALUE}};',

                ],
            ]
        );
        $this->add_control(
            'astrip_video_popup_title_bar_style_color',
            [
                'label'     => esc_html__('Title Bar Color', 'astrip-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    
                    '{{WRAPPER}} .video-wrapper.sibling-3 span.watch-video::after' => 'background: {{VALUE}};',
                    '{{WRAPPER}} .video-wrapper span.watch-video::after' => 'background: {{VALUE}};',

                ],
            ]
        );
        
        $this->add_responsive_control(
            'astrip_video_popup_title_style_margin',
            [
                'label' => esc_html__( 'Margin', 'astrip-core' ),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%', 'em' ],
                'selectors' => [
                    '{{WRAPPER}} .video-wrapper.sibling-3 span.watch-video' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    '{{WRAPPER}} .video-wrapper span.watch-video' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->end_controls_section();

        //video-popup icon

        $this->start_controls_section(
            'astrip_video_popup_icon_section',
            [
                'label' => esc_html__( 'Video Popup Icon', 'astrip-core' ),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
                
            ]
        );


        $this->add_control(
            'astrip_video_popup_icon_style_color',
            [
                'label'     => esc_html__('Color', 'astrip-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .video-play.sibling-3 .video-icon' => 'color: {{VALUE}};',
                    '{{WRAPPER}} .video-play .video-icon' => 'color: {{VALUE}};',

                ],
            ]
        );

        $this->add_control(
            'astrip_video_popup_icon_style_background_color',
            [
                'label'     => esc_html__('Background Color', 'astrip-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .video-play.sibling-3 .video-icon' => 'background: {{VALUE}};',
                    '{{WRAPPER}} .video-play .video-icon' => 'background: {{VALUE}};',

                ],
            ]
        );
        $this->add_control(
            'astrip_video_popup_icon_style_background_wave_effect_color',
            [
                'label'     => esc_html__('Wave Effect Color', 'astrip-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .video-play .video-icon::before' => 'background: {{VALUE}};',

                ],
            ]
        );
        
        
        $this->end_controls_section();

        //card style
        $this->start_controls_section(
            'astrip_video_popup_card_section',
            [
                'label' => esc_html__( 'Video Popup Card', 'astrip-core' ),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
                'condition' => [
                    'astrip_video_popup_style' => 'style_two',
                ],
                
            ]
        );

        $this->add_control(
            'astrip_video_popup_icon_card_style_color',
            [
                'label'     => esc_html__('Background Color', 'astrip-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .video-wrapper.sibling-3' => 'background-color: {{VALUE}};',

                ],
            ]
        );

        $this->add_group_control(
			\Elementor\Group_Control_Box_Shadow::get_type(),
			[
				'name' => 'astrip_video_popup_icon_card_style_box_shadow',
				'label' => esc_html__( 'Box Shadow', 'astrip-core' ),
				'selector' => '{{WRAPPER}} .video-wrapper.sibling-3',
			]
		);

        $this->add_control(
            'astrip_video_popup_card_style_padding',
            [
                'label' => esc_html__( 'Padding', 'astrip-core' ),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%', 'em' ],
                'selectors' => [
                    '{{WRAPPER}} .video-wrapper.sibling-3' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'astrip_video_popup_card_style_size',
            [
                'label' => esc_html__( 'Size', 'astrip-core' ),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => [ 'px', ],
                'range' => [
                    'px' => [
                        'min' => 1,
                        'max' => 200,
                        'step' => 1,
                    ],
                    
                ],
                'default' => [
                    'unit' => 'px',
                ],
                'selectors' => [
                    '{{WRAPPER}}  .video-wrapper.sibling-3' => 'width: {{SIZE}}{{UNIT}};min-height: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->end_controls_section();

       
    }

    protected function render()
    {
        $settings = $this->get_settings_for_display();
    ?> 
    
        <div class="d-flex justify-content-lg-end justify-content-center" >
            <div class="video-wrapper  <?php echo $settings['astrip_video_popup_style'] == 'style_two' ? 'sibling-3' : '' ?>">
                <div class="video-play  <?php echo $settings['astrip_video_popup_style'] == 'style_two' ? 'sibling-3' : '' ?>">
                    <?php if( !empty( $settings['astrip_video_popup_link']['url'] ) ) : ?>
                        <a href="<?php echo esc_url($settings['astrip_video_popup_link']['url']) ?>" class="popup-youtube video-icon"><i class="bx bx-play"></i></a>
                    <?php endif ?>
                </div>
                <?php if( !empty( $settings['astrip_video_popup_title'] ) ) : ?>
                    <span class="watch-video"><?php echo esc_html($settings['astrip_video_popup_title']) ?></span>
                <?php endif ?>
            </div>
        </div>

    <?php
    }
}

Plugin::instance()->widgets_manager->register(new astrip_video_Widget());


