<?php

namespace Elementor;

if (!defined('ABSPATH')) exit; // Exit if accessed directly

use Elementor\core\Schemes;

class Astrip_Tour_Package_Adventure_Widget extends Widget_Base
{

    public function get_name()
    {
        return 'astrip_package_adventure';
    }

    public function get_title()
    {
        return esc_html__('EG Adventure Tour Package', 'astrip-core');
    }

    public function get_icon()
    {
        return ' eicon-price-table';
    }

    public function get_categories()
    {
        return ['astrip_widgets'];
    }

    protected function register_controls()
    {

        //general section
        $this->start_controls_section(
            'astrip_package_adventure_general_section',
            [
                'label' => esc_html__('General', 'astrip-core')
            ]
        );


        $this->add_control(
            'turio_packages',
            [
                'label'             => __('Select Tour', 'turio-core'),
                'type'                 => \Elementor\Controls_Manager::SELECT2,
                'label_block'         => true,
                'multiple'            => true,
                'options'             => egens_core()->get_post_list_by_post_type('astrip-tour'),
                'default'             => egens_core()->get_all_post_key('astrip-tour'),
            ]
        );

        $this->add_control(
            'astrip_package_adventure_content_column_selection',
            [
                'label'   => esc_html__('Column', 'astrip-core'),
                'type'    => Controls_Manager::SELECT,
                'options' => [
                    'column_two'  => esc_html__('2', 'astrip-core'),
                    'column_three' => esc_html__('3', 'astrip-core'),
                    'column_four' => esc_html__('4', 'astrip-core'),
                ],
                'default' => 'column_three',

            ]
        );



        $this->add_control(
            'astrip_package_adventure_posts_per_page',
            [
                'label'       => esc_html__('Posts Per Page', 'astrip-core'),
                'type'        => Controls_Manager::NUMBER,
                'default'     => 5,
                'label_block' => false,
            ]
        );
        $this->add_control(
            'astrip_package_adventure_template_order_by',
            [
                'label'   => esc_html__('Order By', 'astrip-core'),
                'type'    => Controls_Manager::SELECT,
                'default' => 'ID',
                'options' => [
                    'ID'         => esc_html__('Post Id', 'astrip-core'),
                    'author'     => esc_html__('Post Author', 'astrip-core'),
                    'title'      => esc_html__('Title', 'astrip-core'),
                    'post_date'  => esc_html__('Date', 'astrip-core'),
                    'rand'       => esc_html__('Random', 'astrip-core'),
                    'menu_order' => esc_html__('Menu Order', 'astrip-core'),
                ],
            ]
        );
        $this->add_control(
            'astrip_package_adventure_template_order',
            [
                'label'   => esc_html__('Order', 'astrip-core'),
                'type'    => Controls_Manager::SELECT,
                'options' => [
                    'asc'  => esc_html__('Ascending', 'astrip-core'),
                    'desc' => esc_html__('Descending', 'astrip-core')
                ],
                'default' => 'desc',
            ]
        );


        $this->add_control(
            'astrip_package_adventure_heading_ribbon_icon',
            [
                'label' => esc_html__('Ribbon Icon', 'astrip-core'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => esc_html__('Show', 'astrip-core'),
                'label_off' => esc_html__('Hide', 'astrip-core'),
                'return_value' => 'yes',
                'default' => 'yes',

            ]
        );
        $this->add_control(
            'astrip_package_adventure_content_pagination_icon',
            [
                'label' => esc_html__('Pagination Icon', 'astrip-core'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => esc_html__('Show', 'astrip-core'),
                'label_off' => esc_html__('Hide', 'astrip-core'),
                'return_value' => 'yes',
                'default' => 'yes',

            ]
        );


        $this->end_controls_section();
        $this->start_controls_section(
            'astrip_heading_content_main_title_section',
            [
                'label' => esc_html__('Contents', 'astrip-core'),

            ]
        );
        $this->add_control(
            'astrip_heading_content_sub_title',
            [
                'label' => esc_html__('Sub Title', 'astrip-core'),
                'type' => Controls_Manager::TEXT,
                'default' => esc_html__('Our Activities', 'astrip-core'),
                'label_block' => true,
            ]
        );
        $this->add_control(
            'astrip_heading_content_main_title',
            [
                'label' => esc_html__('Main Title', 'astrip-core'),
                'type' => Controls_Manager::TEXTAREA,
                'default' => esc_html__('Enjoy The Adventure Trip', 'astrip-core'),
                'label_block' => true,
            ]
        );
        $this->add_control(
            'astrip_heading_content_image',
            [
                'label' => esc_html__('Choose Image', 'astrip-core'),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'default' => [
                    'url' => \Elementor\Utils::get_placeholder_image_src(),
                ],

            ]
        );

        $this->end_controls_section();
        //Style Section Start


        $this->start_controls_section(
            'astripi_tour_package_one_style',
            [
                'label' => esc_html__('Image', 'astrip-core'),
                'tab'   => Controls_Manager::TAB_STYLE,

            ]
        );

        $this->add_responsive_control(
            'astripi_tour_package_one_style_height',
            [
                'label'       => esc_html__('Height', 'astrip-core'),
                'type'        => Controls_Manager::TEXT,
                'description' => 'Unit in px',
                'selectors'   => [
                    '{{WRAPPER}} .trip-category-single .trip-image img ' => 'height: {{VALUE}}px;',
                ],
            ]
        );
        $this->add_responsive_control(
            'astripi_tour_package_one_style_width',
            [
                'label'       => esc_html__('Width', 'astrip-core'),
                'type'        => Controls_Manager::TEXT,
                'description' => 'Unit in %',
                'selectors'   => [
                    '{{WRAPPER}} .trip-category-single .trip-image img ' => 'width: {{VALUE}}%;',
                ],
            ]
        );
        $this->add_responsive_control(
            'astripi_tour_package_one_style_border_radius',
            [
                'label'      => __('Border Radius', 'astrip-core'),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'selectors'  => [
                    '{{WRAPPER}} .trip-category-single .trip-image img' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
                ]
            ]
        );





        $this->end_controls_section();



        $this->start_controls_section(
            'astrip_heading_style_sub_title_section',
            [
                'label' => esc_html__('Heading Sub Title', 'astrip-core'),
                'tab'   => Controls_Manager::TAB_STYLE,

            ]
        );
        $this->add_control(
            'astrip_heading_style_sub_title_color',
            [
                'label'     => esc_html__('Color', 'astrip-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .section-title4.sibling2 span' => 'color: {{VALUE}};',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label'    => esc_html__('Typography', 'astrip-core'),
                'name'     => 'astrip_heading_style_sub_title_typography',
                'selector' => '{{WRAPPER}}  .section-title4.sibling2 span',

            ]
        );
        $this->add_responsive_control(
            'astrip_heading_style_sub_title_padding',
            [
                'label'      => __('Padding', 'astrip-core'),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'selectors'  => [
                    '{{WRAPPER}} .section-title4.sibling2 span' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',

                ],
            ]
        );
        $this->add_responsive_control(
            'astrip_heading_style_sub_title_margin',
            [
                'label' => esc_html__('Margin', 'astrip-core'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors' => [
                    '{{WRAPPER}} .section-title4.sibling2 span' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->end_controls_section();
        //Heading Title Style Section Start
        $this->start_controls_section(
            'astrip_heading_style_main_title_section',
            [
                'label' => esc_html__('Heading Title', 'astrip-core'),
                'tab'   => Controls_Manager::TAB_STYLE,

            ]
        );
        $this->add_control(
            'astrip_heading_style_main_title_color',
            [
                'label'     => esc_html__('Color', 'astrip-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .section-title4.sibling2 h2' => 'color: {{VALUE}};',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label'    => esc_html__('Typography', 'astrip-core'),
                'name'     => 'astrip_heading_style_main_title_typography',
                'selector' => '{{WRAPPER}} .section-title4.sibling2 h2',

            ]
        );
        $this->add_responsive_control(
            'astrip_heading_style_main_title_padding',
            [
                'label'      => __('Padding', 'astrip-core'),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'selectors'  => [
                    '{{WRAPPER}} .section-title4.sibling2 h2' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',

                ],
            ]
        );
        $this->add_responsive_control(
            'astrip_heading_style_main_title_margin',
            [
                'label' => esc_html__('Margin', 'astrip-core'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors' => [
                    '{{WRAPPER}} .section-title4.sibling2 h2' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->end_controls_section();

        //Title Style Start
        $this->start_controls_section(
            'astrip_tour_package_style_one_title_section_ones',
            [
                'label' => esc_html__('Title', 'astrip-core'),
                'tab'   => Controls_Manager::TAB_STYLE,


            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label'    => esc_html__('Typography', 'astrip-core'),
                'name'     => 'astrip_tour_package_style_one_title_typography_ones',
                'selector' =>
                '{{WRAPPER}} .trip-category-single .trip-content h4 a',


            ]
        );
        $this->add_control(
            'astrip_tour_package_style_one_title_color_ones',
            [
                'label'     => esc_html__('Color', 'astrip-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .trip-category-single .trip-content h4 a' => 'color: {{VALUE}};',
                ],
            ]
        );
        $this->add_control(
            'astrip_tour_package_style_one_title_hover_color',
            [
                'label'     => esc_html__('Hover Color', 'astrip-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .trip-category-single .trip-content h4 :hover a' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'astrip_tour_package_style_one_title_padding_ones',
            [
                'label'      => __('Padding', 'astrip-core'),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'selectors'  => [
                    '{{WRAPPER}} .trip-category-single .trip-content h4 a' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',

                ],
            ]
        );


        $this->end_controls_section();
        //description Style Start
        $this->start_controls_section(
            'astrip_tour_package_style_one_description_section',
            [
                'label' => esc_html__('Description', 'astrip-core'),
                'tab'   => Controls_Manager::TAB_STYLE,


            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label'    => esc_html__('Typography', 'astrip-core'),
                'name'     => 'astrip_tour_package_style_one_description_typography',
                'selector' =>
                '{{WRAPPER}} .trip-category-single .trip-content .trip-text p',


            ]
        );
        $this->add_control(
            'astrip_tour_package_style_one_description_color',
            [
                'label'     => esc_html__('Color', 'astrip-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .trip-category-single .trip-content .trip-text p' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'astrip_tour_package_style_one_description_padding',
            [
                'label'      => __('Padding', 'astrip-core'),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'selectors'  => [
                    '{{WRAPPER}} .trip-category-single .trip-content .trip-text p' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',

                ],
            ]
        );


        $this->end_controls_section();
        //Category Style Start
        $this->start_controls_section(
            'astrip_tour_package_style_category_section',
            [
                'label' => esc_html__('Category', 'astrip-core'),
                'tab'   => Controls_Manager::TAB_STYLE,


            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label'    => esc_html__('Typography', 'astrip-core'),
                'name'     => 'astrip_tour_package_style_category_typography',
                'selector' =>
                '{{WRAPPER}} .trip-category-single .trip-image span.blog-date',


            ]
        );
        $this->add_control(
            'astrip_tour_package_style_category_color',
            [
                'label'     => esc_html__('Color', 'astrip-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .trip-category-single .trip-image span.blog-date' => 'color: {{VALUE}};',
                ],
            ]
        );
        $this->add_control(
            'astrip_tour_package_style_category_bg_color',
            [
                'label'     => esc_html__('Background Color', 'astrip-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .trip-category-single .trip-image span.blog-date' => 'background: {{VALUE}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'astrip_tour_package_style_category_padding',
            [
                'label'      => __('Padding', 'astrip-core'),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'selectors'  => [
                    '{{WRAPPER}} .trip-category-single .trip-image span.blog-date' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',

                ],
            ]
        );


        $this->end_controls_section();
        //meta_list Style Start
        $this->start_controls_section(
            'astrip_tour_package_style_one_meta_list_section',
            [
                'label' => esc_html__('Meta List', 'astrip-core'),
                'tab'   => Controls_Manager::TAB_STYLE,


            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label'    => esc_html__('Typography', 'astrip-core'),
                'name'     => 'astrip_tour_package_style_one_meta_list_typography',
                'selector' =>
                '{{WRAPPER}} .trip-category-single .trip-meta-list li',


            ]
        );
        $this->add_control(
            'astrip_tour_package_style_one_meta_list_color',
            [
                'label'     => esc_html__('Color', 'astrip-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .trip-category-single .trip-meta-list li' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'astrip_tour_package_style_one_meta_list_padding',
            [
                'label'      => __('Padding', 'astrip-core'),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'selectors'  => [
                    '{{WRAPPER}} .trip-category-single .trip-meta-list li' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',

                ],
            ]
        );


        $this->end_controls_section();

        //Reading Button Style Start
        $this->start_controls_section(
            'astrip_package_adventure_style_one_reading_btn_section',
            [
                'label' => esc_html__('Explore Button', 'astrip-core'),
                'tab'   => Controls_Manager::TAB_STYLE,


            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label'    => esc_html__('Typography', 'astrip-core'),
                'name'     => 'astrip_package_adventure_style_one_reading_btn_typography',
                'selector' => '{{WRAPPER}} .trip-category-single .trip-content .explore-btn',

            ]
        );

        $this->add_control(
            'astrip_package_adventure_style_one_reading_btn_color',
            [
                'label' => esc_html__('Color', 'astrip-core'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .trip-category-single .trip-content .explore-btn' => 'color: {{VALUE}}',
                ],
            ]
        );


        $this->end_controls_section();




        $this->start_controls_section(
            'astrip_package_adventure_style_one_navigation_style',
            [
                'label' => esc_html__('Navigation', 'astrip-core'),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );


        $this->add_control(
            'astrip_package_adventure_style_one_navigation_style_color',
            [
                'label' => esc_html__('Color', 'astrip-core'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .swiper-pagination .swiper-pagination-bullet' => 'background: {{VALUE}}',
                    '{{WRAPPER}} .swiper-pagination.sibling-4 .swiper-pagination-bullet::before' => 'background: {{VALUE}}',


                ],
            ]
        );
        $this->add_control(
            'astrip_package_adventure_style_one_navigation_style_color_active',
            [
                'label' => esc_html__('Color (Active)', 'astrip-core'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .swiper-pagination.sibling-4 .swiper-pagination-bullet-active' => 'background: {{VALUE}};border:1px solid {{VALUE}}',
                    '{{WRAPPER}} .swiper-pagination.sibling-4 .swiper-pagination-bullet-active::before' => 'background: {{VALUE}};border:1px solid {{VALUE}}',
                ],
            ]
        );
        $this->end_controls_section();



        //Style Two Section Start


    }
    protected function render()
    {

        $settings = $this->get_settings_for_display();
        $query = new \WP_Query(
            array(
                'post_type'      => 'astrip-tour',
                'posts_per_page' => $settings['astrip_package_adventure_posts_per_page'],
                'orderby'        => $settings['astrip_package_adventure_template_order_by'],
                'order'          => $settings['astrip_package_adventure_template_order'],
                'post__in'       => $settings['turio_packages'],
                'offset'         => 0,
                'post_status'    => 'publish'
            )
        );
?>
        <?php if (is_admin()) : ?>
            <script>
                // trip-category-slider
                var swiper = new Swiper(".trip-category-slider", {
                    slidesPerView: 1,
                    speed: 1200,
                    spaceBetween: 25,
                    // autoplay: true,
                    loop: true,
                    roundLengths: true,
                    pagination: {
                        el: ".swiper-pagination",
                        clickable: "true",
                    },
                    navigation: false,
                    breakpoints: {
                        280: {
                            slidesPerView: 1,
                            navigation: false,
                        },
                        576: {
                            slidesPerView: 1,
                            navigation: false,
                        },
                        768: {
                            slidesPerView: 2,
                            navigation: false,
                        },
                        992: {
                            slidesPerView: 3,
                        },
                        1200: {
                            slidesPerView: 3,
                        },
                    },
                });
            </script>
        <?php endif ?>

        <div class="trip-category-section overflow-hidden pt-120">
            <?php if (!empty($settings['astrip_heading_content_image']['url'])) : ?>
                <img src="<?php echo esc_url($settings['astrip_heading_content_image']['url']) ?>" class="trip-bg" alt="<?php echo esc_attr('heading-image', 'astrip-core') ?>">
            <?php endif ?>
            <div class="container">
                <div class="row justify-content-center">
                    <div class="col-md-6 text-center">
                        <div class="section-title4 sibling2">
                            <?php if (!empty($settings['astrip_heading_content_sub_title'])) : ?>
                                <span><?php echo esc_html($settings['astrip_heading_content_sub_title']) ?></span>
                            <?php endif ?>
                            <?php if (!empty($settings['astrip_heading_content_main_title'])) : ?>
                                <h2><?php echo wp_kses($settings['astrip_heading_content_main_title'], wp_kses_allowed_html('post')) ?></h2>
                            <?php endif ?>
                            <?php if ('yes' === $settings['astrip_package_adventure_heading_ribbon_icon']) : ?>
                                <img src="<?php echo get_template_directory_uri() ?>/assets/images/icons/section-title-white.svg" class="img-fluid" alt="<?php echo esc_attr('heading-ribbon-img', 'astrip-core') ?>">
                            <?php endif ?>
                        </div>
                    </div>
                </div>
                <div class="row ">
                    <div class="col-12">
                        <div class="swiper trip-category-slider">
                            <div class="swiper-wrapper">

                                <?php
                                if ($query->have_posts()) {
                                    while ($query->have_posts()) {
                                        $query->the_post();
                                        $max_people = egens_core()->egns_post_meta_box_value(get_the_ID(), EGNS_TOUR_META_ID, 'tour_max_people');
                                        $duration = egens_core()->egns_post_meta_box_value(get_the_ID(), EGNS_TOUR_META_ID, 'tour_duration');
                                ?>
                                        <div class="swiper-slide">
                                            <div class="trip-category-single">
                                                <div class="trip-image">
                                                    <?php the_post_thumbnail('egns-img-one', array('class' => 'img-fluid')); ?>
                                                    <?php $post_terms = get_the_terms(get_the_ID(), 'astrip-tour-type'); ?>
                                                    <?php if (!empty($post_terms)) :   ?>
                                                        <span class="blog-date"><?php echo $post_terms[0]->name; ?></span>
                                                    <?php endif ?>
                                                </div>
                                                <div class="trip-content">
                                                    <h4><a href="<?php the_permalink() ?>"><?php the_title() ?></a></h4>
                                                    <div class="trip-text">
                                                        <p><?php echo wp_trim_words(get_the_content(), 10, '...'); ?></p>
                                                    </div>
                                                    <div class="trip-bottom">
                                                        <ul class="trip-meta-list">
                                                            <?php if (!empty($max_people)) : ?>
                                                            <li><i class='bx bx-user-circle'></i><?php echo esc_html($max_people . ' People') ?></li>
                                                            <?php endif; ?>
                                                            <?php if (!empty($duration)) : ?>
                                                                <li><i class='bx bx-time-five'></i><?php echo esc_html($duration) ?></li>
                                                            <?php endif; ?>
                                                        </ul>
                                                        <a href="<?php the_permalink() ?>" class="explore-btn"><?php echo esc_html__('Explorer Now', 'astrip-core') ?><i class="bi bi-arrow-right"></i></a>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>



                                <?php
                                    }
                                }
                                wp_reset_postdata();
                                ?>



                            </div>
                        </div>
                    </div>
                </div>
                <?php if ('yes' === $settings['astrip_package_adventure_content_pagination_icon']) : ?>
                    <div class="row">
                        <div class="swiper-pagination sibling-4 d-flex align-items-center justify-content-center mt-60 swiper-pagination-clickable swiper-pagination-bullets swiper-pagination-horizontal"><span class="swiper-pagination-bullet swiper-pagination-bullet-active" tabindex="0" role="button" aria-label="Go to slide 1"></span><span class="swiper-pagination-bullet" tabindex="0" role="button" aria-label="Go to slide 2"></span><span class="swiper-pagination-bullet" tabindex="0" role="button" aria-label="Go to slide 3"></span><span class="swiper-pagination-bullet" tabindex="0" role="button" aria-label="Go to slide 4"></span></div>
                    </div>
                <?php endif ?>
            </div>
        </div>

<?php

    }
}

Plugin::instance()->widgets_manager->register(new Astrip_Tour_Package_Adventure_Widget());
