<?php

namespace Elementor;

if (!defined('ABSPATH')) exit; // Exit if accessed directly

use Elementor\core\Schemes;

class Astrip_Testimonial_Widget extends Widget_Base
{

    public function get_name()
    {
        return 'astrip_testimonial';
    }

    public function get_title()
    {
        return esc_html__('EG Testimonial', 'astrip-core');
    }

    public function get_icon()
    {
        return 'eicon-testimonial';
    }

    public function get_categories()
    {
        return ['astrip_widgets'];
    }

    protected function register_controls()
    {
        //Content Section Start
        $this->start_controls_section(
            'astrip_testimonial_content_general_section',
            [
                'label' => esc_html__('General', 'astrip-core')
            ]
        );
        $this->add_control(
            'astrip_testimonial_content_style_selection',
            [
                'label'   => esc_html__('Select Style', 'astrip-core'),
                'type'    => Controls_Manager::SELECT,
                'options' => [
                    'style_one' => esc_html__('Style One', 'astrip-core'),
                    'style_two' => esc_html__('Style Two', 'astrip-core'),
                    'style_three' => esc_html__('Style Three', 'astrip-core'),
                ],
                'default' => 'style_one',
            ]
        );
        $this->add_control(
			'astrip_testimonial_review_show_hide',
			[
				'label' => esc_html__( 'Review', 'astrip-core' ),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'Show', 'astrip-core' ),
				'label_off' => esc_html__( 'Hide', 'astrip-core' ),
				'return_value' => 'yes',
				'default' => 'yes',
                'condition' => [
                    'astrip_testimonial_content_style_selection' => [ 'style_one', 'style_two' ],
                ],
			]
		);
        $this->add_control(
			'astrip_testimonial_designation_show_hide',
			[
				'label' => esc_html__( 'Designation', 'astrip-core' ),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'Show', 'astrip-core' ),
				'label_off' => esc_html__( 'Hide', 'astrip-core' ),
				'return_value' => 'yes',
				'default' => 'yes',
			]
		);
        $this->add_control(
			'astrip_testimonial_style_one_background_quote_icon_show_hide',
			[
				'label' => esc_html__( 'Background Quote Icon', 'astrip-core' ),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'Show', 'astrip-core' ),
				'label_off' => esc_html__( 'Hide', 'astrip-core' ),
				'return_value' => 'yes',
				'default' => 'yes',
                'condition' => [
                    'astrip_testimonial_content_style_selection' => 'style_one'
                ],
			]
		);
        $this->add_control(
			'astrip_testimonial_style_two_background_quote_icon_show_hide',
			[
				'label' => esc_html__( 'Background Quote Icon', 'astrip-core' ),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'Show', 'astrip-core' ),
				'label_off' => esc_html__( 'Hide', 'astrip-core' ),
				'return_value' => 'yes',
				'default' => 'yes',
                'condition' => [
                    'astrip_testimonial_content_style_selection' => 'style_two'
                ],
			]
		);
        $this->add_control(
			'astrip_testimonial_quote_icon_show_hide',
			[
				'label' => esc_html__( 'Quote Icon', 'astrip-core' ),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'Show', 'astrip-core' ),
				'label_off' => esc_html__( 'Hide', 'astrip-core' ),
				'return_value' => 'yes',
				'default' => 'yes',
                'condition' => [
                    'astrip_testimonial_content_style_selection' => 'style_three'
                ],
			]
		);
        $this->add_control(
			'astrip_testimonial_slide_show_hide',
			[
				'label' => esc_html__( 'Slider Navigation (prev/next)', 'astrip-core' ),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'Enable', 'astrip-core' ),
				'label_off' => esc_html__( 'Disable', 'astrip-core' ),
				'return_value' => 'yes',
				'default' => 'yes',
                'condition' => [
                    'astrip_testimonial_content_style_selection' => [ 'style_two', 'style_three' ],
                ],
			]
		);

        $this->end_controls_section();
        // End Content section
        //Testimonial Section
        $this->start_controls_section(
            'astrip_testimonial_content_section',
            [
                'label' => esc_html__('Testimonial', 'astrip-core'),
                'condition' => [
                    'astrip_testimonial_content_style_selection' => [ 'style_one', 'style_two' ],
                ],
            ]
        );
        $repeater = new \Elementor\Repeater();

        
        $repeater->add_control(
			'astrip_testimonial_author_rating',
			[
				'label' 	 => esc_html__( 'Rating', 'elementor' ),
				'type' 		 => Controls_Manager::NUMBER,
				'min' 		 => 0,
				'max'		 => 5,
				'step'		 => 1,
				'default' 	 => 5,
				'dynamic'    => [
					'active' => true,
				],
			]
		);
        $repeater->add_control(
            'astrip_testimonial_author_text',
            [
                'label' => esc_html__( 'Text', 'astrip-core' ),
                'type' => \Elementor\Controls_Manager::TEXTAREA,
                'rows' => 7,
                'default' => esc_html__( '“This place is great! I had a very pleasant stay here. Great stuff and beautiful suites with a fabulous view etiam rhoncus maecenas”!', 'astrip-core' ),
                'placeholder' => esc_html__( 'Type your text here', 'astrip-core' ),
                'label_block' => true,
            ]
        );
        $repeater->add_control(
            'astrip_testimonial_author_image',
            [
                'label' => esc_html__( 'Author Image', 'astrip-core' ),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'default' => [
                    'url' => \Elementor\Utils::get_placeholder_image_src(),
                ],
            ]
        );
        $repeater->add_control(
            'astrip_testimonial_author_name',
            [
                'label' => esc_html__( 'Name', 'astrip-core' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => esc_html__( 'Johan Martin Sr', 'astrip-core' ),
                'placeholder' => esc_html__( 'Type your name here', 'astrip-core' ),
                'label_block' => true,
            ]
        );

        $repeater->add_control(
            'astrip_testimonial_author_designation',
            [
                'label' => esc_html__( 'Designation', 'astrip-core' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => esc_html__( 'South America.', 'astrip-core' ),
                'placeholder' => esc_html__( 'Type your designation here', 'astrip-core' ),
                'label_block' => true,
            ]
        );
        $this->add_control(
            'testimonial_list',
            [
                'label' => esc_html__( 'Testimonial List', 'astrip-core' ),
                'type' => \Elementor\Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
                'default' => [
                    [
                        'astrip_testimonial_author_rating' => esc_html__( '5', 'astrip-core' ),
                    ],
    
                ],
                'title_field' => esc_html('Testimonial Single'),
            ]
        );
        $this->end_controls_section();
        //Testimonial Section
        $this->start_controls_section(
            'astrip_testimonial_content_style_three_section',
            [
                'label' => esc_html__('Testimonial', 'astrip-core'),
                'condition' => [
                    'astrip_testimonial_content_style_selection' => 'style_three'
                ],
            ]
        );
        $repeater2 = new \Elementor\Repeater();

        
        $repeater2->add_control(
            'astrip_testimonial_style_three_author_text',
            [
                'label' => esc_html__( 'Text', 'astrip-core' ),
                'type' => \Elementor\Controls_Manager::TEXTAREA,
                'rows' => 7,
                'default' => esc_html__( 'Text', 'astrip-core' ),
                'placeholder' => esc_html__( 'Type your text here', 'astrip-core' ),
                'label_block' => true,
            ]
        );
        $repeater2->add_control(
            'astrip_testimonial_style_three_author_image',
            [
                'label' => esc_html__( 'Author Image', 'astrip-core' ),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'default' => [
                    'url' => \Elementor\Utils::get_placeholder_image_src(),
                ],
            ]
        );
        $repeater2->add_control(
            'astrip_testimonial_style_three_author_name',
            [
                'label' => esc_html__( 'Name', 'astrip-core' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => esc_html__( 'Johan Martin Sr', 'astrip-core' ),
                'placeholder' => esc_html__( 'Type your name here', 'astrip-core' ),
                'label_block' => true,
            ]
        );

        $repeater2->add_control(
            'astrip_testimonial_style_three_author_designation',
            [
                'label' => esc_html__( 'Designation', 'astrip-core' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => esc_html__( 'South America.', 'astrip-core' ),
                'placeholder' => esc_html__( 'Type your designation here', 'astrip-core' ),
                'label_block' => true,
            ]
        );
        $this->add_control(
            'testimonial_list_style_three',
            [
                'label' => esc_html__( 'Testimonial List', 'astrip-core' ),
                'type' => \Elementor\Controls_Manager::REPEATER,
                'fields' => $repeater2->get_controls(),
                'default' => [
                    [
                        'astrip_testimonial_style_three_author_text' => esc_html__( '“This place is great! I had a very pleasant stay here. Great stuff and beautiful suites with a fabulous view etiam rhoncus maecenas oist”!', 'astrip-core' ),
                    ],
    
                ],
                'title_field' => esc_html('Testimonial Single'),
            ]
        );
        $this->end_controls_section();
        //General Section Start
        $this->start_controls_section(
            'astrip_testimonial_style_general_section',
            [
                'label' => esc_html__('General', 'astrip-core'),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control(
            'astrip_testimonial_style_review_star_color',
            [
                'label'     => esc_html__('Review Star Color', 'astrip-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .testimonial-single1 .star-list li .bi' => 'color: {{VALUE}};',  
                ],
                'condition' => [
                    'astrip_testimonial_content_style_selection' => [ 'style_one', 'style_two' ],
                ],
            ]
        );
        $this->add_control(
            'astrip_testimonial_style_section_style_one_card_background_color',
            [
                'label'     => esc_html__('Background Color', 'astrip-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .testimonial-section .testimonial-wrapper .testimonial-area' => 'background: {{VALUE}};',
                    '{{WRAPPER}} .testimonial-single1 .testi-author1::before' => 'background: {{VALUE}};',  
                ],
                'condition' => [
                    'astrip_testimonial_content_style_selection' => 'style_one',
                ],
            ]
        );
        $this->add_control(
            'astrip_testimonial_style_card_style_three_background_color',
            [
                'label'     => esc_html__('Background Color (Card)', 'astrip-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .testimonial-single1.sibling-4' => 'background: {{VALUE}};',
                    
                ],
                'condition' => [
                    'astrip_testimonial_content_style_selection' => 'style_three',
                ],
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Box_Shadow::get_type(),
            [
                'name' => 'astrip_testimonial_style_card_box_shadow',
                'label' => esc_html__( 'Box Shadow (Card)', 'astrip-core' ),
                'selector' => '{{WRAPPER}} .testimonial-single1.sibling-4',
                'condition' => [
                    'astrip_testimonial_content_style_selection' => 'style_three',
                ],
            ]
        );
        
        $this->end_controls_section();

        //Text Style Section Start
        $this->start_controls_section(
            'astrip_testimonial_style_text_section',
            [
                'label' => esc_html__('Text', 'astrip-core'),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control(
            'astrip_testimonial_style_text_color',
            [
                'label'     => esc_html__('Color', 'astrip-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .testimonial-single1 .testimonial-content > p' => 'color: {{VALUE}};',
                    '{{WRAPPER}} .testimonial-single1.siblling-2 > p' => 'color: {{VALUE}};',
                    '{{WRAPPER}} .testimonial-single1.sibling-4 > p' => 'color: {{VALUE}};',

                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label'    => esc_html__('Typography', 'astrip-core'),
                'name'     => 'astrip_testimonial_style_text_typography',
                'selector' => '{{WRAPPER}} .testimonial-single1 .testimonial-content > p,.testimonial-single1.siblling-2 > p, .testimonial-single1.sibling-4 > p ',
            ]
        );
        $this->add_responsive_control(
            'astrip_testimonial_style_text_padding',
            [
                'label'      => __('Padding', 'astrip-core'),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'selectors'  => [
                    '{{WRAPPER}} .testimonial-single1 .testimonial-content > p' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    '{{WRAPPER}} .testimonial-single1.siblling-2 > p' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    '{{WRAPPER}} .testimonial-single1.sibling-4 > p' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    
                ],
            ]
        );
        $this->add_responsive_control(
            'astrip_testimonial_style_text_margin',
            [
                'label' => esc_html__( 'Margin', 'astrip-core' ),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%', 'em' ],
                'selectors' => [
                    '{{WRAPPER}} .testimonial-single1 .testimonial-content > p' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    '{{WRAPPER}} .testimonial-single1.siblling-2 > p' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    '{{WRAPPER}} .testimonial-single1.sibling-4 > p' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->end_controls_section();
        //Name Style Section Start
        $this->start_controls_section(
            'astrip_testimonial_style_name_section',
            [
                'label' => esc_html__('Name', 'astrip-core'),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control(
            'astrip_testimonial_style_name_color',
            [
                'label'     => esc_html__('Color', 'astrip-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .testimonial-single1 .testi-author1 .author-text h5' => 'color: {{VALUE}};',
                    '{{WRAPPER}} .testimonial-single1.siblling-2 .author-text h5' => 'color: {{VALUE}};',
                    '{{WRAPPER}} .testimonial-single1.sibling-4 .author-text h5' => 'color: {{VALUE}};',

                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label'    => esc_html__('Typography', 'astrip-core'),
                'name'     => 'astrip_testimonial_style_name_typography',
                'selector' => '{{WRAPPER}} .testimonial-single1 .testi-author1 .author-text h5,.testimonial-single1.siblling-2 .author-text h5, .testimonial-single1.sibling-4 .author-text h5 ',
            ]
        );
        $this->add_responsive_control(
            'astrip_testimonial_style_name_padding',
            [
                'label'      => __('Padding', 'astrip-core'),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'selectors'  => [
                    '{{WRAPPER}} .testimonial-single1 .testi-author1 .author-text h5' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    '{{WRAPPER}} .testimonial-single1.siblling-2 .author-text h5' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    '{{WRAPPER}} .testimonial-single1.sibling-4 .author-text h5' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    
                ],
            ]
        );
        $this->add_responsive_control(
            'astrip_testimonial_style_name_margin',
            [
                'label' => esc_html__( 'Margin', 'astrip-core' ),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%', 'em' ],
                'selectors' => [
                    '{{WRAPPER}} .testimonial-single1 .testi-author1 .author-text h5' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    '{{WRAPPER}} .testimonial-single1.siblling-2 .author-text h5' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    '{{WRAPPER}} .testimonial-single1.sibling-4 .author-text h5' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->end_controls_section();
        //Designation Section Start
        $this->start_controls_section(
            'astrip_testimonial_style_designation_section',
            [
                'label' => esc_html__('Designation', 'astrip-core'),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control(
            'astrip_testimonial_style_designation_color',
            [
                'label'     => esc_html__('Color', 'astrip-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .testimonial-single1 .testi-author1 .author-text p' => 'color: {{VALUE}};',
                    '{{WRAPPER}} .testimonial-single1.siblling-2 .author-text p' => 'color: {{VALUE}};',
                    '{{WRAPPER}} .testimonial-single1.sibling-4 .author-text span' => 'color: {{VALUE}};',

                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label'    => esc_html__('Typography', 'astrip-core'),
                'name'     => 'astrip_testimonial_style_designation_typography',
                'selector' => '{{WRAPPER}} .testimonial-single1 .testi-author1 .author-text p,.testimonial-single1.siblling-2 .author-text p, .testimonial-single1.sibling-4 .author-text span ',
            ]
        );
        $this->add_responsive_control(
            'astrip_testimonial_style_designation_padding',
            [
                'label'      => __('Padding', 'astrip-core'),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'selectors'  => [
                    '{{WRAPPER}} .testimonial-single1 .testi-author1 .author-text p' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    '{{WRAPPER}} .testimonial-single1.siblling-2 .author-text p' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    '{{WRAPPER}} .testimonial-single1.sibling-4 .author-text span' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    
                ],
            ]
        );
        $this->add_responsive_control(
            'astrip_testimonial_style_designation_margin',
            [
                'label' => esc_html__( 'Margin', 'astrip-core' ),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%', 'em' ],
                'selectors' => [
                    '{{WRAPPER}} .testimonial-single1 .testi-author1 .author-text p' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    '{{WRAPPER}} .testimonial-single1.siblling-2 .author-text p' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    '{{WRAPPER}} .testimonial-single1.sibling-4 .author-text span' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->end_controls_section();
        
        // Slider Navigation Style For Style One 
        $this->start_controls_section(
            'astrip_testimonial_style_slider_navigation_style_one_section',
            [
                'label' => esc_html__('Swiper Pagination Bullet', 'astrip-core'),
                'tab'   => Controls_Manager::TAB_STYLE,
                'condition' => [
                    'astrip_testimonial_content_style_selection' => 'style_one'
                ],
            ]
        );
        $this->add_control(
            'astrip_testimonial_style_slider_navigation_color',
            [
                'label'     => esc_html__('Color', 'astrip-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .testimonial1-pagination .swiper-pagination-bullet-active::before' => 'background: {{VALUE}};',
                    '{{WRAPPER}} .testimonial1-pagination .swiper-pagination-bullet-active' => 'border:1px solid {{VALUE}}',
                    
                ],
                'label_block' => true,
            ]
        );
        $this->end_controls_section();

        // Slider Navigaticon Style Two and Three

        $this->start_controls_section(
            'astrip_testimonial_style_slider_navigation_style_two_and_three_section',
            [
                'label' => esc_html__('Slider Navigaticon', 'astrip-core'),
                'tab'   => Controls_Manager::TAB_STYLE,
                'condition' => [
                    'astrip_testimonial_content_style_selection' => [ 'style_two', 'style_three' ],
                ],
            ]
        );
        $this->start_controls_tabs(
            'style_tabs'
        );

        $this->start_controls_tab(
            'style_normal_tab',
            [
                'label' => esc_html__( 'Normal', 'astrip-core' ),
            ]
        );
        $this->add_control(
            'astrip_testimonial_style_slider_navigation_icon_color',
            [
                'label'     => esc_html__('Color', 'astrip-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .arrows-style-3 .swiper-prev-arrow i' => 'color: {{VALUE}};',
                    '{{WRAPPER}} .arrows-style-3 .swiper-next-arrow i' => 'color: {{VALUE}};',
                ],
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Border::get_type(),
            [
                'name' => 'astrip_testimonial_style_slider_navigation_icon_border',
                'label' => esc_html__( 'Border', 'astrip-core' ),
                'selector' => '{{ WRAPPER }} .testimonial2-section .arrows-style-3 .swiper-prev-arrow,.testimonial2-section .arrows-style-3 .swiper-next-arrow,.testimonial3-section .arrows-style-3 .swiper-prev-arrow, .testimonial3-section .arrows-style-3 .swiper-next-arrow'
            ]
        );
        $this->end_controls_tab();
        //  Hover start
        $this->start_controls_tab(
            'style_hover_tab',
            [
                'label' => esc_html__( 'Hover', 'astrip-core' ),
            ]
        );
        $this->add_control(
            'astrip_testimonial_style_slider_navigation_icon_hover_color',
            [
                'label'     => esc_html__('Color', 'astrip-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .arrows-style-3 .swiper-prev-arrow:hover i' => 'color: {{VALUE}};',
                    '{{WRAPPER}} .arrows-style-3.sibling-2 .swiper-prev-arrow:hover i' => 'color: {{VALUE}};',
                    '{{WRAPPER}} .arrows-style-3 .swiper-next-arrow:hover i' => 'color: {{VALUE}};',
                    '{{WRAPPER}} .arrows-style-3.sibling-2 .swiper-next-arrow:hover i' => 'color: {{VALUE}};',
                ],
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Border::get_type(),
            [
                'name' => 'astrip_testimonial_style_slider_navigation_icon_hover_border',
                'label' => esc_html__( 'Border', 'astrip-core' ),
                'selector' => '{{ WRAPPER }} .testimonial2-section .arrows-style-3 .swiper-prev-arrow:hover,.testimonial2-section .arrows-style-3 .swiper-next-arrow:hover,.testimonial3-section .arrows-style-3 .swiper-prev-arrow:hover, .testimonial3-section .arrows-style-3 .swiper-next-arrow:hover'
            ]
        );

        $this->end_controls_tab();
        $this->end_controls_tabs();
        $this->end_controls_section();  
        
    }
    protected function render()
    {
        $settings = $this->get_settings_for_display();
        $items=$settings['testimonial_list'];
        $datas=$settings['testimonial_list_style_three'];
        ?>
        <script>
            <?php if( is_admin() ) : ?>
                // testimoanil slider
                new Swiper(".testimonial1-slider", {
                    slidesPerView: 1,
                    speed: 1000,
                    autoplay: true,
                    spaceBetween: 25,
                    loop: true,
                    roundLengths: true,
                    pagination: {
                    el: ".testimonial1-pagination",
                    clickable: 'true',
                    }
                });

                new Swiper(".testimonial2-slider", {
                    slidesPerView: 1,
                    speed: 1000,
                    autoplay: true,
                    spaceBetween: 45,
                    loop: true,
                    roundLengths: true,
                    pagination: {
                    el: ".swiper-pagination",
                    clickable: 'true',
                    },
                    navigation: {
                    nextEl: ".testi2-next",
                    prevEl: ".testi2-prev",
                    },
                    breakpoints: {
                    280:{
                        slidesPerView: 1,
                        navigation: false,
                        },
                        386:{
                        slidesPerView: 1,
                        navigation: false,
                        },
                    576:{
                    slidesPerView: 1,
                    navigation: false,
                    },
                    768:{
                    slidesPerView: 1,
                    navigation: false,
                    },
                    992:{ 
                    slidesPerView: 2
                    },
                }
                });
                new Swiper(".testimonial2-slider", {
                slidesPerView: 1,
                speed: 1000,
                autoplay: true,
                spaceBetween: 45,
                loop: true,
                roundLengths: true,
                pagination: {
                el: ".swiper-pagination",
                clickable: 'true',
                },
                navigation: {
                nextEl: ".testi2-next",
                prevEl: ".testi2-prev",
                },
                breakpoints: {
                280:{
                    slidesPerView: 1,
                    navigation: false,
                    },
                    386:{
                    slidesPerView: 1,
                    navigation: false,
                    },
                576:{
                slidesPerView: 1,
                navigation: false,
                },
                768:{
                slidesPerView: 1,
                navigation: false,
                },
                992:{ 
                slidesPerView: 2
                },
            }
            });
            new Swiper(".testimonial4-slider", {
            slidesPerView: 1,
            speed: 1000,
            autoplay: true,
            spaceBetween: 25,
            loop: true,
            roundLengths: true,
            pagination: {
            el: ".swiper-pagination",
            clickable: 'true',
            },
            navigation: {
            nextEl: ".testi4-next",
            prevEl: ".testi4-prev",
            },
            breakpoints: {
            280:{
                slidesPerView: 1,
                navigation: false,
                },
                386:{
                slidesPerView: 1,
                navigation: false,
                },
            576:{
            slidesPerView: 1,
            navigation: false,
            },
            768:{
            slidesPerView: 1,
            navigation: false,
            },
            992:{ 
            slidesPerView: 2
            },
        }
        });

                <?php endif ?>
        </script>
            <?php if( !empty( $settings['astrip_testimonial_content_style_selection'] ) && ($settings['astrip_testimonial_content_style_selection'] == 'style_one') )  : ?> 
                <div class="testimonial-section overflow-hidden">
                    <div class="container-fluid px-0">
                        <div class="testimonial-wrapper">
                            <div class="testimonial-area">
                                <?php if ( 'yes' === $settings['astrip_testimonial_style_one_background_quote_icon_show_hide'] ) :?>
                                    <div class="testi-quote">
                                        <svg width="238" height="238" viewBox="0 0 238 238" fill="none" xmlns="http://www.w3.org/2000/svg">
                                        <g opacity="0.05">
                                        <path d="M65.45 15.6653C64.7992 16.409 52.5273 31.7954 38.1637 49.8778C17.4781 76.002 12.0859 83.1141 12.0859 84.1368C12.0859 85.2524 12.7832 86.0426 16.1301 88.8317C18.4078 90.6446 23.1492 95.1536 26.7285 98.7329C41.2316 113.375 49.7383 127.693 52.7133 142.335C53.6895 146.984 53.6895 156.141 52.7133 161.812C49.8313 178.825 38.5355 199.232 22.6844 216.152C20.0348 218.941 19.0586 220.336 19.0586 221.219C19.0586 224.241 21.1969 224.287 28.0766 221.405C47.6 213.177 67.2164 200.115 81.5801 185.705C100.174 167.111 111.051 146.751 115.56 122.254C116.862 115.328 116.769 102.173 115.374 95.386C110.029 68.9829 95.2 41.836 73.9102 19.384C68.6109 13.8059 67.5883 13.3876 65.45 15.6653ZM74.7004 28.1231C90.6445 46.5774 102.452 67.4024 108.076 87.1118C113.004 104.497 112.632 118.07 106.635 136.432C96.827 166.414 72.3297 193.003 38.1172 210.76C32.9574 213.456 32.0277 213.782 32.7715 212.806C41.557 201.324 44.8574 196.304 48.9945 188.262C53.55 179.29 56.7109 169.761 58.152 160.743C59.0352 154.932 58.4773 143.451 57.0363 137.966C53.1316 123.137 44.532 109.145 30.7262 95.293C26.9609 91.5278 22.6379 87.3442 21.0574 85.9497L18.1754 83.4395L43.091 52.1555L67.9602 20.8715L69.1223 21.9407C69.773 22.545 72.2832 25.2876 74.7004 28.1231Z" fill="white"/>
                                        <path d="M174.688 15.6652C174.037 16.4089 161.766 31.7953 147.402 49.8777C126.716 76.0019 121.324 83.114 121.324 84.1367C121.324 85.2523 122.021 86.0425 125.415 88.8316C127.646 90.6445 132.387 95.1535 135.967 98.7327C150.47 113.375 158.977 127.693 161.952 142.335C162.928 146.984 162.928 156.141 161.952 161.812C161.068 166.879 158.698 174.688 156.188 180.452C151.307 191.701 141.452 206.112 131.318 216.803C129.18 219.081 128.297 220.382 128.297 221.266C128.297 224.241 130.435 224.287 137.315 221.405C161.44 211.271 185.705 193.514 200.441 175.246C211.132 161.998 219.267 145.868 223.079 130.389C225.17 121.928 225.635 118.07 225.635 109.006C225.635 101.15 225.542 99.523 224.38 94.3167C218.755 68.0066 204.206 41.557 183.148 19.3839C177.849 13.8058 176.827 13.3875 174.688 15.6652ZM186.356 30.9121C206.67 55.2699 219.732 84.0902 220.661 106.449C221.312 121.975 216.106 140.615 206.623 156.838C193.84 178.779 171.992 198.442 145.868 211.55C141.824 213.596 141.312 213.735 142.056 212.759C151.353 200.673 154.607 195.653 158.977 186.635C162.416 179.616 164.834 172.968 166.507 165.949C167.39 162.091 167.53 160.278 167.53 152.004C167.53 143.172 167.437 142.149 166.321 137.966C162.23 122.905 153.724 109.145 139.964 95.2929C136.199 91.5277 131.876 87.3441 130.296 85.9495L127.414 83.4394L152.376 52.1089L177.291 20.732L180.266 23.9859C181.94 25.7523 184.682 28.8667 186.356 30.9121Z" fill="white"/>
                                        </g>
                                        </svg>
                                    </div>
                                <?php endif ?> 
                                <div class="testimonial-wrap" >
                                    <div class="swiper testimonial1-slider">
                                        <div class="swiper-wrapper">
                                            <?php foreach($items as $item):?>
                                                <div class="swiper-slide">
                                                    <div class="testimonial-single1">
                                                        <div class="testimonial-content">
                                                            <?php if ( 'yes' === $settings['astrip_testimonial_review_show_hide'] ) :?>
                                                                <?php if( !empty( $item['astrip_testimonial_author_rating'] ) ) : ?>
                                                                    <ul class="star-list">
                                                                        <?php
                                                                            for ($i=0; $i <$item['astrip_testimonial_author_rating'] ; $i++) {  ?>
                                                                            <li><i class="bi bi-star-fill"></i></li>	
                                                                        <?php	}
                                                                        ?>  
                                                                    </ul>
                                                                <?php endif ?>
                                                            <?php endif ?> 
                                                            <?php if( !empty( $item['astrip_testimonial_author_text'] ) ) : ?>
                                                                <p><?php echo esc_html($item['astrip_testimonial_author_text']) ?></p>
                                                            <?php endif ?> 
                                                        </div>
                                                        <div class="testi-author1">
                                                            <?php if( !empty( $item['astrip_testimonial_author_image'] ) ) :   ?>
                                                                <div class="image">
                                                                    <img src="<?php echo esc_url( $item['astrip_testimonial_author_image']['url'] ) ?>" alt="<?php esc_attr__('testimonial_author_image','astrip-core') ?>">
                                                                </div>
                                                            <?php endif ?>
                                                            <div class="author-text">
                                                                <?php if( !empty( $item['astrip_testimonial_author_name'] ) ) : ?>
                                                                    <h5><?php echo esc_html($item['astrip_testimonial_author_name']) ?></h5>
                                                                <?php endif ?> 
                                                                <?php if ( 'yes' === $settings['astrip_testimonial_designation_show_hide'] ) :?>
                                                                    <?php if( !empty( $item['astrip_testimonial_author_designation'] ) ) : ?>
                                                                        <p><?php echo esc_html($item['astrip_testimonial_author_designation']) ?></p>
                                                                    <?php endif ?> 
                                                                <?php endif ?> 
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            <?php endforeach?>
                                        </div>
                                        <div class="testimonial1-pagination d-flex align-items-center justify-content-sm-end justify-content-center pt-sm-0 pt-4"></div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            <?php endif ?>
            <?php if( !empty( $settings['astrip_testimonial_content_style_selection'] ) && ($settings['astrip_testimonial_content_style_selection'] == 'style_two') )  : ?> 
                <div class="testimonial-section testimonial2-section overflow-hidden position-relative">
                    <div class="container">
                        <div class="row">
                            <div class="col-12">
                                <div class="swiper testimonial2-slider">
                                    <div class="swiper-wrapper">
                                        <?php foreach($items as $item):?>
                                            <div class="swiper-slide">
                                                <div class="testimonial-single1 siblling-2">
                                                    <?php if ( 'yes' === $settings['astrip_testimonial_style_two_background_quote_icon_show_hide'] ) :?>
                                                        <svg width="238" height="238" viewBox="0 0 238 238" xmlns="http://www.w3.org/2000/svg">
                                                            <g opacity="0.05">
                                                            <path d="M65.45 15.6653C64.7992 16.409 52.5273 31.7954 38.1637 49.8778C17.4781 76.002 12.0859 83.1141 12.0859 84.1368C12.0859 85.2524 12.7832 86.0426 16.1301 88.8317C18.4078 90.6446 23.1492 95.1536 26.7285 98.7329C41.2316 113.375 49.7383 127.693 52.7133 142.335C53.6895 146.984 53.6895 156.141 52.7133 161.812C49.8313 178.825 38.5355 199.232 22.6844 216.152C20.0348 218.941 19.0586 220.336 19.0586 221.219C19.0586 224.241 21.1969 224.287 28.0766 221.405C47.6 213.177 67.2164 200.115 81.5801 185.705C100.174 167.111 111.051 146.751 115.56 122.254C116.862 115.328 116.769 102.173 115.374 95.386C110.029 68.9829 95.2 41.836 73.9102 19.384C68.6109 13.8059 67.5883 13.3876 65.45 15.6653ZM74.7004 28.1231C90.6445 46.5774 102.452 67.4024 108.076 87.1118C113.004 104.497 112.632 118.07 106.635 136.432C96.827 166.414 72.3297 193.003 38.1172 210.76C32.9574 213.456 32.0277 213.782 32.7715 212.806C41.557 201.324 44.8574 196.304 48.9945 188.262C53.55 179.29 56.7109 169.761 58.152 160.743C59.0352 154.932 58.4773 143.451 57.0363 137.966C53.1316 123.137 44.532 109.145 30.7262 95.293C26.9609 91.5278 22.6379 87.3442 21.0574 85.9497L18.1754 83.4395L43.091 52.1555L67.9602 20.8715L69.1223 21.9407C69.773 22.545 72.2832 25.2876 74.7004 28.1231Z"></path>
                                                            <path d="M174.688 15.6652C174.037 16.4089 161.766 31.7953 147.402 49.8777C126.716 76.0019 121.324 83.114 121.324 84.1367C121.324 85.2523 122.021 86.0425 125.415 88.8316C127.646 90.6445 132.387 95.1535 135.967 98.7327C150.47 113.375 158.977 127.693 161.952 142.335C162.928 146.984 162.928 156.141 161.952 161.812C161.068 166.879 158.698 174.688 156.188 180.452C151.307 191.701 141.452 206.112 131.318 216.803C129.18 219.081 128.297 220.382 128.297 221.266C128.297 224.241 130.435 224.287 137.315 221.405C161.44 211.271 185.705 193.514 200.441 175.246C211.132 161.998 219.267 145.868 223.079 130.389C225.17 121.928 225.635 118.07 225.635 109.006C225.635 101.15 225.542 99.523 224.38 94.3167C218.755 68.0066 204.206 41.557 183.148 19.3839C177.849 13.8058 176.827 13.3875 174.688 15.6652ZM186.356 30.9121C206.67 55.2699 219.732 84.0902 220.661 106.449C221.312 121.975 216.106 140.615 206.623 156.838C193.84 178.779 171.992 198.442 145.868 211.55C141.824 213.596 141.312 213.735 142.056 212.759C151.353 200.673 154.607 195.653 158.977 186.635C162.416 179.616 164.834 172.968 166.507 165.949C167.39 162.091 167.53 160.278 167.53 152.004C167.53 143.172 167.437 142.149 166.321 137.966C162.23 122.905 153.724 109.145 139.964 95.2929C136.199 91.5277 131.876 87.3441 130.296 85.9495L127.414 83.4394L152.376 52.1089L177.291 20.732L180.266 23.9859C181.94 25.7523 184.682 28.8667 186.356 30.9121Z"></path>
                                                            </g>
                                                        </svg>
                                                    <?php endif ?> 
                                                    <?php if ( 'yes' === $settings['astrip_testimonial_review_show_hide'] ) :?>
                                                        <?php if( !empty( $item['astrip_testimonial_author_rating'] ) ) : ?>
                                                            <ul class="star-list">
                                                            <?php
                                                                for ($i=0; $i <$item['astrip_testimonial_author_rating'] ; $i++) {  ?>
                                                                <li><i class="bi bi-star-fill"></i></li>	
                                                            <?php	}
                                                            ?> 
                                                            </ul>
                                                        <?php endif ?>
                                                    <?php endif ?> 
                                                        <?php if( !empty( $item['astrip_testimonial_author_text'] ) ) : ?>
                                                            <p><?php echo esc_html($item['astrip_testimonial_author_text']) ?></p>
                                                        <?php endif ?> 
                                                    <div class="testi-author">
                                                        <?php if( !empty( $item['astrip_testimonial_author_image']['url'] ) ) :   ?>
                                                            <div class="image">
                                                                <img class="author-img-size" src="<?php echo esc_url( $item['astrip_testimonial_author_image']['url'] ) ?>" alt="<?php esc_attr__('testimonial_author_image','astrip-core') ?>">
                                                            </div>
                                                        <?php endif ?>
                                                        <div class="author-text">
                                                            <?php if( !empty( $item['astrip_testimonial_author_name'] ) ) : ?>
                                                                <h5><?php echo esc_html($item['astrip_testimonial_author_name']) ?></h5>
                                                            <?php endif ?>
                                                            <?php if ( 'yes' === $settings['astrip_testimonial_designation_show_hide'] ) :?> 
                                                                <?php if( !empty( $item['astrip_testimonial_author_designation'] ) ) : ?>
                                                                    <p><?php echo esc_html($item['astrip_testimonial_author_designation']) ?></p>
                                                                <?php endif ?>
                                                            <?php endif ?>  
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        <?php endforeach?>
                                    </div>
                                </div>
                                <?php if ( 'yes' === $settings['astrip_testimonial_slide_show_hide'] ) :?>
                                    <div class="slider-arrows arrows-style-3 text-center d-xl-flex d-none flex-row justify-content-between align-items-center w-100">
                                        <div class="testi2-prev swiper-prev-arrow" tabindex="0" role="button" aria-label="Previous slide"> 
                                            <i class="bi bi-arrow-left"></i>
                                        </div>
                                        <div class="testi2-next swiper-next-arrow" tabindex="0" role="button" aria-label="Next slide"> 
                                            <i class="bi bi-arrow-right"></i>
                                        </div>
                                    </div>
                                <?php endif ?>
                            </div>   
                        </div>
                    </div>
                </div>
            <?php endif ?>
            <?php if( !empty( $settings['astrip_testimonial_content_style_selection'] ) && ($settings['astrip_testimonial_content_style_selection'] == 'style_three') )  : ?> 
                <div class="testimonial-section4 testimonial3-section position-relative overflow-hidden">
                    <div class="container">
                        <div class="row">
                            <div class="col-12">
                                <div class="swiper testimonial4-slider">
                                    <div class="swiper-wrapper">
                                        <?php foreach($datas as $data):?>
                                            <div class="swiper-slide">
                                                <div class="testimonial-single1 sibling-4">
                                                    <div class="testi-author">
                                                        <?php if( !empty( $data['astrip_testimonial_style_three_author_image']['url'] ) ) :   ?>
                                                            <div class="image">
                                                                <?php if ( 'yes' === $settings['astrip_testimonial_quote_icon_show_hide'] ) :?>
                                                                    <div class="testi-quote">
                                                                        <svg width="18" height="18" viewBox="0 0 18 18" fill="none" xmlns="http://www.w3.org/2000/svg">
                                                                        <path d="M4.95 1.90059C4.90078 1.95302 3.97266 3.03771 2.88633 4.31247C1.32187 6.15414 0.914062 6.65553 0.914062 6.72762C0.914062 6.80627 0.966798 6.86198 1.21992 7.0586C1.39219 7.1864 1.75078 7.50427 2.02148 7.7566C3.11836 8.78886 3.76172 9.79818 3.98672 10.8304C4.06055 11.1581 4.06055 11.8037 3.98672 12.2035C3.76875 13.4029 2.91445 14.8415 1.71563 16.0343C1.51523 16.2309 1.44141 16.3293 1.44141 16.3915C1.44141 16.6045 1.60313 16.6078 2.12344 16.4046C3.6 15.8246 5.08359 14.9038 6.16992 13.8879C7.57617 12.5771 8.39883 11.1418 8.73984 9.41477C8.83828 8.92649 8.83125 7.9991 8.72578 7.52066C8.32149 5.65932 7.2 3.74554 5.58984 2.16275C5.18906 1.76951 5.11172 1.74002 4.95 1.90059Z" fill="#90B956"/>
                                                                        <path d="M13.2117 1.90069C13.1625 1.95312 12.2344 3.03781 11.148 4.31256C9.58359 6.15424 9.17578 6.65563 9.17578 6.72772C9.17578 6.80637 9.22852 6.86208 9.48516 7.0587C9.65391 7.1865 10.0125 7.50437 10.2832 7.7567C11.3801 8.78896 12.0234 9.79828 12.2484 10.8305C12.3223 11.1582 12.3223 11.8038 12.2484 12.2036C12.1816 12.5608 12.0023 13.1113 11.8125 13.5177C11.4434 14.3107 10.698 15.3266 9.93164 16.0803C9.76992 16.2409 9.70313 16.3326 9.70313 16.3949C9.70313 16.6046 9.86484 16.6079 10.3852 16.4047C12.2098 15.6903 14.0449 14.4385 15.1594 13.1507C15.968 12.2167 16.5832 11.0796 16.8715 9.98834C17.0297 9.39193 17.0648 9.11994 17.0648 8.48092C17.0648 7.92711 17.0578 7.81241 16.9699 7.44538C16.5445 5.5906 15.4441 3.72598 13.8516 2.16285C13.4508 1.76961 13.3734 1.74012 13.2117 1.90069Z" fill="#90B956"/>
                                                                        </svg>
                                                                    </div>
                                                                <?php endif ?>
                                                                <img class="author-img-size" src="<?php echo esc_url( $data['astrip_testimonial_style_three_author_image']['url'] ) ?>" alt="<?php esc_attr__('testimonial_author_image','astrip-core') ?>">
                                                            </div>
                                                        <?php endif ?>
                                                        <div class="author-text">
                                                            <?php if( !empty( $data['astrip_testimonial_style_three_author_name'] ) ) : ?>
                                                                <h5><?php echo esc_html($data['astrip_testimonial_style_three_author_name']) ?></h5>
                                                            <?php endif ?>
                                                            <?php if ( 'yes' === $settings['astrip_testimonial_designation_show_hide'] ) :?> 
                                                                <?php if( !empty( $data['astrip_testimonial_style_three_author_designation'] ) ) : ?>
                                                                    <span><?php echo esc_html($data['astrip_testimonial_style_three_author_designation']) ?></span>
                                                                <?php endif ?>
                                                            <?php endif ?>
                                                        </div>
                                                    </div>
                                                    <?php if( !empty( $data['astrip_testimonial_style_three_author_text'] ) ) : ?>
                                                        <p><?php echo esc_html($data['astrip_testimonial_style_three_author_text']) ?></p>
                                                    <?php endif ?> 
                                                </div>
                                            </div>
                                        <?php endforeach ?>
                                    </div>
                                </div>
                                <?php if ( 'yes' === $settings['astrip_testimonial_slide_show_hide'] ) :?>
                                    <div class="slider-arrows arrows-style-3 sibling-2 text-center d-xl-flex d-none flex-row justify-content-between align-items-center w-100">
                                        <div class="testi4-prev swiper-prev-arrow" tabindex="0" role="button" aria-label="Previous slide"> 
                                            <i class="bi bi-arrow-left"></i>
                                        </div>
                                        <div class="testi4-next swiper-next-arrow" tabindex="0" role="button" aria-label="Next slide"> 
                                            <i class="bi bi-arrow-right"></i>
                                        </div>
                                    </div>
                                <?php endif ?>
                            </div>   
                        </div>
                    </div>
                </div>
            <?php endif ?>

        <?php 
        
    }
}

Plugin::instance()->widgets_manager->register(new Astrip_Testimonial_Widget());
