<?php

namespace Elementor;

if (!defined('ABSPATH')) exit; // Exit if accessed directly

use Elementor\core\Schemes;

class Astrip_Team_Widget extends Widget_Base
{

    public function get_name()
    {
        return 'astrip_team';
    }

    public function get_title()
    {
        return esc_html__('EG Team', 'astrip-core');
    }

    public function get_icon()
    {
        return 'eicon-elementor';
    }

    public function get_categories()
    {
        return ['astrip_widgets'];
    }

    protected function register_controls()
    {
        //Content Section Start
        $this->start_controls_section(
            'astrip_team_content_section',
            [
                'label' => esc_html__('Team', 'astrip-core')
            ]
        );
        $this->add_control(
			'astrip_team_content_style_selection',
			[
				'label'   => esc_html__('Select Style', 'astrip-core'),
				'type'    => Controls_Manager::SELECT,
				'options' => [
					'style_one'  => esc_html__('Style One', 'astrip-core'),
					'style_two' => esc_html__('Style Two', 'astrip-core'),
				],
				'default' => 'style_one',
			]
		);

        $this->add_control(
			'astrip_team_content_style_column_section',
			[
				'label'   => esc_html__('Column', 'astrip-core'),
				'type'    => Controls_Manager::SELECT,
				'options' => [
					'column_two'  => esc_html__('2', 'astrip-core'),
					'column_three' => esc_html__('3', 'astrip-core'),
					'column_four' => esc_html__('4', 'astrip-core'),
				],
				'default' => 'column_three',
			]
		);

        // start repeater
        $repeater = new \Elementor\Repeater();
        // Image
        $repeater->add_control(
            'astrip_team_content_single_image',
            [
                'label' => esc_html__( 'Choose Image', 'astrip-core' ),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'default' => [
                    'url' => \Elementor\Utils::get_placeholder_image_src(),
                ],
            ]
        );
        // Name Control
        $repeater->add_control(
            'astrip_team_content_single_name',
            [
                'label' => esc_html__( 'Name', 'astrip-core' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => esc_html__( 'John Doe', 'astrip-core' ),
                'placeholder' => esc_html__( 'Type your name here', 'astrip-core' ),
                'label_block' => true,
            ]
        );

        // Designation Control
        $repeater->add_control(
            'astrip_team_content_single_designation',
            [
                'label' => esc_html__( 'Designation', 'astrip-core' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => esc_html__( 'Tour Guide', 'astrip-core' ),
                'placeholder' => esc_html__( 'Type your designation here', 'astrip-core' ),
                'label_block' => true,
            ]
        );

        // start popcover
        $repeater->add_control(
            'popover-toggle_social',
            [
                'type' => \Elementor\Controls_Manager::POPOVER_TOGGLE,
                'label' => esc_html__( 'Social Media', 'astrip-core' ),
                'label_off' => esc_html__( 'Default', 'astrip-core' ),
                'label_on' => esc_html__( 'Custom', 'astrip-core' ),
                'return_value' => 'yes',
            ]
        );

        $repeater->start_popover();

        
        //facebook Link
        $repeater->add_control(
            'website_link_facebook',
            [
                'label' => esc_html__( 'Facebook Link', 'astrip-core' ),
                'type' => \Elementor\Controls_Manager::URL,
                'placeholder' => esc_html__( 'https://your-link.com', 'astrip-core' ),
                'default' => [
                    'url' => '#',
                    'is_external' => true,
                    'nofollow' => true,
                    'custom_attributes' => '',
                ],
                'label_block' => true,
            ]
        );
        
        //instagram Link
        $repeater->add_control(
            'website_link_instagram',
            [
                'label' => esc_html__( 'Instagram Link', 'astrip-core' ),
                'type' => \Elementor\Controls_Manager::URL,
                'placeholder' => esc_html__( 'https://your-link.com', 'astrip-core' ),
                'default' => [
                    'url' => '#',
                    'is_external' => true,
                    'nofollow' => true,
                    'custom_attributes' => '',
                ],
                'label_block' => true,
            ]
        );

        //twitter Link
        $repeater->add_control(
            'website_link_twitter',
            [
                'label' => esc_html__( 'Twitter Link', 'astrip-core' ),
                'type' => \Elementor\Controls_Manager::URL,
                'placeholder' => esc_html__( 'https://your-link.com', 'astrip-core' ),
                'default' => [
                    'url' => '#',
                    'is_external' => true,
                    'nofollow' => true,
                    'custom_attributes' => '',
                ],
                'label_block' => true,
            ]
        );
        //pinterest Link
        $repeater->add_control(
            'website_link_pinterest',
            [
                'label' => esc_html__( 'Pinterest Link', 'astrip-core' ),
                'type' => \Elementor\Controls_Manager::URL,
                'placeholder' => esc_html__( 'https://your-link.com', 'astrip-core' ),
                'default' => [
                    'url' => '',
                    'is_external' => true,
                    'nofollow' => true,
                    'custom_attributes' => '',
                ],
                'label_block' => true,
            ]
        );
        //linkedin Link
        $repeater->add_control(
            'website_link_linkedin',
            [
                'label' => esc_html__( 'Linkedin Link', 'astrip-core' ),
                'type' => \Elementor\Controls_Manager::URL,
                'placeholder' => esc_html__( 'https://your-link.com', 'astrip-core' ),
                'default' => [
                    'url' => '',
                    'is_external' => true,
                    'nofollow' => true,
                    'custom_attributes' => '',
                ],
                'label_block' => true,
            ]
        );

        //reddit Link
        $repeater->add_control(
            'website_link_reddit',
                [
                    'label' => esc_html__( 'Reddit Link', 'astrip-core' ),
                    'type' => \Elementor\Controls_Manager::URL,
                    'placeholder' => esc_html__( 'https://your-link.com', 'astrip-core' ),
                    'default' => [
                        'url' => '',
                        'is_external' => true,
                        'nofollow' => true,
                        'custom_attributes' => '',
                    ],
                    'label_block' => true,
                ]
            );
        //behance Link
        $repeater->add_control(
            'website_link_behance',
            [
                'label' => esc_html__( 'Behance Link', 'astrip-core' ),
                'type' => \Elementor\Controls_Manager::URL,
                'placeholder' => esc_html__( 'https://your-link.com', 'astrip-core' ),
                'default' => [
                    'url' => '',
                    'is_external' => true,
                    'nofollow' => true,
                    'custom_attributes' => '',
                ],
                'label_block' => true,
            ]
        );

        //stackoverflow Link
        $repeater->add_control(
            'website_link_stackoverflow',
            [
                'label' => esc_html__( 'Stackoverflow Link', 'astrip-core' ),
                'type' => \Elementor\Controls_Manager::URL,
                'placeholder' => esc_html__( 'https://your-link.com', 'astrip-core' ),
                'default' => [
                    'url' => '',
                    'is_external' => true,
                    'nofollow' => true,
                    'custom_attributes' => '',
                ],
                'label_block' => true,
            ]
        );
        
        
        $repeater->end_popover();

		$this->add_control(
			'team_repeater_list',
			[
				'label' => esc_html__( 'Team List', 'astrip-core' ),
				'type' => \Elementor\Controls_Manager::REPEATER,
				'fields' => $repeater->get_controls(),
				'default' => [
					[
						'astrip_team_content_single_name' => esc_html__( 'Savannah Nguyen', 'astrip-core' ),
					],

				],
				'title_field' => '{{{ astrip_team_content_single_name }}}',
			]
		);
        $this->end_controls_section();

        //Style Section Start
        //Name Style Section Start
        $this->start_controls_section(
            'astrip_team_style_name_section',
            [
                'label' => esc_html__('Name', 'astrip-core'),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control(
            'astrip_team_style_name_color',
            [
                'label'     => esc_html__('Color', 'astrip-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .tour-guide-single .guide-contnent h4' => 'color: {{VALUE}};',
                    '{{WRAPPER}} .tour-guide-single2 .tour-guide-image .tour-guide-content .name' => 'color: {{VALUE}};',

                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label'    => esc_html__('Typography', 'astrip-core'),
                'name'     => 'astrip_team_style_name_typography',
                'selector' => '{{WRAPPER}} .tour-guide-single .guide-contnent h4,.tour-guide-single2 .tour-guide-image .tour-guide-content .name',
            ]
        );
        $this->add_responsive_control(
            'astrip_team_style_name_padding',
            [
                'label'      => __('Padding', 'astrip-core'),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'selectors'  => [
                    '{{WRAPPER}} .tour-guide-single .guide-contnent h4' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    '{{WRAPPER}} .tour-guide-single2 .tour-guide-image .tour-guide-content .name' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',                    
                ],
            ]
        );
        $this->add_responsive_control(
            'astrip_team_style_name_margin',
            [
                'label' => esc_html__( 'Margin', 'astrip-core' ),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%', 'em' ],
                'selectors' => [
                    '{{WRAPPER}} .tour-guide-single .guide-contnent h4' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    '{{WRAPPER}} .tour-guide-single2 .tour-guide-image .tour-guide-content .name' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',                ],
            ]
        );
        $this->end_controls_section();
        //Designation Section Start
        $this->start_controls_section(
            'astrip_team_style_designation_section',
            [
                'label' => esc_html__('Designation', 'astrip-core'),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control(
            'astrip_team_style_designation_color',
            [
                'label'     => esc_html__('Color', 'astrip-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .tour-guide-single .guide-contnent p' => 'color: {{VALUE}};',
                    '{{WRAPPER}} .tour-guide-single2 .tour-guide-image .tour-guide-content .designation' => 'color: {{VALUE}};',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label'    => esc_html__('Typography', 'astrip-core'),
                'name'     => 'astrip_team_style_designation_typography',
                'selector' => '{{WRAPPER}} .tour-guide-single .guide-contnent p,.tour-guide-single2 .tour-guide-image .tour-guide-content .designation',
            ]
        );
        $this->add_responsive_control(
            'astrip_team_style_designation_padding',
            [
                'label'      => __('Padding', 'astrip-core'),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'selectors'  => [
                    '{{WRAPPER}} .tour-guide-single .guide-contnent p' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    '{{WRAPPER}} .tour-guide-single2 .tour-guide-image .tour-guide-content .designation' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',                    
                ],
            ]
        );
        $this->add_responsive_control(
            'astrip_team_style_designation_margin',
            [
                'label' => esc_html__( 'Margin', 'astrip-core' ),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%', 'em' ],
                'selectors' => [
                    '{{WRAPPER}} .tour-guide-single .guide-contnent p' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    '{{WRAPPER}} .tour-guide-single2 .tour-guide-image .tour-guide-content .designation' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',                ],
            ]
        );
        $this->end_controls_section();
        //Social Icon Style
        $this->start_controls_section(
			'style_section',
			[
				'label' => esc_html__( 'Social Icon', 'astrip-core' ),
				'tab' => \Elementor\Controls_Manager::TAB_STYLE,
			]
		);

		$this->start_controls_tabs(
			'style_tabs'
		);

		$this->start_controls_tab(
			'style_normal_tab',
			[
				'label' => esc_html__( 'Normal', 'astrip-core' ),
			]
		);
        $this->add_control(
            'astrip_team_style_social_icon_style_one_color',
            [
                'label'     => esc_html__('Color', 'astrip-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .tour-guide-single .guide-social i' => 'color: {{VALUE}};',
                ],
                'condition' => [
                    'astrip_team_content_style_selection' => 'style_one'
                ],
            ]
        );
        $this->add_control(
            'astrip_team_style_social_icon_style_one_background',
            [
                'label'     => esc_html__('Background Color', 'astrip-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .tour-guide-single .guide-social i' => 'background: {{VALUE}};',
                ],
                'condition' => [
                    'astrip_team_content_style_selection' => 'style_one'
                ],
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Border::get_type(),
            [
                'name' => 'astrip_team_style_social_icon_style_one_border',
                'label' => esc_html__( 'Border', 'astrip-core' ),
                'selector' => '{{ WRAPPER }} .tour-guide-single .guide-social i',
                'condition' => [
                    'astrip_team_content_style_selection' => 'style_one'
                ],
            ]
        );
        $this->add_responsive_control(
            'astrip_team_style_social_icon_style_one_border_radius',
            [
            'astrip_team_style_social_icon_border_radius',
                'label'      		=> __('Border Radius', 'astrip-core'),
                'type'       		=> Controls_Manager::DIMENSIONS,
                'size_units' 		=> ['px', '%'],
                'selectors'  		=> [
                    '{{WRAPPER}} .tour-guide-single .guide-social i' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
                'condition' => [
                    'astrip_team_content_style_selection' => 'style_one'
                ],        
            ]
        );
        $this->add_control(
            'astrip_team_style_social_icon_style_two_color',
            [
                'label'     => esc_html__('Color', 'astrip-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .tour-guide-single2 .tour-guide-image .social-area .social-plus .bx' => 'color: {{VALUE}};',
                    '{{WRAPPER}} .tour-guide-single2 .tour-guide-image .social-area .social-links a .bx' => 'color: {{VALUE}};',
                ],
                'condition' => [
                    'astrip_team_content_style_selection' => 'style_two'
                ],
            ]
        );
        
        $this->add_control(
            'astrip_team_style_social_icon_style_two_background',
            [
                'label'     => esc_html__('Background Color', 'astrip-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .tour-guide-single2 .tour-guide-image .social-area .social-plus' => 'background-color: {{VALUE}};',
                    '{{WRAPPER}} .tour-guide-single2 .tour-guide-image .social-area .social-links a .bx' => 'background-color: {{VALUE}};',
                ],
                'condition' => [
                    'astrip_team_content_style_selection' => 'style_two'
                ],
            ]
        );
        $this->add_responsive_control(
            'astrip_team_style_social_icon_style_two_border_radius',
            [
            'astrip_team_style_social_icon_border_radius',
                'label'      		=> __('Border Radius', 'astrip-core'),
                'type'       		=> Controls_Manager::DIMENSIONS,
                'size_units' 		=> ['px', '%'],
                'selectors'  		=> [
                    '{{WRAPPER}} .tour-guide-single2 .tour-guide-image .social-area .social-plus' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    '{{WRAPPER}} .tour-guide-single2 .tour-guide-image .social-area .social-links a .bx' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',

                ],
                'condition' => [
                    'astrip_team_content_style_selection' => 'style_two'
                ],        
            ]
        );
		$this->end_controls_tab();

		$this->start_controls_tab(
			'style_hover_tab',
			[
				'label' => esc_html__( 'Hover', 'astrip-core' ),
			]
		);
        
        $this->add_control(
            'astrip_team_style_social_icon_style_one_hover_background',
            [
                'label'     => esc_html__('Background Color', 'astrip-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .tour-guide-single .guide-social i:hover' => 'background: {{VALUE}};',
                ],
                'condition' => [
                    'astrip_team_content_style_selection' => 'style_one'
                ],
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Border::get_type(),
            [
                'name' => 'astrip_team_style_social_icon_style_one_hover_border',
                'label' => esc_html__( 'Border', 'astrip-core' ),
                'selector' => '{{ WRAPPER }} .tour-guide-single .guide-social i:hover',
                'condition' => [
                    'astrip_team_content_style_selection' => 'style_one'
                ],
            ]
        );
        $this->add_control(
            'astrip_team_style_social_icon_style_two_hover_color',
            [
                'label'     => esc_html__('Color', 'astrip-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .tour-guide-single2 .tour-guide-image .social-area .social-plus:hover .bx' => 'color: {{VALUE}};',
                    '{{WRAPPER}} .tour-guide-single2 .tour-guide-image .social-area .social-links a .bx:hover' => 'color: {{VALUE}};',
                ],
                'condition' => [
                    'astrip_team_content_style_selection' => 'style_two'
                ],
            ]
        );
        $this->add_control(
            'astrip_team_style_social_icon_style_two_hover_background',
            [
                'label'     => esc_html__('Background Color', 'astrip-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .tour-guide-single2 .tour-guide-image .social-area .social-plus:hover' => 'background-color: {{VALUE}};',
                    '{{WRAPPER}} .tour-guide-single2 .tour-guide-image .social-area .social-links a .bx:hover' => 'background-color: {{VALUE}};',
                ],
                'condition' => [
                    'astrip_team_content_style_selection' => 'style_two'
                ],
            ]
        );
		$this->end_controls_tab();

		$this->end_controls_tabs();

		$this->end_controls_section();
        //card style
        $this->start_controls_section(
            'astrip_team_single_card_style_one_section',
            [
                'label' => esc_html__( 'Card', 'astrip-core' ),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
                'condition' => [
                    'astrip_team_content_style_selection' => 'style_one',
                ],
                
            ]
        );

        $this->add_control(
            'astrip_team_single_card_style_one_background_color',
            [
                'label'     => esc_html__('Background Color', 'astrip-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .tour-guide-single' => 'background: {{VALUE}};',

                ],
            ]
        );
        $this->add_responsive_control(
            'astrip_team_single_card_style_one_border_radius',
            [
            'astrip_team_single_card_border_radius',
                'label'      		=> __('Border Radius', 'astrip-core'),
                'type'       		=> Controls_Manager::DIMENSIONS,
                'size_units' 		=> ['px', '%'],
                'selectors'  		=> [
                    '{{WRAPPER}} .tour-guide-single' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],        
            ]
        );
        $this->add_group_control(
			\Elementor\Group_Control_Box_Shadow::get_type(),
			[
				'name' => 'astrip_team_single_card_style_one_box_shadow',
				'label' => esc_html__( 'Box Shadow', 'astrip-core' ),
				'selector' => '{{WRAPPER}} .tour-guide-single',
			]
		);


        $this->end_controls_section();

        $this->start_controls_section(
            'astrip_team_single_card_style_two_section',
            [
                'label' => esc_html__( 'Card (Content)', 'astrip-core' ),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
                'condition' => [
                    'astrip_team_content_style_selection' => 'style_two',
                ],
                
            ]
        );

        $this->add_control(
            'astrip_team_single_card_style_two_background_color',
            [
                'label'     => esc_html__('Background Color', 'astrip-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .tour-guide-single2 .tour-guide-image .tour-guide-content' => 'background: {{VALUE}};',

                ],
            ]
        );
        $this->add_responsive_control(
            'astrip_team_single_card_style_two_border_radius_section',
            [
            'astrip_team_single_card_border_radius',
                'label'      		=> __('Border Radius', 'astrip-core'),
                'type'       		=> Controls_Manager::DIMENSIONS,
                'size_units' 		=> ['px', '%'],
                'selectors'  		=> [
                    '{{WRAPPER}} .tour-guide-single2 .tour-guide-image .tour-guide-content' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],        
            ]
        );
        $this->end_controls_section();
        
        
        
    }
    protected function render()
    {
        $settings = $this->get_settings_for_display();
        $teams = $settings['team_repeater_list'];
        ?>
            
            <?php if( !empty( $settings['astrip_team_content_style_selection'] ) && ($settings['astrip_team_content_style_selection'] == 'style_one') )  : ?> 
                <div class="tour-guide-section">
                    <div class="row justify-content-center">
                        <?php foreach ($teams as $team): ?>
                            <?php if( $settings['astrip_team_content_style_column_section'] == 'column_two' ) : ?>
                                <div class="col-xl-6 col-lg-6 col-md-6 col-sm-10">
                            <?php elseif ($settings['astrip_team_content_style_column_section'] == 'column_three') : ?>
                                <div class="col-xl-4 col-lg-4 col-md-6 col-sm-10">
                            <?php elseif ($settings['astrip_team_content_style_column_section'] == 'column_four') : ?>
                                <div class="col-xl-3 col-lg-3 col-md-6 col-sm-10">
                            <?php endif ?>
                                <div class="tour-guide-single">
                                    <div class="guide-image">
                                        <?php if( !empty( $team['astrip_team_content_single_image']['url'] ) ) : ?>
                                            <img src="<?php echo esc_url( $team['astrip_team_content_single_image']['url']) ?>" class="img-fluid" alt="<?php esc_attr__('team-single-image','astrip-core') ?>">
                                        <?php endif ?>
                                        <div class="social-area">
                                            <ul class="guide-social">
                                                <?php if( !empty( $team['website_link_facebook']['url'] ) ) : ?>
                                                    <li><a href="<?php echo esc_url( $team['website_link_facebook']['url']) ?>">
                                                    <i class='bx bxl-facebook'></i></a></li>
                                                <?php endif ?>                            
                                                <?php if( !empty( $team['website_link_instagram']['url'] ) ) : ?>
                                                    <li><a href="<?php echo esc_url( $team['website_link_instagram']['url']) ?>">
                                                    <i class='bx bxl-instagram'></i></a></li>
                                                <?php endif ?>
                                                <?php if( !empty( $team['website_link_twitter']['url'] ) ) : ?>
                                                    <li><a href="<?php echo esc_url( $team['website_link_twitter']['url']) ?>">
                                                    <i class='bx bxl-twitter'></i></a></li>
                                                <?php endif ?>
                                                <?php if( !empty( $team['website_link_pinterest']['url'] ) ) : ?>
                                                    <li><a href="<?php echo esc_url( $team['website_link_pinterest']['url']) ?>">
                                                    <i class='bx bxl-pinterest'></i></a></li>
                                                <?php endif ?>
                                                <?php if( !empty( $team['website_link_linkedin']['url'] ) ) : ?>
                                                    <li><a href="<?php echo esc_url( $team['website_link_linkedin']['url']) ?>">
                                                    <i class='bx bxl-linkedin'></i></a></li>
                                                <?php endif ?>
                                                <?php if( !empty( $team['website_link_reddit']['url'] ) ) : ?>
                                                    <li><a href="<?php echo esc_url( $team['website_link_reddit']['url']) ?>">
                                                    <i class='bx bxl-reddit'></i></a></li>
                                                <?php endif ?>
                                                <?php if( !empty( $team['website_link_behance']['url'] ) ) : ?>
                                                    <li><a href="<?php echo esc_url( $team['website_link_behance']['url']) ?>">
                                                    <i class='bx bxl-behance'></i></a></li>
                                                <?php endif ?>
                                                <?php if( !empty( $team['website_link_stackoverflow']['url'] ) ) : ?>
                                                    <li><a href="<?php echo esc_url( $team['website_link_stackoverflow']['url']) ?>">
                                                    <i class='bx bxl-stack-overflow'></i></a></li>
                                                <?php endif ?>
                                            </ul>
                                        </div>
                                    </div>
                                    <div class="guide-contnent">
                                        <?php if( !empty( $team['astrip_team_content_single_name'] ) ) : ?>
                                            <h4><?php echo esc_html($team['astrip_team_content_single_name']) ?></h4>
                                        <?php endif ?>
                                        <?php if( !empty( $team['astrip_team_content_single_designation'] ) ) : ?>
                                            <p><?php echo esc_html($team['astrip_team_content_single_designation']) ?></p>
                                        <?php endif ?>
                                    </div> 
                                </div>
                            </div>
                        <?php endforeach ?>
                    </div>
                </div>
            <?php endif ?>
            <?php if( !empty( $settings['astrip_team_content_style_selection'] ) && ($settings['astrip_team_content_style_selection'] == 'style_two') )  : ?> 
                <div class="tour-guide-section">
                    <div class="row g-4 justify-content-center">
                        <?php foreach ($teams as $team): ?>
                            <?php if( $settings['astrip_team_content_style_column_section'] == 'column_two' ) : ?>
                                <div class="col-xl-6 col-lg-6 col-md-6 col-sm-10">
                            <?php elseif ($settings['astrip_team_content_style_column_section'] == 'column_three') : ?>
                                <div class="col-xl-4 col-lg-4 col-md-6 col-sm-10">
                            <?php elseif ($settings['astrip_team_content_style_column_section'] == 'column_four') : ?>
                                <div class="col-xl-3 col-lg-3 col-md-6 col-sm-10">
                            <?php endif ?>
                                <div class="tour-guide-single2">
                                    <div class="tour-guide-image">
                                        <?php if( !empty( $team['astrip_team_content_single_image']['url'] ) ) : ?>
                                            <img src="<?php echo esc_url( $team['astrip_team_content_single_image']['url']) ?>" class="img-fluid" alt="<?php esc_attr__('team-single-image','astrip-core') ?>">
                                        <?php endif ?>
                                        <div class="social-area gap-3">
                                            <div class="social-plus"><i class='bx bx-plus'></i></div>
                                            <ul class="social-links d-flex justify-content-center align-items-center flex-column gap-3">
                                                <?php if( !empty( $team['website_link_facebook']['url'] ) ) : ?>
                                                    <li><a href="<?php echo esc_url( $team['website_link_facebook']['url']) ?>">
                                                    <i class='bx bxl-facebook'></i></a></li>
                                                <?php endif ?>                            
                                                <?php if( !empty( $team['website_link_instagram']['url'] ) ) : ?>
                                                    <li><a href="<?php echo esc_url( $team['website_link_instagram']['url']) ?>">
                                                    <i class='bx bxl-instagram'></i></a></li>
                                                <?php endif ?>
                                                <?php if( !empty( $team['website_link_twitter']['url'] ) ) : ?>
                                                    <li><a href="<?php echo esc_url( $team['website_link_twitter']['url']) ?>">
                                                    <i class='bx bxl-twitter'></i></a></li>
                                                <?php endif ?>
                                                <?php if( !empty( $team['website_link_pinterest']['url'] ) ) : ?>
                                                    <li><a href="<?php echo esc_url( $team['website_link_pinterest']['url']) ?>">
                                                    <i class='bx bxl-pinterest'></i></a></li>
                                                <?php endif ?>
                                                <?php if( !empty( $team['website_link_linkedin']['url'] ) ) : ?>
                                                    <li><a href="<?php echo esc_url( $team['website_link_linkedin']['url']) ?>">
                                                    <i class='bx bxl-linkedin'></i></a></li>
                                                <?php endif ?>
                                                <?php if( !empty( $team['website_link_reddit']['url'] ) ) : ?>
                                                    <li><a href="<?php echo esc_url( $team['website_link_reddit']['url']) ?>">
                                                    <i class='bx bxl-reddit'></i></a></li>
                                                <?php endif ?>
                                                <?php if( !empty( $team['website_link_behance']['url'] ) ) : ?>
                                                    <li><a href="<?php echo esc_url( $team['website_link_behance']['url']) ?>">
                                                    <i class='bx bxl-behance'></i></a></li>
                                                <?php endif ?>
                                                <?php if( !empty( $team['website_link_stackoverflow']['url'] ) ) : ?>
                                                    <li><a href="<?php echo esc_url( $team['website_link_stackoverflow']['url']) ?>">
                                                    <i class='bx bxl-stack-overflow'></i></a></li>
                                                <?php endif ?>
                                            </ul>
                                        </div>
                                        <div class="tour-guide-content">
                                            <?php if( !empty( $team['astrip_team_content_single_name'] ) ) : ?>
                                                <h4 class="name"><?php echo esc_html($team['astrip_team_content_single_name']) ?></h4>
                                            <?php endif ?>
                                            <?php if( !empty( $team['astrip_team_content_single_designation'] ) ) : ?>
                                                <p class="designation"><?php echo esc_html($team['astrip_team_content_single_designation']) ?></p>
                                            <?php endif ?>
                                        </div>
                                    </div>
                                    
                                </div>
                            </div>
                        <?php endforeach ?>
                    </div>
                </div>
            <?php endif ?>

        <?php 
        
    }
}

Plugin::instance()->widgets_manager->register(new Astrip_Team_Widget());
