<?php

namespace Elementor;

if (!defined('ABSPATH')) {
    exit;
} //Exit if accessed directly

use Elementor\Core\Schemes;

class astrip_slider_Widget extends Widget_Base
{

    public function get_name()
    {
        return 'egens_slider';
    }

    public function get_title()
    {
        return esc_html__('EG Slider', 'astrip-core');
    }

    public function get_icon()
    {
        return 'eicon-banner';
    }

    public function get_categories()
    {
        return ['astrip_widgets'];
    }

    protected function register_controls()
    {

        //-------------Content-------------------//
        //Heading Section

        $this->start_controls_section(
            'astrip_banner_content_general_section',
            [
                'label' => esc_html__('General', 'astrip-core')

            ]
        );

        $this->add_control(
            'astrip_banner_style',
            [
                'label' => esc_html__('Banner Design', 'astrip-core'),
                'type' => \Elementor\Controls_Manager::SELECT,
                'default' => 'style_one',
                'options' => [
                    'style_one'  => esc_html__('Style 1', 'astrip-core'),
                    'style_two' => esc_html__('Style 2', 'astrip-core'),
                    'style_three' => esc_html__('Style 3', 'astrip-core'),
                    'style_four' => esc_html__('Style 4', 'astrip-core'),
                    'style_five' => esc_html__('Style 5', 'astrip-core'),

                ],
            ]
        );

        $this->add_control(
            'astrip_tour_search_shortcode_one',
            [
                'label' => esc_html__('Tour Search Shortcode', 'astrip-core'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => '[tour_search style="style_one"]',
                'label_block' => true,
                'condition' => [
                    'astrip_banner_style' => ['style_one', 'style_five'],
                ],
            ]
        );
        $this->add_control(
            'astrip_tour_search_shortcode_two',
            [
                'label' => esc_html__('Tour Search Shortcode', 'astrip-core'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => '[tour_search style="style_two"]',
                'label_block' => true,
                'condition' => [
                    'astrip_banner_style' => 'style_two',
                ],
            ]
        );
        $this->add_control(
            'astrip_tour_search_shortcode_three',
            [
                'label' => esc_html__('Tour Search Shortcode', 'astrip-core'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => '[tour_search style="style_three"]',
                'label_block' => true,
                'condition' => [
                    'astrip_banner_style' => 'style_three',
                ],
            ]
        );
        $this->add_control(
            'astrip_tour_search_shortcode_four',
            [
                'label' => esc_html__('Tour Search Shortcode', 'astrip-core'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => '[tour_search style="style_one" class="siblings-2"]',
                'label_block' => true,
                'condition' => [
                    'astrip_banner_style' => 'style_four',
                ],
            ]
        );

        $this->end_controls_section();




        //Start banner image design Five
        $this->start_controls_section(
            'astrip_banner_five_slider',
            [
                'label' => esc_html__('Slider', 'astrip-core'),
                'condition' => [
                    'astrip_banner_style' => 'style_five',
                ],

            ]
        );
        $repeater = new \Elementor\Repeater();
        $repeater->add_control(
            'astrip_banner_five_slider_image',
            [
                'label' => esc_html__('Choose Image', 'astrip-core'),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'default' => [
                    'url' => \Elementor\Utils::get_placeholder_image_src(),
                ],
            ]
        );

        $repeater->add_control(
            'astrip_banner_five_slider_content',
            [
                'label' => esc_html__('Slider Content', 'astrip-core'),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );
        $repeater->add_control(
            'astrip_banner_five_sub_title',
            [
                'label' => esc_html__('Sub Title', 'astrip-core'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => esc_html__("Let's Feel a Yacht Trip", 'astrip-core'),
                'label_block' => true,
            ]
        );
        $repeater->add_control(
            'astrip_banner_five_main_title',
            [
                'label' => esc_html__('Main Title', 'astrip-core'),
                'type' => \Elementor\Controls_Manager::TEXTAREA,
                'rows' => 3,
                'default' => esc_html__('Enchanting Journeys.', 'astrip-core'),
                'label_block' => true,
            ]
        );
        $repeater->add_control(
            'astrip_banner_five_description',
            [
                'label' => esc_html__('Description', 'astrip-core'),
                'type' => \Elementor\Controls_Manager::TEXTAREA,
                'rows' => 3,
                'default' => esc_html__('Look for tour agencies with a good reputation and positive reviews.', 'astrip-core'),
                'placeholder' => esc_html__('Type your description here', 'astrip-core'),
            ]
        );
        $repeater->add_control(
            'astrip_banner_five_slider_btn',
            [
                'label' => esc_html__('Button', 'astrip-core'),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );
        $repeater->add_control(
            'astrip_banner_five_btn_label_icon',
            [
                'label' => esc_html__('Icon', 'textdomain'),
                'type' => \Elementor\Controls_Manager::ICONS,
                'default' => [
                    'value' => 'fab fa-telegram-plane',
                    'library' => 'fa-solid',
                ],
            ]
        );
        $repeater->add_control(
            'astrip_banner_five_btn_label',
            [
                'label' => esc_html__('Button label', 'astrip-core'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'rows' => 3,
                'default' => esc_html__('Discover More', 'astrip-core'),
                'label_block' => true,
            ]
        );
        $repeater->add_control(
            'astrip_banner_five_slider_btn_link',
            [
                'label' => esc_html__('Button Link', 'astrip-core'),
                'type' => \Elementor\Controls_Manager::URL,
                'options' => ['url', 'is_external', 'nofollow'],
                'default' => [
                    'url' => '#',
                    'is_external' => true,
                    'nofollow' => true,
                    // 'custom_attributes' => '',
                ],
                'label_block' => true,
            ]
        );
        $repeater->add_control(
            'astrip_banner_five_slider_rating',
            [
                'label' => esc_html__('Rating Info', 'astrip-core'),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );
        $repeater->add_control(
            'astrip_banner_five_slider_rating_btn_link',
            [
                'label' => esc_html__('Rating Button Link', 'astrip-core'),
                'type' => \Elementor\Controls_Manager::URL,
                'options' => ['url', 'is_external', 'nofollow'],
                'default' => [
                    'url' => '#',
                    'is_external' => true,
                    'nofollow' => true,
                    // 'custom_attributes' => '',
                ],
                'label_block' => true,
            ]
        );
        $repeater->add_control(
            'astrip_banner_five_slider_rating_icon',
            [
                'label' => esc_html__('Icon', 'textdomain'),
                'type' => \Elementor\Controls_Manager::ICONS,
                'default' => [
                    'value' => 'fab fa-tripadvisor',
                    'library' => 'fa-solid',
                ],
            ]
        );
        $repeater->add_control(
            'astrip_banner_five_slider_rating_logo',
            [
                'label' => esc_html__('Rating Brand', 'astrip-core'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => esc_html__("Tripadvisor", 'astrip-core'),
                'label_block' => true,
            ]
        );
        $repeater->add_control(
            'astrip_banner_five_slider_rating_point',
            [
                'label' => esc_html__('Point Out off 5', 'astrip-core'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => esc_html__("4.5", 'astrip-core'),
                'label_block' => true,
            ]
        );
        $repeater->add_control(
            'astrip_banner_five_slider_rating_title',
            [
                'label' => esc_html__('Rating title', 'astrip-core'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'rows' => 3,
                'default' => esc_html__('trust Rating', 'astrip-core'),
                'label_block' => true,
            ]
        );
        $this->add_control(
            'astrip_banner_five_slider_image_list',
            [
                'label' => esc_html__('Slider List', 'textdomain'),
                'type' => \Elementor\Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
                'default' => [
                    [
                        'astrip_banner_five_slider_image' => esc_html__('Slider Image', 'textdomain'),
                    ],
                ],
                'title_field' => esc_html__('Slider Image', 'astrip-core'),
            ]
        );

        $this->add_responsive_control(
            'astrip_banner_five_slider_paginate',
            [
                'label' => esc_html__('Slider Arrow', 'textdomain'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => esc_html__('Show', 'textdomain'),
                'label_off' => esc_html__('Hide', 'textdomain'),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );
        $this->end_controls_section();
        //End banner image design Five


        //banner image design one

        $this->start_controls_section(
            'astrip_banner_one_content_banner_image_section',
            [
                'label' => esc_html__('Banner Image', 'astrip-core'),
                'condition' => [
                    'astrip_banner_style' => 'style_one',
                ],

            ]
        );

        $this->add_control(
            'astrip_banner_content_banner_image_one',
            [
                'label' => esc_html__('Image One', 'astrip-core'),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'default' => [
                    'url' => \Elementor\Utils::get_placeholder_image_src(),
                ],
            ]
        );
        $this->add_control(
            'astrip_banner_content_banner_image_two',
            [
                'label' => esc_html__('Image Two', 'astrip-core'),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'default' => [
                    'url' => \Elementor\Utils::get_placeholder_image_src(),
                ],
            ]
        );

        $this->add_control(
            'astrip_banner_content_banner_inner_image_two',
            [
                'label' => esc_html__('Image Inner Two', 'astrip-core'),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'default' => [
                    'url' => \Elementor\Utils::get_placeholder_image_src(),
                ],
            ]
        );

        $this->end_controls_section();

        //banner image design one

        $this->start_controls_section(
            'astrip_banner_three_content_banner_image_section',
            [
                'label' => esc_html__('Banner Image', 'astrip-core'),
                'condition' => [
                    'astrip_banner_style' => 'style_three',
                ],

            ]
        );

        $this->add_control(
            'astrip_banner_three_content_banner_image',
            [
                'label' => esc_html__('Image', 'astrip-core'),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'default' => [
                    'url' => \Elementor\Utils::get_placeholder_image_src(),
                ],
            ]
        );

        $this->end_controls_section();


        //heading secton
        $this->start_controls_section(
            'astrip_banner_content_heading_section',
            [
                'label' => esc_html__('Heading', 'astrip-core'),
                'condition' => [
                    'astrip_banner_style' => ['style_one', 'style_three'],
                ],

            ]
        );


        $this->add_control(
            'astrip_banner_sub_title',
            [
                'label' => esc_html__('Sub Title', 'astrip-core'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => esc_html__('Lets Feel a Yacht Trip', 'astrip-core'),
                'label_block' => true,
            ]
        );
        $this->add_control(
            'astrip_banner_main_title',
            [
                'label' => esc_html__('Main Title', 'astrip-core'),
                'type' => \Elementor\Controls_Manager::TEXTAREA,
                'rows' => 3,
                'default' => esc_html__('The Best Way to Plan Your Trip Around The World.', 'astrip-core'),
                'label_block' => true,
            ]
        );

        $this->add_control(
            'astrip_banner_description',
            [
                'label' => esc_html__('Description', 'astrip-core'),
                'type' => \Elementor\Controls_Manager::TEXTAREA,
                'rows' => 3,
                'default' => esc_html__('Treat yourself with a journey to your inner self.', 'astrip-core'),
                'placeholder' => esc_html__('Type your description here', 'astrip-core'),
            ]
        );

        $this->end_controls_section();
        //heading secton
        $this->start_controls_section(
            'astrip_banner_two_content_heading_section',
            [
                'label' => esc_html__('Slider List', 'astrip-core'),
                'condition' => [
                    'astrip_banner_style' => ['style_two', 'style_four'],
                ],

            ]
        );

        $repeater = new \Elementor\Repeater();

        $repeater->add_control(
            'astrip_banner_two_sub_title',
            [
                'label' => esc_html__('Sub Title', 'astrip-core'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => esc_html__('Hot Place', 'astrip-core'),
                'label_block' => true,
            ]
        );
        $repeater->add_control(
            'astrip_banner_two_main_title',
            [
                'label' => esc_html__('Main Title', 'astrip-core'),
                'type' => \Elementor\Controls_Manager::TEXTAREA,
                'rows' => 3,
                'default' => esc_html__('Best  & Amazing Traveling in The CITY.', 'astrip-core'),
                'label_block' => true,
            ]
        );

        $repeater->add_control(
            'astrip_banner_two_description',
            [
                'label' => esc_html__('Description', 'astrip-core'),
                'type' => \Elementor\Controls_Manager::TEXTAREA,
                'rows' => 3,
                'default' => esc_html__('Treat yourself with a journey to your inner self.', 'astrip-core'),
                'placeholder' => esc_html__('Type your description here', 'astrip-core'),
            ]
        );

        $repeater->add_control(
            'astrip_banner_two_content_banner_image',
            [
                'label' => esc_html__('Banner Image', 'astrip-core'),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'default' => [
                    'url' => \Elementor\Utils::get_placeholder_image_src(),
                ],
            ]
        );

        $repeater->add_control(
            'astrip_banner_two_button_text',
            [
                'label' => esc_html__('Button Text', 'astrip-core'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => esc_html__("Discover More", 'astrip-core'),
                'label_block' => true,
            ]
        );

        $repeater->add_control(
            'astrip_banner_two_button_website_link',
            [
                'label' => esc_html__('Link', 'astrip-core'),
                'type' => \Elementor\Controls_Manager::URL,
                'placeholder' => esc_html__('https://your-link.com', 'astrip-core'),
                'options' => ['url', 'is_external', 'nofollow'],
                'default' => [
                    'url' => '',
                    'is_external' => true,
                    'nofollow' => true,
                    // 'custom_attributes' => '',
                ],
                'label_block' => true,
            ]
        );

        $this->add_control(
            'astrip_banner_two_list',
            [
                'label' => esc_html__('Slider List', 'astrip-core'),
                'type' => \Elementor\Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
                'default' => [
                    [
                        'astrip_banner_two_sub_title' => esc_html__('Hot Place', 'astrip-core'),
                        'list_content' => esc_html__('Item content. Click the edit button to change this text.', 'astrip-core'),
                    ],
                    [
                        'astrip_banner_two_sub_title' => esc_html__('Hot Place', 'astrip-core'),
                        'list_content' => esc_html__('Item content. Click the edit button to change this text.', 'astrip-core'),
                    ],
                ],
                'title_field' => '{{{ astrip_banner_two_sub_title }}}',
            ]
        );

        $this->end_controls_section();


        //banner icon show/hide

        $this->start_controls_section(
            'astrip_banner_content_icon_section',
            [
                'label' => esc_html__('Banner Icon', 'astrip-core'),
                'condition' => [
                    'astrip_banner_style' => 'style_one',
                ],

            ]
        );

        $this->add_control(
            'astrip_banner_content_cloud_icon_one',
            [
                'label' => esc_html__('Cloud Icon 1', 'astrip-core'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => esc_html__('Show', 'astrip-core'),
                'label_off' => esc_html__('Hide', 'astrip-core'),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );
        $this->add_control(
            'astrip_banner_content_cloud_icon_two',
            [
                'label' => esc_html__('Cloud Icon 2', 'astrip-core'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => esc_html__('Show', 'astrip-core'),
                'label_off' => esc_html__('Hide', 'astrip-core'),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );
        $this->add_control(
            'astrip_banner_content_plane_icon',
            [
                'label' => esc_html__('Plane Icon', 'astrip-core'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => esc_html__('Show', 'astrip-core'),
                'label_off' => esc_html__('Hide', 'astrip-core'),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );

        $this->add_control(
            'astrip_banner_content_sub_title_icon',
            [
                'label' => esc_html__('Sub Title Icon', 'astrip-core'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => esc_html__('Show', 'astrip-core'),
                'label_off' => esc_html__('Hide', 'astrip-core'),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );
        $this->add_control(
            'astrip_banner_content_main_title_icon',
            [
                'label' => esc_html__('Main Title Icon', 'astrip-core'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => esc_html__('Show', 'astrip-core'),
                'label_off' => esc_html__('Hide', 'astrip-core'),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );

        $this->add_control(
            'astrip_banner_content_discover_button_icon',
            [
                'label' => esc_html__('Discover Button Icon', 'astrip-core'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => esc_html__('Show', 'astrip-core'),
                'label_off' => esc_html__('Hide', 'astrip-core'),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );

        $this->end_controls_section();

        //banner icon show/hide

        $this->start_controls_section(
            'astrip_banner_two_content_pagi_icon_section',
            [
                'label' => esc_html__('Pagination (prev/next)', 'astrip-core'),
                'condition' => [
                    'astrip_banner_style' => 'style_two',
                ],

            ]
        );

        $this->add_control(
            'astrip_banner_content_pagi_icon',
            [
                'label' => esc_html__('Pagination (prev/next)', 'astrip-core'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => esc_html__('Show', 'astrip-core'),
                'label_off' => esc_html__('Hide', 'astrip-core'),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );

        $this->end_controls_section();
        //search form
        $this->start_controls_section(
            'astrip_banner_content_form_section',
            [
                'label' => esc_html__('Search Form', 'astrip-core'),
                'condition' => [
                    'astrip_banner_style' => ['style_two', 'style_three'],
                ],

            ]
        );


        $this->add_control(
            'astrip_banner_two_short_code',
            [
                'label' => esc_html__('Short Code', 'astrip-core'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => esc_html__('[mc4wp_form id="43"]', 'astrip-core'),
                'label_block' => true,
            ]
        );

        $this->end_controls_section();


        //social icon
        $this->start_controls_section(
            'astrip_banner_content_social_icon_section',
            [
                'label' => esc_html__('Social Icon Link', 'astrip-core'),
                'condition' => [
                    'astrip_banner_style' => ['style_one', 'style_four'],
                ],

            ]
        );

        //facebook Link
        $this->add_control(
            'astrip_banner_social_link_facebook',
            [
                'label' => esc_html__('Facebook Link', 'astrip-core'),
                'type' => \Elementor\Controls_Manager::URL,
                'placeholder' => esc_html__('https://your-link.com', 'astrip-core'),
                'default' => [
                    'url' => '#',
                    'is_external' => true,
                    'nofollow' => true,
                    'custom_attributes' => '',
                ],
                'label_block' => true,
            ]
        );

        //twitter Link
        $this->add_control(
            'astrip_banner_social_link_twitter',
            [
                'label' => esc_html__('Twitter Link', 'astrip-core'),
                'type' => \Elementor\Controls_Manager::URL,
                'placeholder' => esc_html__('https://your-link.com', 'astrip-core'),
                'default' => [
                    'url' => '#',
                    'is_external' => true,
                    'nofollow' => true,
                    'custom_attributes' => '',
                ],
                'label_block' => true,
            ]
        );

        //instagram Link
        $this->add_control(
            'astrip_banner_social_link_instagram',
            [
                'label' => esc_html__('Instagram Link', 'astrip-core'),
                'type' => \Elementor\Controls_Manager::URL,
                'placeholder' => esc_html__('https://your-link.com', 'astrip-core'),
                'default' => [
                    'url' => '#',
                    'is_external' => true,
                    'nofollow' => true,
                    'custom_attributes' => '',
                ],
                'label_block' => true,
            ]
        );



        //pinterest Link
        $this->add_control(
            'astrip_banner_social_link_pinterest',
            [
                'label' => esc_html__('Pinterest Link', 'astrip-core'),
                'type' => \Elementor\Controls_Manager::URL,
                'placeholder' => esc_html__('https://your-link.com', 'astrip-core'),
                'default' => [
                    'url' => '#',
                    'is_external' => true,
                    'nofollow' => true,
                    'custom_attributes' => '',
                ],
                'label_block' => true,
            ]
        );

        //linkedin Link
        $this->add_control(
            'astrip_banner_social_link_linkedin',
            [
                'label' => esc_html__('Linkedin Link', 'astrip-core'),
                'type' => \Elementor\Controls_Manager::URL,
                'placeholder' => esc_html__('https://your-link.com', 'astrip-core'),
                'default' => [
                    'url' => '',
                    'is_external' => true,
                    'nofollow' => true,
                    'custom_attributes' => '',
                ],
                'label_block' => true,
            ]
        );

        //Youtube Link
        $this->add_control(
            'astrip_banner_social_link_youtube',
            [
                'label' => esc_html__('Youtube Link', 'astrip-core'),
                'type' => \Elementor\Controls_Manager::URL,
                'placeholder' => esc_html__('https://your-link.com', 'astrip-core'),
                'default' => [
                    'url' => '',
                    'is_external' => true,
                    'nofollow' => true,
                    'custom_attributes' => '',
                ],
                'label_block' => true,
            ]
        );
        //Youtube Link
        $this->add_control(
            'astrip_banner_social_link_google_plus',
            [
                'label' => esc_html__('Google Plus Link', 'astrip-core'),
                'type' => \Elementor\Controls_Manager::URL,
                'placeholder' => esc_html__('https://your-link.com', 'astrip-core'),
                'default' => [
                    'url' => '',
                    'is_external' => true,
                    'nofollow' => true,
                    'custom_attributes' => '',
                ],
                'label_block' => true,
            ]
        );



        //reddit Link
        $this->add_control(
            'astrip_banner_social_link_reddit',
            [
                'label' => esc_html__('Reddit Link', 'astrip-core'),
                'type' => \Elementor\Controls_Manager::URL,
                'placeholder' => esc_html__('https://your-link.com', 'astrip-core'),
                'default' => [
                    'url' => '',
                    'is_external' => true,
                    'nofollow' => true,
                    'custom_attributes' => '',
                ],
                'label_block' => true,
            ]
        );


        $this->end_controls_section();



        //button contents

        $this->start_controls_section(
            'astrip_banner_content_button_section',
            [
                'label' => esc_html__('Button', 'astrip-core'),
                'condition' => [
                    'astrip_banner_style' => ['style_one', 'style_three'],
                ],


            ]
        );

        $this->add_control(
            'astrip_banner_button_text',
            [
                'label' => esc_html__('Button Text', 'astrip-core'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => esc_html__("Discover More", 'astrip-core'),
                'label_block' => true,
            ]
        );

        $this->add_control(
            'astrip_banner_button_website_link',
            [
                'label' => esc_html__('Link', 'astrip-core'),
                'type' => \Elementor\Controls_Manager::URL,
                'placeholder' => esc_html__('https://your-link.com', 'astrip-core'),
                'options' => ['url', 'is_external', 'nofollow'],
                'default' => [
                    'url' => '',
                    'is_external' => true,
                    'nofollow' => true,
                    // 'custom_attributes' => '',
                ],
                'label_block' => true,
            ]
        );

        $this->end_controls_section();


        //---------------Style----------------------//


        //banner sub Title Style
        $this->start_controls_section(
            'astrip_banner_sub_title_style_section',
            [
                'label' => esc_html__('Sub Title', 'astrip-core'),
                'tab'   => Controls_Manager::TAB_STYLE,


            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label'    => esc_html__('Typography', 'astrip-core'),
                'name'     => 'astrip_banner_sub_title_style_typography',
                'selector' =>
                '{{WRAPPER}} .banner-section1 .banner1-content span,
                     .banner2-content span,
                     .banner3-content span,
                     .banner4-content span,
                     .hero-wrapper .hero-content span',


            ]
        );

        $this->add_control(
            'astrip_banner_sub_title_style_color',
            [
                'label'     => esc_html__('Color', 'astrip-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .banner-section1 .banner1-content span' => 'color: {{VALUE}};',
                    '{{WRAPPER}} .banner2-content span' => 'color: {{VALUE}};',
                    '{{WRAPPER}} .banner3-content span' => 'color: {{VALUE}};',
                    '{{WRAPPER}} .banner4-content span' => 'color: {{VALUE}};',
                    '{{WRAPPER}} .hero-wrapper .hero-content span' => 'color: {{VALUE}};',

                ],
            ]
        );


        $this->add_responsive_control(
            'astrip_banner_sub_title_style_margin',
            [
                'label' => esc_html__('Margin', 'astrip-core'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors' => [
                    '{{WRAPPER}} .banner-section1 .banner1-content span' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    '{{WRAPPER}} .banner2-content span' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    '{{WRAPPER}} .banner3-content span' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    '{{WRAPPER}} .banner4-content span' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    '{{WRAPPER}} .hero-wrapper .hero-content span' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->end_controls_section();

        //banner main Title Style
        $this->start_controls_section(
            'astrip_banner_main_title_style_section',
            [
                'label' => esc_html__('Main Title', 'astrip-core'),
                'tab'   => Controls_Manager::TAB_STYLE,


            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label'    => esc_html__('Typography', 'astrip-core'),
                'name'     => 'astrip_banner_main_title_style_typography',
                'selector' =>
                '{{WRAPPER}} .banner-section1 .banner1-content h1,
                    .banner2-content h2,
                    .banner3-content h2,
                    .banner4-content h2,
                    .hero-wrapper .hero-content h1',

            ]
        );

        $this->add_control(
            'astrip_banner_main_title_style_color',
            [
                'label'     => esc_html__('Color', 'astrip-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .banner-section1 .banner1-content h1' => 'color: {{VALUE}};',
                    '{{WRAPPER}} .banner2-content h2' => 'color: {{VALUE}};',
                    '{{WRAPPER}} .banner3-content h2' => 'color: {{VALUE}};',
                    '{{WRAPPER}} .banner4-content h2' => 'color: {{VALUE}};',
                    '{{WRAPPER}} .hero-wrapper .hero-content h1' => 'color: {{VALUE}};',

                ],
            ]
        );


        $this->add_responsive_control(
            'astrip_banner_main_title_style_margin',
            [
                'label' => esc_html__('Margin', 'astrip-core'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors' => [
                    '{{WRAPPER}} .banner-section1 .banner1-content h1' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    '{{WRAPPER}} .banner2-content h2' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    '{{WRAPPER}} .banner3-content h2' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    '{{WRAPPER}} .banner4-content h2' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    '{{WRAPPER}} .hero-wrapper .hero-content h1' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->end_controls_section();

        //banner description Style
        $this->start_controls_section(
            'astrip_banner_description_style_section',
            [
                'label' => esc_html__('Description', 'astrip-core'),
                'tab'   => Controls_Manager::TAB_STYLE,


            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label'    => esc_html__('Typography', 'astrip-core'),
                'name'     => 'astrip_banner_description_style_typography',
                'selector' =>
                '{{WRAPPER}} .banner-section1 .banner1-content p,
                    .banner2-content p,
                    .banner3-content p,
                    .banner4-content p,
                    .hero-wrapper .hero-content >p',

            ]
        );

        $this->add_control(
            'astrip_banner_description_style_color',
            [
                'label'     => esc_html__('Color', 'astrip-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .banner-section1 .banner1-content p' => 'color: {{VALUE}};',
                    '{{WRAPPER}} .banner2-content p' => 'color: {{VALUE}};',
                    '{{WRAPPER}} .banner3-content p' => 'color: {{VALUE}};',
                    '{{WRAPPER}} .banner4-content p' => 'color: {{VALUE}};',
                    '{{WRAPPER}} .hero-wrapper .hero-content >p' => 'color: {{VALUE}};',

                ],
            ]
        );


        $this->add_responsive_control(
            'astrip_banner_description_style_margin',
            [
                'label' => esc_html__('Margin', 'astrip-core'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors' => [
                    '{{WRAPPER}} .banner-section1 .banner1-content p' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    '{{WRAPPER}} .banner2-content p' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    '{{WRAPPER}} .banner3-content p' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    '{{WRAPPER}} .banner4-content p' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    '{{WRAPPER}} .hero-wrapper .hero-content >p' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->end_controls_section();

        //banner form Title Style
        $this->start_controls_section(
            'astrip_banner_form_title_style_section',
            [
                'label' => esc_html__('Form Title', 'astrip-core'),
                'tab'   => Controls_Manager::TAB_STYLE,
                'condition' => [
                    'astrip_banner_style' => ['style_two', 'style_three'],
                ],

            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label'    => esc_html__('Typography', 'astrip-core'),
                'name'     => 'astrip_banner_form_title_style_typography',
                'selector' =>
                '{{WRAPPER}} .banner-form-box h3,.banner-form-box.sibling-2 h3',



            ]
        );

        $this->add_control(
            'astrip_banner_form_title_style_color',
            [
                'label'     => esc_html__('Color', 'astrip-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .banner-form-box h3' => 'color: {{VALUE}};',
                    '{{WRAPPER}} .banner-form-box.sibling-2 h3' => 'color: {{VALUE}};',

                ],
            ]
        );


        $this->add_responsive_control(
            'astrip_banner_form_title_style_margin',
            [
                'label' => esc_html__('Margin', 'astrip-core'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors' => [
                    '{{WRAPPER}} .banner-form-box h3' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    '{{WRAPPER}} .banner-form-box.sibling-2 h3' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->end_controls_section();

        //social icon Style
        $this->start_controls_section(
            'astrip_banner_social_icon_style_section',
            [
                'label' => esc_html__('Social Icon', 'astrip-core'),
                'tab'   => Controls_Manager::TAB_STYLE,
                'condition' => [
                    'astrip_banner_style' => ['style_one', 'style_four'],
                ],


            ]
        );


        $this->add_control(
            'astrip_banner_social_icon_style_color_normal',
            [
                'label'     => esc_html__('Normal Color', 'astrip-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .banner-section1 .banner-social-list li i' => 'color: {{VALUE}};',
                    '{{WRAPPER}} .banner-section5 .banner-social-area2 ul.banner-social li a i' => 'color: {{VALUE}};',

                ],
            ]
        );
        $this->add_control(
            'astrip_banner_social_icon_style_color_hover',
            [
                'label'     => esc_html__('Hover Color', 'astrip-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .banner-section1 .banner-social-list li i:hover' => 'color: {{VALUE}};',
                    '{{WRAPPER}} .banner-section5 .banner-social-area2 ul.banner-social li a i:hover' => 'color: {{VALUE}};',

                ],
            ]
        );
        $this->add_control(
            'astrip_banner_social_icon_style_bg_color_normal',
            [
                'label'     => esc_html__('Background Normal Color', 'astrip-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .banner-section1 .banner-social-list li' => 'background-color: {{VALUE}};',
                    '{{WRAPPER}} .banner-section5 .banner-social-area2 ul.banner-social li a i' => 'background-color: {{VALUE}};',

                ],
            ]
        );
        $this->add_control(
            'astrip_banner_social_icon_style_bg_color_hover',
            [
                'label'     => esc_html__('Background Hover Color', 'astrip-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .banner-section1 .banner-social-list li:hover' => 'background-color: {{VALUE}};',
                    '{{WRAPPER}} .banner-section5 .banner-social-area2 ul.banner-social li a i:hover' => 'background-color: {{VALUE}};',

                ],
            ]
        );

        $this->add_control(
            'astrip_banner_social_icon_style_border',
            [
                'label' => esc_html__('Border Color', 'astrip-core'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .banner-section1 .banner-social-list li' => 'border:1px solid {{VALUE}}',
                    '{{WRAPPER}} .banner-section5 .banner-social-area2 ul.banner-social li a i' => 'border:1px solid {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'astrip_banner_social_icon_style_border_hover',
            [
                'label' => esc_html__('Border Hover Color', 'astrip-core'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .banner-section1 .banner-social-list li:hover' => 'border:1px solid {{VALUE}}',
                    '{{WRAPPER}} .banner-section5 .banner-social-area2 ul.banner-social li a i:hover' => 'border:1px solid {{VALUE}}',
                ],
            ]
        );

        $this->end_controls_section();

        //Button Style
        $this->start_controls_section(
            'astrip_banner_button_style_section',
            [
                'label' => esc_html__('Button', 'astrip-core'),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->start_controls_tabs(
            'style_tabs'
        );

        $this->start_controls_tab(
            'style_normal_tab',
            [
                'label' => esc_html__('Normal', 'astrip-core'),
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label'    => esc_html__('Typography', 'astrip-core'),
                'name'     => 'astrip_banner_button_style_typography',
                'selector' => '{{WRAPPER}} 
                .btn--lg,
                .hero-wrapper .hero-content .btn-group .dsc-btn a',

            ]
        );
        $this->add_control(
            'astrip_banner_button_style_text_color',
            [
                'label'     => esc_html__('Text Color', 'astrip-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .btn--primary' => 'color: {{VALUE}};',
                    '{{WRAPPER}} .btn-primary2-outline' => 'color: {{VALUE}};',
                    '{{WRAPPER}} .btn--white' => 'color: {{VALUE}};',
                    '{{WRAPPER}} .hero-wrapper .hero-content .btn-group .dsc-btn a' => 'color: {{VALUE}};',
                    '{{WRAPPER}} .hero-wrapper .hero-content .btn-group .trip-rating .icon i' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'astrip_banner_button_style_background',
            [
                'label'     => esc_html__('Background Color', 'astrip-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .btn--primary' => 'background: {{VALUE}};',
                    '{{WRAPPER}} .btn-primary2-outline' => 'background: {{VALUE}};',
                    '{{WRAPPER}} .btn--white' => 'background: {{VALUE}};',
                    '{{WRAPPER}} .hero-wrapper .hero-content .btn-group .dsc-btn a' => 'background-color: {{VALUE}};',
                    '{{WRAPPER}} .hero-wrapper .hero-content .btn-group .trip-rating .icon' => 'background-color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'astrip_banner_button_style_border',
            [
                'label' => esc_html__('Border Color', 'astrip-core'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .btn--primary' => 'border:1px solid {{VALUE}}',
                    '{{WRAPPER}} .btn-primary2-outline' => 'border:1px solid {{VALUE}}',
                    '{{WRAPPER}} .btn--white' => 'border:1px solid {{VALUE}}',
                    '{{WRAPPER}} .hero-wrapper .hero-content .btn-group .dsc-btn a' => 'border:1px solid {{VALUE}}',
                ],
            ]
        );
        $this->add_responsive_control(
            'astrip_banner_button_style_border_radius',
            [
                'astrip_banner_button_style_border_radius',
                'label'              => __('Border Radius', 'astrip-core'),
                'type'               => Controls_Manager::DIMENSIONS,
                'size_units'         => ['px', '%'],
                'selectors'          => [
                    '{{WRAPPER}} .btn--primary' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    '{{WRAPPER}} .btn-primary2-outline' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    '{{WRAPPER}} .btn--white' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    '{{WRAPPER}} .hero-wrapper .hero-content .btn-group .dsc-btn a' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],

            ]

        );
        $this->add_responsive_control(
            'astrip_banner_button_style_padding',
            [
                'label'      => __('Padding', 'astrip-core'),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'selectors'  => [
                    '{{WRAPPER}} .btn--lg' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    '{{WRAPPER}} .hero-wrapper .hero-content .btn-group .dsc-btn a' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',

                ],
            ]
        );
        $this->add_responsive_control(
            'astrip_banner_button_style_margin',
            [
                'label' => esc_html__('Margin', 'astrip-core'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors' => [
                    '{{WRAPPER}} .btn--lg' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    '{{WRAPPER}} .hero-wrapper .hero-content .btn-group .dsc-btn a' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->end_controls_tab();
        //Hover start

        $this->start_controls_tab(
            'style_hover_tab',
            [
                'label' => esc_html__('Hover', 'astrip-core'),
            ]
        );
        $this->add_control(
            'astrip_banner_button_style_hover_color',
            [
                'label' => esc_html__('Text Color', 'astrip-core'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .btn--primary:hover' => 'color: {{VALUE}}',
                    '{{WRAPPER}} .btn-primary2-outline:hover' => 'color: {{VALUE}}',
                    '{{WRAPPER}} .btn--white:hover' => 'color: {{VALUE}}',
                    '{{WRAPPER}} .hero-wrapper .hero-content .btn-group .dsc-btn a:hover' => 'color: {{VALUE}}',
                ],

            ]
        );
        $this->add_control(
            'astrip_banner_button_style_hover_background',
            [
                'label' => esc_html__('Background Color', 'astrip-core'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .btn--primary::after' => 'background: {{VALUE}}',
                    '{{WRAPPER}} .btn-primary2-outline::after' => 'background: {{VALUE}}',
                    '{{WRAPPER}} .btn--white::after' => 'background: {{VALUE}}',
                    '{{WRAPPER}} .hero-wrapper .hero-content .btn-group .dsc-btn a:hover::after' => 'background-color: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'astrip_banner_button_style_border_hover_color',
            [
                'label' => esc_html__('Border Color', 'astrip-core'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .btn--primary:hover' => 'border:1px solid {{VALUE}}',
                    '{{WRAPPER}} .btn-primary2-outline:hover' => 'border:1px solid {{VALUE}}',
                    '{{WRAPPER}} .btn--white:hover' => 'border:1px solid {{VALUE}}',
                    '{{WRAPPER}} .hero-wrapper .hero-content .btn-group .dsc-btn a:hover' => 'border:1px solid {{VALUE}}',
                ],
            ]
        );
        $this->end_controls_tab();
        $this->end_controls_tab();
        $this->end_controls_section();



        // Rating style 
        $this->start_controls_section(
            'astrip_banner_rating_style_section',
            [
                'label' => esc_html__('Rating', 'astrip-core'),
                'tab'   => Controls_Manager::TAB_STYLE, 'condition' => [
                    'astrip_banner_style' => 'style_five',
                ],


            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label'    => esc_html__('Typography', 'astrip-core'),
                'name'     => 'astrip_banner_sub_title_style_typography',
                'selector' =>
                '{{WRAPPER}} .hero-wrapper .hero-content .btn-group .trip-rating .cnt h4,
                        .hero-wrapper .hero-content .btn-group .trip-rating .cnt p,
                        .hero-wrapper .hero-content .btn-group .trip-rating .cnt p span',


            ]
        );

        $this->add_control(
            'astrip_banner_rating_style_color',
            [
                'label'     => esc_html__('Color', 'astrip-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .hero-wrapper .hero-content .btn-group .trip-rating .cnt h4' => 'color: {{VALUE}};',
                    '{{WRAPPER}} .hero-wrapper .hero-content .btn-group .trip-rating .cnt p' => 'color: {{VALUE}};',
                    '{{WRAPPER}} .hero-wrapper .hero-content .btn-group .trip-rating .cnt p span' => 'color: {{VALUE}};',

                ],
            ]
        );


        $this->add_responsive_control(
            'astrip_banner_rating_style_margin',
            [
                'label' => esc_html__('Margin', 'astrip-core'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors' => [
                    '{{WRAPPER}} .hero-wrapper .hero-content .btn-group .trip-rating .cnt h4' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    '{{WRAPPER}} .hero-wrapper .hero-content .btn-group .trip-rating .cnt p' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    '{{WRAPPER}} .hero-wrapper .hero-content .btn-group .trip-rating .cnt p span' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->end_controls_section();



        //Pagination (prev/next) Style
        $this->start_controls_section(
            'astrip_banner_pagination_icon_style_section',
            [
                'label' => esc_html__('Pagination (prev/next)', 'astrip-core'),
                'tab'   => Controls_Manager::TAB_STYLE,
                'condition' => [
                    'astrip_banner_style' => 'style_two',
                ],
            ]
        );
        $this->add_control(
            'astrip_banner_pagination_icon_color',
            [
                'label' => esc_html__('Icon Color', 'astrip-core'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .arrows-style-2 .swiper-prev-arrow svg' => 'fill: {{VALUE}}',
                    '{{WRAPPER}} .arrows-style-2 .swiper-next-arrow svg' => 'fill: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'astrip_banner_pagination_icon_hvr_color',
            [
                'label' => esc_html__('Icon Hover', 'astrip-core'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .arrows-style-2.sibling-2 .swiper-prev-arrow:hover svg' => 'fill: {{VALUE}}',
                    '{{WRAPPER}} .arrows-style-2.sibling-2 .swiper-next-arrow:hover svg' => 'fill: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'astrip_banner_pagination_icon_border_color',
            [
                'label' => esc_html__('Border Color', 'astrip-core'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .arrows-style-2 .swiper-prev-arrow' => 'border:1px solid {{VALUE}}',
                    '{{WRAPPER}} .arrows-style-2 .swiper-next-arrow' => 'border:1px solid {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'astrip_banner_pagination_icon_hvr_border_color',
            [
                'label' => esc_html__('Border Hover', 'astrip-core'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .arrows-style-2.sibling-2 .swiper-prev-arrow:hover' => 'border:1px solid {{VALUE}}',
                    '{{WRAPPER}} .arrows-style-2.sibling-2 .swiper-next-arrow:hover' => 'border:1px solid {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'astrip_banner_pagination_icon_hvr_bg_color',
            [
                'label' => esc_html__('Background Hover', 'astrip-core'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .arrows-style-2.sibling-2 .swiper-prev-arrow:hover' => 'background-color: {{VALUE}}',
                    '{{WRAPPER}} .arrows-style-2.sibling-2 .swiper-next-arrow:hover' => 'background-color: {{VALUE}}',
                ],
            ]
        );
        $this->end_controls_section();
    }

    protected function render()
    {
        $settings = $this->get_settings_for_display();
        $data = $settings['astrip_banner_two_list'];
?>
        <?php if (is_admin()) : ?>

            <script>
                // banner2
                var swiper = new Swiper(".mySwiper", {
                    spaceBetween: 10,
                    slidesPerView: 4,
                    freeMode: true,
                    autoplay: true,
                    watchSlidesProgress: true,
                });

                var swiper2 = new Swiper(".mySwiper2", {
                    spaceBetween: 10,
                    autoplay: true,
                    effect: 'fade',
                    navigation: {
                        nextEl: ".banner2-next",
                        prevEl: ".banner2-prev",
                    },
                    thumbs: {
                        swiper: swiper,
                    },
                });

                var swiper = new Swiper(".banner1-slider", {
                    slidesPerView: 1,
                    speed: 1200,
                    spaceBetween: 15,
                    effect: 'fade',
                    fadeEffect: {
                        crossFade: true
                    },
                    autoplay: true,
                    loop: true,
                    roundLengths: true,
                    pagination: {
                        el: ".swiper-pagination",
                        clickable: 'true',
                    },
                    navigation: {
                        nextEl: '.banner1-prev',
                        prevEl: '.banner1-next',
                    },
                });

                var swiper = new Swiper(".banner2-slider", {
                    slidesPerView: 1,
                    speed: 1200,
                    spaceBetween: 15,
                    effect: 'fade',
                    fadeEffect: {
                        crossFade: true
                    },
                    // autoplay: true,
                    loop: true,
                    roundLengths: true,
                    pagination: {
                        el: ".swiper-pagination",
                        clickable: 'true',
                    },
                    navigation: {
                        nextEl: '.banner1-prev',
                        prevEl: '.banner1-next',
                    },
                });

                // banner4-slider
                var swiper = new Swiper(".banner4-slider", {
                    slidesPerView: 1,
                    speed: 1200,
                    spaceBetween: 15,
                    effect: 'fade',
                    fadeEffect: {
                        crossFade: true
                    },
                    autoplay: true,
                    loop: true,
                    // roundLengths: true,
                    pagination: {
                        el: ".swiper-banner-pagination",
                        clickable: true,
                    },
                });

                //hero slider
                var swiper = new Swiper(".hero-slider", {
                    loop: true,
                    effect: 'fade',
                    fadeEffect: {
                        crossFade: true
                    },
                    speed: 2000,
                    autoplay: {
                        delay: 2000,
                    },
                    pagination: {
                        el: ".hero-pagination",
                        clickable: true,
                        renderBullet: function(index, className) {
                            return '<span class="' + className + '">' + 0 + (index + 1) + "</span>";
                        },
                    },
                });
            </script>

        <?php endif ?>




        <?php if ($settings['astrip_banner_style'] == 'style_five') : ?>
            <section class="hero-banner">

                <?php if (!empty($settings['astrip_banner_five_slider_image_list'])) : ?>
                    <div class="swiper hero-slider">
                        <div class="swiper-wrapper">
                            <?php foreach ($settings['astrip_banner_five_slider_image_list'] as $slider_img) : ?>
                                <div class="swiper-slide">
                                    <img src="<?php echo esc_url($slider_img['astrip_banner_five_slider_image']['url']) ?>" alt="">
                                    <div class="hero-wrapper">
                                        <div class="container">
                                            <div class="row">
                                                <div class="col-12 col-lg-9">
                                                    <div class="hero-content">
                                                        <?php if (!empty($slider_img['astrip_banner_five_sub_title'])) : ?>
                                                            <span><?php echo $slider_img['astrip_banner_five_sub_title'] ?></span>
                                                        <?php endif ?>
                                                        <?php if (!empty($slider_img['astrip_banner_five_main_title'])) : ?>
                                                            <h1><?php echo $slider_img['astrip_banner_five_main_title'] ?></h1>
                                                        <?php endif ?>
                                                        <?php if (!empty($slider_img['astrip_banner_five_description'])) : ?>
                                                            <p><?php echo $slider_img['astrip_banner_five_description'] ?></p>
                                                        <?php endif ?>

                                                        <div class="btn-group">
                                                            <?php if (!empty($slider_img['astrip_banner_five_btn_label'])) : ?>
                                                                <div class="dsc-btn">
                                                                    <a href="<?php echo esc_url($slider_img['astrip_banner_five_slider_btn_link']['url']) ?>">
                                                                        <?php if (!empty($slider_img['astrip_banner_five_btn_label_icon'])) : ?>
                                                                            <?php \Elementor\Icons_Manager::render_icon($slider_img['astrip_banner_five_btn_label_icon'], ['aria-hidden' => 'true']); ?>
                                                                        <?php endif; ?>
                                                                        <?php echo $slider_img['astrip_banner_five_btn_label'] ?>
                                                                    </a>
                                                                </div>
                                                            <?php endif ?>
                                                            <a href="<?php echo esc_url($slider_img['astrip_banner_five_slider_rating_btn_link']['url']) ?>" class="rating-wrap">
                                                                <div class="trip-rating">
                                                                    <?php if (!empty($slider_img['astrip_banner_five_slider_rating_icon'])) : ?>
                                                                        <div class="icon">
                                                                            <?php \Elementor\Icons_Manager::render_icon($slider_img['astrip_banner_five_slider_rating_icon'], ['aria-hidden' => 'true']); ?>
                                                                        </div>
                                                                    <?php endif; ?>
                                                                    <?php if (!empty($slider_img['astrip_banner_five_slider_rating_logo'])) : ?>
                                                                        <div class="cnt">
                                                                            <h4><?php echo $slider_img['astrip_banner_five_slider_rating_logo'] ?></h4>
                                                                            <p><span><?php echo $slider_img['astrip_banner_five_slider_rating_point'] ?></span><?php echo $slider_img['astrip_banner_five_slider_rating_title'] ?></p>
                                                                        </div>
                                                                    <?php endif; ?>
                                                                </div>
                                                            </a>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            <?php endforeach; ?>
                        </div>
                        <?php if (!empty($settings['astrip_banner_five_slider_paginate'] === 'yes')) : ?>
                            <div class="hero-pagination"></div>
                        <?php endif; ?>
                    </div>
                <?php endif; ?>
                <?php do_shortcode($settings['astrip_tour_search_shortcode_one']) ?>
            </section>
        <?php endif ?>




        <?php if ($settings['astrip_banner_style'] == 'style_one') : ?>
            <div class="banner-section1 overflow-hidden">
                <?php if ('yes' === $settings['astrip_banner_content_cloud_icon_one']) : ?>
                    <div class="cloud-icon1">
                        <img src="<?php echo get_template_directory_uri() ?>/assets/images/icons/cloud1.svg" alt="<?php echo esc_attr('cloud1-icon') ?>">
                    </div>
                <?php endif ?>
                <?php if ('yes' === $settings['astrip_banner_content_cloud_icon_two']) : ?>
                    <div class="cloud-icon2">
                        <img src="<?php echo get_template_directory_uri() ?>/assets/images/icons/cloud2.svg" alt="<?php echo esc_attr('cloud2-icon') ?>">
                    </div>
                <?php endif ?>

                <?php if ('yes' === $settings['astrip_banner_content_plane_icon']) : ?>
                    <div class="cloud cloud1">
                        <img src="<?php echo get_template_directory_uri() ?>/assets/images/icons/banner-plane.svg" alt="<?php echo esc_attr('plane-icon') ?>">
                    </div>
                <?php endif ?>
                <div class="banner-social-area d-xxl-flex d-none">
                    <ul class="banner-social-list">
                        <?php if (!empty($settings['astrip_banner_social_link_facebook']['url'])) : ?>
                            <li><a href="<?php echo esc_url($settings['astrip_banner_social_link_facebook']['url']) ?>"><i class='bx bxl-facebook'></i></a></li>
                        <?php endif ?>
                        <?php if (!empty($settings['astrip_banner_social_link_twitter']['url'])) : ?>
                            <li><a href="<?php echo esc_url($settings['astrip_banner_social_link_twitter']['url']) ?>"><i class='bx bxl-twitter'></i></a></li>
                        <?php endif ?>
                        <?php if (!empty($settings['astrip_banner_social_link_instagram']['url'])) : ?>
                            <li><a href="<?php echo esc_url($settings['astrip_banner_social_link_instagram']['url']) ?>"><i class='bx bxl-instagram'></i></a></li>
                        <?php endif ?>
                        <?php if (!empty($settings['astrip_banner_social_link_pinterest']['url'])) : ?>
                            <li><a href="<?php echo esc_url($settings['astrip_banner_social_link_pinterest']['url']) ?>"><i class='bx bxl-pinterest'></i></a></li>
                        <?php endif ?>
                        <?php if (!empty($settings['astrip_banner_social_link_linkedin']['url'])) : ?>
                            <li><a href="<?php echo esc_url($settings['astrip_banner_social_link_linkedin']['url']) ?>"><i class='bx bxl-linkedin'></i></a></li>
                        <?php endif ?>
                        <?php if (!empty($settings['astrip_banner_social_link_youtube']['url'])) : ?>
                            <li><a href="<?php echo esc_url($settings['astrip_banner_social_link_youtube']['url']) ?>"><i class='bx bxl-youtube'></i></a></li>
                        <?php endif ?>
                        <?php if (!empty($settings['astrip_banner_social_link_google_plus']['url'])) : ?>
                            <li><a href="<?php echo esc_url($settings['astrip_banner_social_link_google_plus']['url']) ?>"><i class='bx bxl-google-plus'></i></a></li>
                        <?php endif ?>
                        <?php if (!empty($settings['astrip_banner_social_link_reddit']['url'])) : ?>
                            <li><a href="<?php echo esc_url($settings['astrip_banner_social_link_reddit']['url']) ?>"><i class='bx bxl-reddit'></i></a></li>
                        <?php endif ?>
                    </ul>
                </div>
                <?php if (!empty($settings['astrip_banner_content_banner_image_two']['url']) && !empty($settings['astrip_banner_content_banner_inner_image_two']['url'])) : ?>
                    <div class="banner-image2">
                        <div class="inner-img2">
                            <img src="<?php echo esc_url($settings['astrip_banner_content_banner_inner_image_two']['url']) ?>" class="img-fluid" alt="<?php echo esc_attr__('banner-image', 'astrip-core') ?>">
                        </div>
                        <img src="<?php echo esc_url($settings['astrip_banner_content_banner_image_two']['url']) ?>" class="img-fluid" alt="<?php echo esc_attr__('banner-image', 'astrip-core') ?>">
                    </div>
                <?php endif ?>

                <div class="container-fluid">
                    <div class="row align-items-center justify-content-center">
                        <div class="col-xl-2 offset-xl-1 col-lg-2 d-lg-flex d-none justify-content-end">
                            <?php if (!empty($settings['astrip_banner_content_banner_image_one']['url'])) : ?>
                                <div class="banner-image1">
                                    <img src="<?php echo esc_url($settings['astrip_banner_content_banner_image_one']['url']) ?>" class="img-fluid" alt="<?php echo esc_attr__('banner-image', 'astrip-core') ?>">
                                </div>
                            <?php endif ?>
                        </div>
                        <div class="col-xl-6 col-lg-8 col-md-8">
                            <div class="banner1-content">
                                <?php if (!empty($settings['astrip_banner_sub_title'])) : ?>
                                    <span class="<?php echo 'yes' == $settings['astrip_banner_content_sub_title_icon'] ? '' : 'content-none' ?>"><?php echo esc_html($settings['astrip_banner_sub_title']) ?></span>
                                <?php endif ?>
                                <?php if (!empty($settings['astrip_banner_main_title'])) : ?>
                                    <h1 class="<?php echo 'yes' == $settings['astrip_banner_content_main_title_icon'] ? '' : 'content-none' ?>"><?php echo wp_kses($settings['astrip_banner_main_title'], wp_kses_allowed_html('post')) ?></h1>
                                <?php endif ?>
                                <?php if (!empty($settings['astrip_banner_description'])) : ?>
                                    <p><?php echo wp_kses($settings['astrip_banner_description'], wp_kses_allowed_html('post')) ?></p>
                                <?php endif ?>
                                <?php if (!empty($settings['astrip_banner_button_text'])) : ?>
                                    <div class="discover-btn <?php echo 'yes' == $settings['astrip_banner_content_discover_button_icon'] ? '' : 'content-none' ?>">
                                        <a href="<?php echo esc_url($settings['astrip_banner_button_website_link']['url']) ?>" class="eg-btn btn--primary btn--lg">
                                            <?php echo esc_html($settings['astrip_banner_button_text']) ?></a>
                                    </div>
                                <?php endif ?>
                            </div>
                        </div>
                        <div class="col-xl-3 col-lg-2 d-lg-flex d-none justify-content-lg-start justify-content-center">
                        </div>
                    </div>

                </div>

            </div>
            <?php do_shortcode($settings['astrip_tour_search_shortcode_one']) ?>
        <?php endif ?>

        <?php if ($settings['astrip_banner_style'] == 'style_two') : ?>
            <div class="banner-section2">
                <div class="swiper banner2-slider">
                    <div class="swiper-wrapper">
                        <?php foreach ($data as $item) : ?>
                            <div class="swiper-slide">
                                <?php if (!empty($item['astrip_banner_two_content_banner_image']['url'])) : ?>
                                    <img src="<?php echo esc_url($item['astrip_banner_two_content_banner_image']['url']) ?>" class="banner-bg11" alt="<?php echo esc_attr__('banner-image', 'astrip-core') ?>">
                                <?php endif ?>
                                <div class="container">
                                    <div class="row justify-content-lg-start justify-content-center align-items-center g-4">
                                        <div class="col-xl-6 col-lg-7 col-md-12 text-lg-start text-center">
                                            <div class="banner2-content">
                                                <?php if (!empty($item['astrip_banner_two_sub_title'])) : ?>
                                                    <span><?php echo esc_html($item['astrip_banner_two_sub_title']) ?></span>
                                                <?php endif ?>
                                                <?php if (!empty($item['astrip_banner_two_main_title'])) : ?>
                                                    <h2><?php echo wp_kses($item['astrip_banner_two_main_title'], wp_kses_allowed_html('post')) ?></h2>
                                                <?php endif ?>
                                                <?php if (!empty($item['astrip_banner_two_description'])) : ?>
                                                    <p><?php echo wp_kses($item['astrip_banner_two_description'], wp_kses_allowed_html('post')) ?></p>
                                                <?php endif ?>
                                                <?php if (!empty($item['astrip_banner_two_button_text'])) : ?>
                                                    <a href="<?php echo esc_url($item['astrip_banner_two_button_website_link']['url']) ?>" class="eg-btn btn-primary2-outline btn--lg">
                                                        <?php echo esc_html($item['astrip_banner_two_button_text']) ?></a>
                                                <?php endif ?>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        <?php endforeach ?>
                    </div>
                    <?php if ('yes' === $settings['astrip_banner_content_pagi_icon']) : ?>
                        <div class="slider-arrows arrows-style-2 sibling-2 text-center d-lg-flex d-none flex-row justify-content-between align-items-center w-100">
                            <div class="banner1-prev swiper-prev-arrow" tabindex="0" role="button" aria-label="Previous slide">
                                <svg width="20" height="12" viewBox="0 0 20 12" xmlns="http://www.w3.org/2000/svg">
                                    <path d="M7.00001 10.573V6L7.00001 1.42701C7.00001 1.25744 6.80224 1.16481 6.67197 1.27336L1 6L6.67197 10.7266C6.80224 10.8352 7.00001 10.7426 7.00001 10.573Z" />
                                    <path d="M19 6.5C19.2761 6.5 19.5 6.27614 19.5 6C19.5 5.72386 19.2761 5.5 19 5.5V6.5ZM6.67197 10.7266L6.99206 10.3425V10.3425L6.67197 10.7266ZM1 6L0.679909 5.61589L0.218975 6L0.679909 6.38411L1 6ZM6.67197 1.27336L6.35188 0.889252L6.35188 0.889253L6.67197 1.27336ZM19 5.5L7.00001 5.5V6.5L19 6.5V5.5ZM6.50001 6V10.573H7.50001V6H6.50001ZM6.99206 10.3425L1.32009 5.61589L0.679909 6.38411L6.35188 11.1107L6.99206 10.3425ZM1.32009 6.38411L6.99206 1.65747L6.35188 0.889253L0.679909 5.61589L1.32009 6.38411ZM6.50001 1.42701L6.50001 6H7.50001L7.50001 1.42701H6.50001ZM6.99206 1.65747C6.79667 1.82031 6.50001 1.68136 6.50001 1.42701H7.50001C7.50001 0.833523 6.80781 0.509313 6.35188 0.889252L6.99206 1.65747ZM6.50001 10.573C6.50001 10.3186 6.79667 10.1797 6.99206 10.3425L6.35188 11.1107C6.80781 11.4907 7.50001 11.1665 7.50001 10.573H6.50001Z" />
                                </svg>
                            </div>
                            <div class="banner1-next swiper-next-arrow" tabindex="0" role="button" aria-label="Next slide">
                                <svg width="20" height="12" viewBox="0 0 20 12" xmlns="http://www.w3.org/2000/svg">
                                    <path d="M13 1.42701V6V10.573C13 10.7426 13.1978 10.8352 13.328 10.7266L19 6L13.328 1.27336C13.1978 1.16481 13 1.25744 13 1.42701Z" />
                                    <path d="M1 5.5C0.723858 5.5 0.5 5.72386 0.5 6C0.5 6.27614 0.723858 6.5 1 6.5V5.5ZM13.328 1.27336L13.0079 1.65747V1.65747L13.328 1.27336ZM19 6L19.3201 6.38411L19.781 6L19.3201 5.61589L19 6ZM13.328 10.7266L13.6481 11.1107L13.6481 11.1107L13.328 10.7266ZM1 6.5H13V5.5H1V6.5ZM13.5 6V1.42701H12.5V6H13.5ZM13.0079 1.65747L18.6799 6.38411L19.3201 5.61589L13.6481 0.889253L13.0079 1.65747ZM18.6799 5.61589L13.0079 10.3425L13.6481 11.1107L19.3201 6.38411L18.6799 5.61589ZM13.5 10.573V6H12.5V10.573H13.5ZM13.0079 10.3425C13.2033 10.1797 13.5 10.3186 13.5 10.573H12.5C12.5 11.1665 13.1922 11.4907 13.6481 11.1107L13.0079 10.3425ZM13.5 1.42701C13.5 1.68136 13.2033 1.82031 13.0079 1.65747L13.6481 0.889253C13.1922 0.509312 12.5 0.833522 12.5 1.42701H13.5Z" />
                                </svg>
                            </div>
                        </div>
                    <?php endif ?>
                </div>
                <?php if (!empty($settings['astrip_banner_two_short_code'])) : ?>
                    <?php do_shortcode($settings['astrip_tour_search_shortcode_two']) ?>
                <?php endif ?>
            </div>
        <?php endif ?>

        <?php if ($settings['astrip_banner_style'] == 'style_three') : ?>
            <div class="banner-section3 overflow-hidden position-relative ml-230">
                <?php if (!empty($settings['astrip_banner_three_content_banner_image']['url'])) : ?>
                    <img src="<?php echo esc_url($settings['astrip_banner_three_content_banner_image']['url']) ?>" class="banner-bg31" alt="<?php echo esc_attr__('banner-image', 'astrip-core') ?>">
                <?php endif ?>
                <div class="container">
                    <div class="row justify-content-center align-items-center g-4">
                        <div class="col-xl-8 col-lg-8 col-md-12 text-lg-start text-center">
                            <div class="banner3-content">
                                <?php if (!empty($settings['astrip_banner_sub_title'])) : ?>
                                    <span><?php echo esc_html($settings['astrip_banner_sub_title']) ?></span>
                                <?php endif ?>
                                <?php if (!empty($settings['astrip_banner_main_title'])) : ?>
                                    <h2><?php echo wp_kses($settings['astrip_banner_main_title'], wp_kses_allowed_html('post')) ?></h2>
                                <?php endif ?>
                                <?php if (!empty($settings['astrip_banner_description'])) : ?>
                                    <p><?php echo wp_kses($settings['astrip_banner_description'], wp_kses_allowed_html('post')) ?></p>
                                <?php endif ?>
                                <?php if (!empty($settings['astrip_banner_button_text'])) : ?>
                                    <a href="<?php echo esc_url($settings['astrip_banner_button_website_link']['url']) ?>" class="eg-btn btn--white btn--lg"><?php echo esc_html($settings['astrip_banner_button_text']) ?></a>
                                <?php endif ?>
                            </div>
                        </div>
                        <?php if (!empty($settings['astrip_banner_two_short_code'])) : ?>
                            <div class="col-xl-4 col-lg-4 col-md-10">
                                <?php do_shortcode($settings['astrip_tour_search_shortcode_three']) ?>
                            </div>
                        <?php endif ?>
                    </div>
                </div>
            </div>
        <?php endif ?>

        <?php if ($settings['astrip_banner_style'] == 'style_four') : ?>
            <div class="banner-section5 sibling-2">
                <div class="banner-social-area2">
                    <div class="swiper-banner-pagination d-flex flex-column align-items-center gap-4"></div>
                    <ul class="banner-social gap-4">
                        <?php if (!empty($settings['astrip_banner_social_link_facebook']['url'])) : ?>
                            <li><a href="<?php echo esc_url($settings['astrip_banner_social_link_facebook']['url']) ?>"><i class='bx bxl-facebook'></i></a></li>
                        <?php endif ?>
                        <?php if (!empty($settings['astrip_banner_social_link_twitter']['url'])) : ?>
                            <li><a href="<?php echo esc_url($settings['astrip_banner_social_link_twitter']['url']) ?>"><i class='bx bxl-twitter'></i></a></li>
                        <?php endif ?>
                        <?php if (!empty($settings['astrip_banner_social_link_instagram']['url'])) : ?>
                            <li><a href="<?php echo esc_url($settings['astrip_banner_social_link_instagram']['url']) ?>"><i class='bx bxl-instagram'></i></a></li>
                        <?php endif ?>
                        <?php if (!empty($settings['astrip_banner_social_link_pinterest']['url'])) : ?>
                            <li><a href="<?php echo esc_url($settings['astrip_banner_social_link_pinterest']['url']) ?>"><i class='bx bxl-pinterest'></i></a></li>
                        <?php endif ?>
                        <?php if (!empty($settings['astrip_banner_social_link_linkedin']['url'])) : ?>
                            <li><a href="<?php echo esc_url($settings['astrip_banner_social_link_linkedin']['url']) ?>"><i class='bx bxl-linkedin'></i></a></li>
                        <?php endif ?>
                        <?php if (!empty($settings['astrip_banner_social_link_youtube']['url'])) : ?>
                            <li><a href="<?php echo esc_url($settings['astrip_banner_social_link_youtube']['url']) ?>"><i class='bx bxl-youtube'></i></a></li>
                        <?php endif ?>
                        <?php if (!empty($settings['astrip_banner_social_link_google_plus']['url'])) : ?>
                            <li><a href="<?php echo esc_url($settings['astrip_banner_social_link_google_plus']['url']) ?>"><i class='bx bxl-google-plus'></i></a></li>
                        <?php endif ?>
                        <?php if (!empty($settings['astrip_banner_social_link_reddit']['url'])) : ?>
                            <li><a href="<?php echo esc_url($settings['astrip_banner_social_link_reddit']['url']) ?>"><i class='bx bxl-reddit'></i></a></li>
                        <?php endif ?>
                    </ul>
                </div>
                <div class="swiper banner4-slider">
                    <div class="swiper-wrapper">
                        <?php foreach ($data as $item) : ?>
                            <div class="swiper-slide">
                                <?php if (!empty($item['astrip_banner_two_content_banner_image']['url'])) : ?>
                                    <img src="<?php echo esc_url($item['astrip_banner_two_content_banner_image']['url']) ?>" class="banner-bg11" alt="<?php echo esc_attr__('banner-image', 'astrip-core') ?>">
                                <?php endif ?>
                                <div class="banner4-content">
                                    <?php if (!empty($item['astrip_banner_two_sub_title'])) : ?>
                                        <span><?php echo esc_html($item['astrip_banner_two_sub_title']) ?></span>
                                    <?php endif ?>
                                    <?php if (!empty($item['astrip_banner_two_main_title'])) : ?>
                                        <h2><?php echo wp_kses($item['astrip_banner_two_main_title'], wp_kses_allowed_html('post')) ?></h2>
                                    <?php endif ?>
                                    <?php if (!empty($item['astrip_banner_two_description'])) : ?>
                                        <p><?php echo wp_kses($item['astrip_banner_two_description'], wp_kses_allowed_html('post')) ?></p>
                                    <?php endif ?>
                                    <?php if (!empty($item['astrip_banner_two_button_text'])) : ?>
                                        <a href="<?php echo esc_url($item['astrip_banner_two_button_website_link']['url']) ?>" class="eg-btn btn--primary btn--lg">
                                            <?php echo esc_html($item['astrip_banner_two_button_text']) ?></a>
                                    <?php endif ?>
                                </div>
                            </div>
                        <?php endforeach ?>
                    </div>
                </div>
            </div>
            <?php do_shortcode($settings['astrip_tour_search_shortcode_four']) ?>
        <?php endif ?>

<?php
    }
}

Plugin::instance()->widgets_manager->register(new astrip_slider_Widget());
