<?php

namespace Elementor;

if (!defined('ABSPATH')) exit; // Exit if accessed directly

use Elementor\core\Schemes;

class Astrip_package_with_carousel_Widget extends Widget_Base
{

    public function get_name()
    {
        return 'astrip_package_with_carousel';
    }

    public function get_title()
    {
        return esc_html__('EG Tour Package Carousel', 'astrip-core');
    }

    public function get_icon()
    {
        return ' eicon-price-table';
    }

    public function get_categories()
    {
        return ['astrip_widgets'];
    }

    protected function register_controls()
    {

        //grneral section
        $this->start_controls_section(
            'astrip_package_with_carousel_general_section',
            [
                'label' => esc_html__('General', 'astrip-core')
            ]
        );



        $this->add_control(
            'astrip_package_with_carousel_content_style_selection',
            [
                'label'     => esc_html__('Select Style', 'astrip-core'),
                'type'      => \Elementor\Controls_Manager::SELECT,
                'default'   => 'style_one',
                'options'   => [
                    'style_one'        => esc_html__('Style One', 'astrip-core'),
                    'style_two'        => esc_html__('Style Two', 'astrip-core'),

                ],
            ]
        );

        $this->add_control(
            'turio_packages',
            [
                'label'             => __('Select Tour', 'turio-core'),
                'type'                 => \Elementor\Controls_Manager::SELECT2,
                'label_block'         => true,
                'multiple'            => true,
                'options'             => egens_core()->get_post_list_by_post_type('astrip-tour'),
                'default'             => egens_core()->get_all_post_key('astrip-tour'),
            ]
        );





        $this->add_control(
            'astrip_package_with_carousel_posts_per_page',
            [
                'label'       => esc_html__('Posts Per Page', 'astrip-core'),
                'type'        => Controls_Manager::NUMBER,
                'default'     => 5,
                'label_block' => false,
            ]
        );
        $this->add_control(
            'astrip_package_with_carousel_template_order_by',
            [
                'label'   => esc_html__('Order By', 'astrip-core'),
                'type'    => Controls_Manager::SELECT,
                'default' => 'ID',
                'options' => [
                    'ID'         => esc_html__('Post Id', 'astrip-core'),
                    'author'     => esc_html__('Post Author', 'astrip-core'),
                    'title'      => esc_html__('Title', 'astrip-core'),
                    'post_date'  => esc_html__('Date', 'astrip-core'),
                    'rand'       => esc_html__('Random', 'astrip-core'),
                    'menu_order' => esc_html__('Menu Order', 'astrip-core'),
                ],
            ]
        );
        $this->add_control(
            'astrip_package_with_carousel_template_order',
            [
                'label'   => esc_html__('Order', 'astrip-core'),
                'type'    => Controls_Manager::SELECT,
                'options' => [
                    'asc'  => esc_html__('Ascending', 'astrip-core'),
                    'desc' => esc_html__('Descending', 'astrip-core')
                ],
                'default' => 'desc',
            ]
        );






        $this->end_controls_section();

        //========================================style two heading========================================//


        $this->start_controls_section(
            'astrip_package_with_carousel_one_image',
            [
                'label' => esc_html__('Image', 'astrip-core'),
                'tab'   => Controls_Manager::TAB_STYLE,
                'condition' => [
                    'astrip_package_with_carousel_content_style_selection' => ['style_one']
                ],
            ]
        );



        $this->add_responsive_control(
            'astrip_package_with_carousel_one_image_height',
            [
                'label'       => esc_html__('Height', 'astrip-core'),
                'type'        => Controls_Manager::TEXT,
                'description' => 'Unit in px',
                'selectors'   => [
                    '{{WRAPPER}} .offer-single img ' => 'height: {{VALUE}}px;',
                ],
            ]
        );
        $this->add_responsive_control(
            'astrip_package_with_carousel_one_image_width',
            [
                'label'       => esc_html__('Width', 'astrip-core'),
                'type'        => Controls_Manager::TEXT,
                'description' => 'Unit in px',
                'selectors'   => [
                    '{{WRAPPER}} .offer-single img ' => 'width: {{VALUE}}px;',
                ],
            ]
        );
        $this->add_responsive_control(
            'astrip_package_with_carousel_one_image_border_radius',
            [
                'label'      => __('Border Radius', 'astrip-core'),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'selectors'  => [
                    '{{WRAPPER}} .offer-single img' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
                ]
            ]
        );





        $this->end_controls_section();



        $this->start_controls_section(
            'astrip_heading_content_main_title_section',
            [
                'label' => esc_html__('Heading', 'astrip-core'),
                'condition' => [
                    'astrip_package_with_carousel_content_style_selection' => ['style_two']
                ],
            ]
        );
        $this->add_control(
            'astrip_heading_content_sub_title',
            [
                'label' => esc_html__('Sub Title', 'astrip-core'),
                'type' => Controls_Manager::TEXT,
                'default' => esc_html__('Choose Your’s', 'astrip-core'),
                'label_block' => true,
            ]
        );
        $this->add_control(
            'astrip_heading_content_main_title',
            [
                'label' => esc_html__('Main Title', 'astrip-core'),
                'type' => Controls_Manager::TEXTAREA,
                'default' => esc_html__('Get The Best Astrip Tour’s', 'astrip-core'),
                'label_block' => true,
            ]
        );
        $this->end_controls_section();
        //Style Section Start

        //Review Style Start
        $this->start_controls_section(
            'astrip_package_with_carousel_style_review_section',
            [
                'label' => esc_html__('Review', 'astrip-core'),
                'tab'   => Controls_Manager::TAB_STYLE,
                'condition' => [
                    'astrip_package_with_carousel_content_style_selection' => 'style_one'
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label'    => esc_html__('Typography', 'astrip-core'),
                'name'     => 'astrip_package_with_carousel_style_review_typography',
                'selector' =>
                '{{WRAPPER}} .offer-single.sibling-2 .content span.t-review',


            ]
        );
        $this->add_control(
            'astrip_package_with_carousel_style_review_color',
            [
                'label'     => esc_html__('Color', 'astrip-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .offer-single.sibling-2 .content span.t-review' => 'color: {{VALUE}};',
                ],
            ]
        );


        $this->add_control(
            'astrip_package_with_carousel_style_review_star_color',
            [
                'label'     => esc_html__('Icon Color', 'astrip-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .review-area.sibling-2 .star-list li .bi' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'astrip_package_with_carousel_style_review_margin',
            [
                'label' => esc_html__('Margin', 'astrip-core'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors' => [
                    '{{WRAPPER}} .offer-single.sibling-2 .content span.t-review' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'astrip_package_with_carousel_style_review_padding',
            [
                'label'      => __('Padding', 'astrip-core'),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'selectors'  => [
                    '{{WRAPPER}} .offer-single.sibling-2 .content span.t-review' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',

                ],
            ]
        );



        $this->end_controls_section();


        //Title Style Start
        $this->start_controls_section(
            'astrip_package_with_carousel_style_title_section',
            [
                'label' => esc_html__('Title', 'astrip-core'),
                'tab'   => Controls_Manager::TAB_STYLE,
                'condition' => [
                    'astrip_package_with_carousel_content_style_selection' => 'style_one'
                ],

            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label'    => esc_html__('Typography', 'astrip-core'),
                'name'     => 'astrip_package_with_carousel_style_title_typography',
                'selector' =>
                '{{WRAPPER}} .offer-single .content a',


            ]
        );
        $this->add_control(
            'astrip_package_with_carousel_style_title_color',
            [
                'label'     => esc_html__('Color', 'astrip-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .offer-single .content a' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'astrip_package_with_carousel_style_title_padding',
            [
                'label'      => __('Padding', 'astrip-core'),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'selectors'  => [
                    '{{WRAPPER}} .offer-single .content a' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',

                ],
            ]
        );

        $this->end_controls_section();
        //Price Style Start
        $this->start_controls_section(
            'astrip_package_with_carousel_style_package_price_section',
            [
                'label' => esc_html__('Date & Price', 'astrip-core'),
                'tab'   => Controls_Manager::TAB_STYLE,
                'condition' => [
                    'astrip_package_with_carousel_content_style_selection' => 'style_one'
                ],

            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label'    => esc_html__('Typography', 'astrip-core'),
                'name'     => 'astrip_package_with_carousel_style_package_price_typography',
                'selector' =>
                '{{WRAPPER}} .offer-single.sibling-2 .content span.tt',


            ]
        );
        $this->add_control(
            'astrip_package_with_carousel_style_package_price_color',
            [
                'label'     => esc_html__('Color', 'astrip-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .offer-single.sibling-2 .content span.tt' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'astrip_package_with_carousel_style_package_price_margin',
            [
                'label' => esc_html__('Margin', 'astrip-core'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors' => [
                    '{{WRAPPER}} .offer-single.sibling-2 .content span.tt' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'astrip_package_with_carousel_style_package_price_padding',
            [
                'label'      => __('Padding', 'astrip-core'),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'selectors'  => [
                    '{{WRAPPER}} .offer-single.sibling-2 .content span.tt' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',

                ],
            ]
        );

        $this->end_controls_section();

        //==============================design two style section starts ============================================//

        //Heading Sub Title Style Section Start
        $this->start_controls_section(
            'astrip_heading_style_sub_title_section',
            [
                'label' => esc_html__('Heading Sub Title', 'astrip-core'),
                'tab'   => Controls_Manager::TAB_STYLE,
                'condition' => [
                    'astrip_package_with_carousel_content_style_selection' => 'style_two'
                ],
            ]
        );
        $this->add_control(
            'astrip_heading_style_sub_title_color',
            [
                'label'     => esc_html__('Color', 'astrip-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .section-title2 span' => 'color: {{VALUE}};',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label'    => esc_html__('Typography', 'astrip-core'),
                'name'     => 'astrip_heading_style_sub_title_typography',
                'selector' => '{{WRAPPER}}  .section-title2 span',

            ]
        );
        $this->add_responsive_control(
            'astrip_heading_style_sub_title_padding',
            [
                'label'      => __('Padding', 'astrip-core'),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'selectors'  => [
                    '{{WRAPPER}} .section-title2 span' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',

                ],
            ]
        );
        $this->add_responsive_control(
            'astrip_heading_style_sub_title_margin',
            [
                'label' => esc_html__('Margin', 'astrip-core'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors' => [
                    '{{WRAPPER}} .section-title2 span' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->end_controls_section();
        //Heading Title Style Section Start
        $this->start_controls_section(
            'astrip_heading_style_main_title_section',
            [
                'label' => esc_html__('Heading Title', 'astrip-core'),
                'tab'   => Controls_Manager::TAB_STYLE,
                'condition' => [
                    'astrip_package_with_carousel_content_style_selection' => 'style_two'
                ],
            ]
        );
        $this->add_control(
            'astrip_heading_style_main_title_color',
            [
                'label'     => esc_html__('Color', 'astrip-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .section-title2 h2' => 'color: {{VALUE}};',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label'    => esc_html__('Typography', 'astrip-core'),
                'name'     => 'astrip_heading_style_main_title_typography',
                'selector' => '{{WRAPPER}} .section-title2 h2',

            ]
        );
        $this->add_responsive_control(
            'astrip_heading_style_main_title_padding',
            [
                'label'      => __('Padding', 'astrip-core'),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'selectors'  => [
                    '{{WRAPPER}} .section-title2 h2' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',

                ],
            ]
        );
        $this->add_responsive_control(
            'astrip_heading_style_main_title_margin',
            [
                'label' => esc_html__('Margin', 'astrip-core'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors' => [
                    '{{WRAPPER}} .section-title2 h2' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->end_controls_section();
        // Image
        $this->start_controls_section(
            'astrip_package_with_carousel_style_one_image_section',
            [
                'label' => esc_html__('Image', 'astrip-core'),
                'tab'   => Controls_Manager::TAB_STYLE,
                'condition' => [
                    'astrip_package_with_carousel_content_style_selection' => 'style_two'
                ],

            ]
        );


        $this->add_responsive_control(
            'eael_accordisdafon_height',
            [
                'label'       => esc_html__('Height', 'astrip-core'),
                'type'        => Controls_Manager::TEXT,
                'description' => 'Unit in px',
                'selectors'   => [
                    '{{WRAPPER}} .tour-package-single img ' => 'height: {{VALUE}}px;',
                ],
            ]
        );
        $this->add_responsive_control(
            'eael_accodfdrdion_width',
            [
                'label'       => esc_html__('Width', 'astrip-core'),
                'type'        => Controls_Manager::TEXT,
                'description' => 'Unit in px',
                'selectors'   => [
                    '{{WRAPPER}} .tour-package-single img ' => 'width: {{VALUE}}px;',
                ],
            ]
        );
        $this->add_responsive_control(
            'eael_accorfdsfdsdion_border_radius',
            [
                'label'      => __('Border Radius', 'astrip-core'),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'selectors'  => [
                    '{{WRAPPER}} .tour-package-single img' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
                ]
            ]
        );



        $this->end_controls_section();

        //Title Style Start
        $this->start_controls_section(
            'astrip_package_with_carousel_style_one_title_section',
            [
                'label' => esc_html__('Title', 'astrip-core'),
                'tab'   => Controls_Manager::TAB_STYLE,
                'condition' => [
                    'astrip_package_with_carousel_content_style_selection' => 'style_two'
                ],

            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label'    => esc_html__('Typography', 'astrip-core'),
                'name'     => 'astrip_package_with_carousel_style_one_title_typography',
                'selector' =>
                '{{WRAPPER}} .tour-package-single .package-content h4',


            ]
        );
        $this->add_control(
            'astrip_package_with_carousel_style_one_title_color',
            [
                'label'     => esc_html__('Color', 'astrip-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .tour-package-single .package-content h4' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'astrip_package_with_carousel_style_one_title_padding',
            [
                'label'      => __('Padding', 'astrip-core'),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'selectors'  => [
                    '{{WRAPPER}} .tour-package-single .package-content h4' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',

                ],
            ]
        );


        $this->end_controls_section();
        //description Style Start
        $this->start_controls_section(
            'astrip_package_with_carousel_style_one_description_section',
            [
                'label' => esc_html__('Description', 'astrip-core'),
                'tab'   => Controls_Manager::TAB_STYLE,
                'condition' => [
                    'astrip_package_with_carousel_content_style_selection' => 'style_two'
                ],

            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label'    => esc_html__('Typography', 'astrip-core'),
                'name'     => 'astrip_package_with_carousel_style_one_description_typography',
                'selector' =>
                '{{WRAPPER}} .tour-package-single .package-content p',


            ]
        );
        $this->add_control(
            'astrip_package_with_carousel_style_one_description_color',
            [
                'label'     => esc_html__('Color', 'astrip-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .tour-package-single .package-content p' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'astrip_package_with_carousel_style_one_description_padding',
            [
                'label'      => __('Padding', 'astrip-core'),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'selectors'  => [
                    '{{WRAPPER}} .tour-package-single .package-content p' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',

                ],
            ]
        );


        $this->end_controls_section();


        // Package  Price Style
        $this->start_controls_section(
            'astrip_package_price_ones',
            [
                'label' => esc_html__('Price', 'astrip-core'),
                'tab'   => Controls_Manager::TAB_STYLE,
                'condition' => [
                    'astrip_package_with_carousel_content_style_selection' => 'style_two'
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label' => esc_html__('Typography', 'astrip-core'),
                'name' => 'astrip_package_current_price_style_typography_ones',
                'selector' =>
                '{{WRAPPER}} .tour-package-single .package-content span.price',

            ]
        );
        $this->add_control(
            'astrip_package_price_style_color_ones',
            [
                'label'  => esc_html__('Color', 'astrip-core'),
                'type'   => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .tour-package-single .package-content span.price' => 'color : {{VALUE}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'astrip_package_price_style_padding_ones',
            [
                'label'      => __('Padding', 'astrip-core'),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'selectors'  => [
                    '{{WRAPPER}} .tour-package-single .package-content span.price' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',

                ],
            ]
        );
        $this->end_controls_section();

        //Explore Button Style Start
        $this->start_controls_section(
            'astrip_package_with_carousel_style_one_reading_btn_section',
            [
                'label' => esc_html__('Explore Button', 'astrip-core'),
                'tab'   => Controls_Manager::TAB_STYLE,
                'condition' => [
                    'astrip_package_with_carousel_content_style_selection' => 'style_two'
                ],

            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label'    => esc_html__('Typography', 'astrip-core'),
                'name'     => 'astrip_package_with_carousel_style_one_reading_btn_typography',
                'selector' => '{{WRAPPER}} .tour-package-single .explore-btn',

            ]
        );
        $this->add_control(
            'astrip_package_with_carousel_style_one_reading_btn_color',
            [
                'label'     => esc_html__('Color', 'astrip-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .tour-package-single .explore-btn' => 'color: {{VALUE}};',
                ],
            ]
        );
        $this->add_control(
            'astrip_package_with_carousel_style_one_reading_btn_hover_color',
            [
                'label'     => esc_html__('Hover Color', 'astrip-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .tour-package-single .explore-btn' => 'color: {{VALUE}};',
                ],
            ]
        );
        $this->add_control(
            'astrip_package_with_carousel_style_one_reading_btn_background_color',
            [
                'label'     => esc_html__('Background Color', 'astrip-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .tour-package-single .explore-btn' => 'background: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'astrip_package_with_carousel_style_one_reading_btn_background_hover_color',
            [
                'label'     => esc_html__('Hover Background Color', 'astrip-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .tour-package-single .explore-btn' => 'background: {{VALUE}};',
                ],
            ]
        );


        $this->add_responsive_control(
            'astrip_package_with_carousel_style_one_reading_btn_padding',
            [
                'label'      => __('Padding', 'astrip-core'),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'selectors'  => [
                    '{{WRAPPER}} .tour-package-single .explore-btn' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',

                ],
            ]
        );


        $this->end_controls_section();
    }
    protected function render()
    {

        $settings = $this->get_settings_for_display();
        $query = new \WP_Query(
            array(
                'post_type'      => 'astrip-tour',
                'posts_per_page' => $settings['astrip_package_with_carousel_posts_per_page'],
                'orderby'        => $settings['astrip_package_with_carousel_template_order_by'],
                'order'          => $settings['astrip_package_with_carousel_template_order'],
                'post__in'       => $settings['turio_packages'],
                'offset'         => 0,
                'post_status'    => 'publish'
            )
        );
?>
        <?php if (is_admin()) : ?>
            <script>
                // offer-slider
                var swiper = new Swiper(".offer-slider", {
                    slidesPerView: 1,
                    speed: 1200,
                    spaceBetween: 25,
                    autoplay: true,
                    loop: true,
                    roundLengths: true,
                    pagination: {
                        el: ".swiper-pagination",
                        clickable: 'true',
                    },
                    navigation: false,
                    breakpoints: {
                        280: {
                            slidesPerView: 1,
                            navigation: false,
                        },
                        576: {
                            slidesPerView: 1,
                            navigation: false,
                        },
                        768: {
                            slidesPerView: 2,
                            navigation: false,
                        },
                        992: {
                            slidesPerView: 3
                        },
                        1200: {
                            slidesPerView: 3
                        },
                    }
                });

                // tour-package-selider
                var swiper = new Swiper(".tour-package-selider", {
                    slidesPerView: 1,
                    speed: 1200,
                    spaceBetween: 20,
                    autoplay: true,
                    loop: true,
                    roundLengths: true,
                    pagination: {
                        el: ".swiper-pagination",
                        clickable: 'true',
                    },
                    navigation: {
                        nextEl: ".package1-next",
                        prevEl: ".package1-prev",
                    },
                    breakpoints: {
                        280: {
                            slidesPerView: 1,
                            navigation: false,
                        },
                        386: {
                            slidesPerView: 1,
                            navigation: false,
                        },
                        576: {
                            slidesPerView: 2,
                            navigation: false,
                        },
                        768: {
                            slidesPerView: 2,
                            navigation: false,
                        },
                        992: {
                            slidesPerView: 3
                        },
                        1200: {
                            slidesPerView: 3
                        },
                        1400: {
                            slidesPerView: 4
                        },
                    }
                });
            </script>
        <?php endif ?>

        <?php if (!empty($settings['astrip_package_with_carousel_content_style_selection']) && ($settings['astrip_package_with_carousel_content_style_selection'] == 'style_one')) : ?>
            <div class="offer-section">
                <div class="row">
                    <div class="col-12 ">
                        <div class="swiper offer-slider">
                            <div class="swiper-wrapper">

                                <?php
                                if ($query->have_posts()) {
                                    while ($query->have_posts()) {
                                        $query->the_post();
                                        $product_id = egens_core()->egns_post_meta_box_value(get_the_ID(), EGNS_TOUR_META_ID, 'tour_product');
                                        $duration = isset(get_post_meta(get_the_ID(), 'egns-meta')[0]['tour_duration']) ? get_post_meta(get_the_ID(), 'egns-meta')[0]['tour_duration'] : '';
                                        $show_offer = false;
                                        $get_booking_form_type = egens_core()->egns_post_meta_box_value(get_the_ID(),EGNS_TOUR_META_ID, 'tour_booking_options');
                                        $price_html = '';
                                        if( $get_booking_form_type != 'enquiry_form' ) {
                                            if( class_exists('Woocommerce') && !empty( $product_id ) ) {
                                                $product = wc_get_product( $product_id );
                                                if ( egens_core()->egns_check_sale_price_schedule($product->get_id() ) ) {
                                                    $price_html = '<span>'.'From '.get_woocommerce_currency_symbol().egens_core()->egns_calculate_product_price($product->get_id()).'</span>/' . ' <del>' . get_woocommerce_currency_symbol() . $product->get_regular_price() .  '</del>';
                                                } else {
                                                    $price_html = '<span>'.'From '. get_woocommerce_currency_symbol() .egens_core()->egns_calculate_product_price($product->get_id()).'</span>';
                                                }
                                            }
                                        }else{
                                            if( !empty( egens_core()->egns_post_meta_box_value( get_the_ID(),EGNS_TOUR_META_ID, 'sale_price' ) ) ) {
                                                $price_html = '<span>'.'From '.egens_core()->egns_calculate_product_price().'</span>/' . ' <del>' . egens_core()->egns_post_meta_box_value(get_the_ID(), EGNS_TOUR_META_ID, 'regular_price' ) .  '</del>';
                                    
                                            }else{
                                                $price_html =  egens_core()->egns_calculate_product_price();
                                            }
                                        }
                                    ?>

                                        <div class="swiper-slide">
                                            <div class="offer-single sibling-2">
                                                <?php the_post_thumbnail('egns-img-one', array('class' => 'offer-bg')); ?>
                                                <?php if ($show_offer && !empty($product_id)) : ?>
                                                    <div class="offer-badge">
                                                        <img src="<?php echo get_template_directory_uri() ?>/assets/images/icons/Frame.svg" alt="<?php echo esc_attr('offer-img') ?>">
                                                        <div class="offer-text">
                                                            <h5><span><?php echo egens_core()->egns_calculate_offer_percent($product_id) ?><?php echo esc_html('%') ?></span> <br> <?php echo esc_html__('Off', 'astrip-core') ?></h5>
                                                        </div>
                                                    </div>
                                                <?php endif; ?>
                                                <div class="content">
                                                    <div class="review-area sibling-2">
                                                        <?php if (egens_core()->egns_core_get_avg_rating_by_tour_id(get_the_ID()) > 0) : ?>
                                                            <ul class="star-list">
                                                                <?php
                                                                for ($x = 1; $x <= 5; $x++) {
                                                                    if (egens_core()->egns_core_get_avg_rating_by_tour_id(get_the_ID()) >= $x) {
                                                                        echo wp_kses_post('<li><i class="bi bi-star-fill"></i></li>');
                                                                    } else {
                                                                        echo wp_kses_post('<li><i class="bi bi-star"></i></li>');
                                                                    }
                                                                }
                                                                ?>
                                                            </ul>
                                                            <?php if (egens_core()->egns_core_get_all_rating_count_by_tour_id(get_the_ID()) > 0) : ?>
                                                                <span>(<?php echo egens_core()->egns_core_get_avg_rating_by_tour_id(get_the_ID()); ?> <?php echo egens_core()->egns_core_get_all_rating_count_by_tour_id(get_the_ID()) == 1 ? esc_html__('Review', 'astrip') : esc_html__('Reviews', 'astrip') ?>)</span>
                                                            <?php endif ?>
                                                        <?php endif ?>
                                                    </div>
                                                    <a href="<?php esc_url(the_permalink()) ?>"><?php echo wp_kses(get_the_title(), wp_kses_allowed_html('post')) ?></a>
                                                    <?php if (!empty($product_id)) : ?>
                                                        <span class="tt"><?php echo esc_html($duration . ' / ') ?> <?php echo wp_kses($price_html, wp_kses_allowed_html('post'))  ?></span>
                                                    <?php endif ?>
                                                </div>
                                            </div>
                                        </div>

                                <?php
                                    }
                                }
                                wp_reset_postdata();
                                ?>



                            </div>
                        </div>
                    </div>
                </div>
            </div>
        <?php endif ?>



        <?php if (!empty($settings['astrip_package_with_carousel_content_style_selection']) && ($settings['astrip_package_with_carousel_content_style_selection'] == 'style_two')) : ?>
            <div class="tour-package-section">
                <div class="row justify-content-start align-items-start">
                    <div class="col-lg-6 col-md-8 text-md-start text-center">
                        <div class="section-title2 d-flex flex-column justify-content-center mb-45">
                            <?php if (!empty($settings['astrip_heading_content_sub_title'])) : ?>
                                <span><?php echo esc_html($settings['astrip_heading_content_sub_title']) ?></span>
                            <?php endif ?>
                            <?php if (!empty($settings['astrip_heading_content_main_title'])) : ?>
                                <h2><?php echo wp_kses($settings['astrip_heading_content_main_title'], wp_kses_allowed_html('post')) ?></h2>
                            <?php endif ?>
                        </div>
                    </div>
                    <div class="col-lg-6 col-md-4">
                        <div class="slider-arrows arrows-style-4 text-center d-md-flex d-none flex-row gap-5 justify-content-end align-items-center pt-1">
                            <div class="package1-prev swiper-prev-arrow" tabindex="0" role="button" aria-label="Previous slide" aria-controls="swiper-wrapper-2964f6f3c684a1d1">
                                <i class="bi bi-arrow-left"></i>
                            </div>
                            <div class="package1-next swiper-next-arrow" tabindex="0" role="button" aria-label="Next slide" aria-controls="swiper-wrapper-2964f6f3c684a1d1">
                                <i class="bi bi-arrow-right"></i>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="row">
                    <div class="col-12">
                        <div class="swiper tour-package-selider">
                            <div class="swiper-wrapper">
                                <?php
                                if ($query->have_posts()) {
                                    while ($query->have_posts()) {
                                        $query->the_post();
                                        $product_id = egens_core()->egns_post_meta_box_value(get_the_ID(), EGNS_TOUR_META_ID, 'tour_product');
                                        $get_booking_form_type = egens_core()->egns_post_meta_box_value(get_the_ID(),EGNS_TOUR_META_ID, 'tour_booking_options');
                                        $price_html = '';
                                        if( $get_booking_form_type != 'enquiry_form' ) {
                                            if( class_exists('Woocommerce') && !empty( $product_id ) ) {
                                                $product = wc_get_product( $product_id );
                                                if ( egens_core()->egns_check_sale_price_schedule($product->get_id() ) ) {
                                                    $price_html = '<span>'.'From '.get_woocommerce_currency_symbol().egens_core()->egns_calculate_product_price($product->get_id()).'</span>/' . ' <del>' . get_woocommerce_currency_symbol() . $product->get_regular_price() .  '</del>';
                                                } else {
                                                    $price_html = '<span>'.'From '. get_woocommerce_currency_symbol() .egens_core()->egns_calculate_product_price($product->get_id()).'</span>';
                                                }
                                            }
                                        }else{
                                            if( !empty( egens_core()->egns_post_meta_box_value( get_the_ID(),EGNS_TOUR_META_ID, 'sale_price' ) ) ) {
                                                $price_html = '<span>'.'From '.egens_core()->egns_calculate_product_price().'</span>/' . ' <del>' . egens_core()->egns_post_meta_box_value(get_the_ID(), EGNS_TOUR_META_ID, 'regular_price' ) .  '</del>';
                                    
                                            }else{
                                                $price_html =  egens_core()->egns_calculate_product_price();
                                            }
                                        }

                                    ?>


                                        <div class="swiper-slide">
                                            <div class="tour-package-single">
                                                <?php the_post_thumbnail('', array('class' => '')); ?>
                                                <div class="package-content">
                                                    <a href="<?php the_permalink() ?>">
                                                        <h4><?php the_title() ?></h4>
                                                    </a>
                                                    <p><?php echo wp_trim_words(get_the_content(), 10, '...'); ?></p>
                                                    <?php if (isset($product_id)) : ?>
                                                        <span class="price"> <?php echo wp_kses($price_html, wp_kses_allowed_html('post'))  ?></span>
                                                    <?php endif ?>
                                                </div>
                                                <a href="<?php the_permalink() ?>" class="explore-btn"><?php echo esc_html__('Explore Now', 'astrip-core') ?></a>
                                            </div>
                                        </div>



                                <?php
                                    }
                                }
                                wp_reset_postdata();
                                ?>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        <?php endif ?>

<?php

    }
}

Plugin::instance()->widgets_manager->register(new Astrip_package_with_carousel_Widget());
