<?php

namespace Elementor;

if (!defined('ABSPATH')) {
    exit;
} //Exit if accessed directly

use Elementor\Core\Schemes;

class astrip_instagram_feed_Widget extends Widget_Base
{

    public function get_name()
    {
        return 'egens_instagram_feed';
    }

    public function get_title()
    {
        return esc_html__('EG Instagram Feed', 'astrip-core');
    }

    public function get_icon()
    {
        return 'eicon-instagram-gallery';
    }

    public function get_categories()
    {
        return ['astrip_widgets'];
    }

    protected function register_controls()
    {

        //-------------Content-------------------//
        //stats Section

        $this->start_controls_section(
            'astrip_section_content_general',
            [
                'label' => esc_html__('General', 'astrip-core')

            ]
        );


        $this->add_control(
            'astrip_insta_feed_title',
            [
                'label' => esc_html__('Title', 'astrip-core'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => esc_html__('Instagram Feed', 'astrip-core'),
                'label_block' => true,
            ]
        );
        $this->add_control(
            'inst_access_token',
            [
                'label' => esc_html__('Instagram Access Token', 'astrip-core'),
                'type' => \Elementor\Controls_Manager::TEXTAREA,
                'default' => esc_html__('IGQVJWcU1ENmIxeGFDZA0RfSGlnQ2x5NG85bm9HTGFsU192Sk5rbU9ISjB1ODdZARUJUVlJONUpKWERnU3I5dVNlSnhYYllNM2EzWWR6X2phTVJ5OElPMTgwY0pjbjZArMkMxRWhfSGpsMXJZAX0l4UVNEQgZDZD', 'astrip-core'),
                'label_block' => true,
            ]
        );
        $this->add_control(
            'inst_post_limit',
            [
                'label' => __('Item Limit', 'astrip-core'),
                'type' => Controls_Manager::NUMBER,
                'min' => 1,
                'max' => 200,
                'step' => 1,
                'default' => 8,
                'separator' => 'before',
            ]
        );


        $this->end_controls_section();

        //---------------Style----------------------//


        //Instagram Feed Title Style
        $this->start_controls_section(
            'astrip_instagram_feed_title_style_section',
            [
                'label' => esc_html__('Title', 'astrip-core'),
                'tab'   => Controls_Manager::TAB_STYLE,


            ]
        );
        $this->add_control(
            'astrip_instagram_feed_title_style_color',
            [
                'label'     => esc_html__('Color', 'astrip-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .section-title-small span' => 'color: {{VALUE}};',

                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label'    => esc_html__('Typography', 'astrip-core'),
                'name'     => 'astrip_instagram_feed_title_style_typography',
                'selector' =>
                '{{WRAPPER}} .section-title-small span',



            ]
        );
        $this->add_responsive_control(
            'astrip_instagram_feed_title_style_margin',
            [
                'label' => esc_html__('Margin', 'astrip-core'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors' => [
                    '{{WRAPPER}} .section-title-small span' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->end_controls_section();
        //Instagram Feed Icon Style
        $this->start_controls_section(
            'astrip_instagram_feed_icon_style_section',
            [
                'label' => esc_html__('Instagram Icon', 'astrip-core'),
                'tab'   => Controls_Manager::TAB_STYLE,


            ]
        );
        $this->add_control(
            'astrip_instagram_feed_icon_style_color',
            [
                'label'     => esc_html__('Color', 'astrip-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .section-title-small i' => 'color: {{VALUE}};',

                ],
            ]
        );
        $this->add_responsive_control(
            'astrip_instagram_feed_icon_style_ize',
            [
                'label' => esc_html__('Icon Size', 'astrip-core'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['px'],
                'range' => [
                    'px' => [
                        'min' => 10,
                        'max' => 100,
                        'step' => 1,
                    ],
                ],
                'default' => [
                    'unit' => 'px',

                ],
                'selectors' => [
                    '{{WRAPPER}} .section-title-small i' => 'font-size: {{SIZE}}{{UNIT}}',
                ],
            ]
        );
        $this->end_controls_section();
    }

    protected function render()
    {
        $settings = $this->get_settings_for_display();
        // query the user media
        $fields = "id,caption,media_type,media_url,permalink,thumbnail_url,timestamp,username";
        $token = !empty($settings['inst_access_token']) ? $settings['inst_access_token'] : '';
        $limit = !empty($settings['inst_post_limit']) ? $settings['inst_post_limit'] : '';

        $json_feed_url = "https://graph.instagram.com/me/media?fields={$fields}&access_token={$token}&limit={$limit}";
        $json_feed = @file_get_contents($json_feed_url);
        $contents = json_decode($json_feed, true, 512, JSON_BIGINT_AS_STRING);

?>
        <?php if (is_admin()) : ?>
            <script>
                // insta-feed-slider
                var swiper = new Swiper(".insta-feed-slider", {
                    // slidesPerView: 1,
                    // speed: 800,
                    freeMode: true,
                    spaceBetween: 0,
                    // grabCursor: true,
                    slidesPerView: 7,
                    loop: true,
                    autoplay: {
                        delay: 1,
                        disableOnInteraction: true
                    },
                    freeMode: true,
                    speed: 5000,
                    freeModeMomentum: false,
                    pagination: {
                        el: ".swiper-pagination",
                        clickable: 'true',
                    },
                    breakpoints: {
                        280: {
                            slidesPerView: 1,
                            navigation: false,
                        },
                        386: {
                            slidesPerView: 2,
                            navigation: false,
                        },
                        576: {
                            slidesPerView: 3,
                            navigation: false,
                        },
                        768: {
                            slidesPerView: 4,
                            navigation: false,
                        },
                        992: {
                            slidesPerView: 5
                        },
                        1200: {
                            slidesPerView: 7
                        },
                        1400: {
                            slidesPerView: 7
                        },
                    }
                });
            </script>
        <?php endif ?>
        <?php if (!empty($contents['data'])) : ?>
            <div class="instagram-feed-section">
                <div class="container">
                    <div class="row justify-content-lg-start justify-content-center">
                        <div class="col-lg-4">
                            <?php if (!empty($settings['astrip_insta_feed_title'])) : ?>
                                <div class="section-title-small text-lg-start text-center">
                                    <i class="bi bi-instagram"></i><span><?php echo esc_html($settings['astrip_insta_feed_title']) ?></span>
                                </div>
                            <?php endif ?>
                        </div>
                    </div>
                </div>
                <div class="container-fluid px-0">
                    <div class="swiper insta-feed-slider">
                        <div class="swiper-wrapper">
                            <?php if (!empty($contents['data'])) : ?>
                                <?php foreach ((array) $contents["data"] as $post) : ?>
                                    <div class="swiper-slide">
                                        <?php if (!empty($post['media_url'])) : ?>
                                            <div class="insta-feed-single">
                                                <img src="<?php echo esc_url($post['media_url']) ?>" alt="<?php echo esc_attr('insta-feed') ?>">
                                            </div>
                                        <?php endif ?>
                                    </div>
                                <?php endforeach ?>
                            <?php endif ?>
                        </div>
                    </div>
                </div>
            </div>
        <?php endif ?>
<?php
    }
}

Plugin::instance()->widgets_manager->register(new astrip_instagram_feed_Widget());
