<?php

namespace Elementor;

if (!defined('ABSPATH')) exit; // Exit if accessed directly

use Elementor\core\Schemes;

class Astrip_Feature_Widget extends Widget_Base
{

    public function get_name()
    {
        return 'astrip_feature';
    }

    public function get_title()
    {
        return esc_html__('EG Feature', 'astrip-core');
    }

    public function get_icon()
    {
        return 'eicon-featured-image';
    }

    public function get_categories()
    {
        return ['astrip_widgets'];
    }

    protected function register_controls()
    {
        //Content Section Start
        $this->start_controls_section(
            'astrip_feature_content_general_section',
            [
                'label' => esc_html__('General', 'astrip-core')
            ]
        );
        
        $this->add_control(
            'astrip_feature_content_style_selection',
            [
                'label'   => esc_html__('Select Style', 'astrip-core'),
                'type'    => Controls_Manager::SELECT,
                'options' => [
                    'style_one' => esc_html__('Style One', 'astrip-core'),
                    'style_two' => esc_html__('Style Two', 'astrip-core'),
                ],
                'default' => 'style_one',
            ]
        );
        $this->end_controls_section();
        //Image Content
        $this->start_controls_section(
            'astrip_feature_content_image_section',
            [
                'label' => esc_html__( 'Feature Image', 'astrip-core' ),
                'condition' => [
                    'astrip_feature_content_style_selection' => 'style_one'
                ],              
            ]
        );

        $this->add_control(
            'astrip_feature_content_image',
            [
                'label' => esc_html__( 'Feature Image', 'astrip-core' ),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'default' => [
                    'url' => \Elementor\Utils::get_placeholder_image_src(),
                ],
            ]
        );
        $this->end_controls_section();
        //Sub Title Content
        $this->start_controls_section(
            'astrip_feature_content_sub_title_section',
            [
                'label' => esc_html__('Sub Title', 'astrip-core')
            ]
        );
        $this->add_control(
            'astrip_feature_content_sub_title',
            [
                'label' => esc_html__('Sub Title', 'astrip-core'),
                'type' => Controls_Manager::TEXT,
                'default' => esc_html__('Why We Are Awesome!', 'astrip-core'),
                'label_block' => true,
            ]
        );
        $this->end_controls_section();
        //Main Title Content
        $this->start_controls_section(
            'astrip_feature_content_main_title_section',
            [
                'label' => esc_html__('Main Title', 'astrip-core')
            ]
        );
        $this->add_control(
            'astrip_feature_content_main_title',
            [
                'label' => esc_html__('Main Title', 'astrip-core'),
                'type' => Controls_Manager::TEXTAREA,
                'default' => esc_html__('We are Professional Planners For your Vacations', 'astrip-core'),
                'label_block' => true,
            ]
        );
        $this->end_controls_section();
        //Description Content
        $this->start_controls_section(
            'astrip_feature_content_description_section',
            [
                'label' => esc_html__('Description', 'astrip-core'),
            ],
            
        );
        $this->add_control(
            'astrip_feature_content_description',
            [
                'label' => esc_html__('Description', 'astrip-core'),
                'type' => Controls_Manager::TEXTAREA,
                'default' => esc_html__('Lorem ipsum dolor sit amet, consectetur adi- piscing elit. sed do eiusmod tempor incididunt ut labore et dolore magna aliqua.', 'astrip-core'),
                'label_block' => true,
            ],
        );
        $this->end_controls_section();
        //Feature Lists Content
        $this->start_controls_section(
			'astrip_feature_content_list_content_section',
			[
				'label' => esc_html__( 'Feature Lists', 'astrip-core' ),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);
        $repeater = new \Elementor\Repeater();

        $repeater->add_control(
            'astrip_feature_content_list_content',
            [
                'label' => esc_html__('', 'astrip-core'),
                'type' => Controls_Manager::TEXTAREA,
                'default' => esc_html__('Best Rate Gurantee', 'astrip-core'),
                'label_block' => true,
            ],
        );
        $this->add_control(
			'feature_list_content',
			[
				'label' => esc_html__( 'List Content', 'astrip-core' ),
				'type' => \Elementor\Controls_Manager::REPEATER,
				'fields' => $repeater->get_controls(),
				'default' => [
					[
						'astrip_feature_content_list_content' => esc_html__( 'Best Rate Gurantee', 'astrip-core' ),
						'list_content' => esc_html__( 'Item content. Click the edit button to change this text.', 'astrip-core' ),
					],
					[
						'astrip_feature_content_list_content' => esc_html__( 'Diverse Destinations', 'astrip-core' ),
						'list_content' => esc_html__( 'Item content. Click the edit button to change this text.', 'astrip-core' ),
					],
                    [
						'astrip_feature_content_list_content' => esc_html__( 'Various Adventures', 'astrip-core' ),
						'list_content' => esc_html__( 'Item content. Click the edit button to change this text.', 'astrip-core' ),
					],
                    [
						'astrip_feature_content_list_content' => esc_html__( 'Free Fast Booking', 'astrip-core' ),
						'list_content' => esc_html__( 'Item content. Click the edit button to change this text.', 'astrip-core' ),
					],
                    [
						'astrip_feature_content_list_content' => esc_html__( 'Complete Guide Line', 'astrip-core' ),
						'list_content' => esc_html__( 'Item content. Click the edit button to change this text.', 'astrip-core' ),
					],
				],
				'title_field' => '{{{ astrip_feature_content_list_content }}}',
			]
		);
        $this->end_controls_section();
        //Button Content
        $this->start_controls_section(
            'astrip_feature_content_button_section',
            [
                'label' => esc_html__('Feature Button', 'astrip-core')
            ]
        );
        
        $this->add_control(
            'astrip_feature_content_button_text',
            [
                'label' => esc_html__('Button Text', 'astrip-core'),
                'type' => Controls_Manager::TEXT,
                'default' => esc_html__('Explore Now', 'astrip-core'),
                'label_block' => true,
          
            ]
        );
        $this->add_control(
			'astrip_feature_content_button_url',
			[
				'label' => esc_html__( 'Button URL', 'astrip-core' ),
				'type' => \Elementor\Controls_Manager::URL,
				'placeholder' => esc_html__( 'https://your-link.com', 'astrip-core' ),
				'options' => [ 'url', 'is_external', 'nofollow' ],
				'default' => [
					'url' => '',
					'is_external' => true,
					'nofollow' => true,
					// 'custom_attributes' => '',
				],
				'label_block' => true,
			]
		);
        $this->add_responsive_control(
			'astrip_feature_content_button_align',
			[
				'label' 		=> esc_html__( 'Button Align', 'astrip-core' ),
				'type' 			=> \Elementor\Controls_Manager::CHOOSE,
				'options' 		=> [
					'left' 		=> [
						'title' => esc_html__( 'Left', 'astrip-core' ),
						'icon' 	=> 'eicon-text-align-left',
					],
					'center' 	=> [
						'title' => esc_html__( 'Center', 'astrip-core' ),
						'icon' 	=> 'eicon-text-align-center',
					],
					'right' 	=> [
						'title' => esc_html__( 'Right', 'astrip-core' ),
						'icon' 	=> 'eicon-text-align-right',
					],
					'justify' 	=> [
						'title' => esc_html__( 'Justified', 'astrip-core' ),
						'icon' 	=> 'eicon-text-align-justify',
					],
				],
				'default' 		=> 'left',
				'selectors' 	=> [
					'{{WRAPPER}} .btn-align  ' 	=> 'text-align: {{VALUE}};',     
				],
			]
		);
        $this->end_controls_section(); 
        //Image Style Two
        $this->start_controls_section(
            'astrip_feature_content_style_two_image_section',
            [
                'label' => esc_html__( 'Feature Images', 'astrip-core' ),
                'condition' => [
                    'astrip_feature_content_style_selection' => 'style_two'
                ],              
            ]
        );
        $this->add_control(
			'astrip_feature_content_image_aeroplane_icon',
			[
				'label' => esc_html__( 'Feature Icon', 'astrip-core' ),
				'type' => \Elementor\Controls_Manager::ICONS,
				'default' => [
					'value' => '',
					'library' => '',
				],
			]
		);
        $this->add_control(
            'astrip_feature_content_image_one',
            [
                'label' => esc_html__( 'Feature Image One', 'astrip-core' ),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'default' => [
                    'url' => \Elementor\Utils::get_placeholder_image_src(),
                ],
            ]
        );
        $this->add_control(
            'astrip_feature_content_image_two',
            [
                'label' => esc_html__( 'Feature Image Two', 'astrip-core' ),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'default' => [
                    'url' => \Elementor\Utils::get_placeholder_image_src(),
                ],
            ]
        );

        $this->end_controls_section();
        //End Content section
        //Style Section Start
        $this->start_controls_section(
            'astrip_feature_style_one_general_section',
            [
                'label' => esc_html__('General', 'astrip-core'),
                'tab'   => Controls_Manager::TAB_STYLE,
                'condition' => [
                    'astrip_feature_content_style_selection' => 'style_one'
                ], 
            ]
        );
        $this->add_group_control(
			\Elementor\Group_Control_Background::get_type(),
			[
				'name' => 'astrip_feature_style_one_section_background',
				'label' => esc_html__( 'Background', 'astrip-core' ),
				'types' => [ 'classic', 'gradient', 'video' ],
				'selector' => '{{WRAPPER}} .feature-section',
                'fields_options' => [
                    'background' => [
                        'label' => esc_html__('Background (Image/Color)', 'astrip-core'),
                    ],
                    'color' => [
                        'default' => '',
                    ],
                ],
			]
		);
        
        $this->end_controls_section();
        $this->start_controls_section(
            'astrip_feature_style_two_general_section',
            [
                'label' => esc_html__('General', 'astrip-core'),
                'tab'   => Controls_Manager::TAB_STYLE,
                'condition' => [
                    'astrip_feature_content_style_selection' => 'style_two'
                ], 
            ]
        );
        $this->add_control(
            'astrip_feature_style_two_general_background',
            [
                'label'     => esc_html__('Background Color', 'astrip-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .feature-section2 ' => 'background: {{VALUE}};',
                ],
            ]
        );
        
        $this->end_controls_section();
        //Sub Title Style 
        $this->start_controls_section(
            'astrip_feature_style_sub_title_section',
            [
                'label' => esc_html__('Sub Title', 'astrip-core'),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control(
            'astrip_feature_style_sub_title_color',
            [
                'label'     => esc_html__('Color', 'astrip-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .feature-section .feature-content span' => 'color: {{VALUE}};',
                    '{{WRAPPER}} .about3-title > span' => 'color: {{VALUE}};',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label'    => esc_html__('Typography', 'astrip-core'),
                'name'     => 'astrip_feature_style_sub_title_typography',
                'selector' => '{{WRAPPER}} .feature-section .feature-content span, .about3-title > span',

            ]
        );
        $this->add_responsive_control(
            'astrip_feature_style_sub_title_padding',
            [
                'label'      => __('Padding', 'astrip-core'),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'selectors'  => [
                    '{{WRAPPER}} .feature-section .feature-content span' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    '{{WRAPPER}} .about3-title > span' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    
                ],
            ]
        );
        $this->add_responsive_control(
            'astrip_feature_style_sub_title_margin',
            [
                'label' => esc_html__( 'Margin', 'astrip-core' ),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%', 'em' ],
                'selectors' => [
                    '{{WRAPPER}} .feature-section .feature-content span' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    '{{WRAPPER}} .about3-title > span' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->end_controls_section();
        //Title Style
        $this->start_controls_section(
            'astrip_feature_style_main_title_section',
            [
                'label' => esc_html__('Main Title', 'astrip-core'),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control(
            'astrip_feature_style_main_title_color',
            [
                'label'     => esc_html__('Color', 'astrip-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .feature-section .feature-content h2' => 'color: {{VALUE}};',
                    '{{WRAPPER}} .about3-title h2' => 'color: {{VALUE}};',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label'    => esc_html__('Typography', 'astrip-core'),
                'name'     => 'astrip_feature_style_main_title_typography',
                'selector' => '{{WRAPPER}} .feature-section .feature-content h2, .about3-title h2',

            ]
        );
        $this->add_responsive_control(
            'astrip_feature_style_main_title_padding',
            [
                'label'      => __('Padding', 'astrip-core'),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'selectors'  => [
                    '{{WRAPPER}} .feature-section .feature-content h2' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    '{{WRAPPER}} .about3-title h2' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    
                ],
            ]
        );
        $this->add_responsive_control(
            'astrip_feature_style_main_title_margin',
            [
                'label' => esc_html__( 'Margin', 'astrip-core' ),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%', 'em' ],
                'selectors' => [
                    '{{WRAPPER}} .feature-section .feature-content h2' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    '{{WRAPPER}} .about3-title h2' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->end_controls_section();
        //Description Style
        $this->start_controls_section(
            'astrip_feature_style_description_section',
            [
                'label' => esc_html__('Description', 'astrip-core'),
                'tab'   => Controls_Manager::TAB_STYLE,
            ],
            
        );
        $this->add_control(
            'astrip_feature_style_description_color',
            [
                'label'     => esc_html__('Color', 'astrip-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .para' => 'color: {{VALUE}};',
                    '{{WRAPPER}} .about3-title p' => 'color: {{VALUE}};',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label'    => esc_html__('Typography', 'astrip-core'),
                'name'     => 'astrip_feature_style_description_typography',
                'selector' => '{{WRAPPER}} .para, .about3-title p',

            ]
        );
        $this->add_responsive_control(
            'astrip_feature_style_description_padding',
            [
                'label'      => __('Padding', 'astrip-core'),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'selectors'  => [
                    '{{WRAPPER}} .para' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    '{{WRAPPER}} .about3-title p' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    
                ],
            ]
        );
        $this->add_responsive_control(
            'astrip_feature_style_description_margin',
            [
                'label' => esc_html__( 'Margin', 'astrip-core' ),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%', 'em' ],
                'selectors' => [
                    '{{WRAPPER}} .para' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    '{{WRAPPER}} .about3-title p' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->end_controls_section();
        //Feature Lists Content Style
        $this->start_controls_section(
            'astrip_feature_style_list_content_section',
            [
                'label' => esc_html__('Feature Lists', 'astrip-core'),
                'tab'   => Controls_Manager::TAB_STYLE,
            ],
            
        );
        $this->add_control(
            'astrip_feature_style_list_content_marker_color',
            [
                'label'     => esc_html__('Marker Color', 'astrip-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .feature3-list li::marker' => 'color: {{VALUE}};',
                ],
                'condition' => [
                    'astrip_feature_content_style_selection' => 'style_two'
                ],  
            ]
        );
        $this->add_control(
            'astrip_feature_style_list_content_arrow_icon_color',
            [
                'label'     => esc_html__('Arrow Icon Color', 'astrip-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .feature-section .feature-content ul.feature-list li svg' => 'fill: {{VALUE}};',
                ],
                'condition' => [
                    'astrip_feature_content_style_selection' => 'style_one'
                ],  
            ]
        );
        $this->add_control(
            'astrip_feature_style_list_content_color',
            [
                'label'     => esc_html__('Text Color', 'astrip-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .feature-section .feature-content ul.feature-list li' => 'color: {{VALUE}};',
                    '{{WRAPPER}} .feature3-list li' => 'color: {{VALUE}};',
                ],
            ]
        );
        $this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'astrip_feature_style_list_content_style_one_typography',
				'selector' => '{{WRAPPER}} .feature-section .feature-content ul.feature-list li',
                'condition' => [
                    'astrip_feature_content_style_selection' => 'style_one'
                ], 
			]
		);
        $this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'astrip_feature_style_list_content_style_two_typography',
				'selector' => '{{WRAPPER}} .feature3-list li',
                'condition' => [
                    'astrip_feature_content_style_selection' => 'style_two'
                ], 
			]
		);
        $this->add_responsive_control(
            'astrip_feature_style_list_content_padding',
            [
                'label'      => __('Padding', 'astrip-core'),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'selectors'  => [
                    '{{WRAPPER}} .feature-section .feature-content ul.feature-list li' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    '{{WRAPPER}} .feature3-list li' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    
                ],
            ]
        );
        $this->add_responsive_control(
            'astrip_feature_style_list_content_margin',
            [
                'label' => esc_html__( 'Margin', 'astrip-core' ),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%', 'em' ],
                'selectors' => [
                    '{{WRAPPER}} .feature-section .feature-content ul.feature-list li' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    '{{WRAPPER}} .feature3-list li' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->end_controls_section();
        //Button Style
       $this->start_controls_section(
        'astrip_feature_style_button_section',
        [
            'label' => esc_html__('Feature Button', 'astrip-core'),
            'tab'   => Controls_Manager::TAB_STYLE,
        ]
        );
        $this->start_controls_tabs(
            'style_tabs'
        );

        $this->start_controls_tab(
            'style_normal_tab',
            [
                'label' => esc_html__( 'Normal', 'astrip-core' ),
            ]
        );
        $this->add_control(
            'astrip_feature_style_button_text_color',
            [
                'label'     => esc_html__('Text Color', 'astrip-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .btn--primary2' => 'color: {{VALUE}};',
                    '{{WRAPPER}} .btn--primary3-outline.sibling-2' => 'color: {{VALUE}};',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label'    => esc_html__('Typography', 'astrip-core'),
                'name'     => 'astrip_feature_style_button_typography',
                'selector' => '{{WRAPPER}} .btn--lg ',

            ]
        );
        $this->add_control(
            'astrip_feature_style_button_background',
            [
                'label'     => esc_html__('Background Color', 'astrip-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .btn--primary2' => 'background: {{VALUE}};', 
                    '{{WRAPPER}} .btn--primary3-outline' => 'background: {{VALUE}};',
                ],
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Border::get_type(),
            [
                'name' => 'astrip_feature_style_button_border',
                'label' => esc_html__( 'Border', 'astrip-core' ),
                'selector' => '{{WRAPPER}} .btn--primary2, .btn--primary3-outline',
            ]
        );
        $this->add_responsive_control(
            'astrip_feature_style_button_border_radius',
            [
            'astrip_feature_style_button_border_radius',
                'label'      		=> __('Border Radius', 'astrip-core'),
                'type'       		=> Controls_Manager::DIMENSIONS,
                'size_units' 		=> ['px', '%'],
                'selectors'  		=> [
                    '{{WRAPPER}} .btn--primary2' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    '{{WRAPPER}} .btn--primary2::after' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    '{{WRAPPER}} .btn--primary3-outline' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    '{{WRAPPER}} .btn--primary3-outline::after' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
        
            ]

        );
        $this->add_responsive_control(
            'astrip_feature_style_button_padding',
            [
                'label'      => __('Padding', 'astrip-core'),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'selectors'  => [
                    '{{WRAPPER}} .btn--lg' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',   
                    
                ],
            ]
        );
        $this->add_responsive_control(
            'astrip_feature_style_button_margin',
            [
                'label' => esc_html__( 'Margin', 'astrip-core' ),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%', 'em' ],
                'selectors' => [
                    '{{WRAPPER}} .btn--lg' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->end_controls_tab();
        //Hover start

        $this->start_controls_tab(
            'style_hover_tab',
            [
                'label' => esc_html__( 'Hover', 'astrip-core' ),
            ]
        );
        $this->add_control(
            'astrip_feature_style_button_hover_color',
            [
                'label' => esc_html__( 'Text Color', 'astrip-core' ),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .btn--primary2:hover' => 'color: {{VALUE}}',
                    '{{WRAPPER}} .btn--primary3-outline:hover' => 'color: {{VALUE}}',
                ],

        
            ]
        );
        $this->add_control(
            'astrip_feature_style_button_hover_background',
            [
                'label' => esc_html__( 'Background Color', 'astrip-core' ),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .btn--primary2::after' => 'background: {{VALUE}}',
                    '{{WRAPPER}} .btn--primary3-outline.sibling-2::after' => 'background: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Border::get_type(),
            [
                'name' => 'astrip_feature_style_button_hover_border',
                'label' => esc_html__( 'Border', 'astrip-core' ),
                'selector' => '{{WRAPPER}} .btn--primary2:hover',
            ]
        );
        $this->end_controls_tab();
        $this->end_controls_tab();
        $this->end_controls_section();
        
    }
    protected function render()
    {
        $settings = $this->get_settings_for_display();
        $items=$settings['feature_list_content'];
        if ( ! empty( $settings['astrip_feature_content_button_url']['url'] ) ) {
			$this->add_link_attributes( 'astrip_feature_content_button_url', $settings['astrip_feature_content_button_url'] );
		}
        ?>
            
            <?php if( !empty( $settings['astrip_feature_content_style_selection'] ) && ($settings['astrip_feature_content_style_selection'] == 'style_one') )  : ?> 
                <div class="feature-section">
                    <div class="container-xl container-lg-fluid container">
                        <div class="row align-items-center">
                            <div class="col-lg-6 d-lg-block d-none">
                                <?php if( !empty( $settings['astrip_feature_content_image']['url'] ) ) : ?>
                                    <div class="feature-image">
                                        <img src="<?php echo esc_url($settings['astrip_feature_content_image']['url']) ?>" class="img-fluid" alt="<?php echo esc_attr('feature-image','astrip-core') ?>">
                                    </div>
                                <?php endif ?>
                            </div>
                            <div class="col-lg-6">
                                <div class="feature-content">
                                <?php if( !empty( $settings['astrip_feature_content_sub_title'] ) ) : ?>
                                    <span><?php echo esc_html($settings['astrip_feature_content_sub_title']) ?></span>
                                <?php endif ?>
                                <?php if( !empty( $settings['astrip_feature_content_main_title'] ) ) : ?>
                                    <h2><?php echo esc_html($settings['astrip_feature_content_main_title']) ?></h2>
                                <?php endif ?>
                                <?php if( !empty( $settings['astrip_feature_content_description'] ) ) : ?>
                                    <p class="para"><?php echo wp_kses($settings['astrip_feature_content_description'], wp_kses_allowed_html('post')) ?></p>
                                <?php endif ?>
                                    <ul class="feature-list">
                                        <?php foreach($items as $item): ?>
                                            <?php if( !empty( $item['astrip_feature_content_list_content'] ) ) : ?>                                                          
                                                <li><svg width="20" height="16" viewBox="0 0 20 16"  xmlns="http://www.w3.org/2000/svg">
                                                <path d="M12.1406 0.358092C11.5234 0.557311 11.0469 1.03387 10.8594 1.64325C10.7852 1.88153 10.7812 2.01044 10.7812 4.4284V6.96356H5.65625H0.535156L0.367187 7.06122C0.121094 7.20575 0 7.43231
                                                 0 7.74481C0 8.05731 0.121094 8.28387 0.367187 8.4284L0.535156
                                                8.52606L5.88281 8.51825L11.2305 8.50653L11.4648 8.39325C11.9375
                                                8.15887 12.2656 7.70575 12.3437 7.1784C12.3633 7.02215 12.3828
                                                5.88934 12.3828 4.49872V2.09247L12.4805 1.9909C12.5937 1.87762
                                                12.7227 1.84637 12.8555 1.89325C12.9883 1.94012 18.2305 7.18622
                                                18.3242 7.362C18.4219 7.5534 18.4219 7.85809 18.3242 8.0495C18.2812
                                                8.12762 17.0586 9.38153 15.5781 10.862C12.9141 13.5222 12.9102 13.5261
                                                12.75 13.5261C12.6289 13.5261 12.5625 13.5026 12.4883 13.4245L12.3906
                                                13.3268L12.375 12.3034C12.3633 11.3464 12.3555 11.2682 12.2773 11.1237C12.1836
                                                10.9479 12.1055 10.8659 11.9336 10.78C11.5469 10.5847 11.0781 10.7214 10.8711
                                                11.0847C10.7852 11.237 10.7812 11.2722 10.7812 12.3776C10.7812 13.405 10.7891
                                                13.5417 10.8594 13.7682C11.0469 14.3815 11.5352 14.8659 12.1602 15.0573C12.3828 15.1237
                                                12.5 15.1354 12.8555 15.1198C13.2578 15.1042 13.2969 15.0925 13.6016 14.9401C13.9219
                                                14.7839 13.9648 14.7448 16.7812 11.9167C19.4414 9.24481 19.6406 9.03387 19.7578 
                                                8.78778C19.9609 8.35809 20.0117 8.10419 19.9922 7.58856C19.9727 7.10028 19.8867 6.8034 
                                                19.6641 6.44794C19.5195 6.22137 14.1055 0.772155 13.8516 0.596374C13.5273 0.377624 13.2031 
                                                0.283874 12.7539 0.28778C12.4883 0.28778 12.293 0.311217 12.1406 0.358092Z"/>
                                            </svg>  <?php echo esc_html($item['astrip_feature_content_list_content']) ?></li>
                                            <?php endif ?>
                                        <?php endforeach ?>
                                    </ul>
                                    <?php if( !empty( $settings['astrip_feature_content_button_text']) ) : ?>
                                        <div class="btn-align">
                                            <a <?php echo $this->get_render_attribute_string( 'astrip_feature_content_button_url' ); ?> class="eg-btn btn--primary2 btn--lg">
                                                <?php echo esc_html($settings['astrip_feature_content_button_text'],'astrip-core'); ?>
                                            </a>
                                        </div>
                                    <?php endif ?>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            <?php endif ?>
            <?php if( !empty( $settings['astrip_feature_content_style_selection'] ) && ($settings['astrip_feature_content_style_selection'] == 'style_two') )  : ?> 
                <div class="feature-section2 ">
                    <div class="row justify-content-center">
                        <div class="col-lg-6 ps-lg-5">
                            <div class="about3-title text-start">
                                <?php if( !empty( $settings['astrip_feature_content_sub_title'] ) ) : ?>
                                    <span><?php echo esc_html($settings['astrip_feature_content_sub_title']) ?></span>
                                <?php endif ?>
                                <?php if( !empty( $settings['astrip_feature_content_main_title'] ) ) : ?>
                                    <h2><?php echo esc_html($settings['astrip_feature_content_main_title']) ?></h2>
                                <?php endif ?>
                                <?php if( !empty( $settings['astrip_feature_content_description'] ) ) : ?>
                                    <p><?php echo wp_kses($settings['astrip_feature_content_description'], wp_kses_allowed_html('post')) ?></p>
                                <?php endif ?>
                            </div>
                            <ul class="feature3-list">
                                <?php foreach($items as $item): ?>
                                    <?php if( !empty( $item['astrip_feature_content_list_content'] ) ) : ?>
                                        <li><?php echo esc_html($item['astrip_feature_content_list_content']) ?></li>
                                    <?php endif ?>
                                <?php endforeach ?>
                            </ul>
                            <?php if( !empty( $settings['astrip_feature_content_button_text']) ) : ?>
                                <div class="btn-align">
                                    <a <?php echo $this->get_render_attribute_string( 'astrip_feature_content_button_url' ); ?> class="eg-btn btn--primary3-outline sibling-2 btn--lg">
                                        <?php echo esc_html($settings['astrip_feature_content_button_text'],'astrip-core'); ?>
                                    </a>
                                </div>
                            <?php endif ?> 
                        </div>
                        <div class="col-lg-6">
                            <div class="feature-image-group d-flex flex-row justify-content-center gap-5">
                                <?php if( !empty( $settings['astrip_feature_content_image_aeroplane_icon']) ) : ?>
                                    <div class="feature3-icon">
                                        <?php \Elementor\Icons_Manager::render_icon( $settings['astrip_feature_content_image_aeroplane_icon'], [ 'aria-hidden' => 'true' ] ); ?>
                                    </div>
                                <?php endif ?>
                                <?php if( !empty( $settings['astrip_feature_content_image_one']['url'] ) ) : ?>
                                    <div class="feature-image">
                                        <img src="<?php echo esc_url($settings['astrip_feature_content_image_one']['url']) ?>" class="img-fluid" alt="<?php echo esc_attr('feature-image-one','astrip-core') ?>">
                                    </div>
                                <?php endif ?>
                                <?php if( !empty( $settings['astrip_feature_content_image_two']['url'] ) ) : ?>
                                    <div class="feature-image translate-y">
                                        <img src="<?php echo esc_url($settings['astrip_feature_content_image_two']['url']) ?>" class="img-fluid" alt="<?php echo esc_attr('feature-image-one','astrip-core') ?>">
                                    </div>
                                <?php endif ?>
                            </div>
                        </div>
                    </div>
                </div>
            <?php endif ?>

        <?php 
        
    }
}

Plugin::instance()->widgets_manager->register(new Astrip_Feature_Widget());
