<?php

namespace Elementor;

if (!defined('ABSPATH')) {
    exit;
} //Exit if accessed directly

use Elementor\Core\Schemes;

class astrip_counter_Widget extends Widget_Base
{

    public function get_name()
    {
        return 'egens_counter';
    }

    public function get_title()
    {
        return esc_html__('EG Counter', 'astrip-core');
    }

    public function get_icon()
    {
        return 'eicon-counter';
    }

    public function get_categories()
    {
        return ['astrip_widgets'];
    }

    protected function register_controls()
    {

        //-------------Content-------------------//
        //counter Section

        $this->start_controls_section(
            'astrip_counter_section_content_general',
            [
                'label' => esc_html__('General', 'astrip-core')
                
            ]
        );


        $this->add_control(
            'astrip_counter_style_column',
            [
                'label'   => esc_html__('Column', 'astrip-core'),
                'type'    => Controls_Manager::SELECT,
                'options' => [
                    'column_two'  => esc_html__('2', 'astrip-core'),
                    'column_three' => esc_html__('3', 'astrip-core'),
                    'column_four' => esc_html__('4', 'astrip-core'),
                    'column_six' => esc_html__('6', 'astrip-core'),
                ],
                'default' => 'column_four',
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'astrip_section_content_counter',
            [
                'label' => esc_html__('Counter List', 'astrip-core')
                
            ]
        );

        // Repeater
        $repeater = new \Elementor\Repeater();
       
        // counter text
        $repeater->add_control(
            'astrip_content_counter_text',
            [
                'label' => esc_html__( 'Text', 'astrip-core' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'rows' => 15,
                'default' => esc_html__( 'Awesome Tour', 'astrip-core' ),
                'label_block' => true,            
            ]
        );

         // counter number
         $repeater->add_control(
            'astrip_content_counter_number', 
            [
                'label' => esc_html__( 'Number', 'astrip-core' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => esc_html__( '400' , 'astrip-core' ),
                'label_block' => true,           
            ]
        );

        $repeater->add_control(
            'astrip_content_counter_icon',
            [
                'label' => esc_html__( 'Icon', 'astrip-core' ),
                'type' => \Elementor\Controls_Manager::ICONS,
                'default' => [
                    'value' => 'fas fa-circle',
                    'library' => 'fa-solid',
                ],
                
            ]
        );

        
        $this->add_control(
            'astrip_counter_content_list',
            [
                'label' => esc_html__( 'Counters', 'astrip-core' ),
                'type' => \Elementor\Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
                'default' => [
                    [
                        'astrip_content_counter_text' => esc_html__( 'Awesome Tour ', 'astrip-core' ),
                    ],

                ],
                'title_field' => '{{{ astrip_content_counter_text }}}',
            ]
        );
        
        $this->end_controls_section();

        //---------------Style----------------------//

        //Number Style
        $this->start_controls_section(
            'astrip_counter_number_style_section',
            [
                'label' => esc_html__('Number', 'astrip-core'),
                'tab'   => Controls_Manager::TAB_STYLE,
                
                
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label'    => esc_html__('Typography', 'astrip-core'),
                'name'     => 'astrip_counter_number_style_typography',
                'selector' => 
                    '{{WRAPPER}} .counter-single .coundown h3',
 
            ]
        );

        $this->add_control(
            'astrip_counter_number_style_title_color',
            [
                'label'     => esc_html__('Color', 'astrip-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .counter-single .coundown h3' => 'color: {{VALUE}};',

                ],
            ]
        );
        
        $this->add_responsive_control(
            'astrip_counter_number_style_title_margin',
            [
                'label' => esc_html__( 'Margin', 'astrip-core' ),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%', 'em' ],
                'selectors' => [
                    '{{WRAPPER}} .counter-single .coundown h3' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->end_controls_section();

         //plus icon Style
         $this->start_controls_section(
            'astrip_counter_plus_icon_style_section',
            [
                'label' => esc_html__('Plus(+) Icon', 'astrip-core'),
                'tab'   => Controls_Manager::TAB_STYLE,
                
                
            ]
        );

        $this->add_control(
            'astrip_counter_plus_icon_style_color',
            [
                'label'     => esc_html__('Color', 'astrip-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .bi-plus-lg::before' => 'color: {{VALUE}};',

                ],
            ]
        );

        $this->add_control(
            'astrip_counter_plus_icon_size_style',
            [
                'label' => esc_html__( 'Size', 'astrip-core' ),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => [ 'px','rem' ],
                'range' => [
                    'px' => [
                        'min' => 1,
                        'max' => 200,
                        'step' => 1,
                    ],
                    'rem' => [
                        'min' => 1,
                        'max' => 100,
                        'step' => 1,
                    ],
                ],
                'default' => [
                    'unit' => 'px',
                ],
                'selectors' => [
                    '{{WRAPPER}} .bi-plus-lg::before' => 'font-size: {{SIZE}}{{UNIT}};height: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->end_controls_section();

        //text Style
        $this->start_controls_section(
            'astrip_counter_text_style_section',
            [
                'label' => esc_html__('Text', 'astrip-core'),
                'tab'   => Controls_Manager::TAB_STYLE,
                
                
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label'    => esc_html__('Typography', 'astrip-core'),
                'name'     => 'astrip_counter_text_style_typography',
                'selector' => 
                    '{{WRAPPER}} .counter-single .coundown p',
                    

            ]
        );

        $this->add_control(
            'astrip_counter_text_style_color',
            [
                'label'     => esc_html__('Color', 'astrip-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .counter-single .coundown p' => 'color: {{VALUE}};',

                ],
            ]
        );
        
        $this->add_responsive_control(
            'astrip_counter_text_style_margin',
            [
                'label' => esc_html__( 'Margin', 'astrip-core' ),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%', 'em' ],
                'selectors' => [
                    '{{WRAPPER}} .counter-single .coundown p' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->end_controls_section();

        //icon style

        $this->start_controls_section(
            'astrip_counter_icon_style_section',
            [
                'label' => esc_html__('Counter Icon', 'astrip-core'),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'astrip_counter_icon_color',
            [
                'label'     => esc_html__('Color', 'astrip-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}}  svg path' => 'fill: {{VALUE}};',
                    '{{WRAPPER}}  .counter-icon i' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'astrip_counter_icon_size',
            [
                'label' => esc_html__( 'Size', 'astrip-core' ),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => [ 'px','rem' ],
                'range' => [
                    'px' => [
                        'min' => 1,
                        'max' => 200,
                        'step' => 1,
                    ],
                    'rem' => [
                        'min' => 1,
                        'max' => 100,
                        'step' => 1,
                    ],
                ],
                'default' => [
                    'unit' => 'px',
                ],
                'selectors' => [
                    '{{WRAPPER}}  svg' => 'width: {{SIZE}}{{UNIT}};height: {{SIZE}}{{UNIT}};',
                    '{{WRAPPER}} .counter-icon i' => 'font-size: {{SIZE}}{{UNIT}};',
                ],
            ]
        );
        

        $this->end_controls_section();

        
    }

    protected function render()
    {
        $settings = $this->get_settings_for_display();
        $data = $settings['astrip_counter_content_list'];
    ?>
        <?php if( is_admin() ) : ?> 
            <script>
                // Odometer Counter
                jQuery(".counter-single").each(function () {
                jQuery(this).isInViewport(function (status) {
                if (status === "entered") {
                    for (var i = 0; i < document.querySelectorAll(".odometer").length; i++) {
                    var el = document.querySelectorAll('.odometer')[i];
                    el.innerHTML = el.getAttribute("data-odometer-final");
                    }
                }

                });
                });

            </script>
        <?php endif ?>
    

        <div class="counter-section">
            <div class="counter-wrapper">
                <div class="row g-2 d-flex justify-content-center">
                    <?php foreach($data as $item): ?>
                        <?php if( $settings['astrip_counter_style_column'] == 'column_two' ) : ?>
                            <div class="col-xl-6 col-lg-6 col-md-4 col-sm-6 col-10">
                        <?php elseif ($settings['astrip_counter_style_column'] == 'column_three') : ?>
                            <div class="col-xl-4 col-lg-4 col-md-4 col-sm-6 col-10">
                        <?php elseif ($settings['astrip_counter_style_column'] == 'column_four') : ?>
                            <div class="col-xl-3 col-lg-3 col-md-4 col-sm-6 col-10">
                        <?php elseif ($settings['astrip_counter_style_column'] == 'column_six') : ?>
                            <div class="col-xl-2 col-lg-2 col-md-4 col-sm-6 col-10">
                        <?php endif ?>
                            <div class="counter-single text-center d-flex flex-column hover-border1" >
                                <div class="counter-icon">
                                     <?php if( !empty( $item['astrip_content_counter_icon'] ) ) : ?>
                                        <?php \Elementor\Icons_Manager::render_icon( $item['astrip_content_counter_icon'], [ 'aria-hidden' => 'true' ] ); ?>
                                     <?php endif ?>
                                </div>
                                <div class="coundown d-flex flex-column">
                                    <div class="d-flex flex-row justify-content-center align-items-center gap-2">
                                        <?php if( !empty( $item['astrip_content_counter_number'] ) ) : ?>
                                            <div class="plus-icon">
                                                <h3 class="odometer" data-odometer-final="<?php echo esc_html($item['astrip_content_counter_number']) ?>">&nbsp;</h3><i class="bi bi-plus-lg"></i>
                                            </div>
                                        <?php endif ?>
                                    </div>
                                     <?php if( !empty( $item['astrip_content_counter_text'] ) ) : ?>
                                        <p><?php echo esc_html($item['astrip_content_counter_text']) ?></p>
                                     <?php endif ?>
                                </div>
                            </div>
                        </div>
                    <?php endforeach ?> 
                </div>
            </div>
        </div>

    

    <?php
    }
}

Plugin::instance()->widgets_manager->register(new astrip_counter_Widget());


