<?php

    namespace Elementor;
    
    if (!defined('ABSPATH')) exit; // Exit if accessed directly
    
    use Elementor\core\Schemes;
    
    class Astrip_Blog_Widget extends Widget_Base
    {
    
        public function get_name()
        {
            return 'astrip_blog';
        }
    
        public function get_title()
        {
            return esc_html__('EG Blog', 'astrip-core');
        }
    
        public function get_icon()
        {
            return 'eicon-post-list';
        }
    
        public function get_categories()
        {
            return ['astrip_widgets'];
        }
    
        protected function register_controls()
        {
    
            //general section
            $this->start_controls_section(
                'astrip_blog_general_section',
                [
                    'label' => esc_html__('General', 'astrip-core')
                ]
            );
    
    
            
            $this->add_control(
                'astrip_blog_content_style_selection',
                [
                    'label'     => esc_html__( 'Select Style', 'astrip-core' ),
                    'type'      => \Elementor\Controls_Manager::SELECT,
                    'default'   => 'style_one',
                    'options'   => [
                        'style_one'        => esc_html__( 'Style One', 'astrip-core' ),
                        'style_two'        => esc_html__( 'Style Two', 'astrip-core' ),
                        'style_three'      => esc_html__( 'Style Three', 'astrip-core' ),
                        'style_four'      => esc_html__( 'Blog Stories', 'astrip-core' ),
                    ],
                ]
            );
            $this->add_control(
                'astrip_blog_content_style_one_and_two_column_selection',
                [
                    'label'   => esc_html__('Column', 'astrip-core'),
                    'type'    => Controls_Manager::SELECT,
                    'options' => [
                        'column_two'  => esc_html__('2', 'astrip-core'),
                        'column_three' => esc_html__('3', 'astrip-core'),
                        'column_four' => esc_html__('4', 'astrip-core'),
                    ],
                    'default' => 'column_three',
                    'condition' => [
                        'astrip_blog_content_style_selection' => ['style_one','style_two'],
                    ]
                ]
            );
            $this->add_control(
                'astrip_blog_content_style_three_column_selection',
                [
                    'label'   => esc_html__('Column', 'astrip-core'),
                    'type'    => Controls_Manager::SELECT,
                    'options' => [
                        'column_two'  => esc_html__('2', 'astrip-core'),
                        'column_three' => esc_html__('3', 'astrip-core'),
                        'column_four' => esc_html__('4', 'astrip-core'),
                    ],
                    'default' => 'column_four',
                    'condition' => [
                        'astrip_blog_content_style_selection' => 'style_three'
                    ],
                ]
            );
            $this->add_control(
                'astrip_blog_posts_per_page',
                [
                    'label'       => esc_html__('Posts Per Page', 'astrip-core'),
                    'type'        => Controls_Manager::NUMBER,
                    'default'     => 5,
                    'label_block' => false,
                ]
            );
            $this->add_control(
                'astrip_blog_template_order_by',
                [
                    'label'   => esc_html__('Order By', 'astrip-core'),
                    'type'    => Controls_Manager::SELECT,
                    'default' => 'ID',
                    'options' => [
                        'ID'         => esc_html__('Post Id', 'astrip-core'),
                        'author'     => esc_html__('Post Author', 'astrip-core'),
                        'title'      => esc_html__('Title', 'astrip-core'),
                        'post_date'  => esc_html__('Date', 'astrip-core'),
                        'rand'       => esc_html__('Random', 'astrip-core'),
                        'menu_order' => esc_html__('Menu Order', 'astrip-core'),
                    ],
                ]
            );
            $this->add_control(
                'astrip_blog_template_order',
                [
                    'label'   => esc_html__('Order', 'astrip-core'),
                    'type'    => Controls_Manager::SELECT,
                    'options' => [
                        'asc'  => esc_html__('Ascending', 'astrip-core'),
                        'desc' => esc_html__('Descending', 'astrip-core')
                    ],
                    'default' => 'desc',
                ]
            );
            $this->add_control(
                'astrip_blog_date_show_hide_selection',
                [
                    'label' => esc_html__( 'Show Date', 'astrip-core' ),
                    'type' => \Elementor\Controls_Manager::SWITCHER,
                    'label_on' => esc_html__( 'Show', 'astrip-core' ),
                    'label_off' => esc_html__( 'Hide', 'astrip-core' ),
                    'return_value' => 'yes',
                    'default' => 'yes',                   
                ]
            );
            $this->add_control(
                'astrip_blog_category_show_hide_selection',
                [
                    'label' => esc_html__( 'Show Category', 'astrip-core' ),
                    'type' => \Elementor\Controls_Manager::SWITCHER,
                    'label_on' => esc_html__( 'Show', 'astrip-core' ),
                    'label_off' => esc_html__( 'Hide', 'astrip-core' ),
                    'return_value' => 'yes',
                    'default' => 'yes',
                    'condition' => [
                        'astrip_blog_content_style_selection' => ['style_two','style_three','style_four'],
                    ],
                    
                ]
            );
            $this->add_control(
                'astrip_blog_pagination_show_hide_selection_style_two',
                [
                    'label' => esc_html__( 'Pagination Icon', 'astrip-core' ),
                    'type' => \Elementor\Controls_Manager::SWITCHER,
                    'label_on' => esc_html__( 'Show', 'astrip-core' ),
                    'label_off' => esc_html__( 'Hide', 'astrip-core' ),
                    'return_value' => 'yes',
                    'default' => 'no',
                    'condition' => [
                        'astrip_blog_content_style_selection' => ['style_two'],
                    ]
                ]
            );
            
            $this->end_controls_section();  
            //Style Section Start
            //General Section Style Two Start
            $this->start_controls_section(
                'astrip_blog_style_general_style_two_section',
                [
                    'label' => esc_html__('General', 'astrip-core'),
                    'tab'   => Controls_Manager::TAB_STYLE,
                    'condition' => [
                        'astrip_blog_content_style_selection' => 'style_two',
                    ],
                ]
            );
            $this->add_control(
                'astrip_blog_style_general_style_two_content_background',
                [
                    'label'     => esc_html__('Background Color (Card)', 'astrip-core'),
                    'type'      => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .blog-single2 .content' => 'background: {{VALUE}};',
                    ],
                ]
            );
            $this->add_group_control(
                \Elementor\Group_Control_Box_Shadow::get_type(),
                [
                    'name' => 'astrip_blog_style_general_style_two_content_box_shadow',
                    'label' => esc_html__( 'Box Shadow (Card)', 'astrip-core' ),
                    'selector' => '{{WRAPPER}} .blog-single2',
                ]
            );
            
            $this->end_controls_section();
            //General Section Style Three Start
            $this->start_controls_section(
                'astrip_blog_style_general_style_three_section',
                [
                    'label' => esc_html__('General', 'astrip-core'),
                    'tab'   => Controls_Manager::TAB_STYLE,
                    'condition' => [
                        'astrip_blog_content_style_selection' => 'style_three',
                    ],
                ]
            );
            $this->add_control(
                'astrip_blog_style_general_style_three_content_background',
                [
                    'label'     => esc_html__('Background Color (Card)', 'astrip-core'),
                    'type'      => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .blog-single3 .content' => 'background: {{VALUE}};',
                    ],
                ]
            );
            $this->add_group_control(
                \Elementor\Group_Control_Box_Shadow::get_type(),
                [
                    'name' => 'astrip_blog_style_general_style_three_content_box_shadow',
                    'label' => esc_html__( 'Box Shadow (Card)', 'astrip-core' ),
                    'selector' => '{{WRAPPER}} .blog-single3',
                ]
            );
            
            $this->end_controls_section();
            //General Section Style Four Start
            $this->start_controls_section(
                'astrip_blog_style_general_style_four_section',
                [
                    'label' => esc_html__('General', 'astrip-core'),
                    'tab'   => Controls_Manager::TAB_STYLE,
                    'condition' => [
                        'astrip_blog_content_style_selection' => 'style_four',
                    ],
                ]
            );
            $this->add_control(
                'astrip_blog_style_general_style_four_content_background',
                [
                    'label'     => esc_html__('Background Color (Card)', 'astrip-core'),
                    'type'      => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .blog-single2.sibling-3 .content' => 'background-color: {{VALUE}};',
                        '{{WRAPPER}} .blog-single2.sibling-4 .content' => 'background-color: {{VALUE}};',
                    ],
                ]
            );
            $this->add_group_control(
                \Elementor\Group_Control_Box_Shadow::get_type(),
                [
                    'name' => 'astrip_blog_style_general_style_four_content_box_shadow',
                    'label' => esc_html__( 'Box Shadow', 'astrip-core' ),
                    'selector' => '{{WRAPPER}} .blog-single2.sibling-3 .content, .blog-single2.sibling-4 .content',
                ]
            );
            
            $this->end_controls_section();
            //Style One Section Start
            //Date Style Start
            $this->start_controls_section(
                'astrip_blog_style_one_date_section',
                [
                    'label' => esc_html__('Date', 'astrip-core'),
                    'tab'   => Controls_Manager::TAB_STYLE,
                    'condition' => [
                        'astrip_blog_content_style_selection' => 'style_one'
                    ],
                ]
            );
            $this->add_control(
                'astrip_blog_style_one_date_color',
                [
                    'label'     => esc_html__('Color', 'astrip-core'),
                    'type'      => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .blog-single1 .image span.blog-date' => 'color: {{VALUE}};',
                    ],
                ]
            );
            $this->add_control(
                'astrip_blog_style_one_date_background',
                [
                    'label'     => esc_html__('Background Color', 'astrip-core'),
                    'type'      => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .blog-single1 .image span.blog-date' => 'background: {{VALUE}};',
                    ],
                ]
            );
            $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'label'    => esc_html__('Typography', 'astrip-core'),
                    'name'     => 'astrip_blog_style_one_date_typography',
                    'selector' => '{{WRAPPER}} .blog-single1 .image span.blog-date',

                ]
            );
            $this->add_responsive_control(
                'astrip_blog_style_one_date_padding',
                [
                    'label'      => __('Padding', 'astrip-core'),
                    'type'       => Controls_Manager::DIMENSIONS,
                    'size_units' => ['px', '%'],
                    'selectors'  => [
                        '{{WRAPPER}} .blog-single1 .image span.blog-date' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',  
                    ],
                ]
            );
            $this->add_responsive_control(
                'astrip_blog_style_one_date_margin',
                [
                    'label' => esc_html__( 'Margin', 'astrip-core' ),
                    'type' => \Elementor\Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px', '%', 'em' ],
                    'selectors' => [
                        '{{WRAPPER}} .blog-single1 .image span.blog-date' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ],
                ]
            );
            $this->end_controls_section();
            //Title Style Start
            $this->start_controls_section(
                'astrip_blog_style_one_title_section',
                [
                    'label' => esc_html__('Title', 'astrip-core'),
                    'tab'   => Controls_Manager::TAB_STYLE,
                    'condition' => [
                        'astrip_blog_content_style_selection' => 'style_one'
                    ],
                ]
            );
            $this->add_control(
                'astrip_blog_style_one_title_color',
                [
                    'label'     => esc_html__('Color', 'astrip-core'),
                    'type'      => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .blog-single1 .content h4 a' => 'color: {{VALUE}};',
                    ],
                ]
            );
            $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'label'    => esc_html__('Typography', 'astrip-core'),
                    'name'     => 'astrip_blog_style_one_title_typography',
                    'selector' => '{{WRAPPER}} .blog-single1 .content h4 a',

                ]
            );
            $this->add_control(
                'astrip_blog_style_one_title_hover_color',
                [
                    'label'     => esc_html__('Hover Color', 'astrip-core'),
                    'type'      => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .blog-single1 .content h4 a:hover' => 'color: {{VALUE}};',
                    ],
                ]
            );
            $this->add_responsive_control(
                'astrip_blog_style_one_title_padding',
                [
                    'label'      => __('Padding', 'astrip-core'),
                    'type'       => Controls_Manager::DIMENSIONS,
                    'size_units' => ['px', '%'],
                    'selectors'  => [
                        '{{WRAPPER}} .blog-single1 .content h4' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                        
                    ],
                ]
            );
            $this->add_responsive_control(
                'astrip_blog_style_one_title_margin',
                [
                    'label' => esc_html__( 'Margin', 'astrip-core' ),
                    'type' => \Elementor\Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px', '%', 'em' ],
                    'selectors' => [
                        '{{WRAPPER}} .blog-single1 .content h4' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ],
                ]
            );
            $this->end_controls_section();
            //Reading Button Style Start
            $this->start_controls_section(
                'astrip_blog_style_one_reading_btn_section',
                [
                    'label' => esc_html__('Reading Button', 'astrip-core'),
                    'tab'   => Controls_Manager::TAB_STYLE,
                    'condition' => [
                        'astrip_blog_content_style_selection' => 'style_one'
                    ],
                ]
            );
            $this->add_control(
                'astrip_blog_style_one_reading_btn_color',
                [
                    'label'     => esc_html__('Color', 'astrip-core'),
                    'type'      => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .read-more-btn' => 'color: {{VALUE}};',
                        '{{WRAPPER}} .read-more-btn::after' => 'border-bottom:1px dashed {{VALUE}}',
                    ],
                ]
            );
            $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'label'    => esc_html__('Typography', 'astrip-core'),
                    'name'     => 'astrip_blog_style_one_reading_btn_typography',
                    'selector' => '{{WRAPPER}} .read-more-btn',

                ]
            );
            $this->add_responsive_control(
                'astrip_blog_style_one_reading_btn_padding',
                [
                    'label'      => __('Padding', 'astrip-core'),
                    'type'       => Controls_Manager::DIMENSIONS,
                    'size_units' => ['px', '%'],
                    'selectors'  => [
                        '{{WRAPPER}} .read-more-btn' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                        
                    ],
                ]
            );
            $this->add_responsive_control(
                'astrip_blog_style_one_reading_btn_margin',
                [
                    'label' => esc_html__( 'Margin', 'astrip-core' ),
                    'type' => \Elementor\Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px', '%', 'em' ],
                    'selectors' => [
                        '{{WRAPPER}} .read-more-btn' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ],
                ]
            );
            $this->add_control(
                'astrip_blog_style_one_reading_btn_hover_color',
                [
                    'label'     => esc_html__('Hover Color', 'astrip-core'),
                    'type'      => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .read-more-btn:hover' => 'color: {{VALUE}};',
                        '{{WRAPPER}} .read-more-btn:hover::after' => 'border-bottom:1px dashed {{VALUE}}',
                    ],
                ]
            );
            $this->end_controls_section();
            //Style Two Section Start
            //Category Style Start
            $this->start_controls_section(
                'astrip_blog_style_two_category_section',
                [
                    'label' => esc_html__('Category', 'astrip-core'),
                    'tab'   => Controls_Manager::TAB_STYLE,
                    'condition' => [
                        'astrip_blog_content_style_selection' => 'style_two'
                    ],
                ]
            );
            $this->add_control(
                'astrip_blog_style_two_category_color',
                [
                    'label'     => esc_html__('Color', 'astrip-core'),
                    'type'      => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .blog-single2 .image span.blog-category' => 'color: {{VALUE}};',
                    ],
                ]
            );
            $this->add_control(
                'astrip_blog_style_two_category_background',
                [
                    'label'     => esc_html__('Background Color', 'astrip-core'),
                    'type'      => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .blog-single2 .image span.blog-category' => 'background: {{VALUE}};',
                    ],
                ]
            );
            $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'label'    => esc_html__('Typography', 'astrip-core'),
                    'name'     => 'astrip_blog_style_two_category_typography',
                    'selector' => '{{WRAPPER}} .blog-single2 .image span.blog-category',

                ]
            );
            $this->add_responsive_control(
                'astrip_blog_style_two_category_padding',
                [
                    'label'      => __('Padding', 'astrip-core'),
                    'type'       => Controls_Manager::DIMENSIONS,
                    'size_units' => ['px', '%'],
                    'selectors'  => [
                        '{{WRAPPER}} .blog-single2 .image span.blog-category' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',  
                    ],
                ]
            );
            $this->add_responsive_control(
                'astrip_blog_style_two_category_margin',
                [
                    'label' => esc_html__( 'Margin', 'astrip-core' ),
                    'type' => \Elementor\Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px', '%', 'em' ],
                    'selectors' => [
                        '{{WRAPPER}} .blog-single2 .image span.blog-category' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ],
                ]
            );
            $this->end_controls_section();
            //Title Style Start
            $this->start_controls_section(
                'astrip_blog_style_two_title_section',
                [
                    'label' => esc_html__('Title', 'astrip-core'),
                    'tab'   => Controls_Manager::TAB_STYLE,
                    'condition' => [
                        'astrip_blog_content_style_selection' => 'style_two'
                    ],
                ]
            );
            $this->add_control(
                'astrip_blog_style_two_title_color',
                [
                    'label'     => esc_html__('Color', 'astrip-core'),
                    'type'      => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .blog-single2 .content h5 a' => 'color: {{VALUE}};',
                    ],
                ]
            );
            $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'label'    => esc_html__('Typography', 'astrip-core'),
                    'name'     => 'astrip_blog_style_two_title_typography',
                    'selector' => '{{WRAPPER}} .blog-single2 .content h5 a',

                ]
            );
            $this->add_control(
                'astrip_blog_style_two_title_hover_color',
                [
                    'label'     => esc_html__('Hover Color', 'astrip-core'),
                    'type'      => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .blog-single2 .content h5 a:hover' => 'color: {{VALUE}};',
                    ],
                ]
            );
            $this->add_responsive_control(
                'astrip_blog_style_two_title_padding',
                [
                    'label'      => __('Padding', 'astrip-core'),
                    'type'       => Controls_Manager::DIMENSIONS,
                    'size_units' => ['px', '%'],
                    'selectors'  => [
                        '{{WRAPPER}} .blog-single2 .content h5' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                        
                    ],
                ]
            );
            $this->add_responsive_control(
                'astrip_blog_style_two_title_margin',
                [
                    'label' => esc_html__( 'Margin', 'astrip-core' ),
                    'type' => \Elementor\Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px', '%', 'em' ],
                    'selectors' => [
                        '{{WRAPPER}} .blog-single2 .content h5' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ],
                ]
            );
            $this->end_controls_section();
            //Date Style Start
            $this->start_controls_section(
                'astrip_blog_style_two_date_section',
                [
                    'label' => esc_html__('Date', 'astrip-core'),
                    'tab'   => Controls_Manager::TAB_STYLE,
                    'condition' => [
                        'astrip_blog_content_style_selection' => 'style_two'
                    ],
                ]
            );
            $this->add_control(
                'astrip_blog_style_two_date_color',
                [
                    'label'     => esc_html__('Color', 'astrip-core'),
                    'type'      => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .blog-single2 .content .blog-date span' => 'color: {{VALUE}};',
                        '{{WRAPPER}} .blog-single2 .content .blog-date i' => 'color: {{VALUE}};',   
                    ],
                ]
            );
            $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'label'    => esc_html__('Typography', 'astrip-core'),
                    'name'     => 'astrip_blog_style_two_date_typography',
                    'selector' => '{{WRAPPER}} .blog-single2 .content .blog-date span,.blog-single2 .content .blog-date i',

                ]
            );
            $this->add_responsive_control(
                'astrip_blog_style_two_date_padding',
                [
                    'label'      => __('Padding', 'astrip-core'),
                    'type'       => Controls_Manager::DIMENSIONS,
                    'size_units' => ['px', '%'],
                    'selectors'  => [
                        '{{WRAPPER}} .blog-single2 .content .blog-date' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',  
                    ],
                ]
            );
            $this->add_responsive_control(
                'astrip_blog_style_two_date_margin',
                [
                    'label' => esc_html__( 'Margin', 'astrip-core' ),
                    'type' => \Elementor\Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px', '%', 'em' ],
                    'selectors' => [
                        '{{WRAPPER}} .blog-single2 .content .blog-date' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ],
                ]
            );
            $this->end_controls_section();
            //Style Three Section Start
            //Date Style Start
            $this->start_controls_section(
                'astrip_blog_style_three_date_section',
                [
                    'label' => esc_html__('Date', 'astrip-core'),
                    'tab'   => Controls_Manager::TAB_STYLE,
                    'condition' => [
                        'astrip_blog_content_style_selection' => 'style_three'
                    ],
                ]
            );
            $this->add_control(
                'astrip_blog_style_three_date_color',
                [
                    'label'     => esc_html__('Color', 'astrip-core'),
                    'type'      => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .blog-single3 .image span.blog-date' => 'color: {{VALUE}};',
                        '{{WRAPPER}} .blog-single3 .image span.blog-date .bi' => 'color: {{VALUE}};',
                    ],
                ]
            );
            $this->add_control(
                'astrip_blog_style_three_date_background',
                [
                    'label'     => esc_html__('Background Color', 'astrip-core'),
                    'type'      => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .blog-single3 .image span.blog-date' => 'background: {{VALUE}};',
                    ],
                ]
            );
            $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'label'    => esc_html__('Typography', 'astrip-core'),
                    'name'     => 'astrip_blog_style_three_date_typography',
                    'selector' => '{{WRAPPER}} .blog-single3 .image span.blog-date',

                ]
            );
            $this->add_control(
                'astrip_blog_style_three_date_hover_color',
                [
                    'label'     => esc_html__('Hover Color', 'astrip-core'),
                    'type'      => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .blog-single3:hover .image span.blog-date' => 'color: {{VALUE}};',
                        '{{WRAPPER}} .blog-single3:hover .image span.blog-date .bi' => 'color: {{VALUE}};',
                        
                    ],
                ]
            );
            $this->add_control(
                'astrip_blog_style_three_date_hover_background',
                [
                    'label'     => esc_html__('Hover Background', 'astrip-core'),
                    'type'      => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .blog-single3:hover .image span.blog-date' => 'background: {{VALUE}};',
                    ],
                ]
            );
            $this->add_responsive_control(
                'astrip_blog_style_three_date_padding',
                [
                    'label'      => __('Padding', 'astrip-core'),
                    'type'       => Controls_Manager::DIMENSIONS,
                    'size_units' => ['px', '%'],
                    'selectors'  => [
                        '{{WRAPPER}} .blog-single3 .image span.blog-date' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',  
                    ],
                ]
            );
            $this->add_responsive_control(
                'astrip_blog_style_three_date_margin',
                [
                    'label' => esc_html__( 'Margin', 'astrip-core' ),
                    'type' => \Elementor\Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px', '%', 'em' ],
                    'selectors' => [
                        '{{WRAPPER}} .blog-single3 .image span.blog-date' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ],
                ]
            );
            
            $this->end_controls_section();
            //Category Style Start
            $this->start_controls_section(
                'astrip_blog_style_three_category_section',
                [
                    'label' => esc_html__('Category', 'astrip-core'),
                    'tab'   => Controls_Manager::TAB_STYLE,
                    'condition' => [
                        'astrip_blog_content_style_selection' => 'style_three'
                    ],
                ]
            );
            $this->add_control(
                'astrip_blog_style_three_category_color',
                [
                    'label'     => esc_html__('Color', 'astrip-core'),
                    'type'      => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .blog-single3 .content span.category' => 'color: {{VALUE}};',
                    ],
                ]
            );
            $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'label'    => esc_html__('Typography', 'astrip-core'),
                    'name'     => 'astrip_blog_style_three_category_typography',
                    'selector' => '{{WRAPPER}} .blog-single3 .content span.category',

                ]
            );
            $this->add_responsive_control(
                'astrip_blog_style_three_category_padding',
                [
                    'label'      => __('Padding', 'astrip-core'),
                    'type'       => Controls_Manager::DIMENSIONS,
                    'size_units' => ['px', '%'],
                    'selectors'  => [
                        '{{WRAPPER}} .blog-single3 .content span.category' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',  
                    ],
                ]
            );
            $this->add_responsive_control(
                'astrip_blog_style_three_category_margin',
                [
                    'label' => esc_html__( 'Margin', 'astrip-core' ),
                    'type' => \Elementor\Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px', '%', 'em' ],
                    'selectors' => [
                        '{{WRAPPER}} .blog-single3 .content span.category' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ],
                ]
            );
            $this->end_controls_section();
            //Title Style Start
            $this->start_controls_section(
                'astrip_blog_style_three_title_section',
                [
                    'label' => esc_html__('Title', 'astrip-core'),
                    'tab'   => Controls_Manager::TAB_STYLE,
                    'condition' => [
                        'astrip_blog_content_style_selection' => 'style_three'
                    ],
                ]
            );
            $this->add_control(
                'astrip_blog_style_three_title_color',
                [
                    'label'     => esc_html__('Color', 'astrip-core'),
                    'type'      => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .blog-single3 .content h4 a' => 'color: {{VALUE}};',
                    ],
                ]
            );
            $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'label'    => esc_html__('Typography', 'astrip-core'),
                    'name'     => 'astrip_blog_style_three_title_typography',
                    'selector' => '{{WRAPPER}} .blog-single3 .content h4 a',

                ]
            );
            $this->add_control(
                'astrip_blog_style_three_title_hover_color',
                [
                    'label'     => esc_html__('Hover Color', 'astrip-core'),
                    'type'      => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .blog-single3 .content h4 a:hover' => 'color: {{VALUE}};',
                    ],
                ]
            );
            $this->add_responsive_control(
                'astrip_blog_style_three_title_padding',
                [
                    'label'      => __('Padding', 'astrip-core'),
                    'type'       => Controls_Manager::DIMENSIONS,
                    'size_units' => ['px', '%'],
                    'selectors'  => [
                        '{{WRAPPER}} .blog-single3 .content h4' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                        
                    ],
                ]
            );
            $this->add_responsive_control(
                'astrip_blog_style_three_title_margin',
                [
                    'label' => esc_html__( 'Margin', 'astrip-core' ),
                    'type' => \Elementor\Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px', '%', 'em' ],
                    'selectors' => [
                        '{{WRAPPER}} .blog-single3 .content h4' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ],
                ]
            );            
            $this->end_controls_section();

            //Reading Button Style Start
            $this->start_controls_section(
                'astrip_blog_style_three_reading_btn_section',
                [
                    'label' => esc_html__('Reading Button', 'astrip-core'),
                    'tab'   => Controls_Manager::TAB_STYLE,
                    'condition' => [
                        'astrip_blog_content_style_selection' => 'style_three'
                    ],
                ]
            );
            $this->add_control(
                'astrip_blog_style_three_reading_btn_color',
                [
                    'label'     => esc_html__('Color', 'astrip-core'),
                    'type'      => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .read-more-btn' => 'color: {{VALUE}};',
                        '{{WRAPPER}} .read-more-btn.sibling-2' => 'border:1px solid {{VALUE}}',
                    ],
                ]
            );
            $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'label'    => esc_html__('Typography', 'astrip-core'),
                    'name'     => 'astrip_blog_style_three_reading_btn_typography',
                    'selector' => '{{WRAPPER}} .read-more-btn',

                ]
            );
            $this->add_control(
                'astrip_blog_style_three_reading_btn_hover_color',
                [
                    'label'     => esc_html__('Hover Color', 'astrip-core'),
                    'type'      => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .read-more-btn.sibling-2:hover' => 'color: {{VALUE}};',
                        
                    ],
                ]
            );
            $this->add_control(
                'astrip_blog_style_three_reading_btn_hover_background',
                [
                    'label'     => esc_html__('Hover Background', 'astrip-core'),
                    'type'      => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .read-more-btn.sibling-2:hover' => 'background-color: {{VALUE}};',
                    ],
                ]
            );
            $this->add_group_control(
                \Elementor\Group_Control_Border::get_type(),
                [
                    'name' => 'astrip_blog_style_three_reading_btn_border',
                    'label' => esc_html__( 'Border', 'astrip-core' ),
                    'selector' => '{{WRAPPER}} .read-more-btn.sibling-2',
                ]
            );
            $this->add_responsive_control(
                'astrip_blog_style_three_reading_btn_padding',
                [
                    'label'      => __('Padding', 'astrip-core'),
                    'type'       => Controls_Manager::DIMENSIONS,
                    'size_units' => ['px', '%'],
                    'selectors'  => [
                        '{{WRAPPER}} .read-more-btn' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                        
                    ],
                ]
            );
            $this->add_responsive_control(
                'astrip_blog_style_three_reading_btn_margin',
                [
                    'label' => esc_html__( 'Margin', 'astrip-core' ),
                    'type' => \Elementor\Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px', '%', 'em' ],
                    'selectors' => [
                        '{{WRAPPER}} .read-more-btn' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ],
                ]
            );
            $this->end_controls_section();
            //Style Four Section Start
            //Date Style Start
            $this->start_controls_section(
                'astrip_blog_style_four_date_section',
                [
                    'label' => esc_html__('Date', 'astrip-core'),
                    'tab'   => Controls_Manager::TAB_STYLE,
                    'condition' => [
                        'astrip_blog_content_style_selection' => 'style_four'
                    ],
                ]
            );
            $this->add_control(
                'astrip_blog_style_four_date_color',
                [
                    'label'     => esc_html__('Color', 'astrip-core'),
                    'type'      => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .blog-single2 .content .blog-date i' => 'color: {{VALUE}};',
                        '{{WRAPPER}} .blog-single2 .content .blog-date span' => 'color: {{VALUE}};',
                        '{{WRAPPER}} .blog-single2.sibling-4 .image .blog-date' => 'color: {{VALUE}};',
                    ],
                ]
            );
            $this->add_control(
                'astrip_blog_style_four_date_background',
                [
                    'label'     => esc_html__('Background', 'astrip-core'),
                    'type'      => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .blog-single2.sibling-4 .image .blog-date' => 'background: {{VALUE}};',
                    ],
                ]
            );
            $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'label'    => esc_html__('Typography', 'astrip-core'),
                    'name'     => 'astrip_blog_style_four_date_typography',
                    'selector' => '{{WRAPPER}} .blog-single2 .content .blog-date span,.blog-single2 .content .blog-date i,.blog-single2.sibling-4 .image .blog-date',

                ]
            );
            $this->end_controls_section();
            //Category Style Start
            $this->start_controls_section(
                'astrip_blog_style_four_category_section',
                [
                    'label' => esc_html__('Category', 'astrip-core'),
                    'tab'   => Controls_Manager::TAB_STYLE,
                    'condition' => [
                        'astrip_blog_content_style_selection' => 'style_four'
                    ],
                ]
            );
            $this->add_control(
                'astrip_blog_style_four_category_color',
                [
                    'label'     => esc_html__('Color', 'astrip-core'),
                    'type'      => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .blog-single2.sibling-4 .content span.tour-category' => 'color: {{VALUE}};',
                    ],
                ]
            );
            $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'label'    => esc_html__('Typography', 'astrip-core'),
                    'name'     => 'astrip_blog_style_four_category_typography',
                    'selector' => '{{WRAPPER}} .blog-single2.sibling-4 .content span.tour-category',

                ]
            );
            $this->add_responsive_control(
                'astrip_blog_style_four_category_padding',
                [
                    'label'      => __('Padding', 'astrip-core'),
                    'type'       => Controls_Manager::DIMENSIONS,
                    'size_units' => ['px', '%'],
                    'selectors'  => [
                        '{{WRAPPER}} .blog-single2.sibling-4 .content span.tour-category' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',  
                    ],
                ]
            );
            $this->add_responsive_control(
                'astrip_blog_style_four_category_margin',
                [
                    'label' => esc_html__( 'Margin', 'astrip-core' ),
                    'type' => \Elementor\Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px', '%', 'em' ],
                    'selectors' => [
                        '{{WRAPPER}} .blog-single2.sibling-4 .content span.tour-category' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ],
                ]
            );
            $this->end_controls_section();
            //Title Style Start
            $this->start_controls_section(
                'astrip_blog_style_four_title_section',
                [
                    'label' => esc_html__('Title', 'astrip-core'),
                    'tab'   => Controls_Manager::TAB_STYLE,
                    'condition' => [
                        'astrip_blog_content_style_selection' => 'style_four'
                    ],
                ]
            );
            $this->add_control(
                'astrip_blog_style_four_title_color',
                [
                    'label'     => esc_html__('Color', 'astrip-core'),
                    'type'      => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .blog-single2.sibling-3 .content h5 a' => 'color: {{VALUE}};',
                        '{{WRAPPER}} .blog-single2.sibling-4 .content h5 a' => 'color: {{VALUE}};',
                    ],
                ]
            );
            $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'label'    => esc_html__('Typography', 'astrip-core'),
                    'name'     => 'astrip_blog_style_four_title_typography',
                    'selector' => '{{WRAPPER}} .blog-single2.sibling-3 .content h5 a,.blog-single2.sibling-4 .content h5 a',

                ]
            );
            $this->add_control(
                'astrip_blog_style_four_title_hover_color',
                [
                    'label'     => esc_html__('Hover Color', 'astrip-core'),
                    'type'      => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .blog-single2.sibling-3 .content h5 a:hover' => 'color: {{VALUE}};',
                        '{{WRAPPER}} .blog-single2.sibling-4 .content h5 a:hover' => 'color: {{VALUE}};',
                    ],
                ]
            );
            $this->end_controls_section();

            //Reading Button Style Start
            $this->start_controls_section(
                'astrip_blog_style_four_reading_btn_section',
                [
                    'label' => esc_html__('Reading Button', 'astrip-core'),
                    'tab'   => Controls_Manager::TAB_STYLE,
                    'condition' => [
                        'astrip_blog_content_style_selection' => 'style_four'
                    ],
                ]
            );
            $this->add_control(
                'astrip_blog_style_four_reading_btn_color',
                [
                    'label'     => esc_html__('Color', 'astrip-core'),
                    'type'      => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .read-more-btn' => 'color: {{VALUE}};',
                        '{{WRAPPER}} .read-more-btn::after' => 'border-bottom:1px dashed {{VALUE}}',   
                    ],
                ]
            );
            $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'label'    => esc_html__('Typography', 'astrip-core'),
                    'name'     => 'astrip_blog_style_four_reading_btn_typography',
                    'selector' => '{{WRAPPER}} .read-more-btn',

                ]
            );
            $this->add_responsive_control(
                'astrip_blog_style_four_reading_btn_padding',
                [
                    'label'      => __('Padding', 'astrip-core'),
                    'type'       => Controls_Manager::DIMENSIONS,
                    'size_units' => ['px', '%'],
                    'selectors'  => [
                        '{{WRAPPER}} .read-more-btn' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                        
                    ],
                ]
            );
            $this->add_responsive_control(
                'astrip_blog_style_four_reading_btn_margin',
                [
                    'label' => esc_html__( 'Margin', 'astrip-core' ),
                    'type' => \Elementor\Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px', '%', 'em' ],
                    'selectors' => [
                        '{{WRAPPER}} .read-more-btn' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ],
                ]
            );
            $this->add_control(
                'astrip_blog_style_four_reading_btn_hover_color',
                [
                    'label'     => esc_html__('Hover Color', 'astrip-core'),
                    'type'      => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .read-more-btn:hover' => 'color: {{VALUE}};',
                        '{{WRAPPER}} .read-more-btn:hover::after' => 'border-bottom:1px dashed {{VALUE}}',
                        
                    ],
                ]
            );
            $this->end_controls_section();
            
    
    
    
        }
        protected function render()
        {
    
            $settings = $this->get_settings_for_display();
            $query = new \WP_Query(
                array(
                    'post_type'      => 'post',
                    'posts_per_page' => $settings['astrip_blog_posts_per_page'],
                    'orderby'        => $settings['astrip_blog_template_order_by'],
                    'order'          => $settings['astrip_blog_template_order'],
                    'offset'         => 0,
                    'post_status'    => 'publish'
                )
            );    
            ?>
            <?php if( !empty( $settings['astrip_blog_content_style_selection'] ) && ($settings['astrip_blog_content_style_selection'] == 'style_one') )  : ?> 
                <div class="blog-section overflow-hidden">
                        <div class="row justify-content-center"> 
                            <?php
                            if ( $query ->have_posts() ) {
                            while( $query -> have_posts() ) {
                                $query -> the_post();
                            ?>
                                <?php if( $settings['astrip_blog_content_style_one_and_two_column_selection'] == 'column_two' ) : ?>
                                    <div class="col-xl-6 col-lg-6 col-md-6 col-sm-10">
                                <?php elseif ($settings['astrip_blog_content_style_one_and_two_column_selection'] == 'column_three') : ?>
                                    <div class="col-xl-4 col-lg-4 col-md-6 col-sm-10">
                                <?php elseif ($settings['astrip_blog_content_style_one_and_two_column_selection'] == 'column_four') : ?>
                                    <div class="col-xl-3 col-lg-3 col-md-6 col-sm-10">
                                <?php endif ?>
                                    <div class="blog-single1">
                                        <div class="image">
                                        <?php if(has_post_thumbnail()): ?>
                                            <?php the_post_thumbnail('',['class' => 'img-fluid']); ?>
                                        <?php endif ?>
                                            <?php if ( 'yes' === $settings['astrip_blog_date_show_hide_selection'] ) :?>
                                                <span class="blog-date"><a href="<?php echo esc_url( home_url( get_the_date('Y/m/d') ) ) ?>"><?php echo get_the_date( 'F j, Y' );?></a></span>
                                            <?php endif ?>
                                        </div>
                                        <div class="content">
                                            <h4><a href="<?php esc_url( the_permalink() ) ?>"><?php echo wp_kses(get_the_title(), wp_kses_allowed_html('post')) ?></a></h4>
                                            <a href="<?php esc_url( the_permalink() ) ?>" class="read-more-btn"><?php ?><?php echo esc_html__("Continue Reading","astrip-core")?><i class="bi bi-arrow-right"></i></a>
                                        </div>
                                    </div>
                                </div>
                            <?php
                                }
                            }
                                wp_reset_query();
                            ?>
                        </div>
                </div>

            <?php endif ?>
            <?php if( !empty( $settings['astrip_blog_content_style_selection'] ) && ($settings['astrip_blog_content_style_selection'] == 'style_two') )  : ?>
                <div class="blog-section overflow-hidden">
                    <div class="row g-4 justify-content-center">
                        <?php
                        if ( $query ->have_posts() ) {
                        while( $query -> have_posts() ) {
                            $query -> the_post();
                        ?>
                            <?php if( $settings['astrip_blog_content_style_one_and_two_column_selection'] == 'column_two' ) : ?>
                                <div class="col-xl-6 col-lg-6 col-md-6 col-sm-10">
                            <?php elseif ($settings['astrip_blog_content_style_one_and_two_column_selection'] == 'column_three') : ?>
                                <div class="col-xl-4 col-lg-4 col-md-6 col-sm-10">
                            <?php elseif ($settings['astrip_blog_content_style_one_and_two_column_selection'] == 'column_four') : ?>
                                <div class="col-xl-3 col-lg-3 col-md-6 col-sm-10">
                            <?php endif ?>
                        
                                <div class="blog-single2">
                                    <div class="image">
                                        <?php if(has_post_thumbnail()): ?>
                                            <?php the_post_thumbnail('',['class' => 'img-fluid']); ?>
                                        <?php endif ?>
                                        <?php if ( 'yes' === $settings['astrip_blog_category_show_hide_selection'] ) :?>
                                            <?php 
                                                $getCategoryName = get_the_category( get_the_ID() );
                                            ?>
                                            <span class="blog-category"><a href="<?php echo get_category_link($getCategoryName[0]->cat_ID) ?>"><?php echo esc_html($getCategoryName[0]->name) ?? '' ?></a></span>
                                        <?php endif ?>
                                    </div>
                                    <div class="content">
                                        <h5><a href="<?php esc_url( the_permalink() ) ?>"><?php echo wp_kses(get_the_title(), wp_kses_allowed_html('post')) ?></a></h5>
                                        <?php if ( 'yes' === $settings['astrip_blog_date_show_hide_selection'] ) :?>
                                            <div class="blog-date">
                                                <i class="bi bi-calendar-check"></i><span><a href="<?php echo esc_url( home_url( get_the_date('Y/m/d') ) ) ?>"><?php echo get_the_date( 'F j, Y' );?></a></span>
                                            </div>
                                        <?php endif ?>
                                    </div>
                                </div>
                            </div>
                        <?php
                            }
                        }
                            wp_reset_query();
                        ?> 
                    </div>
                    <?php if ( 'yes' === $settings['astrip_blog_pagination_show_hide_selection_style_two'] ) : ?>   
                        <div class="row justify-content-center">
                            <nav class="pagination-wrap">
                                <?php egens_core()->egns_blog_pagination() ?>
                            </nav>              
                        </div>
                    <?php endif ?>
                </div>
            <?php endif ?>
            <?php if( !empty( $settings['astrip_blog_content_style_selection'] ) && ($settings['astrip_blog_content_style_selection'] == 'style_three') )  : ?>
                <div class="blog-section">
                        <div class="row g-4 justify-content-center">
                            <?php
                            if ( $query ->have_posts() ) {
                            while( $query -> have_posts() ) {
                                $query -> the_post();
                            ?>
                                <?php if( $settings['astrip_blog_content_style_three_column_selection'] == 'column_two' ) : ?>
                                    <div class="col-xl-6 col-lg-6 col-md-6 col-sm-10">
                                <?php elseif ($settings['astrip_blog_content_style_three_column_selection'] == 'column_three') : ?>
                                    <div class="col-xl-4 col-lg-4 col-md-6 col-sm-10">
                                <?php elseif ($settings['astrip_blog_content_style_three_column_selection'] == 'column_four') : ?>
                                    <div class="col-xl-3 col-lg-3 col-md-6 col-sm-10">
                                <?php endif ?>
                               
                                    <div class="blog-single3">
                                        <div class="image">
                                            <?php if(has_post_thumbnail()): ?>
                                                <?php the_post_thumbnail('',['class' => 'img-fluid']); ?>
                                            <?php endif ?>
                                            <?php if ( 'yes' === $settings['astrip_blog_date_show_hide_selection'] ) :?>
                                                <span class="blog-date"><i class="bi bi-calendar-check"></i><a href="<?php echo esc_url( home_url( get_the_date('Y/m/d') ) ) ?>"><?php echo get_the_date( 'F j, Y' );?></a></span>
                                            <?php endif ?>
                                        </div>
                                        <div class="content">
                                            <?php if ( 'yes' === $settings['astrip_blog_category_show_hide_selection'] ) :?>
                                                <?php 
                                                    $getCategoryName = get_the_category( get_the_ID() );
                                                ?>
                                                <span class="category"><a href="<?php echo get_category_link($getCategoryName[0]->cat_ID) ?>"><?php echo esc_html($getCategoryName[0]->name) ?? '' ?></a></span>
                                            <?php endif ?>
                                            <h4><a href="<?php esc_url( the_permalink() ) ?>"><?php echo wp_kses(get_the_title(), wp_kses_allowed_html('post')) ?></a></h4>
                                            <a href="<?php esc_url( the_permalink() ) ?>" class="read-more-btn sibling-2"><?php echo esc_html__("Continue Reading","astrip-core")?><i class="bi bi-arrow-right"></i></a>
                                        </div>
                                    </div>
                                </div>
                            <?php
                                }
                            }
                                wp_reset_query();
                            ?>
                        </div>
                </div>
            
            <?php endif ?>
            <?php if( !empty( $settings['astrip_blog_content_style_selection'] ) && ($settings['astrip_blog_content_style_selection'] == 'style_four') )  : ?>
                <div class="blog-section">
                    <div class="container">
                        <div class="row justify-content-center g-4">
                            <div class="col-lg-5 col-md-10">
                                <?php
                                    $query = new \WP_Query(
                                        array(
                                            'post_type' => 'post',
                                            'posts_per_page' => 3,
                                            'orderby'        => $settings['astrip_blog_template_order_by'],
                                            'order'          => $settings['astrip_blog_template_order'],
                                            'offset'         => 0,
                                            'post_status'    => 'publish'
                                        )
                                    );
            
                                    $post_data = array();
                                    while ($query->have_posts()) {
                                        $query->the_post();
                                        $post_data[] = array(
                                            "title" => get_the_title(),
                                            "exercpt" => get_the_excerpt(),
                                            "date" => get_the_date('F j, Y'),
                                            "date_link" => home_url( get_the_date('Y/m/d') ),                                 
                                            "thumbnail" => get_the_post_thumbnail_url(),
                                            "author" => get_the_author_meta("display_name"),
                                            "author_link" => get_author_posts_url(get_the_author_meta("ID")),
                                            "permalink" => get_the_permalink(),
                                            "comments" => get_comments_number(),
                                            "comments_link" => get_comments_link(),
                                            "category" => get_the_category( get_the_ID() ),
                                        );
                                    }
                                ?>
                                    <div class="blog-single2 <?php echo $post_data[0]['thumbnail'] ? 'sibling-3' : '' ?>">
                                        <div class="image">
                                            <?php if (!empty($post_data[0]['thumbnail'])) :   ?>
                                                <img src="<?php echo esc_url($post_data[0]['thumbnail'] ?? ''); ?>" class="img-fluid" alt="<?php echo esc_attr('blog-image') ?>">
                                            <?php endif ?>
                                        </div>
                                        <div class="content">
                                            <?php if ( 'yes' === $settings['astrip_blog_date_show_hide_selection'] ) :?>
                                                <?php if (!empty($post_data[0]['date'])) :   ?>
                                                    <div class="blog-date">
                                                        <i class="bi bi-calendar-check"></i><span><a href="<?php echo esc_url($post_data[0]['date_link'] ?? ''); ?>"><?php echo esc_html($post_data[0]['date'] ?? ''); ?></a></span>
                                                    </div>
                                                <?php endif ?>
                                            <?php endif ?> 
                                            <?php if (!empty($post_data[0]['title'])) :   ?>
                                                <h5><a href="<?php echo esc_url($post_data[0]['permalink'] ?? ''); ?>"><?php echo wp_kses($post_data[0]['title'], wp_kses_allowed_html('post')) ?></a></h5>
                                            <?php endif ?>
                                            <a href="<?php echo esc_url($post_data[0]['permalink'] ?? ''); ?>" class="read-more-btn"><?php echo esc_html__("Continue Reading","astrip-core")?><i class="bi bi-arrow-right"></i></a>
                                        </div>
                                    </div>
                            </div>
                            <div class="col-lg-7">
                                <div class="row g-4 justify-content-center">
                                    <div class="col-md-6 col-sm-6">
                                        <div class="blog-single2 sibling-4">
                                            <div class="image">
                                                <?php if(!empty($post_data[1]['thumbnail'])): ?>
                                                    <img src="<?php echo esc_url($post_data[1]['thumbnail'] ?? ''); ?>" class="img-fluid" alt="<?php echo esc_attr('blog-image') ?>">
                                                <?php endif ?>
                                                <?php if ( 'yes' === $settings['astrip_blog_date_show_hide_selection'] ) :?>
                                                    <div class="blog-date">
                                                        <i class="bi bi-calendar-check"></i><span><a href="<?php echo esc_url($post_data[1]['date_link'] ?? ''); ?>"><?php echo esc_html($post_data[1]['date'] ?? ''); ?></a></span>
                                                    </div>
                                                <?php endif ?>
                                            </div>
                                            <div class="content">
                                                <?php if ( 'yes' === $settings['astrip_blog_category_show_hide_selection'] && isset($post_data[1]['category']->name) )  : ?>
                                                    <span class="tour-category"><a href="<?php echo get_category_link($post_data[1]['category']->cat_ID) ?>"><?php echo esc_html($post_data[1]['category']->name) ?></a></span>
                                                <?php endif ?>
                                                <h5><a href="<?php echo esc_url($post_data[1]['permalink'] ?? ''); ?>"><?php echo wp_kses($post_data[1]['title'], wp_kses_allowed_html('post')) ?></a></h5>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-md-6 col-sm-6">
                                        <div class="blog-single2 sibling-4">
                                            <div class="image">
                                                <img src="<?php echo esc_url($post_data[2]['thumbnail'] ?? ''); ?>" class="img-fluid" alt="<?php echo esc_attr('blog-image') ?>">
                                                <?php if ( 'yes' === $settings['astrip_blog_date_show_hide_selection'] ) :?>
                                                    <div class="blog-date">
                                                        <i class="bi bi-calendar-check"></i><span><a href="<?php echo esc_url($post_data[1]['date_link'] ?? ''); ?>"><?php echo esc_html($post_data[1]['date'] ?? ''); ?></a></span>
                                                    </div>
                                                <?php endif ?>
                                            </div>
                                            <div class="content">
                                                <?php if ( 'yes' === $settings['astrip_blog_category_show_hide_selection'] && isset($post_data[2]['category']->name) ) :?>
                                                    <span class="tour-category"><a href="<?php echo get_category_link($post_data[2]['category']->cat_ID) ?>"><?php echo esc_html($post_data[2]['category']->name) ?></a></span>
                                                <?php endif ?>
                                                <h5><a href="<?php echo esc_url($post_data[2]['permalink'] ?? ''); ?>"><?php echo wp_kses($post_data[2]['title'], wp_kses_allowed_html('post')) ?></a></h5>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            <?php endif ?>
    
    
            <?php 
            
        }
    }
    
    Plugin::instance()->widgets_manager->register(new Astrip_Blog_Widget());
