<?php

/**
 * Custom Post Type
 * Author EgensLab
 * @since 1.3.0
 * */

if (!defined('ABSPATH')) {
	exit(); //exit if access directly
}
if (!class_exists('Egens_Custom_Post_Type')) {
	class Egens_Custom_Post_Type
	{

		//$instance variable
		private static $instance;

		public function __construct()
		{
			//register post type
			add_action('init', array($this, 'register_custom_post_type'));
		}

		/**
		 * get Instance
		 * @since  1.3.0
		 * */
		public static function getInstance()
		{
			if (null == self::$instance) {
				self::$instance = new self();
			}

			return self::$instance;
		}

		/**
		 * Register Custom Post Type
		 * @since  2.0.0
		 * */
		public function register_custom_post_type()
		{
			if (!defined('ELEMENTOR_VERSION')) {
				return;
			}
			$tour_link = get_option('egens_cpt_base') ? get_option('egens_cpt_base') : 'tour';
			$destination_link = get_option('egens_cpt_base2') ? get_option('egens_cpt_base2') : 'destination';
			$all_post_type = array(
				[
					'post_type' => 'astrip-tour',
					'args'      => array(
						'label'              => esc_html__('Astrip Tours', 'egens-core'),
						'description'        => esc_html__('Astrip Tours', 'egens-core'),
						'menu_icon'          => 'dashicons-airplane',
						'labels'             => array(
							'name'               => esc_html_x('Tours', 'Post Type General Name', 'egens-core'),
							'singular_name'      => esc_html_x('Tours', 'Post Type Singular Name', 'egens-core'),
							'menu_name'          => esc_html__('Astrip Tours', 'egens-core'),
							'all_items'          => esc_html__('All Tours', 'egens-core'),
							'view_item'          => esc_html__('View Tours', 'egens-core'),
							'add_new_item'       => esc_html__('Add New Tour', 'egens-core'),
							'add_new'            => esc_html__('Add New Tour', 'egens-core'),
							'edit_item'          => esc_html__('Edit Tour', 'egens-core'),
							'update_item'        => esc_html__('Update Tour', 'egens-core'),
							'search_items'       => esc_html__('Search Tours', 'egens-core'),
							'not_found'          => esc_html__('Not Found', 'egens-core'),
							'not_found_in_trash' => esc_html__('Not found in Trash', 'egens-core'),
						),
						'supports'           => array('title', 'editor', 'excerpt', 'thumbnail'),
						'hierarchical'       => true,
						'public'             => true,
						'has_archive' 		 => true,
						"publicly_queryable" => true,
						'show_ui'            => true,
						"rewrite" => array('slug' => $tour_link, 'with_front' => true),
						'exclude_from_search'   => false,
						'can_export'         => true,
						'capability_type'    => 'post',
						'query_var'          => true,
						"show_in_rest"		 => true,
					)
				],
				[
					'post_type' => 'enquiries',
					'args'      => array(
						'labels'             => array(
							'name'               => esc_html_x('All Enquiries', 'Post Type General Name', 'egens-core'),
							'singular_name'      => esc_html_x('All Enquiries', 'Post Type Singular Name', 'egens-core'),
							'menu_name'          => esc_html__('All Enquiries', 'egens-core'),
							'all_items'          => esc_html__('Enquiries', 'egens-core'),
							'view_item'          => esc_html__('View Enquiry', 'egens-core'),
							'add_new_item'       => esc_html__('Add New Enquiry', 'egens-core'),
							'add_new'            => esc_html__('Add New Enquiry', 'egens-core'),
							'edit_item'          => esc_html__('Edit Enquiry', 'egens-core'),
							'update_item'        => esc_html__('Update Enquiry', 'egens-core'),
							'search_items'       => esc_html__('Search Enquiry', 'egens-core'),
							'not_found'          => esc_html__('Not Found', 'egens-core'),
							'not_found_in_trash' => esc_html__('Not found in Trash', 'egens-core'),
						),
						'capabilities' => array(
							'create_posts' => false,
							'edit_post' => 'manage_options',
							'read_post' => 'manage_options',
							'delete_post' => 'manage_options',
							'edit_posts' => 'manage_options',
							'edit_others_posts' => 'manage_options',
							'publish_posts' => 'manage_options',
							'read_private_posts' => 'manage_options',
						),
						'supports'           => array('title'),
						'hierarchical'       => true,
						'public'             => true,
						'has_archive' 		=> false,
						"publicly_queryable" => true,
						'show_ui'            => true,
						"rewrite" => array('slug' => 'enquiries', 'with_front' => true),
						'exclude_from_search'   => true,
						'can_export'         => true,
						'capability_type'    => 'post',
						'query_var'          => true,
						"show_in_rest"		 => false,
						"show_in_menu"		 => 'edit.php?post_type=astrip-tour',

					)
				],
				[
					'post_type' => 'review-rating',
					'args'      => array(
						'label'              => esc_html__('Review & Rating', 'egens-core'),
						'description'        => esc_html__('Review & Rating', 'egens-core'),
						'menu_icon'           => 'dashicons-book',
						'labels'             => array(
							'name'               => esc_html_x('All Review & Rating', 'Post Type General Name', 'egens-core'),
							'singular_name'      => esc_html_x('All Review & Rating', 'Post Type Singular Name', 'egens-core'),
							'menu_name'          => esc_html__('All Review & Rating', 'egens-core'),
							'all_items'          => esc_html__('Review & Rating', 'egens-core'),
							'view_item'          => esc_html__('View Review & Rating', 'egens-core'),
							'add_new_item'       => esc_html__('Add New Review & Rating', 'egens-core'),
							'add_new'            => esc_html__('Add New Review & Rating', 'egens-core'),
							'edit_item'          => esc_html__('Edit Review & Rating', 'egens-core'),
							'update_item'        => esc_html__('Update Review & Rating', 'egens-core'),
							'search_items'       => esc_html__('Search Review & Rating', 'egens-core'),
							'not_found'          => esc_html__('Not Found', 'egens-core'),
							'not_found_in_trash' => esc_html__('Not found in Trash', 'egens-core'),
						),
						'capabilities' => array(
							'create_posts' => false,
							'edit_post' => 'manage_options',
							'read_post' => 'manage_options',
							'delete_post' => 'manage_options',
							'edit_posts' => 'manage_options',
							'edit_others_posts' => 'manage_options',
							'publish_posts' => 'manage_options',
							'read_private_posts' => 'manage_options',
						),
						'supports'           => array('title'),
						'hierarchical'       => true,
						'public'             => true,
						'has_archive' 		=> true,
						"publicly_queryable" => true,
						'show_ui'            => true,
						"rewrite" 				=> array('slug' => 'review-rating', 'with_front' => false),
						'exclude_from_search'   => true,
						'can_export'         => true,
						'capability_type'    => 'post',
						'query_var'          => true,
						"show_in_rest"		 => true,
						"show_in_menu"		 => 'edit.php?post_type=astrip-tour',

					)
				],
				[
					'post_type' => 'astrip-destination',
					'args'      => array(
						'label'              => esc_html__('Destination', 'egens-core'),
						'description'        => esc_html__('Destination', 'egens-core'),
						'menu_icon'           => 'dashicons-location',
						'labels'             => array(
							'name'               => esc_html_x('Destination', 'Post Type General Name', 'egens-core'),
							'singular_name'      => esc_html_x('Destination', 'Post Type Singular Name', 'egens-core'),
							'menu_name'          => esc_html__('Destination', 'egens-core'),
							'all_items'          => esc_html__('All Destination', 'egens-core'),
							'view_item'          => esc_html__('View Destination', 'egens-core'),
							'add_new_item'       => esc_html__('Add New Destination', 'egens-core'),
							'add_new'            => esc_html__('Add New Destination', 'egens-core'),
							'edit_item'          => esc_html__('Edit Destination', 'egens-core'),
							'update_item'        => esc_html__('Update Destination', 'egens-core'),
							'search_items'       => esc_html__('Search Destination', 'egens-core'),
							'not_found'          => esc_html__('Not Found', 'egens-core'),
							'not_found_in_trash' => esc_html__('Not found in Trash', 'egens-core'),
						),
						'supports'           => array('title', 'editor', 'excerpt', 'thumbnail'),
						'hierarchical'       => true,
						'public'             => true,
						'has_archive' 		=> true,
						"publicly_queryable" => true,
						'show_ui'            => true,
						"rewrite" => array('slug' => $destination_link, 'with_front' => true),
						'exclude_from_search'   => true,
						'can_export'         => true,
						'capability_type'    => 'post',
						'query_var'          => true,
						"show_in_rest"		 => true,
					)
				],
			);

			if (!empty($all_post_type) && is_array($all_post_type)) {
				foreach ($all_post_type as $post_type) {
					call_user_func_array('register_post_type', $post_type);
				}
			}

			/**
			 * Custom Taxonomy Register
			 */
			$all_custom_taxonmy = array(
				array(
					'taxonomy' => 'astrip-tour-type',
					'object_type' => 'astrip-tour',
					'args' => array(
						"labels" => array(
							"name" => esc_html__("Tour Type", 'egens-core'),
							"singular_name" => esc_html__("Tour Type", 'egens-core'),
							"menu_name" => esc_html__("Tour Type", 'egens-core'),
							"all_items" => esc_html__("All Tour Type", 'egens-core'),
							"add_new_item" => esc_html__("Add New Tour Type", 'egens-core')
						),
						"public" => true,
						"hierarchical" => true,
						'has_archive' => true,
						"show_ui" => true,
						"show_in_menu" => true,
						"show_in_nav_menus" => true,
						"rewrite" => array('slug' => 'tour-type', 'with_front' => true),
						"query_var" => true,
						"show_admin_column" => true,
						"show_in_rest" => true,
						"show_in_quick_edit" => true,
					),
				),

			);


			if (is_array($all_custom_taxonmy) && !empty($all_custom_taxonmy)) {
				foreach ($all_custom_taxonmy as $taxonomy) {
					call_user_func_array('register_taxonomy', $taxonomy);
				}
			}
			flush_rewrite_rules();
		}
	} //end class

	if (class_exists('Egens_Custom_Post_Type')) {
		Egens_Custom_Post_Type::getInstance();
	}
}
